/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.resource.scanner.helper;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.sonatype.sisu.resource.scanner.Listener;
import org.sonatype.sisu.resource.scanner.helper.CompositeListenerExceptionPolicy;
import org.sonatype.sisu.resource.scanner.helper.ListenerSupport;

public class CompositeListener
extends ListenerSupport {
    private final Collection<Listener> listeners;
    private final CompositeListenerExceptionPolicy exceptionPolicy;

    public CompositeListener(Listener ... listeners) {
        this(CompositeListenerExceptionPolicy.ignore(), listeners);
    }

    public CompositeListener(CompositeListenerExceptionPolicy exceptionPolicy, Listener ... listeners) {
        this.exceptionPolicy = exceptionPolicy;
        this.listeners = new ArrayList<Listener>();
        if (listeners != null) {
            this.listeners.addAll(Arrays.asList(listeners));
        }
    }

    public CompositeListener add(Listener listener) {
        this.listeners.add(listener);
        return this;
    }

    public CompositeListener remove(Listener listener) {
        this.listeners.remove(listener);
        return this;
    }

    @Override
    public void onBegin() {
        for (Listener listener : this.listeners) {
            try {
                listener.onBegin();
            }
            catch (Exception e) {
                this.exceptionPolicy.onBegin(listener, e);
            }
        }
    }

    @Override
    public void onEnterDirectory(File directory) {
        for (Listener listener : this.listeners) {
            try {
                listener.onEnterDirectory(directory);
            }
            catch (Exception e) {
                this.exceptionPolicy.onEnterDirectory(listener, e, directory);
            }
        }
    }

    @Override
    public void onExitDirectory(File directory) {
        for (Listener listener : this.listeners) {
            try {
                listener.onExitDirectory(directory);
            }
            catch (Exception e) {
                this.exceptionPolicy.onExitDirectory(listener, e, directory);
            }
        }
    }

    @Override
    public void onFile(File file) {
        for (Listener listener : this.listeners) {
            try {
                listener.onFile(file);
            }
            catch (Exception e) {
                this.exceptionPolicy.onFile(listener, e, file);
            }
        }
    }

    @Override
    public void onEnd() {
        for (Listener listener : this.listeners) {
            try {
                listener.onEnd();
            }
            catch (Exception e) {
                this.exceptionPolicy.onEnd(listener, e);
            }
        }
    }
}

