/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.whitelist;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.whitelist.SystemProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeWhitelist {
    private static final Logger log = LoggerFactory.getLogger(TypeWhitelist.class);
    public static final String DEFAULT_PACKAGE_NAME = "<default>";
    @VisibleForTesting
    public static final SystemProperty allowAllProperty = new SystemProperty(TypeWhitelist.class, "allowAll");
    @VisibleForTesting
    public static final SystemProperty allowedTypesProperty = new SystemProperty(TypeWhitelist.class, "allowedTypes");
    @VisibleForTesting
    public static final SystemProperty allowedPackagesProperty = new SystemProperty(TypeWhitelist.class, "allowedPackages");
    @VisibleForTesting
    public static final SystemProperty allowedPatternsProperty = new SystemProperty(TypeWhitelist.class, "allowedPatterns");
    private final Set<String> allowedTypes = Sets.newHashSet();
    private final Set<String> allowedPackages = Sets.newHashSet();
    private final List<Pattern> allowedPatterns = Lists.newArrayList();
    private boolean allowAll;

    public TypeWhitelist() {
        this.setAllowAll(allowAllProperty.get(Boolean.class, false));
        this.configureDefaults();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "allowAll=" + this.allowAll + ", allowedTypes=" + this.allowedTypes + ", allowedPackages=" + this.allowedPackages + ", allowedPatterns=" + this.allowedPatterns + '}';
    }

    @VisibleForTesting
    void configureDefaults() {
        boolean trace = log.isTraceEnabled();
        this.allowedTypes.addAll(allowedTypesProperty.asList());
        if (trace && !this.allowedTypes.isEmpty()) {
            log.trace("Default allowed types:");
            for (String name : this.sort(this.allowedTypes)) {
                log.trace("  {}", (Object)name);
            }
        }
        this.allowedPackages.addAll(allowedPackagesProperty.asList());
        if (trace && !this.allowedPackages.isEmpty()) {
            log.trace("Default allowed packages:");
            for (String name : this.sort(this.allowedPackages)) {
                log.trace("  {}", (Object)name);
            }
        }
        this.allowedPatterns.addAll(Lists.transform(allowedPatternsProperty.asList(), (Function)new Function<String, Pattern>(){

            public Pattern apply(String input) {
                return TypeWhitelist.this.compilePattern(input);
            }
        }));
        if (trace && !this.allowedPatterns.isEmpty()) {
            log.trace("Default allowed patterns:");
            for (Pattern pattern : this.allowedPatterns) {
                log.trace("  {}", (Object)pattern);
            }
        }
    }

    public boolean isAllowAll() {
        return this.allowAll;
    }

    public void setAllowAll(boolean allowAll) {
        this.allowAll = allowAll;
        if (allowAll) {
            log.warn("All types are allowed");
        }
    }

    private Collection<String> sort(Collection<String> collection) {
        ArrayList list = Lists.newArrayList(collection);
        Collections.sort(list);
        return list;
    }

    public Set<String> getAllowedTypes() {
        return ImmutableSet.copyOf(this.allowedTypes);
    }

    public Set<String> getAllowedPackages() {
        return ImmutableSet.copyOf(this.allowedPackages);
    }

    public void allowType(String ... names) {
        if (names == null) {
            return;
        }
        for (String name : names) {
            if (name == null) continue;
            this.allowedTypes.add(name);
            log.trace("Allow type: {}", (Object)name);
        }
    }

    public void allowType(Class ... types) {
        if (types == null) {
            return;
        }
        for (Class type : types) {
            if (type == null) continue;
            this.allowType(type.getName());
        }
    }

    public void allowPackage(String ... names) {
        if (names == null) {
            return;
        }
        for (String name : names) {
            if (name == null) continue;
            this.allowedPackages.add(name);
            log.trace("Allow package: {}", (Object)name);
        }
    }

    public void allowPackage(Package ... packages) {
        if (packages == null) {
            return;
        }
        for (Package pkg : packages) {
            if (pkg == null) continue;
            this.allowPackage(pkg.getName());
        }
    }

    public void allowPattern(Pattern ... patterns) {
        if (patterns == null) {
            return;
        }
        for (Pattern pattern : patterns) {
            if (pattern == null) continue;
            this.allowedPatterns.add(pattern);
            log.trace("Allow pattern: {}", (Object)pattern);
        }
    }

    public void allowPattern(String ... patterns) {
        if (patterns == null) {
            return;
        }
        for (String pattern : patterns) {
            if (pattern == null) continue;
            this.allowPattern(this.compilePattern(pattern));
        }
    }

    @VisibleForTesting
    Pattern compilePattern(String pattern) {
        return Pattern.compile(pattern);
    }

    public boolean isAllowed(String className) {
        Preconditions.checkNotNull((Object)className);
        if (this.allowAll) {
            log.trace("All types allowed: {}", (Object)className);
            return true;
        }
        log.trace("Checking type allowance: {}", (Object)className);
        if (this.allowedTypes.contains(className)) {
            log.trace("Type allowed: {}", (Object)className);
            return true;
        }
        String packageName = this.parsePackageName(className);
        log.trace("Checking package allowance: {}", (Object)packageName);
        if (this.allowedPackages.contains(packageName)) {
            log.trace("Package allowed: {}", (Object)packageName);
            return true;
        }
        for (Pattern pattern : this.allowedPatterns) {
            if (!pattern.matcher(className).matches()) continue;
            log.trace("Type allowed: {}, by pattern: {}", (Object)className, (Object)pattern);
            return true;
        }
        log.warn("Type NOT allowed: {}", (Object)className);
        return false;
    }

    @VisibleForTesting
    String parsePackageName(String className) {
        int i = className.lastIndexOf(".");
        if (i == -1) {
            return DEFAULT_PACKAGE_NAME;
        }
        return className.substring(0, i);
    }

    public boolean isAllowed(Class type) {
        Preconditions.checkNotNull((Object)type);
        return this.isAllowed(type.getName());
    }

    public void ensureAllowed(String name) throws TypeNotAllowedException {
        Preconditions.checkNotNull((Object)name);
        if (!this.isAllowed(name)) {
            log.warn("Type NOT allowed: {}", (Object)name);
            throw new TypeNotAllowedException(name);
        }
    }

    public void ensureAllowed(Class type) throws TypeNotAllowedException {
        Preconditions.checkNotNull((Object)type);
        this.ensureAllowed(type.getName());
    }

    public static class TypeNotAllowedException
    extends CannotResolveClassException {
        public TypeNotAllowedException(String className) {
            super(className);
        }
    }
}

