/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.whitelist;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomProperties
extends Properties {
    public static final String UNKNOWN = "unknown";
    public static final String GROUP_ID = "groupId";
    public static final String ARTIFACT_ID = "artifactId";
    public static final String VERSION = "version";
    private static final Logger log = LoggerFactory.getLogger(PomProperties.class);

    public PomProperties(Class owner, String groupId, String artifactId) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)artifactId);
        try {
            this.loadMetadata(owner, groupId, artifactId);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetadata(Class owner, String groupId, String artifactId) throws IOException {
        String foundArtifactId;
        String path = String.format("/META-INF/maven/%s/%s/pom.properties", groupId, artifactId);
        URL url = owner.getResource(path);
        if (url == null) {
            log.warn("Missing Maven pom.properties metadata: {}", (Object)path);
            return;
        }
        log.debug("Loading properties from: {}", (Object)url);
        InputStream input = url.openStream();
        try {
            this.load(input);
        }
        finally {
            input.close();
        }
        String foundGroupId = this.getGroupId();
        if (!groupId.equals(foundGroupId)) {
            log.warn("Artifact groupId mismatch; expected: {}, found: {}", (Object)groupId, (Object)foundGroupId);
        }
        if (!artifactId.equals(foundArtifactId = this.getArtifactId())) {
            log.warn("Artifact artifactId mismatch; expected: {}, found: {}", (Object)artifactId, (Object)foundArtifactId);
        }
    }

    public String getGroupId() {
        return this.getProperty(GROUP_ID, UNKNOWN);
    }

    public String getArtifactId() {
        return this.getProperty(ARTIFACT_ID, UNKNOWN);
    }

    public String getVersion() {
        return this.getProperty(VERSION, UNKNOWN);
    }
}

