/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.memory;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCachePointer;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ODirectMemoryOnlyDiskCache
implements ODiskCache {
    private final Lock metadataLock = new ReentrantLock();
    private final Map<String, Long> fileNameIdMap = new HashMap<String, Long>();
    private final Map<Long, String> fileIdNameMap = new HashMap<Long, String>();
    private final ConcurrentMap<Long, MemoryFile> files = new ConcurrentHashMap<Long, MemoryFile>();
    private long counter = 0L;
    private final int pageSize;

    public ODirectMemoryOnlyDiskCache(int pageSize) {
        this.pageSize = pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addFile(String fileName) throws IOException {
        this.metadataLock.lock();
        try {
            Long fileId = this.fileNameIdMap.get(fileName);
            if (fileId == null) {
                ++this.counter;
            } else {
                throw new OStorageException(fileName + " already exists.");
            }
            long id = this.counter;
            this.files.put(id, new MemoryFile(id, this.pageSize));
            this.fileNameIdMap.put(fileName, id);
            fileId = id;
            this.fileIdNameMap.put(fileId, fileName);
            long l = fileId;
            return l;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bookFileId(String fileName) {
        this.metadataLock.lock();
        try {
            ++this.counter;
            long l = this.counter;
            return l;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long openFile(String fileName) throws IOException {
        this.metadataLock.lock();
        try {
            Long fileId = this.fileNameIdMap.get(fileName);
            if (fileId == null) {
                throw new OStorageException("File " + fileName + " does not exist.");
            }
            long l = fileId;
            return l;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    @Override
    public void openFile(long fileId) throws IOException {
        MemoryFile memoryFile = (MemoryFile)this.files.get(fileId);
        if (memoryFile == null) {
            throw new OStorageException("File with id " + fileId + " does not exist");
        }
    }

    @Override
    public void openFile(String fileName, long fileId) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(String fileName, long fileId) throws IOException {
        this.metadataLock.lock();
        try {
            if (this.files.containsKey(fileId)) {
                throw new OStorageException("File with id " + fileId + " already exists.");
            }
            if (this.fileNameIdMap.containsKey(fileName)) {
                throw new OStorageException(fileName + " already exists.");
            }
            this.files.put(fileId, new MemoryFile(fileId, this.pageSize));
            this.fileNameIdMap.put(fileName, fileId);
            this.fileIdNameMap.put(fileId, fileName);
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCacheEntry load(long fileId, long pageIndex, boolean checkPinnedPages) throws IOException {
        MemoryFile memoryFile = this.getFile(fileId);
        OCacheEntry cacheEntry = memoryFile.loadPage(pageIndex);
        if (cacheEntry == null) {
            return null;
        }
        OCacheEntry oCacheEntry = cacheEntry;
        synchronized (oCacheEntry) {
            cacheEntry.incrementUsages();
        }
        return cacheEntry;
    }

    @Override
    public void pinPage(OCacheEntry cacheEntry) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCacheEntry allocateNewPage(long fileId) throws IOException {
        OCacheEntry cacheEntry;
        MemoryFile memoryFile = this.getFile(fileId);
        OCacheEntry oCacheEntry = cacheEntry = memoryFile.addNewPage();
        synchronized (oCacheEntry) {
            cacheEntry.incrementUsages();
        }
        return cacheEntry;
    }

    private MemoryFile getFile(long fileId) {
        MemoryFile memoryFile = (MemoryFile)this.files.get(fileId);
        if (memoryFile == null) {
            throw new OStorageException("File with id " + fileId + " does not exist");
        }
        return memoryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(OCacheEntry cacheEntry) {
        OCacheEntry oCacheEntry = cacheEntry;
        synchronized (oCacheEntry) {
            cacheEntry.decrementUsages();
        }
    }

    @Override
    public long getFilledUpTo(long fileId) throws IOException {
        MemoryFile memoryFile = this.getFile(fileId);
        return memoryFile.size();
    }

    @Override
    public void flushFile(long fileId) throws IOException {
    }

    @Override
    public void closeFile(long fileId) throws IOException {
    }

    @Override
    public void closeFile(long fileId, boolean flush) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(long fileId) throws IOException {
        this.metadataLock.lock();
        try {
            String fileName = this.fileIdNameMap.remove(fileId);
            if (fileName == null) {
                return;
            }
            this.fileNameIdMap.remove(fileName);
            MemoryFile file = (MemoryFile)this.files.remove(fileId);
            if (file != null) {
                file.clear();
            }
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(long fileId, String oldFileName, String newFileName) throws IOException {
        this.metadataLock.lock();
        try {
            String fileName = this.fileIdNameMap.get(fileId);
            if (fileName == null) {
                return;
            }
            this.fileNameIdMap.remove(fileName);
            fileName = newFileName + fileName.substring(fileName.lastIndexOf(oldFileName) + fileName.length());
            this.fileIdNameMap.put(fileId, fileName);
            this.fileNameIdMap.put(fileName, fileId);
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    @Override
    public void truncateFile(long fileId) throws IOException {
        MemoryFile file = this.getFile(fileId);
        file.clear();
    }

    @Override
    public boolean wasSoftlyClosed(long fileId) throws IOException {
        return true;
    }

    @Override
    public void setSoftlyClosed(long fileId, boolean softlyClosed) throws IOException {
    }

    @Override
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
    }

    @Override
    public void flushBuffer() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void delete() throws IOException {
        this.metadataLock.lock();
        try {
            for (MemoryFile file : this.files.values()) {
                file.clear();
            }
            this.files.clear();
            this.fileIdNameMap.clear();
            this.fileNameIdMap.clear();
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    @Override
    public OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        return new OPageDataVerificationError[0];
    }

    @Override
    public boolean isOpen(long fileId) {
        return this.files.get(fileId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String name) {
        this.metadataLock.lock();
        try {
            Long fileId = this.fileNameIdMap.get(name);
            if (fileId == null) {
                boolean bl = false;
                return bl;
            }
            MemoryFile memoryFile = (MemoryFile)this.files.get(fileId);
            boolean bl = memoryFile != null;
            return bl;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(long fileId) {
        this.metadataLock.lock();
        try {
            MemoryFile memoryFile = (MemoryFile)this.files.get(fileId);
            boolean bl = memoryFile != null;
            return bl;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fileNameById(long fileId) {
        this.metadataLock.lock();
        try {
            String string = this.fileIdNameMap.get(fileId);
            return string;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    @Override
    public void lock() throws IOException {
    }

    @Override
    public void unlock() throws IOException {
    }

    @Override
    public void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
    }

    @Override
    public void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
    }

    @Override
    public long getUsedMemory() {
        long totalPages = 0L;
        for (MemoryFile file : this.files.values()) {
            totalPages += file.getUsedMemory();
        }
        return totalPages * (long)(this.pageSize + 16);
    }

    @Override
    public void startFuzzyCheckpoints() {
    }

    @Override
    public boolean checkLowDiskSpace() {
        return true;
    }

    @Override
    public void makeFuzzyCheckpoint() {
    }

    private static final class MemoryFile {
        private final long id;
        private final int pageSize;
        private final ReadWriteLock clearLock = new ReentrantReadWriteLock();
        private final ConcurrentSkipListMap<Long, OCacheEntry> content = new ConcurrentSkipListMap();

        private MemoryFile(long id, int pageSize) {
            this.id = id;
            this.pageSize = pageSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OCacheEntry loadPage(long index) {
            this.clearLock.readLock().lock();
            try {
                OCacheEntry oCacheEntry = this.content.get(index);
                return oCacheEntry;
            }
            finally {
                this.clearLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OCacheEntry addNewPage() {
            this.clearLock.readLock().lock();
            try {
                OCacheEntry cacheEntry;
                long index = -1L;
                do {
                    if (this.content.isEmpty()) {
                        index = 0L;
                    } else {
                        long lastIndex = this.content.lastKey();
                        index = lastIndex + 1L;
                    }
                    ODirectMemoryPointer directMemoryPointer = new ODirectMemoryPointer(new byte[this.pageSize + 16]);
                    OCachePointer cachePointer = new OCachePointer(directMemoryPointer, new OLogSequenceNumber(-1L, -1L));
                    cachePointer.incrementReferrer();
                    cacheEntry = new OCacheEntry(this.id, index, cachePointer, false);
                    OCacheEntry oldCacheEntry = this.content.putIfAbsent(index, cacheEntry);
                    if (oldCacheEntry == null) continue;
                    cacheEntry.getCachePointer().decrementReferrer();
                    index = -1L;
                } while (index < 0L);
                OCacheEntry oCacheEntry = cacheEntry;
                return oCacheEntry;
            }
            finally {
                this.clearLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long size() {
            this.clearLock.readLock().lock();
            try {
                if (this.content.isEmpty()) {
                    long l = 0L;
                    return l;
                }
                long l = this.content.lastKey() + 1L;
                return l;
            }
            finally {
                this.clearLock.readLock().unlock();
            }
        }

        private long getUsedMemory() {
            return this.content.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clear() {
            boolean thereAreNotReleased = false;
            this.clearLock.writeLock().lock();
            try {
                Iterator<OCacheEntry> iterator = this.content.values().iterator();
                while (iterator.hasNext()) {
                    OCacheEntry entry;
                    OCacheEntry oCacheEntry = entry = iterator.next();
                    synchronized (oCacheEntry) {
                        thereAreNotReleased |= entry.getUsagesCount() > 0;
                        entry.getCachePointer().decrementReferrer();
                    }
                }
                this.content.clear();
            }
            finally {
                this.clearLock.writeLock().unlock();
            }
            if (thereAreNotReleased) {
                throw new IllegalStateException("Some cache entries were not released. Storage may be in invalid state.");
            }
        }
    }
}

