/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OLongSerializer;
import java.util.UUID;

public class OOperationUnitId {
    public static final int SERIALIZED_SIZE = 16;
    private UUID uuid;

    public static OOperationUnitId generateId() {
        OOperationUnitId operationUnitId = new OOperationUnitId();
        operationUnitId.uuid = UUID.randomUUID();
        return operationUnitId;
    }

    public OOperationUnitId() {
    }

    public OOperationUnitId(UUID uuid) {
        this.uuid = uuid;
    }

    public int toStream(byte[] content, int offset) {
        OLongSerializer.INSTANCE.serializeNative(this.uuid.getMostSignificantBits(), content, offset, new Object[0]);
        OLongSerializer.INSTANCE.serializeNative(this.uuid.getLeastSignificantBits(), content, offset += 8, new Object[0]);
        return offset += 8;
    }

    public int fromStream(byte[] content, int offset) {
        long most = OLongSerializer.INSTANCE.deserializeNative(content, offset);
        long least = OLongSerializer.INSTANCE.deserializeNative(content, offset += 8);
        this.uuid = new UUID(most, least);
        return offset += 8;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OOperationUnitId that = (OOperationUnitId)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        return "OOperationUnitId{uuid=" + this.uuid + "} ";
    }
}

