/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.orient.core.storage.impl.local.OFullCheckpointRequestListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OMemoryWriteAheadLog
extends OAbstractWriteAheadLog {
    private long counter = 0L;
    private List<OWALRecord> records = new ArrayList<OWALRecord>();

    @Override
    public OLogSequenceNumber begin() throws IOException {
        this.syncObject.lock();
        try {
            if (this.records.isEmpty()) {
                OLogSequenceNumber oLogSequenceNumber = null;
                return oLogSequenceNumber;
            }
            OLogSequenceNumber oLogSequenceNumber = this.records.get(0).getLsn();
            return oLogSequenceNumber;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public OLogSequenceNumber end() throws IOException {
        this.syncObject.lock();
        try {
            if (this.records.isEmpty()) {
                OLogSequenceNumber oLogSequenceNumber = null;
                return oLogSequenceNumber;
            }
            OLogSequenceNumber oLogSequenceNumber = this.records.get(this.records.size() - 1).getLsn();
            return oLogSequenceNumber;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public OLogSequenceNumber logAtomicOperationStartRecord(boolean isRollbackSupported, OOperationUnitId unitId) throws IOException {
        return this.log(new OAtomicUnitStartRecord(isRollbackSupported, unitId));
    }

    @Override
    public OLogSequenceNumber logAtomicOperationEndRecord(OOperationUnitId operationUnitId, boolean rollback, OLogSequenceNumber startLsn) throws IOException {
        return this.log(new OAtomicUnitEndRecord(operationUnitId, rollback, startLsn));
    }

    @Override
    public OLogSequenceNumber log(OWALRecord record) throws IOException {
        OLogSequenceNumber logSequenceNumber;
        this.syncObject.lock();
        try {
            logSequenceNumber = new OLogSequenceNumber(0L, this.counter);
            ++this.counter;
            if (record instanceof OAtomicUnitStartRecord) {
                this.records.clear();
            }
            this.records.add(record);
            record.setLsn(logSequenceNumber);
        }
        finally {
            this.syncObject.unlock();
        }
        return logSequenceNumber;
    }

    @Override
    public void truncate() throws IOException {
        this.syncObject.lock();
        try {
            this.records.clear();
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void close(boolean flush) throws IOException {
    }

    @Override
    public void delete() throws IOException {
        this.truncate();
    }

    @Override
    public void delete(boolean flush) throws IOException {
        this.truncate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OWALRecord read(OLogSequenceNumber lsn) throws IOException {
        this.syncObject.lock();
        try {
            if (this.records.isEmpty()) {
                OWALRecord oWALRecord = null;
                return oWALRecord;
            }
            long index = lsn.getPosition() - this.records.get(0).getLsn().getPosition();
            if (index < 0L || index >= (long)this.records.size()) {
                OWALRecord oWALRecord = null;
                return oWALRecord;
            }
            OWALRecord oWALRecord = this.records.get((int)index);
            return oWALRecord;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber next(OLogSequenceNumber lsn) throws IOException {
        this.syncObject.lock();
        try {
            if (this.records.isEmpty()) {
                OLogSequenceNumber oLogSequenceNumber = null;
                return oLogSequenceNumber;
            }
            long index = lsn.getPosition() - this.records.get(0).getLsn().getPosition() + 1L;
            if (index < 0L || index >= (long)this.records.size()) {
                OLogSequenceNumber oLogSequenceNumber = null;
                return oLogSequenceNumber;
            }
            OLogSequenceNumber oLogSequenceNumber = new OLogSequenceNumber(0L, lsn.getPosition() + 1L);
            return oLogSequenceNumber;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public OLogSequenceNumber getFlushedLSN() {
        return new OLogSequenceNumber(Long.MAX_VALUE, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cutTill(OLogSequenceNumber lsn) throws IOException {
        this.syncObject.lock();
        try {
            if (this.records.isEmpty()) {
                return;
            }
            long index = this.records.get(0).getLsn().getPosition() - lsn.getPosition();
            if (index < 0L) {
                return;
            }
            if (index > (long)this.records.size()) {
                index = this.records.size();
            }
            int i = 0;
            while ((long)i < index) {
                this.records.remove(0);
                ++i;
            }
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void addFullCheckpointListener(OFullCheckpointRequestListener listener) {
    }

    @Override
    public void removeFullCheckpointListener(OFullCheckpointRequestListener listener) {
    }
}

