/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.base;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.io.IOException;

public class ODurablePage {
    public static final int PAGE_PADDING = 8;
    protected static final int MAGIC_NUMBER_OFFSET = 0;
    protected static final int CRC32_OFFSET = 8;
    public static final int WAL_SEGMENT_OFFSET = 12;
    public static final int WAL_POSITION_OFFSET = 20;
    public static final int MAX_PAGE_SIZE_BYTES = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    protected static final int NEXT_FREE_POSITION = 28;
    protected OWALChangesTree changesTree;
    private final OCacheEntry cacheEntry;
    private final ODirectMemoryPointer pagePointer;

    public ODurablePage(OCacheEntry cacheEntry, OWALChangesTree changesTree) {
        assert (cacheEntry != null || changesTree != null);
        this.cacheEntry = cacheEntry;
        if (cacheEntry != null) {
            OCachePointer cachePointer = cacheEntry.getCachePointer();
            this.pagePointer = cachePointer.getDataPointer();
        } else {
            this.pagePointer = null;
        }
        this.changesTree = changesTree;
    }

    public static OLogSequenceNumber getLogSequenceNumberFromPage(ODirectMemoryPointer dataPointer) {
        long segment = OLongSerializer.INSTANCE.deserializeFromDirectMemory(dataPointer, 20L);
        long position = OLongSerializer.INSTANCE.deserializeFromDirectMemory(dataPointer, 28L);
        return new OLogSequenceNumber(segment, position);
    }

    protected int getIntValue(int pageOffset) {
        if (this.changesTree == null) {
            return OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.pagePointer, (long)(pageOffset + 8));
        }
        return OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.changesTree.wrap(this.pagePointer), (long)(pageOffset + 8));
    }

    protected long getLongValue(int pageOffset) {
        if (this.changesTree == null) {
            return OLongSerializer.INSTANCE.deserializeFromDirectMemory(this.pagePointer, (long)(pageOffset + 8));
        }
        return OLongSerializer.INSTANCE.deserializeFromDirectMemory(this.changesTree.wrap(this.pagePointer), (long)(pageOffset + 8));
    }

    protected byte[] getBinaryValue(int pageOffset, int valLen) {
        if (this.changesTree == null) {
            return this.pagePointer.get(pageOffset + 8, valLen);
        }
        return this.changesTree.getBinaryValue(this.pagePointer, pageOffset + 8, valLen);
    }

    protected int getObjectSizeInDirectMemory(OBinarySerializer binarySerializer, long offset) {
        if (this.changesTree == null) {
            return binarySerializer.getObjectSizeInDirectMemory(this.pagePointer, offset + 8L);
        }
        return binarySerializer.getObjectSizeInDirectMemory(this.changesTree.wrap(this.pagePointer), offset + 8L);
    }

    protected <T> T deserializeFromDirectMemory(OBinarySerializer<T> binarySerializer, long offset) {
        if (this.changesTree == null) {
            return binarySerializer.deserializeFromDirectMemoryObject(this.pagePointer, offset + 8L);
        }
        return binarySerializer.deserializeFromDirectMemoryObject(this.changesTree.wrap(this.pagePointer), offset + 8L);
    }

    protected byte getByteValue(int pageOffset) {
        if (this.changesTree == null) {
            return this.pagePointer.getByte(pageOffset + 8);
        }
        return this.changesTree.getByteValue(this.pagePointer, pageOffset + 8);
    }

    protected int setIntValue(int pageOffset, int value) throws IOException {
        if (this.changesTree != null) {
            byte[] svalue = new byte[4];
            OIntegerSerializer.INSTANCE.serializeNative(value, svalue, 0, new Object[0]);
            this.changesTree.add(svalue, pageOffset + 8);
        } else {
            OIntegerSerializer.INSTANCE.serializeInDirectMemory(value, this.pagePointer, pageOffset + 8, new Object[0]);
        }
        this.cacheEntry.markDirty();
        return 4;
    }

    protected int setByteValue(int pageOffset, byte value) {
        if (this.changesTree != null) {
            this.changesTree.add(new byte[]{value}, pageOffset + 8);
        } else {
            this.pagePointer.setByte(pageOffset + 8, value);
        }
        this.cacheEntry.markDirty();
        return 1;
    }

    protected int setLongValue(int pageOffset, long value) throws IOException {
        if (this.changesTree != null) {
            byte[] svalue = new byte[8];
            OLongSerializer.INSTANCE.serializeNative(value, svalue, 0, new Object[0]);
            this.changesTree.add(svalue, pageOffset + 8);
        } else {
            OLongSerializer.INSTANCE.serializeInDirectMemory(value, this.pagePointer, pageOffset + 8, new Object[0]);
        }
        this.cacheEntry.markDirty();
        return 8;
    }

    protected int setBinaryValue(int pageOffset, byte[] value) throws IOException {
        if (value.length == 0) {
            return 0;
        }
        if (this.changesTree != null) {
            this.changesTree.add(value, pageOffset + 8);
        } else {
            this.pagePointer.set(pageOffset + 8, value, 0, value.length);
        }
        this.cacheEntry.markDirty();
        return value.length;
    }

    protected void moveData(int from, int to, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.changesTree != null) {
            byte[] content = this.changesTree.getBinaryValue(this.pagePointer, from + 8, len);
            this.changesTree.add(content, to + 8);
        } else {
            this.pagePointer.moveData(from + 8, this.pagePointer, to + 8, len);
        }
        this.cacheEntry.markDirty();
    }

    public OWALChangesTree getChangesTree() {
        return this.changesTree;
    }

    public void restoreChanges(OWALChangesTree changesTree) {
        changesTree.applyChanges(this.cacheEntry.getCachePointer().getDataPointer());
        this.cacheEntry.markDirty();
    }

    public OLogSequenceNumber getLsn() {
        long segment = this.getLongValue(12);
        long position = this.getLongValue(20);
        return new OLogSequenceNumber(segment, position);
    }

    public void setLsn(OLogSequenceNumber lsn) {
        OLongSerializer.INSTANCE.serializeInDirectMemory(lsn.getSegment(), this.pagePointer, 20L, new Object[0]);
        OLongSerializer.INSTANCE.serializeInDirectMemory(lsn.getPosition(), this.pagePointer, 28L, new Object[0]);
        this.cacheEntry.markDirty();
    }
}

