/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCachePointer;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileCreatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileDeletedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileTruncatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OUpdatePageRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OAtomicOperation {
    private final OLogSequenceNumber startLSN;
    private final OOperationUnitId operationUnitId;
    private int startCounter;
    private boolean rollback;
    private Set<String> lockedObjects = new HashSet<String>();
    private Map<Long, FileChanges> fileChanges = new HashMap<Long, FileChanges>();
    private Map<String, Long> newFileNamesId = new HashMap<String, Long>();
    private Set<Long> deletedFiles = new HashSet<Long>();
    private Map<String, Long> deletedFileNameIdMap = new HashMap<String, Long>();

    public OAtomicOperation(OLogSequenceNumber startLSN, OOperationUnitId operationUnitId) {
        this.startLSN = startLSN;
        this.operationUnitId = operationUnitId;
        this.startCounter = 1;
    }

    public OLogSequenceNumber getStartLSN() {
        return this.startLSN;
    }

    public OOperationUnitId getOperationUnitId() {
        return this.operationUnitId;
    }

    public OCacheEntry loadPage(long fileId, long pageIndex, ODiskCache diskCache, boolean checkPinnedPages) throws IOException {
        if (this.deletedFiles.contains(fileId)) {
            throw new OStorageException("File with id " + fileId + " is deleted.");
        }
        FileChanges changesContainer = this.fileChanges.get(fileId);
        if (changesContainer == null) {
            changesContainer = new FileChanges();
            this.fileChanges.put(fileId, changesContainer);
        }
        FilePageChanges pageChangesContainer = (FilePageChanges)changesContainer.pageChangesMap.get(pageIndex);
        if (changesContainer.isNew) {
            if (pageIndex <= changesContainer.maxNewPageIndex) {
                return new OCacheEntry(fileId, pageIndex, new OCachePointer((ODirectMemoryPointer)null, new OLogSequenceNumber(-1L, -1L)), false);
            }
            return null;
        }
        long filledUpTo = this.filledUpTo(fileId, diskCache);
        if (pageIndex < filledUpTo) {
            if (pageChangesContainer == null) {
                pageChangesContainer = new FilePageChanges();
                changesContainer.pageChangesMap.put(pageIndex, pageChangesContainer);
            }
            if (pageChangesContainer.isNew) {
                return new OCacheEntry(fileId, pageIndex, new OCachePointer((ODirectMemoryPointer)null, new OLogSequenceNumber(-1L, -1L)), false);
            }
            return diskCache.load(fileId, pageIndex, checkPinnedPages);
        }
        return null;
    }

    public void pinPage(OCacheEntry cacheEntry) throws IOException {
        if (this.deletedFiles.contains(cacheEntry.getFileId())) {
            throw new OStorageException("File with id " + cacheEntry.getFileId() + " is deleted.");
        }
        FileChanges changesContainer = this.fileChanges.get(cacheEntry.getFileId());
        assert (changesContainer != null);
        FilePageChanges pageChangesContainer = (FilePageChanges)changesContainer.pageChangesMap.get(cacheEntry.getPageIndex());
        assert (pageChangesContainer != null);
        pageChangesContainer.pinPage = true;
    }

    public OCacheEntry addPage(long fileId, ODiskCache diskCache) throws IOException {
        if (this.deletedFiles.contains(fileId)) {
            throw new OStorageException("File with id " + fileId + " is deleted.");
        }
        long filledUpTo = this.filledUpTo(fileId, diskCache);
        FileChanges changesContainer = this.fileChanges.get(fileId);
        assert (changesContainer != null);
        FilePageChanges pageChangesContainer = (FilePageChanges)changesContainer.pageChangesMap.get(filledUpTo);
        assert (pageChangesContainer == null);
        pageChangesContainer = new FilePageChanges();
        pageChangesContainer.isNew = true;
        changesContainer.pageChangesMap.put(filledUpTo, pageChangesContainer);
        changesContainer.maxNewPageIndex = filledUpTo;
        return new OCacheEntry(fileId, filledUpTo, new OCachePointer((ODirectMemoryPointer)null, new OLogSequenceNumber(-1L, -1L)), false);
    }

    public void releasePage(OCacheEntry cacheEntry, ODiskCache diskCache) {
        if (this.deletedFiles.contains(cacheEntry.getFileId())) {
            throw new OStorageException("File with id " + cacheEntry.getFileId() + " is deleted.");
        }
        if (cacheEntry.getCachePointer().getDataPointer() != null) {
            diskCache.release(cacheEntry);
        }
    }

    public OWALChangesTree getChangesTree(long fileId, long pageIndex) {
        if (this.deletedFiles.contains(fileId)) {
            throw new OStorageException("File with id " + fileId + " is deleted.");
        }
        FileChanges changesContainer = this.fileChanges.get(fileId);
        assert (changesContainer != null);
        FilePageChanges pageChangesContainer = (FilePageChanges)changesContainer.pageChangesMap.get(pageIndex);
        assert (pageChangesContainer != null);
        return pageChangesContainer.changesTree;
    }

    public long filledUpTo(long fileId, ODiskCache diskCache) throws IOException {
        if (this.deletedFiles.contains(fileId)) {
            throw new OStorageException("File with id " + fileId + " is deleted.");
        }
        FileChanges changesContainer = this.fileChanges.get(fileId);
        if (changesContainer == null) {
            changesContainer = new FileChanges();
            this.fileChanges.put(fileId, changesContainer);
        } else {
            if (changesContainer.isNew || changesContainer.maxNewPageIndex > -2L) {
                return changesContainer.maxNewPageIndex + 1L;
            }
            if (changesContainer.truncate) {
                return 0L;
            }
        }
        return diskCache.getFilledUpTo(fileId);
    }

    public long addFile(String fileName, ODiskCache diskCache) throws IOException {
        boolean isNew;
        long fileId;
        if (this.newFileNamesId.containsKey(fileName)) {
            throw new OStorageException("File with name " + fileName + " already exists.");
        }
        if (this.deletedFileNameIdMap.containsKey(fileName)) {
            fileId = this.deletedFileNameIdMap.remove(fileName);
            this.deletedFiles.remove(fileId);
            isNew = false;
        } else {
            fileId = diskCache.bookFileId(fileName);
            isNew = true;
        }
        this.newFileNamesId.put(fileName, fileId);
        FileChanges fileChanges = new FileChanges();
        fileChanges.isNew = isNew;
        fileChanges.fileName = fileName;
        fileChanges.maxNewPageIndex = -1L;
        this.fileChanges.put(fileId, fileChanges);
        return fileId;
    }

    public long openFile(String fileName, ODiskCache diskCache) throws IOException {
        FileChanges fileChanges;
        Long fileId = this.newFileNamesId.get(fileName);
        if (fileId == null) {
            fileId = diskCache.openFile(fileName);
        }
        if ((fileChanges = this.fileChanges.get(fileId)) == null) {
            fileChanges = new FileChanges();
            this.fileChanges.put(fileId, fileChanges);
        }
        return fileId;
    }

    public void openFile(long fileId, ODiskCache diskCache) throws IOException {
        if (this.deletedFiles.contains(fileId)) {
            throw new OStorageException("File with id " + fileId + " is deleted.");
        }
        FileChanges changesContainer = this.fileChanges.get(fileId);
        if (changesContainer == null || !changesContainer.isNew) {
            diskCache.openFile(fileId);
        }
    }

    public void deleteFile(long fileId, ODiskCache diskCache) {
        FileChanges fileChanges = this.fileChanges.remove(fileId);
        if (fileChanges != null && fileChanges.fileName != null) {
            this.newFileNamesId.remove(fileChanges.fileName);
        } else {
            this.deletedFiles.add(fileId);
            this.deletedFileNameIdMap.put(diskCache.fileNameById(fileId), fileId);
        }
    }

    public boolean isFileExists(String fileName, ODiskCache diskCache) {
        if (this.newFileNamesId.containsKey(fileName)) {
            return true;
        }
        if (this.deletedFileNameIdMap.containsKey(fileName)) {
            return false;
        }
        return diskCache.exists(fileName);
    }

    public boolean isFileExists(long fileId, ODiskCache diskCache) {
        if (this.fileChanges.containsKey(fileId)) {
            return true;
        }
        if (this.deletedFiles.contains(fileId)) {
            return false;
        }
        return diskCache.exists(fileId);
    }

    public String fileNameById(long fileId, ODiskCache diskCache) {
        FileChanges fileChanges = this.fileChanges.get(fileId);
        if (fileChanges != null && fileChanges.fileName != null) {
            return fileChanges.fileName;
        }
        if (this.deletedFiles.contains(fileId)) {
            throw new OStorageException("File with id " + fileId + " was deleted.");
        }
        return diskCache.fileNameById(fileId);
    }

    public void truncateFile(long fileId) {
        FileChanges fileChanges = this.fileChanges.get(fileId);
        if (fileChanges == null) {
            fileChanges = new FileChanges();
            this.fileChanges.put(fileId, fileChanges);
        }
        fileChanges.pageChangesMap.clear();
        fileChanges.maxNewPageIndex = -1L;
        if (fileChanges.isNew) {
            return;
        }
        fileChanges.truncate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitChanges(ODiskCache diskCache, OWriteAheadLog writeAheadLog) throws IOException {
        FilePageChanges filePageChanges;
        long pageIndex;
        long fileId;
        FileChanges fileChanges;
        Iterator<Object> iterator = this.deletedFiles.iterator();
        while (iterator.hasNext()) {
            long l = iterator.next();
            writeAheadLog.log(new OFileDeletedWALRecord(this.operationUnitId, this.startLSN, l));
        }
        for (Map.Entry entry : this.fileChanges.entrySet()) {
            fileChanges = (FileChanges)entry.getValue();
            fileId = (Long)entry.getKey();
            if (fileChanges.isNew) {
                writeAheadLog.log(new OFileCreatedWALRecord(this.operationUnitId, fileChanges.fileName, fileId, this.startLSN));
            } else if (fileChanges.truncate) {
                writeAheadLog.log(new OFileTruncatedWALRecord(this.operationUnitId, this.startLSN, fileId));
            }
            for (Map.Entry filePageChangesEntry : fileChanges.pageChangesMap.entrySet()) {
                pageIndex = (Long)filePageChangesEntry.getKey();
                filePageChanges = (FilePageChanges)filePageChangesEntry.getValue();
                filePageChanges.lsn = writeAheadLog.log(new OUpdatePageRecord(pageIndex, fileId, this.operationUnitId, filePageChanges.changesTree, this.startLSN));
            }
        }
        iterator = this.deletedFiles.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            diskCache.deleteFile(l);
        }
        for (Map.Entry entry : this.fileChanges.entrySet()) {
            fileChanges = (FileChanges)entry.getValue();
            fileId = (Long)entry.getKey();
            if (fileChanges.isNew) {
                diskCache.addFile(fileChanges.fileName, this.newFileNamesId.get(fileChanges.fileName));
            } else if (fileChanges.truncate) {
                diskCache.truncateFile(fileId);
            }
            for (Map.Entry filePageChangesEntry : fileChanges.pageChangesMap.entrySet()) {
                pageIndex = (Long)filePageChangesEntry.getKey();
                filePageChanges = (FilePageChanges)filePageChangesEntry.getValue();
                OCacheEntry cacheEntry = diskCache.load(fileId, pageIndex, true);
                if (cacheEntry == null) {
                    assert (filePageChanges.isNew);
                    do {
                        if (cacheEntry == null) continue;
                        diskCache.release(cacheEntry);
                    } while ((cacheEntry = diskCache.allocateNewPage(fileId)).getPageIndex() != pageIndex);
                }
                cacheEntry.acquireExclusiveLock();
                try {
                    ODurablePage durablePage = new ODurablePage(cacheEntry, null);
                    durablePage.restoreChanges(filePageChanges.changesTree);
                    durablePage.setLsn(filePageChanges.lsn);
                    if (filePageChanges.pinPage) {
                        diskCache.pinPage(cacheEntry);
                    }
                    diskCache.release(cacheEntry);
                }
                finally {
                    cacheEntry.releaseExclusiveLock();
                }
            }
        }
    }

    void incrementCounter() {
        ++this.startCounter;
    }

    int decrementCounter() {
        --this.startCounter;
        return this.startCounter;
    }

    void rollback() {
        this.rollback = true;
    }

    boolean isRollback() {
        return this.rollback;
    }

    void addLockedObject(String lockedObject) {
        this.lockedObjects.add(lockedObject);
    }

    boolean containsInLockedObjects(String objectToLock) {
        return this.lockedObjects.contains(objectToLock);
    }

    Iterable<String> lockedObjects() {
        return this.lockedObjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAtomicOperation operation = (OAtomicOperation)o;
        return this.operationUnitId.equals(operation.operationUnitId);
    }

    public int hashCode() {
        return this.operationUnitId.hashCode();
    }

    private static class FilePageChanges {
        private OWALChangesTree changesTree = new OWALChangesTree();
        private OLogSequenceNumber lsn = null;
        private boolean isNew = false;
        private boolean pinPage = false;

        private FilePageChanges() {
        }
    }

    private static class FileChanges {
        private Map<Long, FilePageChanges> pageChangesMap = new HashMap<Long, FilePageChanges>();
        private long maxNewPageIndex = -2L;
        private boolean isNew = false;
        private boolean truncate = false;
        private String fileName = null;

        private FileChanges() {
        }
    }
}

