/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class OPaginatedStorageDirtyFlag {
    private final String dirtyFilePath;
    private File dirtyFile;
    private RandomAccessFile dirtyFileData;
    private volatile boolean dirtyFlag;
    private final Lock lock = new ReentrantLock();

    public OPaginatedStorageDirtyFlag(String dirtyFilePath) {
        this.dirtyFilePath = dirtyFilePath;
    }

    public void create() throws IOException {
        this.lock.lock();
        try {
            boolean fileDeleted;
            this.dirtyFile = new File(this.dirtyFilePath);
            if (this.dirtyFile.exists() && !(fileDeleted = this.dirtyFile.delete())) {
                throw new IllegalStateException("Can not delete file : " + this.dirtyFilePath);
            }
            boolean fileCreated = this.dirtyFile.createNewFile();
            if (!fileCreated) {
                throw new IllegalStateException("Can not create file : " + this.dirtyFilePath);
            }
            this.dirtyFileData = new RandomAccessFile(this.dirtyFile, "rwd");
            this.dirtyFileData.seek(0L);
            this.dirtyFileData.writeBoolean(true);
            this.dirtyFlag = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean exists() {
        this.lock.lock();
        try {
            boolean bl = new File(this.dirtyFilePath).exists();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void open() throws IOException {
        this.lock.lock();
        try {
            this.dirtyFile = new File(this.dirtyFilePath);
            if (!this.dirtyFile.exists()) {
                throw new IllegalStateException("File '" + this.dirtyFilePath + "' does not exist.");
            }
            this.dirtyFileData = new RandomAccessFile(this.dirtyFile, "rwd");
            this.dirtyFileData.seek(0L);
            this.dirtyFlag = this.dirtyFileData.readBoolean();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() throws IOException {
        this.lock.lock();
        try {
            if (this.dirtyFile == null) {
                return;
            }
            if (this.dirtyFile.exists()) {
                this.dirtyFileData.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void delete() throws IOException {
        this.lock.lock();
        try {
            if (this.dirtyFile == null) {
                return;
            }
            if (this.dirtyFile.exists()) {
                this.dirtyFileData.close();
                boolean deleted = this.dirtyFile.delete();
                while (!deleted) {
                    deleted = !this.dirtyFile.exists() || this.dirtyFile.delete();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void makeDirty() throws IOException {
        if (this.dirtyFlag) {
            return;
        }
        this.lock.lock();
        try {
            if (this.dirtyFlag) {
                return;
            }
            this.dirtyFileData.seek(0L);
            this.dirtyFileData.writeBoolean(true);
            this.dirtyFlag = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearDirty() throws IOException {
        if (!this.dirtyFlag) {
            return;
        }
        this.lock.lock();
        try {
            if (!this.dirtyFlag) {
                return;
            }
            this.dirtyFileData.seek(0L);
            this.dirtyFileData.writeBoolean(false);
            this.dirtyFlag = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }
}

