/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.concur.lock.OModificationLock;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.compression.OCompression;
import com.orientechnologies.orient.core.compression.OCompressionFactory;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterEntryIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPositionMap;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPositionMapBucket;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedClusterState;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.CRC32;

public class OPaginatedCluster
extends ODurableComponent
implements OCluster {
    public static final String DEF_EXTENSION = ".pcl";
    private static final int DISK_PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger();
    private static final int LOWEST_FREELIST_BOUNDARY = OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger();
    private static final int FREE_LIST_SIZE = DISK_PAGE_SIZE - LOWEST_FREELIST_BOUNDARY;
    private static final int PAGE_INDEX_OFFSET = 16;
    private static final int RECORD_POSITION_MASK = 65535;
    private static final int ONE_KB = 1024;
    private final OModificationLock externalModificationLock = new OModificationLock();
    private volatile OCompression compression;
    private ODiskCache diskCache;
    private OClusterPositionMap clusterPositionMap;
    private OAbstractPaginatedStorage storageLocal;
    private volatile int id;
    private long fileId;
    private OStoragePaginatedClusterConfiguration config;
    private long pinnedStateEntryIndex;
    private boolean useCRC32 = OGlobalConfiguration.STORAGE_USE_CRC32_FOR_EACH_RECORD.getValueAsBoolean();
    private ORecordConflictStrategy recordConflictStrategy;

    public OPaginatedCluster(String name, OAbstractPaginatedStorage storage) {
        super(storage, name, DEF_EXTENSION);
        this.diskCache = storage.getDiskCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(OStorage storage, int id, String clusterName, Object ... parameters) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                OContextConfiguration ctxCfg = storage.getConfiguration().getContextConfiguration();
                String cfgCompression = ctxCfg.getValueAsString(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD);
                this.config = new OStoragePaginatedClusterConfiguration(storage.getConfiguration(), id, clusterName, null, true, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, cfgCompression, null, OStorageClusterConfiguration.STATUS.ONLINE);
                this.config.name = clusterName;
                this.init((OAbstractPaginatedStorage)storage, this.config);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(OStorage storage, OStorageClusterConfiguration config) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.init((OAbstractPaginatedStorage)storage, config);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public boolean exists() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            boolean bl;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                bl = OPaginatedCluster.isFileExists(atomicOperation, this.getFullName(), this.diskCache);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return bl;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(int startSize) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation();
            this.acquireExclusiveLock();
            try {
                this.fileId = OPaginatedCluster.addFile(atomicOperation, this.getFullName(), this.diskCache);
                this.initCusterState(atomicOperation);
                if (this.config.root.clusters.size() <= this.config.id) {
                    this.config.root.clusters.add(this.config);
                } else {
                    this.config.root.clusters.set(this.config.id, this.config);
                }
                this.clusterPositionMap.create();
                this.endAtomicOperation(false);
            }
            catch (Throwable e) {
                this.endAtomicOperation(true);
                throw new OStorageException("Error during creation of cluster with name " + this.getName(), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                this.fileId = OPaginatedCluster.openFile(atomicOperation, this.getFullName(), this.diskCache);
                OCacheEntry pinnedStateEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, 0L, false, this.diskCache);
                try {
                    OPaginatedCluster.pinPage(atomicOperation, pinnedStateEntry, this.diskCache);
                    this.pinnedStateEntryIndex = pinnedStateEntry.getPageIndex();
                }
                finally {
                    OPaginatedCluster.releasePage(atomicOperation, pinnedStateEntry, this.diskCache);
                }
                this.clusterPositionMap.open();
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    @Override
    public void close(boolean flush) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                if (flush) {
                    this.synch();
                }
                this.diskCache.closeFile(this.fileId, flush);
                this.clusterPositionMap.close(flush);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation();
            this.acquireExclusiveLock();
            try {
                OPaginatedCluster.deleteFile(atomicOperation, this.fileId, this.diskCache);
                this.clusterPositionMap.delete();
                this.endAtomicOperation(false);
            }
            catch (IOException ioe) {
                this.endAtomicOperation(true);
                throw ioe;
            }
            catch (Exception e) {
                this.endAtomicOperation(true);
                throw new OStorageException("Error during deletion of cluset " + this.getName(), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object set(OCluster.ATTRIBUTES attribute, Object value) throws IOException {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = value != null ? value.toString() : null;
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                switch (attribute) {
                    case NAME: {
                        this.setNameInternal(stringValue);
                        return null;
                    }
                    case USE_WAL: {
                        this.setUseWalInternal(stringValue);
                        return null;
                    }
                    case RECORD_GROW_FACTOR: {
                        this.setRecordGrowFactorInternal(stringValue);
                        return null;
                    }
                    case RECORD_OVERFLOW_GROW_FACTOR: {
                        this.setRecordOverflowGrowFactorInternal(stringValue);
                        return null;
                    }
                    case COMPRESSION: {
                        if (this.getEntries() > 0L) {
                            throw new IllegalArgumentException("Cannot change compression setting on cluster '" + this.getName() + "' because it is not empty");
                        }
                        this.setCompressionInternal(stringValue);
                        return null;
                    }
                    case CONFLICTSTRATEGY: {
                        this.setRecordConflictStrategy(stringValue);
                        return null;
                    }
                    case STATUS: {
                        Boolean bl = this.storageLocal.setClusterStatus(this.id, OStorageClusterConfiguration.STATUS.valueOf(stringValue.toUpperCase()));
                        return bl;
                    }
                    default: {
                        throw new IllegalArgumentException("Runtime change of attribute '" + (Object)((Object)attribute) + " is not supported");
                    }
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public boolean useWal() {
        this.acquireSharedLock();
        try {
            boolean bl = this.config.useWal;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public float recordGrowFactor() {
        this.acquireSharedLock();
        try {
            float f = this.config.recordGrowFactor;
            return f;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public float recordOverflowGrowFactor() {
        this.acquireSharedLock();
        try {
            float f = this.config.recordOverflowGrowFactor;
            return f;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String compression() {
        this.acquireSharedLock();
        try {
            String string = this.config.compression;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void convertToTombstone(long iPosition) throws IOException {
        throw new UnsupportedOperationException("convertToTombstone");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OPhysicalPosition createRecord(byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ORawBuffer readRecord(long clusterPosition) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            byte[] fullContent;
            ORecordVersion recordVersion;
            block24: {
                long pageIndex;
                int recordPosition;
                OAtomicOperation atomicOperation;
                block23: {
                    OClusterPage localPage;
                    OCacheEntry cacheEntry;
                    block22: {
                        block21: {
                            OClusterPositionMapBucket.PositionEntry positionEntry;
                            block20: {
                                ORawBuffer oRawBuffer;
                                this.acquireSharedLock();
                                try {
                                    atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                                    positionEntry = this.clusterPositionMap.get(clusterPosition);
                                    if (positionEntry != null) break block20;
                                    oRawBuffer = null;
                                }
                                catch (Throwable throwable) {
                                    this.releaseSharedLock();
                                    throw throwable;
                                }
                                this.releaseSharedLock();
                                return oRawBuffer;
                            }
                            recordPosition = positionEntry.getRecordPosition();
                            pageIndex = positionEntry.getPageIndex();
                            if (OPaginatedCluster.getFilledUpTo(atomicOperation, this.diskCache, this.fileId) > pageIndex) break block21;
                            ORawBuffer oRawBuffer = null;
                            this.releaseSharedLock();
                            return oRawBuffer;
                        }
                        recordVersion = null;
                        cacheEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, pageIndex, false, this.diskCache);
                        localPage = new OClusterPage(cacheEntry, false, OPaginatedCluster.getChangesTree(atomicOperation, cacheEntry));
                        if (!localPage.isDeleted(recordPosition)) break block22;
                        ORawBuffer oRawBuffer = null;
                        OPaginatedCluster.releasePage(atomicOperation, cacheEntry, this.diskCache);
                        this.releaseSharedLock();
                        return oRawBuffer;
                    }
                    recordVersion = localPage.getRecordVersion(recordPosition);
                    break block23;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        OPaginatedCluster.releasePage(atomicOperation, cacheEntry, this.diskCache);
                    }
                }
                fullContent = this.readFullEntry(clusterPosition, pageIndex, recordPosition, atomicOperation);
                if (fullContent != null) break block24;
                ORawBuffer oRawBuffer = null;
                this.releaseSharedLock();
                return oRawBuffer;
            }
            if (this.useCRC32) {
                CRC32 crc32 = new CRC32();
                int crcPosition = fullContent.length - 8 - 1 - 4;
                crc32.update(fullContent, 0, crcPosition);
                int crc = OIntegerSerializer.INSTANCE.deserializeNative(fullContent, crcPosition);
                if (crc != (int)crc32.getValue()) {
                    throw new OStorageException("Content of record for cluster with id " + this.id + " and position " + clusterPosition + " is broken.");
                }
            }
            int fullContentPosition = 0;
            byte recordType = fullContent[fullContentPosition];
            int readContentSize = OIntegerSerializer.INSTANCE.deserializeNative(fullContent, ++fullContentPosition);
            byte[] recordContent = this.compression.uncompress(fullContent, fullContentPosition += 4, readContentSize);
            ORawBuffer oRawBuffer = new ORawBuffer(recordContent, recordVersion, recordType);
            this.releaseSharedLock();
            return oRawBuffer;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean deleteRecord(long clusterPosition) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 23[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hideRecord(long position) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation();
            this.acquireExclusiveLock();
            try {
                OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(position);
                if (positionEntry == null) {
                    this.endAtomicOperation(false);
                    boolean bl = false;
                    return bl;
                }
                long pageIndex = positionEntry.getPageIndex();
                if (OPaginatedCluster.getFilledUpTo(atomicOperation, this.diskCache, this.fileId) <= pageIndex) {
                    this.endAtomicOperation(false);
                    boolean bl = false;
                    return bl;
                }
                this.updateClusterState(-1L, 0L, atomicOperation);
                this.clusterPositionMap.remove(position);
                this.endAtomicOperation(false);
                boolean bl = true;
                return bl;
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(long clusterPosition, byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        content = this.compression.compress(content);
        this.externalModificationLock.requestModificationLock();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation();
            this.acquireExclusiveLock();
            try {
                byte[] recordEntry;
                OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition);
                if (positionEntry == null) {
                    this.endAtomicOperation(false);
                    return;
                }
                int recordPosition = positionEntry.getRecordPosition();
                long pageIndex = positionEntry.getPageIndex();
                long pagePointer = this.createPagePointer(pageIndex, recordPosition);
                byte[] fullEntryContent = this.readFullEntry(clusterPosition, pageIndex, recordPosition, atomicOperation);
                if (fullEntryContent == null) {
                    this.endAtomicOperation(false);
                    return;
                }
                if (this.useCRC32) {
                    CRC32 crc32 = new CRC32();
                    int crcPosition = fullEntryContent.length - 8 - 1 - 4;
                    crc32.update(fullEntryContent, 0, crcPosition);
                    int crc = OIntegerSerializer.INSTANCE.deserializeNative(fullEntryContent, crcPosition);
                    if (crc != (int)crc32.getValue()) {
                        throw new OStorageException("Content of record for cluster with id " + this.id + " and position " + clusterPosition + " is broken.");
                    }
                }
                int updatedContentLength = content.length + 2 + 4 + 8;
                if (this.useCRC32) {
                    updatedContentLength += 4;
                }
                if (updatedContentLength <= fullEntryContent.length) {
                    recordEntry = new byte[fullEntryContent.length - 8 - 1];
                } else {
                    int grownContent = (int)((float)content.length * this.config.recordOverflowGrowFactor);
                    recordEntry = !this.useCRC32 ? new byte[grownContent + 1 + 4] : new byte[grownContent + 1 + 8];
                }
                try {
                    int entryPosition = 0;
                    recordEntry[entryPosition] = recordType;
                    OIntegerSerializer.INSTANCE.serializeNative(content.length, recordEntry, ++entryPosition, new Object[0]);
                    System.arraycopy(content, 0, recordEntry, entryPosition += 4, content.length);
                    if (this.useCRC32) {
                        CRC32 crc32 = new CRC32();
                        int crcPosition = recordEntry.length - 4;
                        crc32.update(recordEntry, 0, crcPosition);
                        OIntegerSerializer.INSTANCE.serializeNative((int)crc32.getValue(), recordEntry, crcPosition, new Object[0]);
                    }
                    int recordsSizeDiff = 0;
                    long prevPageRecordPointer = -1L;
                    int currentPos = 0;
                    while (pagePointer >= 0L && currentPos < recordEntry.length) {
                        int freePageIndex;
                        recordPosition = (int)(pagePointer & 0xFFFFL);
                        pageIndex = pagePointer >>> 16;
                        OCacheEntry cacheEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, pageIndex, false, this.diskCache);
                        cacheEntry.acquireExclusiveLock();
                        try {
                            OClusterPage localPage = new OClusterPage(cacheEntry, false, OPaginatedCluster.getChangesTree(atomicOperation, cacheEntry));
                            int freeSpace = localPage.getFreeSpace();
                            freePageIndex = this.calculateFreePageIndex(localPage);
                            int chunkSize = localPage.getRecordSize(recordPosition);
                            long nextPagePointer = localPage.getRecordLongValue(recordPosition, -8);
                            int newChunkLen = Math.min(recordEntry.length - currentPos + 8 + 1, chunkSize);
                            int dataLen = newChunkLen - 8 - 1;
                            byte[] newRecordChunk = new byte[newChunkLen];
                            System.arraycopy(recordEntry, currentPos, newRecordChunk, 0, dataLen);
                            newRecordChunk[newRecordChunk.length - 8 - 1] = currentPos > 0 ? (byte)0 : 1;
                            OLongSerializer.INSTANCE.serializeNative(-1L, newRecordChunk, newRecordChunk.length - 8, new Object[0]);
                            if (prevPageRecordPointer >= 0L) {
                                long prevPageIndex = prevPageRecordPointer >>> 16;
                                int prevPageRecordPosition = (int)(prevPageRecordPointer & 0xFFFFL);
                                OCacheEntry prevPageCacheEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, prevPageIndex, false, this.diskCache);
                                prevPageCacheEntry.acquireExclusiveLock();
                                try {
                                    OClusterPage prevPage = new OClusterPage(prevPageCacheEntry, false, OPaginatedCluster.getChangesTree(atomicOperation, prevPageCacheEntry));
                                    prevPage.setRecordLongValue(prevPageRecordPosition, -8, pagePointer);
                                }
                                finally {
                                    prevPageCacheEntry.releaseExclusiveLock();
                                    OPaginatedCluster.releasePage(atomicOperation, prevPageCacheEntry, this.diskCache);
                                }
                            }
                            localPage.replaceRecord(recordPosition, newRecordChunk, recordVersion.getCounter() != -2 ? recordVersion : null);
                            currentPos += dataLen;
                            recordsSizeDiff += freeSpace - localPage.getFreeSpace();
                            prevPageRecordPointer = pagePointer;
                            pagePointer = nextPagePointer;
                        }
                        finally {
                            cacheEntry.releaseExclusiveLock();
                            OPaginatedCluster.releasePage(atomicOperation, cacheEntry, this.diskCache);
                        }
                        this.updateFreePagesIndex(freePageIndex, pageIndex, atomicOperation);
                    }
                    int from = currentPos;
                    int to = from + (OClusterPage.MAX_RECORD_SIZE - 1 - 8);
                    if (to > recordEntry.length) {
                        to = recordEntry.length;
                    }
                    while (from < to) {
                        byte[] entryContent = new byte[to - from + 1 + 8];
                        System.arraycopy(recordEntry, from, entryContent, 0, to - from);
                        entryContent[entryContent.length - 8 - 1] = from > 0 ? (byte)0 : 1;
                        OLongSerializer.INSTANCE.serializeNative(-1L, entryContent, entryContent.length - 8, new Object[0]);
                        AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, atomicOperation);
                        recordsSizeDiff += addEntryResult.recordsSizeDiff;
                        long addedPagePointer = this.createPagePointer(addEntryResult.pageIndex, addEntryResult.pagePosition);
                        if (prevPageRecordPointer >= 0L) {
                            long prevPageIndex = prevPageRecordPointer >>> 16;
                            int prevPageRecordPosition = (int)(prevPageRecordPointer & 0xFFFFL);
                            OCacheEntry prevPageCacheEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, prevPageIndex, false, this.diskCache);
                            prevPageCacheEntry.acquireExclusiveLock();
                            try {
                                OClusterPage prevPage = new OClusterPage(prevPageCacheEntry, false, OPaginatedCluster.getChangesTree(atomicOperation, prevPageCacheEntry));
                                prevPage.setRecordLongValue(prevPageRecordPosition, -8, addedPagePointer);
                            }
                            finally {
                                prevPageCacheEntry.releaseExclusiveLock();
                                OPaginatedCluster.releasePage(atomicOperation, prevPageCacheEntry, this.diskCache);
                            }
                        }
                        prevPageRecordPointer = addedPagePointer;
                        from = to;
                        if ((to += OClusterPage.MAX_RECORD_SIZE - 8 - 1) <= recordEntry.length) continue;
                        to = recordEntry.length;
                    }
                    this.updateClusterState(0L, recordsSizeDiff, atomicOperation);
                    this.endAtomicOperation(false);
                }
                catch (Throwable e) {
                    this.endAtomicOperation(true);
                    throw new OStorageException(null, e);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public long getTombstonesCount() {
        return 0L;
    }

    @Override
    public boolean hasTombstonesSupport() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate() throws IOException {
        this.storageLocal.checkForClusterPermissions(this.getName());
        this.externalModificationLock.requestModificationLock();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation();
            this.acquireExclusiveLock();
            try {
                OPaginatedCluster.truncateFile(atomicOperation, this.fileId, this.diskCache);
                this.clusterPositionMap.truncate();
                this.initCusterState(atomicOperation);
                this.endAtomicOperation(false);
            }
            catch (Throwable e) {
                this.endAtomicOperation(true);
                throw new OStorageException(null, e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition position) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 20[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getEntries() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long getFirstPosition() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            long l;
            this.acquireSharedLock();
            try {
                l = this.clusterPositionMap.getFirstPosition();
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return l;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public long getLastPosition() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            long l;
            this.acquireSharedLock();
            try {
                l = this.clusterPositionMap.getLastPosition();
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return l;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void synch() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            this.acquireSharedLock();
            try {
                this.diskCache.flushFile(this.fileId);
                this.clusterPositionMap.flush();
            }
            finally {
                this.releaseSharedLock();
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.diskCache.setSoftlyClosed(this.fileId, softlyClosed);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean wasSoftlyClosed() throws IOException {
        this.acquireSharedLock();
        try {
            boolean bl = this.diskCache.wasSoftlyClosed(this.fileId) || this.clusterPositionMap.wasSoftlyClosed();
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getRecordsSize() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isHashBased() {
        return false;
    }

    @Override
    public OClusterEntryIterator absoluteIterator() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OClusterEntryIterator oClusterEntryIterator;
            this.acquireSharedLock();
            try {
                oClusterEntryIterator = new OClusterEntryIterator(this);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oClusterEntryIterator;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] higherPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                long[] clusterPositions = this.clusterPositionMap.higherPositions(position.clusterPosition);
                oPhysicalPositionArray = this.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                long[] clusterPositions = this.clusterPositionMap.ceilingPositions(position.clusterPosition);
                oPhysicalPositionArray = this.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] lowerPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                long[] clusterPositions = this.clusterPositionMap.lowerPositions(position.clusterPosition);
                oPhysicalPositionArray = this.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] floorPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                long[] clusterPositions = this.clusterPositionMap.floorPositions(position.clusterPosition);
                oPhysicalPositionArray = this.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public OModificationLock getExternalModificationLock() {
        return this.externalModificationLock;
    }

    @Override
    public ORecordConflictStrategy getRecordConflictStrategy() {
        return this.recordConflictStrategy;
    }

    private void setRecordConflictStrategy(String stringValue) {
        this.recordConflictStrategy = Orient.instance().getRecordConflictStrategy().getStrategy(stringValue);
        this.config.conflictStrategy = stringValue;
        this.storageLocal.getConfiguration().update();
    }

    @Override
    protected void endAtomicOperation(boolean rollback) throws IOException {
        if (!this.config.useWal) {
            return;
        }
        super.endAtomicOperation(rollback);
    }

    @Override
    protected OAtomicOperation startAtomicOperation() throws IOException {
        if (!this.config.useWal) {
            return this.atomicOperationsManager.getCurrentOperation();
        }
        return super.startAtomicOperation();
    }

    private long createPagePointer(long pageIndex, int pagePosition) {
        return pageIndex << 16 | (long)pagePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClusterState(long sizeDiff, long recordsSizeDiff, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true, this.diskCache);
        pinnedStateEntry.acquireExclusiveLock();
        try {
            OPaginatedClusterState paginatedClusterState = new OPaginatedClusterState(pinnedStateEntry, OPaginatedCluster.getChangesTree(atomicOperation, pinnedStateEntry));
            paginatedClusterState.setSize(paginatedClusterState.getSize() + sizeDiff);
            paginatedClusterState.setRecordsSize(paginatedClusterState.getRecordsSize() + recordsSizeDiff);
        }
        finally {
            pinnedStateEntry.releaseExclusiveLock();
            OPaginatedCluster.releasePage(atomicOperation, pinnedStateEntry, this.diskCache);
        }
    }

    private void init(OAbstractPaginatedStorage storage, OStorageClusterConfiguration config) throws IOException {
        OFileUtils.checkValidName(config.getName());
        this.config = (OStoragePaginatedClusterConfiguration)config;
        this.compression = OCompressionFactory.INSTANCE.getCompression(this.config.compression);
        if (((OStoragePaginatedClusterConfiguration)config).conflictStrategy != null) {
            this.recordConflictStrategy = Orient.instance().getRecordConflictStrategy().getStrategy(((OStoragePaginatedClusterConfiguration)config).conflictStrategy);
        }
        this.storageLocal = storage;
        this.id = config.getId();
        this.clusterPositionMap = new OClusterPositionMap(storage, this.getName(), this.config.useWal);
    }

    private void setCompressionInternal(String stringValue) {
        try {
            this.compression = OCompressionFactory.INSTANCE.getCompression(stringValue);
            this.config.compression = stringValue;
            this.storageLocal.getConfiguration().update();
        }
        catch (IllegalArgumentException e) {
            throw new OStorageException("Invalid value for " + (Object)((Object)OCluster.ATTRIBUTES.COMPRESSION) + " attribute. ", e);
        }
    }

    private void setRecordOverflowGrowFactorInternal(String stringValue) {
        try {
            float growFactor = Float.parseFloat(stringValue);
            if (growFactor < 1.0f) {
                throw new OStorageException((Object)((Object)OCluster.ATTRIBUTES.RECORD_OVERFLOW_GROW_FACTOR) + " can not be less than 1");
            }
            this.config.recordOverflowGrowFactor = growFactor;
            this.storageLocal.getConfiguration().update();
        }
        catch (NumberFormatException nfe) {
            throw new OStorageException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.RECORD_OVERFLOW_GROW_FACTOR) + " was passed [" + stringValue + "].", nfe);
        }
    }

    private void setRecordGrowFactorInternal(String stringValue) {
        try {
            float growFactor = Float.parseFloat(stringValue);
            if (growFactor < 1.0f) {
                throw new OStorageException((Object)((Object)OCluster.ATTRIBUTES.RECORD_GROW_FACTOR) + " can not be less than 1");
            }
            this.config.recordGrowFactor = growFactor;
            this.storageLocal.getConfiguration().update();
        }
        catch (NumberFormatException nfe) {
            throw new OStorageException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.RECORD_GROW_FACTOR) + " was passed [" + stringValue + "].", nfe);
        }
    }

    private void setUseWalInternal(String stringValue) {
        if (!stringValue.equals("true") && !stringValue.equals("false")) {
            throw new OStorageException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.USE_WAL) + " was passed [" + stringValue + "].");
        }
        this.config.useWal = Boolean.valueOf(stringValue);
        this.clusterPositionMap.setUseWal(this.config.useWal);
        this.storageLocal.getConfiguration().update();
    }

    private void setNameInternal(String newName) throws IOException {
        this.diskCache.renameFile(this.fileId, this.getFullName(), newName + this.getExtension());
        this.clusterPositionMap.rename(newName);
        this.config.name = newName;
        this.storageLocal.renameCluster(this.getName(), newName);
        this.setName(newName);
        this.storageLocal.getConfiguration().update();
    }

    private OPhysicalPosition createPhysicalPosition(byte recordType, long clusterPosition, ORecordVersion version) {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        physicalPosition.recordType = recordType;
        physicalPosition.recordSize = -1;
        physicalPosition.clusterPosition = clusterPosition;
        physicalPosition.recordVersion = version;
        return physicalPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFullEntry(long clusterPosition, long pageIndex, int recordPosition, OAtomicOperation atomicOperation) throws IOException {
        byte[] fullContent;
        if (OPaginatedCluster.getFilledUpTo(atomicOperation, this.diskCache, this.fileId) <= pageIndex) {
            return null;
        }
        ArrayList<byte[]> recordChunks = new ArrayList<byte[]>();
        int contentSize = 0;
        long nextPagePointer = -1L;
        boolean firstEntry = true;
        do {
            OCacheEntry cacheEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, pageIndex, false, this.diskCache);
            try {
                OClusterPage localPage = new OClusterPage(cacheEntry, false, OPaginatedCluster.getChangesTree(atomicOperation, cacheEntry));
                if (localPage.isDeleted(recordPosition)) {
                    if (recordChunks.isEmpty()) {
                        Iterator iterator = null;
                        return iterator;
                    }
                    throw new OStorageException("Content of record " + new ORecordId(this.id, clusterPosition) + " was broken.");
                }
                byte[] content = localPage.getRecordBinaryValue(recordPosition, 0, localPage.getRecordSize(recordPosition));
                if (firstEntry && content[content.length - 8 - 1] == 0) {
                    byte[] byArray = null;
                    return byArray;
                }
                recordChunks.add(content);
                nextPagePointer = OLongSerializer.INSTANCE.deserializeNative(content, content.length - 8);
                contentSize += content.length - 8 - 1;
                firstEntry = false;
            }
            finally {
                OPaginatedCluster.releasePage(atomicOperation, cacheEntry, this.diskCache);
            }
            pageIndex = nextPagePointer >>> 16;
            recordPosition = (int)(nextPagePointer & 0xFFFFL);
        } while (nextPagePointer >= 0L);
        if (recordChunks.size() == 1) {
            fullContent = (byte[])recordChunks.get(0);
        } else {
            fullContent = new byte[contentSize + 8 + 1];
            int fullContentPosition = 0;
            for (byte[] recordChuck : recordChunks) {
                System.arraycopy(recordChuck, 0, fullContent, fullContentPosition, recordChuck.length - 8 - 1);
                fullContentPosition += recordChuck.length - 8 - 1;
            }
        }
        return fullContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddEntryResult addEntry(ORecordVersion recordVersion, byte[] entryContent, OAtomicOperation atomicOperation) throws IOException {
        int recordSizesDiff;
        ORecordVersion finalVersion;
        int position;
        FindFreePageResult findFreePageResult = this.findFreePage(entryContent.length, atomicOperation);
        int freePageIndex = findFreePageResult.freePageIndex;
        long pageIndex = findFreePageResult.pageIndex;
        boolean newRecord = freePageIndex >= FREE_LIST_SIZE;
        OCacheEntry cacheEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, pageIndex, false, this.diskCache);
        if (cacheEntry == null) {
            cacheEntry = OPaginatedCluster.addPage(atomicOperation, this.fileId, this.diskCache);
        }
        cacheEntry.acquireExclusiveLock();
        try {
            OClusterPage localPage = new OClusterPage(cacheEntry, newRecord, OPaginatedCluster.getChangesTree(atomicOperation, cacheEntry));
            assert (newRecord || freePageIndex == this.calculateFreePageIndex(localPage));
            int initialFreeSpace = localPage.getFreeSpace();
            position = localPage.appendRecord(recordVersion, entryContent, false);
            assert (position >= 0);
            finalVersion = localPage.getRecordVersion(position);
            int freeSpace = localPage.getFreeSpace();
            recordSizesDiff = initialFreeSpace - freeSpace;
        }
        finally {
            cacheEntry.releaseExclusiveLock();
            OPaginatedCluster.releasePage(atomicOperation, cacheEntry, this.diskCache);
        }
        this.updateFreePagesIndex(freePageIndex, pageIndex, atomicOperation);
        return new AddEntryResult(pageIndex, position, finalVersion, recordSizesDiff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindFreePageResult findFreePage(int contentSize, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true, this.diskCache);
        try {
            long pageIndex;
            int freePageIndex;
            while (true) {
                int realFreePageIndex;
                freePageIndex = contentSize / 1024;
                if ((freePageIndex -= OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger()) < 0) {
                    freePageIndex = 0;
                }
                OPaginatedClusterState freePageLists = new OPaginatedClusterState(pinnedStateEntry, OPaginatedCluster.getChangesTree(atomicOperation, pinnedStateEntry));
                while ((pageIndex = freePageLists.getFreeListPage(freePageIndex)) < 0L && ++freePageIndex < FREE_LIST_SIZE) {
                }
                if (pageIndex < 0L) {
                    pageIndex = OPaginatedCluster.getFilledUpTo(atomicOperation, this.diskCache, this.fileId);
                } else {
                    --freePageIndex;
                }
                if (freePageIndex >= FREE_LIST_SIZE) break;
                OCacheEntry cacheEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, pageIndex, false, this.diskCache);
                try {
                    OClusterPage localPage = new OClusterPage(cacheEntry, false, OPaginatedCluster.getChangesTree(atomicOperation, cacheEntry));
                    realFreePageIndex = this.calculateFreePageIndex(localPage);
                }
                finally {
                    OPaginatedCluster.releasePage(atomicOperation, cacheEntry, this.diskCache);
                }
                if (realFreePageIndex == freePageIndex) break;
                OLogManager.instance().warn((Object)this, "Page in file %s with index %d was placed in wrong free list, this error will be fixed automatically.", this.getFullName(), pageIndex);
                this.updateFreePagesIndex(freePageIndex, pageIndex, atomicOperation);
            }
            FindFreePageResult findFreePageResult = new FindFreePageResult(pageIndex, freePageIndex);
            return findFreePageResult;
        }
        finally {
            OPaginatedCluster.releasePage(atomicOperation, pinnedStateEntry, this.diskCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFreePagesIndex(int prevFreePageIndex, long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        block29: {
            OCacheEntry cacheEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, pageIndex, false, this.diskCache);
            cacheEntry.acquireExclusiveLock();
            try {
                long oldFreePage;
                OClusterPage localPage = new OClusterPage(cacheEntry, false, OPaginatedCluster.getChangesTree(atomicOperation, cacheEntry));
                int newFreePageIndex = this.calculateFreePageIndex(localPage);
                if (prevFreePageIndex == newFreePageIndex) {
                    return;
                }
                long nextPageIndex = localPage.getNextPage();
                long prevPageIndex = localPage.getPrevPage();
                if (prevPageIndex >= 0L) {
                    OCacheEntry prevPageCacheEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, prevPageIndex, false, this.diskCache);
                    prevPageCacheEntry.acquireExclusiveLock();
                    try {
                        OClusterPage prevPage = new OClusterPage(prevPageCacheEntry, false, OPaginatedCluster.getChangesTree(atomicOperation, prevPageCacheEntry));
                        assert (this.calculateFreePageIndex(prevPage) == prevFreePageIndex);
                        prevPage.setNextPage(nextPageIndex);
                    }
                    finally {
                        prevPageCacheEntry.releaseExclusiveLock();
                        OPaginatedCluster.releasePage(atomicOperation, prevPageCacheEntry, this.diskCache);
                    }
                }
                if (nextPageIndex >= 0L) {
                    OCacheEntry nextPageCacheEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, nextPageIndex, false, this.diskCache);
                    nextPageCacheEntry.acquireExclusiveLock();
                    try {
                        OClusterPage nextPage = new OClusterPage(nextPageCacheEntry, false, OPaginatedCluster.getChangesTree(atomicOperation, nextPageCacheEntry));
                        if (this.calculateFreePageIndex(nextPage) != prevFreePageIndex) {
                            this.calculateFreePageIndex(nextPage);
                        }
                        assert (this.calculateFreePageIndex(nextPage) == prevFreePageIndex);
                        nextPage.setPrevPage(prevPageIndex);
                    }
                    finally {
                        nextPageCacheEntry.releaseExclusiveLock();
                        OPaginatedCluster.releasePage(atomicOperation, nextPageCacheEntry, this.diskCache);
                    }
                }
                localPage.setNextPage(-1L);
                localPage.setPrevPage(-1L);
                if (prevFreePageIndex < 0 && newFreePageIndex < 0) {
                    return;
                }
                if (prevFreePageIndex >= 0 && prevFreePageIndex < FREE_LIST_SIZE && prevPageIndex < 0L) {
                    this.updateFreePagesList(prevFreePageIndex, nextPageIndex, atomicOperation);
                }
                if (newFreePageIndex < 0) break block29;
                OCacheEntry pinnedStateEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true, this.diskCache);
                try {
                    OPaginatedClusterState clusterFreeList = new OPaginatedClusterState(pinnedStateEntry, OPaginatedCluster.getChangesTree(atomicOperation, pinnedStateEntry));
                    oldFreePage = clusterFreeList.getFreeListPage(newFreePageIndex);
                }
                finally {
                    OPaginatedCluster.releasePage(atomicOperation, pinnedStateEntry, this.diskCache);
                }
                if (oldFreePage >= 0L) {
                    OCacheEntry oldFreePageCacheEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, oldFreePage, false, this.diskCache);
                    oldFreePageCacheEntry.acquireExclusiveLock();
                    try {
                        OClusterPage oldFreeLocalPage = new OClusterPage(oldFreePageCacheEntry, false, OPaginatedCluster.getChangesTree(atomicOperation, oldFreePageCacheEntry));
                        assert (this.calculateFreePageIndex(oldFreeLocalPage) == newFreePageIndex);
                        oldFreeLocalPage.setPrevPage(pageIndex);
                    }
                    finally {
                        oldFreePageCacheEntry.releaseExclusiveLock();
                        OPaginatedCluster.releasePage(atomicOperation, oldFreePageCacheEntry, this.diskCache);
                    }
                    localPage.setNextPage(oldFreePage);
                    localPage.setPrevPage(-1L);
                }
                this.updateFreePagesList(newFreePageIndex, pageIndex, atomicOperation);
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                OPaginatedCluster.releasePage(atomicOperation, cacheEntry, this.diskCache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFreePagesList(int freeListIndex, long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = OPaginatedCluster.loadPage(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true, this.diskCache);
        pinnedStateEntry.acquireExclusiveLock();
        try {
            OPaginatedClusterState paginatedClusterState = new OPaginatedClusterState(pinnedStateEntry, OPaginatedCluster.getChangesTree(atomicOperation, pinnedStateEntry));
            paginatedClusterState.setFreeListPage(freeListIndex, pageIndex);
        }
        finally {
            pinnedStateEntry.releaseExclusiveLock();
            OPaginatedCluster.releasePage(atomicOperation, pinnedStateEntry, this.diskCache);
        }
    }

    private int calculateFreePageIndex(OClusterPage localPage) {
        int newFreePageIndex;
        if (localPage.isEmpty()) {
            newFreePageIndex = FREE_LIST_SIZE - 1;
        } else {
            newFreePageIndex = (localPage.getMaxRecordSize() - 1023) / 1024;
            newFreePageIndex -= LOWEST_FREELIST_BOUNDARY;
        }
        return newFreePageIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCusterState(OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = OPaginatedCluster.addPage(atomicOperation, this.fileId, this.diskCache);
        pinnedStateEntry.acquireExclusiveLock();
        try {
            OPaginatedClusterState paginatedClusterState = new OPaginatedClusterState(pinnedStateEntry, OPaginatedCluster.getChangesTree(atomicOperation, pinnedStateEntry));
            OPaginatedCluster.pinPage(atomicOperation, pinnedStateEntry, this.diskCache);
            paginatedClusterState.setSize(0L);
            paginatedClusterState.setRecordsSize(0L);
            for (int i = 0; i < FREE_LIST_SIZE; ++i) {
                paginatedClusterState.setFreeListPage(i, -1L);
            }
            this.pinnedStateEntryIndex = pinnedStateEntry.getPageIndex();
        }
        finally {
            pinnedStateEntry.releaseExclusiveLock();
            OPaginatedCluster.releasePage(atomicOperation, pinnedStateEntry, this.diskCache);
        }
    }

    private OPhysicalPosition[] convertToPhysicalPositions(long[] clusterPositions) {
        OPhysicalPosition[] positions = new OPhysicalPosition[clusterPositions.length];
        for (int i = 0; i < positions.length; ++i) {
            OPhysicalPosition physicalPosition = new OPhysicalPosition();
            physicalPosition.clusterPosition = clusterPositions[i];
            positions[i] = physicalPosition;
        }
        return positions;
    }

    private static final class FindFreePageResult {
        private final long pageIndex;
        private final int freePageIndex;

        private FindFreePageResult(long pageIndex, int freePageIndex) {
            this.pageIndex = pageIndex;
            this.freePageIndex = freePageIndex;
        }
    }

    private static final class AddEntryResult {
        private final long pageIndex;
        private final int pagePosition;
        private final ORecordVersion recordVersion;
        private final int recordsSizeDiff;

        public AddEntryResult(long pageIndex, int pagePosition, ORecordVersion recordVersion, int recordsSizeDiff) {
            this.pageIndex = pageIndex;
            this.pagePosition = pagePosition;
            this.recordVersion = recordVersion;
            this.recordsSizeDiff = recordsSizeDiff;
        }

        static /* synthetic */ ORecordVersion access$300(AddEntryResult x0) {
            return x0.recordVersion;
        }
    }
}

