/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPositionMapBucket;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import java.io.IOException;
import java.util.Arrays;

public class OClusterPositionMap
extends ODurableComponent {
    public static final String DEF_EXTENSION = ".cpm";
    private long fileId;
    private boolean useWal;
    private ODiskCache diskCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClusterPositionMap(OAbstractPaginatedStorage storage, String name, boolean useWal) {
        super(storage, name, DEF_EXTENSION);
        this.acquireExclusiveLock();
        try {
            this.useWal = useWal;
            this.diskCache = storage.getDiskCache();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void setUseWal(boolean useWal) {
        this.acquireExclusiveLock();
        try {
            this.useWal = useWal;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void open() throws IOException {
        this.acquireExclusiveLock();
        try {
            OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
            this.fileId = OClusterPositionMap.openFile(atomicOperation, this.getFullName(), this.diskCache);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void create() throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            this.fileId = OClusterPositionMap.addFile(atomicOperation, this.getFullName(), this.diskCache);
            this.endAtomicOperation(false);
        }
        catch (IOException ioe) {
            this.endAtomicOperation(true);
            throw ioe;
        }
        catch (Exception e) {
            this.endAtomicOperation(true);
            throw new OStorageException("Error during cluster position - physical position map.", e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void flush() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            this.acquireSharedLock();
            try {
                this.diskCache.flushFile(this.fileId);
            }
            finally {
                this.releaseSharedLock();
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    public void close(boolean flush) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.diskCache.closeFile(this.fileId, flush);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void truncate() throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            OClusterPositionMap.truncateFile(atomicOperation, this.fileId, this.diskCache);
            this.endAtomicOperation(false);
        }
        catch (IOException ioe) {
            this.endAtomicOperation(true);
            throw ioe;
        }
        catch (Exception e) {
            this.endAtomicOperation(true);
            throw new OStorageException("Error during truncation of cluster position - physical position map", e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void delete() throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            OClusterPositionMap.deleteFile(atomicOperation, this.fileId, this.diskCache);
            this.endAtomicOperation(false);
        }
        catch (IOException ioe) {
            this.endAtomicOperation(true);
            throw ioe;
        }
        catch (Exception e) {
            this.endAtomicOperation(true);
            throw new OStorageException("Error during deletion of cluster position - physical position map.", e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void rename(String newName) throws IOException {
        this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            this.diskCache.renameFile(this.fileId, this.getFullName(), newName + this.getExtension());
            this.setName(newName);
            this.endAtomicOperation(false);
        }
        catch (IOException ioe) {
            this.endAtomicOperation(true);
            throw ioe;
        }
        catch (Exception e) {
            this.endAtomicOperation(true);
            throw new OStorageException("Error during rename of cluster position - physical position map.");
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Loose catch block
     */
    public long add(long pageIndex, int recordPosition) throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            long lastPage = OClusterPositionMap.getFilledUpTo(atomicOperation, this.diskCache, this.fileId) - 1L;
            OCacheEntry cacheEntry = lastPage < 0L ? OClusterPositionMap.addPage(atomicOperation, this.fileId, this.diskCache) : OClusterPositionMap.loadPage(atomicOperation, this.fileId, lastPage, false, this.diskCache);
            cacheEntry.acquireExclusiveLock();
            try {
                OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, OClusterPositionMap.getChangesTree(atomicOperation, cacheEntry));
                if (bucket.isFull()) {
                    cacheEntry.releaseExclusiveLock();
                    OClusterPositionMap.releasePage(atomicOperation, cacheEntry, this.diskCache);
                    cacheEntry = OClusterPositionMap.addPage(atomicOperation, this.fileId, this.diskCache);
                    cacheEntry.acquireExclusiveLock();
                    bucket = new OClusterPositionMapBucket(cacheEntry, OClusterPositionMap.getChangesTree(atomicOperation, cacheEntry));
                }
                long index = bucket.add(pageIndex, recordPosition);
                long result = index + cacheEntry.getPageIndex() * (long)OClusterPositionMapBucket.MAX_ENTRIES;
                this.endAtomicOperation(false);
                long l = result;
                return l;
            }
            catch (Throwable e) {
                this.endAtomicOperation(true);
                throw new OStorageException("Error during creation of mapping between logical adn physical record position.", e);
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                OClusterPositionMap.releasePage(atomicOperation, cacheEntry, this.diskCache);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    public OClusterPositionMapBucket.PositionEntry get(long clusterPosition) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public OClusterPositionMapBucket.PositionEntry remove(long clusterPosition) throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            OClusterPositionMapBucket.PositionEntry positionEntry;
            long pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES;
            int index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
            OCacheEntry cacheEntry = OClusterPositionMap.loadPage(atomicOperation, this.fileId, pageIndex, false, this.diskCache);
            cacheEntry.acquireExclusiveLock();
            try {
                OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, OClusterPositionMap.getChangesTree(atomicOperation, cacheEntry));
                OClusterPositionMapBucket.PositionEntry positionEntry2 = bucket.remove(index);
                if (positionEntry2 == null) {
                    this.endAtomicOperation(false);
                    OClusterPositionMapBucket.PositionEntry positionEntry3 = null;
                    return positionEntry3;
                }
                this.endAtomicOperation(false);
                positionEntry = positionEntry2;
            }
            catch (Throwable e) {
                this.endAtomicOperation(true);
                throw new OStorageException("Error during removal of mapping between logical and physical record position.", e);
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                OClusterPositionMap.releasePage(atomicOperation, cacheEntry, this.diskCache);
            }
            return positionEntry;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] higherPositions(long clusterPosition) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                long[] lArray;
                this.acquireSharedLock();
                try {
                    if (clusterPosition != Long.MAX_VALUE) break block8;
                    lArray = new long[]{};
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return lArray;
            }
            long[] lArray = this.ceilingPositions(clusterPosition + 1L);
            this.releaseSharedLock();
            return lArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] ceilingPositions(long clusterPosition) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            long[] lArray;
            long filledUpTo;
            OAtomicOperation atomicOperation;
            int index;
            long pageIndex;
            block15: {
                this.acquireSharedLock();
                if (clusterPosition < 0L) {
                    clusterPosition = 0L;
                }
                pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES;
                index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
                atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                filledUpTo = OClusterPositionMap.getFilledUpTo(atomicOperation, this.diskCache, this.fileId);
                if (pageIndex < filledUpTo) break block15;
                long[] lArray2 = new long[]{};
                this.releaseSharedLock();
                return lArray2;
            }
            try {
                long[] result = null;
                do {
                    OCacheEntry cacheEntry;
                    OClusterPositionMapBucket bucket;
                    int resultSize;
                    if ((resultSize = (bucket = new OClusterPositionMapBucket(cacheEntry = OClusterPositionMap.loadPage(atomicOperation, this.fileId, pageIndex, false, this.diskCache), OClusterPositionMap.getChangesTree(atomicOperation, cacheEntry))).getSize() - index) <= 0) {
                        OClusterPositionMap.releasePage(atomicOperation, cacheEntry, this.diskCache);
                        ++pageIndex;
                        index = 0;
                        continue;
                    }
                    int entriesCount = 0;
                    long startIndex = cacheEntry.getPageIndex() * (long)OClusterPositionMapBucket.MAX_ENTRIES + (long)index;
                    result = new long[resultSize];
                    for (int i = 0; i < resultSize; ++i) {
                        if (!bucket.exists(i + index)) continue;
                        result[entriesCount] = startIndex + (long)i;
                        ++entriesCount;
                    }
                    if (entriesCount == 0) {
                        result = null;
                        ++pageIndex;
                        index = 0;
                    } else {
                        result = Arrays.copyOf(result, entriesCount);
                    }
                    OClusterPositionMap.releasePage(atomicOperation, cacheEntry, this.diskCache);
                } while (result == null && pageIndex < filledUpTo);
                if (result == null) {
                    result = new long[]{};
                }
                lArray = result;
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return lArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] lowerPositions(long clusterPosition) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                long[] lArray;
                this.acquireSharedLock();
                try {
                    if (clusterPosition != 0L) break block8;
                    lArray = new long[]{};
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return lArray;
            }
            long[] lArray = this.floorPositions(clusterPosition - 1L);
            this.releaseSharedLock();
            return lArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] floorPositions(long clusterPosition) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            long[] lArray;
            OAtomicOperation atomicOperation;
            int index;
            long pageIndex;
            block18: {
                block17: {
                    this.acquireSharedLock();
                    if (clusterPosition >= 0L) break block17;
                    long[] lArray2 = new long[]{};
                    this.releaseSharedLock();
                    return lArray2;
                }
                pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES;
                index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
                atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                long filledUpTo = OClusterPositionMap.getFilledUpTo(atomicOperation, this.diskCache, this.fileId);
                if (pageIndex >= filledUpTo) {
                    pageIndex = filledUpTo - 1L;
                    index = Integer.MIN_VALUE;
                }
                if (pageIndex >= 0L) break block18;
                long[] lArray3 = new long[]{};
                this.releaseSharedLock();
                return lArray3;
            }
            try {
                long[] result;
                do {
                    OCacheEntry cacheEntry = OClusterPositionMap.loadPage(atomicOperation, this.fileId, pageIndex, false, this.diskCache);
                    OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, OClusterPositionMap.getChangesTree(atomicOperation, cacheEntry));
                    if (index == Integer.MIN_VALUE) {
                        index = bucket.getSize() - 1;
                    }
                    int resultSize = index + 1;
                    int entriesCount = 0;
                    long startPosition = cacheEntry.getPageIndex() * (long)OClusterPositionMapBucket.MAX_ENTRIES;
                    result = new long[resultSize];
                    for (int i = 0; i < resultSize; ++i) {
                        if (!bucket.exists(i)) continue;
                        result[entriesCount] = startPosition + (long)i;
                        ++entriesCount;
                    }
                    if (entriesCount == 0) {
                        result = null;
                        --pageIndex;
                        index = Integer.MIN_VALUE;
                    } else {
                        result = Arrays.copyOf(result, entriesCount);
                    }
                    OClusterPositionMap.releasePage(atomicOperation, cacheEntry, this.diskCache);
                } while (result == null && pageIndex >= 0L);
                if (result == null) {
                    result = new long[]{};
                }
                lArray = result;
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return lArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    public long getFirstPosition() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 12[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long getLastPosition() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 12[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean wasSoftlyClosed() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            boolean bl;
            this.acquireSharedLock();
            try {
                bl = this.diskCache.wasSoftlyClosed(this.fileId);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return bl;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    protected void endAtomicOperation(boolean rollback) throws IOException {
        if (this.useWal) {
            super.endAtomicOperation(rollback);
        }
    }

    @Override
    protected OAtomicOperation startAtomicOperation() throws IOException {
        if (this.useWal) {
            return super.startAtomicOperation();
        }
        return this.atomicOperationsManager.getCurrentOperation();
    }
}

