/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OModificationLock;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManagerShared;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OLowDiskSpaceException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCachePointer;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.impl.local.OFullCheckpointRequestListener;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OOfflineCluster;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OOfflineClusterException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractCheckPointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODiskWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileCreatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileDeletedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileTruncatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFullCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ONonTxOperationPerformedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OPaginatedClusterFactory;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OUpdatePageRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageBrokenException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTxListener;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class OAbstractPaginatedStorage
extends OStorageAbstract
implements OLowDiskSpaceListener,
OFullCheckpointRequestListener {
    private static final int RECORD_LOCK_TIMEOUT = OGlobalConfiguration.STORAGE_RECORD_LOCK_TIMEOUT.getValueAsInteger();
    private final OLockManager<ORID, OAbstractPaginatedStorage> lockManager;
    private final String PROFILER_CREATE_RECORD;
    private final String PROFILER_READ_RECORD;
    private final String PROFILER_UPDATE_RECORD;
    private final String PROFILER_DELETE_RECORD;
    private final ConcurrentMap<String, OCluster> clusterMap = new ConcurrentHashMap<String, OCluster>();
    private final ThreadLocal<OStorageTransaction> transaction = new ThreadLocal();
    private final OModificationLock modificationLock = new OModificationLock();
    private final AtomicBoolean checkpointInProgress = new AtomicBoolean();
    protected volatile OWriteAheadLog writeAheadLog;
    protected volatile ODiskCache diskCache;
    private ORecordConflictStrategy recordConflictStrategy = (ORecordConflictStrategy)Orient.instance().getRecordConflictStrategy().newInstanceOfDefaultClass();
    private CopyOnWriteArrayList<OCluster> clusters = new CopyOnWriteArrayList();
    private volatile int defaultClusterId = -1;
    private volatile OAtomicOperationsManager atomicOperationsManager;
    private volatile boolean wereDataRestoredAfterOpen = false;
    private volatile boolean wereNonTxOperationsPerformedInPreviousOpen = false;
    private boolean makeFullCheckPointAfterClusterCreate = OGlobalConfiguration.STORAGE_MAKE_FULL_CHECKPOINT_AFTER_CLUSTER_CREATE.getValueAsBoolean();
    private volatile OLowDiskSpaceInformation lowDiskSpace = null;
    private volatile boolean checkpointRequest = false;

    public OAbstractPaginatedStorage(String name, String filePath, String mode) {
        super(name, filePath, mode, OGlobalConfiguration.STORAGE_LOCK_TIMEOUT.getValueAsInteger());
        this.lockManager = new OLockManager<ORID, OAbstractPaginatedStorage>(true, -1){

            @Override
            protected ORID getImmutableResourceId(ORID iResourceId) {
                return new ORecordId(iResourceId);
            }
        };
        this.PROFILER_CREATE_RECORD = "db." + this.name + ".createRecord";
        this.PROFILER_READ_RECORD = "db." + this.name + ".readRecord";
        this.PROFILER_UPDATE_RECORD = "db." + this.name + ".updateRecord";
        this.PROFILER_DELETE_RECORD = "db." + this.name + ".deleteRecord";
    }

    @Override
    public void open(String iUserName, String iUserPassword, Map<String, Object> iProperties) {
        if (this.status == OStorage.STATUS.OPEN) {
            return;
        }
        this.lock.acquireExclusiveLock();
        try {
            if (this.status == OStorage.STATUS.OPEN) {
                return;
            }
            if (!this.exists()) {
                throw new OStorageException("Cannot open the storage '" + this.name + "' because it does not exist in path: " + this.url);
            }
            this.configuration.load();
            this.componentsFactory = new OCurrentStorageComponentsFactory(this.configuration);
            this.preOpenSteps();
            this.initWalAndDiskCache();
            this.atomicOperationsManager = new OAtomicOperationsManager(this);
            this.restoreIfNeeded();
            this.addDefaultClusters();
            for (int i = 0; i < this.configuration.clusters.size(); ++i) {
                OStorageClusterConfiguration clusterConfig = this.configuration.clusters.get(i);
                if (clusterConfig != null) {
                    int pos = this.createClusterFromConfig(clusterConfig);
                    try {
                        if (pos == -1) {
                            this.clusters.get(i).open();
                            continue;
                        }
                        if (clusterConfig.getName().equals("default")) {
                            this.defaultClusterId = pos;
                        }
                        this.clusters.get(pos).open();
                    }
                    catch (FileNotFoundException e) {
                        OLogManager.instance().warn((Object)this, "Error on loading cluster '" + this.clusters.get(i).getName() + "' (" + i + "): file not found. It will be excluded from current database '" + this.getName() + "'.", new Object[0]);
                        this.clusterMap.remove(this.clusters.get(i).getName().toLowerCase());
                        this.setCluster(i, null);
                    }
                    continue;
                }
                this.setCluster(i, null);
            }
            if (OGlobalConfiguration.STORAGE_MAKE_FULL_CHECKPOINT_AFTER_OPEN.getValueAsBoolean()) {
                this.makeFullCheckpoint();
            }
            this.diskCache.startFuzzyCheckpoints();
            this.status = OStorage.STATUS.OPEN;
        }
        catch (Exception e) {
            this.status = OStorage.STATUS.CLOSED;
            throw new OStorageException("Cannot open local storage '" + this.url + "' with mode=" + this.mode, e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void open(OToken iToken, Map<String, Object> iProperties) {
        this.open(iToken.getUserName(), "", iProperties);
    }

    @Override
    public void create(Map<String, Object> iProperties) {
        this.lock.acquireExclusiveLock();
        try {
            if (this.status != OStorage.STATUS.CLOSED) {
                throw new OStorageException("Cannot create new storage '" + this.name + "' because it is not closed");
            }
            if (this.exists()) {
                throw new OStorageException("Cannot create new storage '" + this.name + "' because it already exists");
            }
            if (!this.configuration.getContextConfiguration().getContextKeys().contains(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.getKey())) {
                this.configuration.getContextConfiguration().setValue(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD, OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.getValue());
            }
            this.componentsFactory = new OCurrentStorageComponentsFactory(this.configuration);
            this.initWalAndDiskCache();
            this.atomicOperationsManager = new OAtomicOperationsManager(this);
            this.preCreateSteps();
            this.status = OStorage.STATUS.OPEN;
            this.doAddCluster("internal", false, null);
            this.configuration.create();
            this.doAddCluster("index", false, null);
            this.doAddCluster("manindex", false, null);
            this.defaultClusterId = this.doAddCluster("default", false, null);
            this.clearStorageDirty();
            if (OGlobalConfiguration.STORAGE_MAKE_FULL_CHECKPOINT_AFTER_CREATE.getValueAsBoolean()) {
                this.makeFullCheckpoint();
            }
            this.diskCache.startFuzzyCheckpoints();
            this.postCreateSteps();
        }
        catch (OStorageException e) {
            this.close();
            throw e;
        }
        catch (IOException e) {
            this.close();
            throw new OStorageException("Error on creation of storage '" + this.name + "'", e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void startAtomicOperation() throws IOException {
        this.lock.acquireSharedLock();
        try {
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation(null);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public void commitAtomicOperation() throws IOException {
        this.lock.acquireSharedLock();
        try {
            this.atomicOperationsManager.endAtomicOperation(false);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public void rollbackAtomicOperation() throws IOException {
        this.lock.acquireSharedLock();
        try {
            this.atomicOperationsManager.endAtomicOperation(true);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public void markDirty() throws IOException {
        this.makeStorageDirty();
    }

    @Override
    public void close(boolean force, boolean onDelete) {
        this.doClose(force, onDelete);
    }

    @Override
    public void delete() {
        long timer = Orient.instance().getProfiler().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            this.doClose(true, true);
            try {
                Orient.instance().unregisterStorage(this);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Cannot unregister storage", (Throwable)e, new Object[0]);
            }
            if (this.writeAheadLog != null) {
                this.writeAheadLog.delete();
            }
            if (this.diskCache != null) {
                this.diskCache.delete();
            }
            this.postDeleteSteps();
        }
        catch (IOException e) {
            throw new OStorageException("Cannot delete database '" + this.name + "'.", e);
        }
        finally {
            this.lock.releaseExclusiveLock();
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".drop", "Drop a database", timer, "db.*.drop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(boolean verbose, OCommandOutputListener listener) {
        this.lock.acquireExclusiveLock();
        try {
            long start = System.currentTimeMillis();
            OPageDataVerificationError[] pageErrors = this.diskCache.checkStoredPages(verbose ? listener : null);
            listener.onMessage("Check of storage completed in " + (System.currentTimeMillis() - start) + "ms. " + (pageErrors.length > 0 ? pageErrors.length + " with errors." : " without errors."));
            boolean bl = pageErrors.length == 0;
            return bl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void enableFullCheckPointAfterClusterCreate() {
        this.checkOpeness();
        this.lock.acquireExclusiveLock();
        try {
            this.makeFullCheckPointAfterClusterCreate = true;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void disableFullCheckPointAfterClusterCreate() {
        this.checkOpeness();
        this.lock.acquireExclusiveLock();
        try {
            this.makeFullCheckPointAfterClusterCreate = false;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public boolean isMakeFullCheckPointAfterClusterCreate() {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            boolean bl = this.makeFullCheckPointAfterClusterCreate;
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int addCluster(String clusterName, boolean forceListBased, Object ... parameters) {
        this.checkOpeness();
        this.checkLowDiskSpaceAndFullCheckpointRequests();
        this.lock.acquireExclusiveLock();
        try {
            this.makeStorageDirty();
            int n = this.doAddCluster(clusterName, true, parameters);
            return n;
        }
        catch (Exception e) {
            throw new OStorageException("Error in creation of new cluster '" + clusterName, e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public int addCluster(String clusterName, int requestedId, boolean forceListBased, Object ... parameters) {
        this.checkLowDiskSpaceAndFullCheckpointRequests();
        this.lock.acquireExclusiveLock();
        try {
            if (requestedId < 0) {
                throw new OConfigurationException("Cluster id must be positive!");
            }
            if (requestedId < this.clusters.size() && this.clusters.get(requestedId) != null) {
                throw new OConfigurationException("Requested cluster ID [" + requestedId + "] is occupied by cluster with name [" + this.clusters.get(requestedId).getName() + "]");
            }
            this.makeStorageDirty();
            int n = this.addClusterInternal(clusterName, requestedId, true, parameters);
            return n;
        }
        catch (Exception e) {
            throw new OStorageException("Error in creation of new cluster '" + clusterName + "'", e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public boolean dropCluster(int clusterId, boolean iTruncate) {
        this.checkLowDiskSpaceAndFullCheckpointRequests();
        this.lock.acquireExclusiveLock();
        try {
            if (clusterId < 0 || clusterId >= this.clusters.size()) {
                throw new IllegalArgumentException("Cluster id '" + clusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.size() - 1) + ") in database '" + this.name + "'");
            }
            OCluster cluster = this.clusters.get(clusterId);
            if (cluster == null) {
                boolean bl = false;
                return bl;
            }
            if (iTruncate) {
                cluster.truncate();
            }
            cluster.delete();
            this.makeStorageDirty();
            this.clusterMap.remove(cluster.getName().toLowerCase());
            this.clusters.set(clusterId, null);
            this.configuration.dropCluster(clusterId);
            this.makeFullCheckpoint();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new OStorageException("Error while removing cluster '" + clusterId + "'", e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public boolean setClusterStatus(int clusterId, OStorageClusterConfiguration.STATUS iStatus) {
        this.lock.acquireExclusiveLock();
        try {
            OCluster newCluster;
            if (clusterId < 0 || clusterId >= this.clusters.size()) {
                throw new IllegalArgumentException("Cluster id '" + clusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.size() - 1) + ") in database '" + this.name + "'");
            }
            OCluster cluster = this.clusters.get(clusterId);
            if (cluster == null) {
                boolean bl = false;
                return bl;
            }
            if (iStatus == OStorageClusterConfiguration.STATUS.OFFLINE && cluster instanceof OOfflineCluster || iStatus == OStorageClusterConfiguration.STATUS.ONLINE && !(cluster instanceof OOfflineCluster)) {
                boolean bl = false;
                return bl;
            }
            if (iStatus == OStorageClusterConfiguration.STATUS.OFFLINE) {
                cluster.close(true);
                newCluster = new OOfflineCluster(this, clusterId, cluster.getName());
            } else {
                newCluster = OPaginatedClusterFactory.INSTANCE.createCluster(cluster.getName(), this.configuration.version, this);
                newCluster.configure(this, clusterId, cluster.getName(), new Object[0]);
                newCluster.open();
            }
            this.clusterMap.put(cluster.getName().toLowerCase(), newCluster);
            this.clusters.set(clusterId, newCluster);
            this.makeStorageDirty();
            this.configuration.setClusterStatus(clusterId, iStatus);
            this.makeFullCheckpoint();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new OStorageException("Error while removing cluster '" + clusterId + "'", e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public Class<OSBTreeCollectionManagerShared> getCollectionManagerClass() {
        return OSBTreeCollectionManagerShared.class;
    }

    public ODiskCache getDiskCache() {
        return this.diskCache;
    }

    public void freeze(boolean throwException, int clusterId) {
        OCluster cluster = this.getClusterById(clusterId);
        String name = cluster.getName();
        if ("index".equals(name) || "manindex".equals(name)) {
            throw new IllegalArgumentException("It is impossible to freeze and release index or manual index cluster!");
        }
        cluster.getExternalModificationLock().prohibitModifications(throwException);
        try {
            cluster.synch();
            cluster.setSoftlyClosed(true);
        }
        catch (IOException e) {
            throw new OStorageException("Error on synch cluster '" + name + "'", e);
        }
    }

    public void release(int clusterId) {
        OCluster cluster = this.getClusterById(clusterId);
        String name = cluster.getName();
        if ("index".equals(name) || "manindex".equals(name)) {
            throw new IllegalArgumentException("It is impossible to freeze and release index or manualindex cluster!");
        }
        try {
            cluster.setSoftlyClosed(false);
        }
        catch (IOException e) {
            throw new OStorageException("Error on unfreeze storage '" + name + "'", e);
        }
        cluster.getExternalModificationLock().allowModifications();
    }

    @Override
    public long count(int iClusterId) {
        return this.count(iClusterId, false);
    }

    @Override
    public long count(int clusterId, boolean countTombstones) {
        if (clusterId == -1) {
            throw new OStorageException("Cluster Id " + clusterId + " is invalid in database '" + this.name + "'");
        }
        this.checkOpeness();
        OCluster cluster = this.clusters.get(clusterId);
        if (cluster == null) {
            return 0L;
        }
        if (countTombstones) {
            return cluster.getEntries();
        }
        return cluster.getEntries() - cluster.getTombstonesCount();
    }

    @Override
    public long[] getClusterDataRange(int iClusterId) {
        if (iClusterId == -1) {
            return new long[]{-1L, -1L};
        }
        this.checkOpeness();
        try {
            long[] lArray;
            if (this.clusters.get(iClusterId) != null) {
                long[] lArray2 = new long[2];
                lArray2[0] = this.clusters.get(iClusterId).getFirstPosition();
                lArray = lArray2;
                lArray2[1] = this.clusters.get(iClusterId).getLastPosition();
            } else {
                lArray = new long[]{};
            }
            return lArray;
        }
        catch (IOException ioe) {
            throw new OStorageException("Can not retrieve information about data range", ioe);
        }
    }

    @Override
    public long count(int[] iClusterIds) {
        return this.count(iClusterIds, false);
    }

    @Override
    public long count(int[] iClusterIds, boolean countTombstones) {
        this.checkOpeness();
        long tot = 0L;
        for (int iClusterId : iClusterIds) {
            OCluster c;
            if (iClusterId >= this.clusters.size()) {
                throw new OConfigurationException("Cluster id " + iClusterId + " was not found in database '" + this.name + "'");
            }
            if (iClusterId <= -1 || (c = this.clusters.get(iClusterId)) == null) continue;
            tot += c.getEntries() - (countTombstones ? 0L : c.getTombstonesCount());
        }
        return tot;
    }

    /*
     * Exception decompiling
     */
    @Override
    public OStorageOperationResult<OPhysicalPosition> createRecord(ORecordId rid, byte[] content, ORecordVersion recordVersion, byte recordType, int mode, ORecordCallback<Long> callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordMetadata getRecordMetadata(ORID rid) {
        block12: {
            if (rid.isNew()) {
                throw new OStorageException("Passed record with id " + rid + " is new and can not be stored.");
            }
            this.checkOpeness();
            OCluster cluster = this.getClusterById(rid.getClusterId());
            this.lockManager.acquireLock(this, rid, OLockManager.LOCK.SHARED);
            try {
                OPhysicalPosition ppos;
                block11: {
                    this.lock.acquireSharedLock();
                    try {
                        ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
                        if (ppos != null) break block11;
                        ORecordMetadata oRecordMetadata = null;
                        this.lock.releaseSharedLock();
                        return oRecordMetadata;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.lock.releaseSharedLock();
                            throw throwable;
                        }
                        catch (IOException ioe) {
                            OLogManager.instance().error((Object)this, "Retrieval of record  '" + rid + "' cause: " + ioe.getMessage(), (Throwable)ioe, new Object[0]);
                            break block12;
                        }
                    }
                }
                ORecordMetadata oRecordMetadata = new ORecordMetadata(rid, ppos.recordVersion);
                this.lock.releaseSharedLock();
                return oRecordMetadata;
            }
            finally {
                this.lockManager.releaseLock(this, rid, OLockManager.LOCK.SHARED);
            }
        }
        return null;
    }

    @Override
    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback) {
        this.checkOpeness();
        return new OStorageOperationResult<ORawBuffer>(this.readRecord(this.getClusterById(iRid.clusterId), iRid));
    }

    /*
     * Exception decompiling
     */
    @Override
    public OStorageOperationResult<ORecordVersion> updateRecord(ORecordId rid, boolean updateContent, byte[] content, ORecordVersion version, byte recordType, int mode, ORecordCallback<ORecordVersion> callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public OStorageTransaction getStorageTransaction() {
        return this.transaction.get();
    }

    public OAtomicOperationsManager getAtomicOperationsManager() {
        return this.atomicOperationsManager;
    }

    public OWriteAheadLog getWALInstance() {
        return this.writeAheadLog;
    }

    /*
     * Exception decompiling
     */
    @Override
    public OStorageOperationResult<Boolean> deleteRecord(ORecordId rid, ORecordVersion version, int mode, ORecordCallback<Boolean> callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OStorageOperationResult<Boolean> hideRecord(ORecordId rid, int mode, ORecordCallback<Boolean> callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        if (iExclusiveLock) {
            this.modificationLock.requestModificationLock();
            try {
                V v = super.callInLock(iCallable, true);
                return v;
            }
            finally {
                this.modificationLock.releaseModificationLock();
            }
        }
        return super.callInLock(iCallable, false);
    }

    @Override
    public Set<String> getClusterNames() {
        this.checkOpeness();
        return new HashSet<String>(this.clusterMap.keySet());
    }

    @Override
    public int getClusterIdByName(String clusterName) {
        this.checkOpeness();
        if (clusterName == null) {
            throw new IllegalArgumentException("Cluster name is null");
        }
        if (clusterName.length() == 0) {
            throw new IllegalArgumentException("Cluster name is empty");
        }
        if (Character.isDigit(clusterName.charAt(0))) {
            return Integer.parseInt(clusterName);
        }
        OCluster segment = (OCluster)this.clusterMap.get(clusterName.toLowerCase());
        if (segment != null) {
            return segment.getId();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(OTransaction clientTx, Runnable callback) {
        this.checkOpeness();
        this.checkLowDiskSpaceAndFullCheckpointRequests();
        ODatabaseDocumentInternal databaseRecord = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (databaseRecord != null) {
            ((OMetadataInternal)databaseRecord.getMetadata()).makeThreadLocalSchemaSnapshot();
        }
        try {
            this.modificationLock.requestModificationLock();
            try {
                this.lock.acquireExclusiveLock();
                try {
                    if (this.writeAheadLog == null && clientTx.isUsingLog()) {
                        throw new OStorageException("WAL mode is not active. Transactions are not supported in given mode");
                    }
                    this.makeStorageDirty();
                    this.startStorageTx(clientTx);
                    ArrayList<ORecordOperation> tmpEntries = new ArrayList<ORecordOperation>();
                    while (clientTx.getCurrentRecordEntries().iterator().hasNext()) {
                        for (ORecordOperation oRecordOperation : clientTx.getCurrentRecordEntries()) {
                            tmpEntries.add(oRecordOperation);
                        }
                        clientTx.clearRecordEntries();
                        for (ORecordOperation oRecordOperation : tmpEntries) {
                            ORecord record;
                            if (oRecordOperation.type != 3 && oRecordOperation.type != 1 || !((record = oRecordOperation.getRecord()) instanceof ODocument)) continue;
                            ((ODocument)record).validate();
                        }
                        for (ORecordOperation oRecordOperation : tmpEntries) {
                            this.commitEntry(clientTx, oRecordOperation);
                        }
                    }
                    if (callback != null) {
                        callback.run();
                    }
                    this.endStorageTx();
                    OTransactionAbstract.updateCacheFromEntries(clientTx, clientTx.getAllRecordEntries(), true);
                }
                catch (Exception e) {
                    OLogManager.instance().debug((Object)this, "Error during transaction commit, transaction will be rolled back (tx-id=%d)", (Throwable)e, clientTx.getId());
                    this.rollback(clientTx);
                    if (e instanceof OException) {
                        throw (OException)e;
                    }
                    throw new OStorageException("Error during transaction commit.", e);
                }
                finally {
                    this.transaction.set(null);
                    this.lock.releaseExclusiveLock();
                }
            }
            finally {
                this.modificationLock.releaseModificationLock();
            }
        }
        finally {
            if (databaseRecord != null) {
                ((OMetadataInternal)databaseRecord.getMetadata()).clearThreadLocalSchemaSnapshot();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(OTransaction clientTx) {
        this.checkOpeness();
        this.modificationLock.requestModificationLock();
        try {
            this.lock.acquireExclusiveLock();
            try {
                if (this.transaction.get() == null) {
                    return;
                }
                if (this.writeAheadLog == null) {
                    throw new OStorageException("WAL mode is not active. Transactions are not supported in given mode");
                }
                if (this.transaction.get().getClientTx().getId() != clientTx.getId()) {
                    throw new OStorageException("Passed in and active transaction are different transactions. Passed in transaction can not be rolled back.");
                }
                this.makeStorageDirty();
                this.rollbackStorageTx();
                OTransactionAbstract.updateCacheFromEntries(clientTx, clientTx.getAllRecordEntries(), false);
            }
            catch (IOException e) {
                throw new OStorageException("Error during transaction rollback.", e);
            }
            finally {
                this.transaction.set(null);
                this.lock.releaseExclusiveLock();
            }
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return ppos != null && !ppos.recordVersion.isTombstone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synch() {
        this.checkOpeness();
        long timer = Orient.instance().getProfiler().startChrono();
        this.modificationLock.prohibitModifications();
        try {
            this.lock.acquireSharedLock();
            try {
                if (this.writeAheadLog != null) {
                    this.makeFullCheckpoint();
                    return;
                }
                this.diskCache.flushBuffer();
                if (this.configuration != null) {
                    this.configuration.synch();
                }
                this.clearStorageDirty();
            }
            catch (IOException e) {
                throw new OStorageException("Error on synch storage '" + this.name + "'", e);
            }
            finally {
                this.lock.releaseSharedLock();
                Orient.instance().getProfiler().stopChrono("db." + this.name + ".synch", "Synch a database", timer, "db.*.synch");
            }
        }
        finally {
            this.modificationLock.allowModifications();
        }
    }

    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        this.checkOpeness();
        if (iClusterId < 0 || iClusterId >= this.clusters.size()) {
            return null;
        }
        return this.clusters.get(iClusterId) != null ? this.clusters.get(iClusterId).getName() : null;
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    @Override
    public void setDefaultClusterId(int defaultClusterId) {
        this.defaultClusterId = defaultClusterId;
    }

    @Override
    public OCluster getClusterById(int iClusterId) {
        if (iClusterId == -1) {
            iClusterId = this.defaultClusterId;
        }
        this.checkClusterSegmentIndexRange(iClusterId);
        OCluster cluster = this.clusters.get(iClusterId);
        if (cluster == null) {
            throw new IllegalArgumentException("Cluster " + iClusterId + " is null");
        }
        return cluster;
    }

    @Override
    public OCluster getClusterByName(String clusterName) {
        OCluster cluster = (OCluster)this.clusterMap.get(clusterName.toLowerCase());
        if (cluster == null) {
            throw new IllegalArgumentException("Cluster " + clusterName + " does not exist in database '" + this.name + "'");
        }
        return cluster;
    }

    @Override
    public long getSize() {
        try {
            long size = 0L;
            for (OCluster c : this.clusters) {
                if (c == null) continue;
                size += c.getRecordsSize();
            }
            return size;
        }
        catch (IOException ioe) {
            throw new OStorageException("Can not calculate records size");
        }
    }

    @Override
    public int getClusters() {
        return this.clusterMap.size();
    }

    public Set<OCluster> getClusterInstances() {
        HashSet<OCluster> result = new HashSet<OCluster>();
        for (OCluster c : this.clusters) {
            if (c == null) continue;
            result.add(c);
        }
        return result;
    }

    public void renameCluster(String oldName, String newName) {
        this.clusterMap.put(newName.toLowerCase(), (OCluster)this.clusterMap.remove(oldName.toLowerCase()));
    }

    @Override
    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        return this.deleteRecord(recordId, recordVersion, iMode, callback).getResult();
    }

    public void freeze(boolean throwException) {
        this.modificationLock.prohibitModifications(throwException);
        this.synch();
        try {
            this.unlock();
            this.diskCache.setSoftlyClosed(true);
            if (this.configuration != null) {
                this.configuration.setSoftlyClosed(true);
            }
        }
        catch (IOException e) {
            this.modificationLock.allowModifications();
            try {
                this.lock();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new OStorageException("Error on freeze of storage '" + this.name + "'", e);
        }
    }

    public void release() {
        try {
            this.lock();
            this.diskCache.setSoftlyClosed(false);
            if (this.configuration != null) {
                this.configuration.setSoftlyClosed(false);
            }
        }
        catch (IOException e) {
            throw new OStorageException("Error on release of storage '" + this.name + "'", e);
        }
        this.modificationLock.allowModifications();
    }

    public boolean wereDataRestoredAfterOpen() {
        return this.wereDataRestoredAfterOpen;
    }

    public boolean wereNonTxOperationsPerformedInPreviousOpen() {
        return this.wereNonTxOperationsPerformedInPreviousOpen;
    }

    @Override
    public void reload() {
    }

    public String getMode() {
        return this.mode;
    }

    @Override
    public void lowDiskSpace(OLowDiskSpaceInformation information) {
        this.lowDiskSpace = information;
    }

    @Override
    public void requestCheckpoint() {
        this.checkpointRequest = true;
    }

    @Override
    public Object command(OCommandRequestText iCommand) {
        OCommandExecutor executor = OCommandManager.instance().getExecutor(iCommand);
        executor.setContext(iCommand.getContext());
        executor.setProgressListener(iCommand.getProgressListener());
        executor.parse(iCommand);
        return this.executeCommand(iCommand, executor);
    }

    public Object executeCommand(OCommandRequestText iCommand, OCommandExecutor executor) {
        if (iCommand.isIdempotent() && !executor.isIdempotent()) {
            throw new OCommandExecutionException("Cannot execute non idempotent command");
        }
        long beginTime = Orient.instance().getProfiler().startChrono();
        try {
            Object object = executor.execute(iCommand.getParameters());
            return object;
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OCommandExecutionException("Error on execution of command: " + iCommand, e);
        }
        finally {
            if (Orient.instance().getProfiler().isRecording()) {
                Orient.instance().getProfiler().stopChrono("db." + ODatabaseRecordThreadLocal.INSTANCE.get().getName() + ".command." + iCommand.toString(), "Command executed against the database", beginTime, "db.*.command.*");
            }
        }
    }

    @Override
    public OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        if (currentClusterId == -1) {
            return null;
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.getClusterById(currentClusterId);
            OPhysicalPosition[] oPhysicalPositionArray = cluster.higherPositions(physicalPosition);
            return oPhysicalPositionArray;
        }
        catch (IOException ioe) {
            throw new OStorageException("Cluster Id " + currentClusterId + " is invalid in storage '" + this.name + '\'', ioe);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        if (clusterId == -1) {
            return null;
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.getClusterById(clusterId);
            OPhysicalPosition[] oPhysicalPositionArray = cluster.ceilingPositions(physicalPosition);
            return oPhysicalPositionArray;
        }
        catch (IOException ioe) {
            throw new OStorageException("Cluster Id " + clusterId + " is invalid in storage '" + this.name + '\'', ioe);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        if (currentClusterId == -1) {
            return null;
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.getClusterById(currentClusterId);
            OPhysicalPosition[] oPhysicalPositionArray = cluster.lowerPositions(physicalPosition);
            return oPhysicalPositionArray;
        }
        catch (IOException ioe) {
            throw new OStorageException("Cluster Id " + currentClusterId + " is invalid in storage '" + this.name + '\'', ioe);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        if (clusterId == -1) {
            return null;
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.getClusterById(clusterId);
            OPhysicalPosition[] oPhysicalPositionArray = cluster.floorPositions(physicalPosition);
            return oPhysicalPositionArray;
        }
        catch (IOException ioe) {
            throw new OStorageException("Cluster Id " + clusterId + " is invalid in storage '" + this.name + '\'', ioe);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public void acquireWriteLock(ORID rid) {
        assert (!this.lock.assertSharedLockHold() && !this.lock.assertExclusiveLockHold()) : " a record lock should not be taken inside a storage lock";
        this.lockManager.acquireLock(this, rid, OLockManager.LOCK.EXCLUSIVE);
    }

    public void releaseWriteLock(ORID rid) {
        assert (!this.lock.assertSharedLockHold() && !this.lock.assertExclusiveLockHold()) : " a record lock should not be released inside a storage lock";
        this.lockManager.releaseLock(this, rid, OLockManager.LOCK.EXCLUSIVE);
    }

    public void acquireReadLock(ORID rid) {
        assert (!this.lock.assertSharedLockHold() && !this.lock.assertExclusiveLockHold()) : " a record lock should not be taken inside a storage lock";
        this.lockManager.acquireLock(this, rid, OLockManager.LOCK.SHARED);
    }

    public void releaseReadLock(ORID iRid) {
        assert (!this.lock.assertSharedLockHold() && !this.lock.assertExclusiveLockHold()) : " a record lock should not be released inside a storage lock";
        this.lockManager.releaseLock(this, iRid, OLockManager.LOCK.SHARED);
    }

    @Override
    public ORecordConflictStrategy getConflictStrategy() {
        return this.recordConflictStrategy;
    }

    @Override
    public void setConflictStrategy(ORecordConflictStrategy conflictResolver) {
        this.recordConflictStrategy = conflictResolver;
    }

    protected void checkOpeness() {
        if (this.status != OStorage.STATUS.OPEN) {
            throw new OStorageException("Storage " + this.name + " is not opened.");
        }
    }

    protected void makeFullCheckpoint() throws IOException {
        if (this.writeAheadLog == null) {
            return;
        }
        try {
            this.writeAheadLog.flush();
            if (this.configuration != null) {
                this.configuration.synch();
            }
            OLogSequenceNumber lastLSN = this.writeAheadLog.logFullCheckpointStart();
            this.diskCache.flushBuffer();
            this.writeAheadLog.logFullCheckpointEnd();
            this.writeAheadLog.flush();
            this.writeAheadLog.cutTill(lastLSN);
            this.clearStorageDirty();
        }
        catch (IOException ioe) {
            throw new OStorageException("Error during checkpoint creation for storage " + this.name, ioe);
        }
    }

    protected void preOpenSteps() throws IOException {
    }

    protected void postCreateSteps() {
    }

    protected void preCreateSteps() throws IOException {
    }

    protected abstract void initWalAndDiskCache() throws IOException;

    protected void postCloseSteps(boolean onDelete) throws IOException {
    }

    protected void preCloseSteps() throws IOException {
    }

    protected void postDeleteSteps() {
    }

    protected void makeStorageDirty() throws IOException {
    }

    protected void clearStorageDirty() throws IOException {
    }

    protected boolean isDirty() throws IOException {
        return false;
    }

    protected void lock() throws IOException {
        OLogManager.instance().debug((Object)this, "Locking storage %s...", this.name);
        this.configuration.lock();
        this.diskCache.lock();
    }

    protected void unlock() throws IOException {
        OLogManager.instance().debug((Object)this, "Unlocking storage %s...", this.name);
        this.configuration.unlock();
        this.diskCache.unlock();
    }

    /*
     * Exception decompiling
     */
    private ORawBuffer readRecord(OCluster clusterSegment, ORecordId rid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void endStorageTx() throws IOException {
        this.atomicOperationsManager.endAtomicOperation(false);
        assert (this.atomicOperationsManager.getCurrentOperation() == null);
    }

    private void startStorageTx(OTransaction clientTx) throws IOException {
        if (this.writeAheadLog == null) {
            return;
        }
        OStorageTransaction storageTx = this.transaction.get();
        if (storageTx != null && storageTx.getClientTx().getId() != clientTx.getId()) {
            this.rollback(clientTx);
        }
        assert (this.atomicOperationsManager.getCurrentOperation() == null);
        this.transaction.set(new OStorageTransaction(clientTx));
        try {
            this.atomicOperationsManager.startAtomicOperation(null);
        }
        catch (RuntimeException e) {
            this.transaction.set(null);
            throw e;
        }
    }

    private void rollbackStorageTx() throws IOException {
        if (this.writeAheadLog == null || this.transaction.get() == null) {
            return;
        }
        this.atomicOperationsManager.endAtomicOperation(true);
        assert (this.atomicOperationsManager.getCurrentOperation() == null);
    }

    private void restoreIfNeeded() throws Exception {
        if (this.isDirty()) {
            OLogManager.instance().warn((Object)this, "Storage " + this.name + " was not closed properly. Will try to restore from write ahead log.", new Object[0]);
            try {
                this.wereDataRestoredAfterOpen = this.restoreFromWAL();
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Exception during storage data restore.", (Throwable)e, new Object[0]);
                throw e;
            }
            OLogManager.instance().info((Object)this, "Storage data restore was completed", new Object[0]);
        }
    }

    private OStorageOperationResult<OPhysicalPosition> doCreateRecord(ORecordId rid, byte[] content, ORecordVersion recordVersion, byte recordType, ORecordCallback<Long> callback, OCluster cluster, OPhysicalPosition ppos) {
        if (content == null) {
            throw new IllegalArgumentException("Record is null");
        }
        try {
            if (recordVersion.getCounter() > -1) {
                recordVersion.increment();
            } else {
                recordVersion = OVersionFactory.instance().createVersion();
            }
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation(null);
            try {
                ppos = cluster.createRecord(content, recordVersion, recordType);
                rid.clusterPosition = ppos.clusterPosition;
                ORecordSerializationContext context = ORecordSerializationContext.getContext();
                if (context != null) {
                    context.executeOperations(this);
                }
                this.atomicOperationsManager.endAtomicOperation(false);
            }
            catch (Throwable throwable) {
                this.atomicOperationsManager.endAtomicOperation(true);
                if (throwable instanceof OOfflineClusterException) {
                    throw (OOfflineClusterException)throwable;
                }
                OLogManager.instance().error((Object)this, "Error on creating record in cluster: " + cluster, throwable, new Object[0]);
                try {
                    if (ppos.clusterPosition != -1L) {
                        cluster.deleteRecord(ppos.clusterPosition);
                    }
                }
                catch (IOException e) {
                    OLogManager.instance().error((Object)this, "Error on removing record in cluster: " + cluster, (Throwable)e, new Object[0]);
                }
                return null;
            }
            if (callback != null) {
                callback.call(rid, ppos.clusterPosition);
            }
            return new OStorageOperationResult<OPhysicalPosition>(ppos);
        }
        catch (IOException ioe) {
            try {
                if (ppos.clusterPosition != -1L) {
                    cluster.deleteRecord(ppos.clusterPosition);
                }
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on creating record in cluster: " + cluster, (Throwable)e, new Object[0]);
            }
            OLogManager.instance().error((Object)this, "Error on creating record in cluster: " + cluster, (Throwable)ioe, new Object[0]);
            throw new OStorageException("Error during record deletion", ioe);
        }
    }

    private OStorageOperationResult<ORecordVersion> doUpdateRecord(ORecordId rid, boolean updateContent, byte[] content, ORecordVersion version, byte recordType, ORecordCallback<ORecordVersion> callback, OCluster cluster) {
        try {
            byte[] newContent;
            OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.clusterPosition));
            if (!this.checkForRecordValidity(ppos)) {
                ORecordVersion recordVersion = OVersionFactory.instance().createUntrackedVersion();
                if (callback != null) {
                    callback.call(rid, recordVersion);
                }
                return new OStorageOperationResult<ORecordVersion>(recordVersion);
            }
            boolean contentModified = false;
            if (updateContent && (newContent = this.checkAndIncrementVersion(cluster, rid, version, ppos.recordVersion, content, recordType)) != null) {
                contentModified = true;
                content = newContent;
            }
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation(null);
            try {
                ORecordSerializationContext context;
                if (updateContent) {
                    cluster.updateRecord(rid.clusterPosition, content, ppos.recordVersion, recordType);
                }
                if ((context = ORecordSerializationContext.getContext()) != null) {
                    context.executeOperations(this);
                }
                this.atomicOperationsManager.endAtomicOperation(false);
            }
            catch (Throwable e) {
                this.atomicOperationsManager.endAtomicOperation(true);
                OLogManager.instance().error((Object)this, "Error on updating record " + rid + " (cluster: " + cluster + ")", e, new Object[0]);
                ORecordVersion recordVersion = OVersionFactory.instance().createUntrackedVersion();
                if (callback != null) {
                    callback.call(rid, recordVersion);
                }
                return new OStorageOperationResult<ORecordVersion>(recordVersion);
            }
            if (callback != null) {
                callback.call(rid, ppos.recordVersion);
            }
            if (contentModified) {
                return new OStorageOperationResult<ORecordVersion>(ppos.recordVersion, content, false);
            }
            return new OStorageOperationResult<ORecordVersion>(ppos.recordVersion);
        }
        catch (IOException ioe) {
            OLogManager.instance().error((Object)this, "Error on updating record " + rid + " (cluster: " + cluster + ")", (Throwable)ioe, new Object[0]);
            ORecordVersion recordVersion = OVersionFactory.instance().createUntrackedVersion();
            if (callback != null) {
                callback.call(rid, recordVersion);
            }
            return new OStorageOperationResult<ORecordVersion>(recordVersion);
        }
    }

    private OStorageOperationResult<Boolean> doDeleteRecord(ORecordId rid, ORecordVersion version, OCluster cluster) {
        try {
            OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.clusterPosition));
            if (ppos == null) {
                return new OStorageOperationResult<Boolean>(false);
            }
            if (version.getCounter() > -1 && !ppos.recordVersion.equals(version)) {
                if (OFastConcurrentModificationException.enabled()) {
                    throw OFastConcurrentModificationException.instance();
                }
                throw new OConcurrentModificationException(rid, ppos.recordVersion, version, 2);
            }
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation(null);
            try {
                ORecordSerializationContext context = ORecordSerializationContext.getContext();
                if (context != null) {
                    context.executeOperations(this);
                }
                cluster.deleteRecord(ppos.clusterPosition);
                this.atomicOperationsManager.endAtomicOperation(false);
            }
            catch (Throwable e) {
                this.atomicOperationsManager.endAtomicOperation(true);
                OLogManager.instance().error((Object)this, "Error on deleting record " + rid + "( cluster: " + cluster + ")", e, new Object[0]);
                return new OStorageOperationResult<Boolean>(false);
            }
            return new OStorageOperationResult<Boolean>(true);
        }
        catch (IOException ioe) {
            OLogManager.instance().error((Object)this, "Error on deleting record " + rid + "( cluster: " + cluster + ")", (Throwable)ioe, new Object[0]);
            throw new OStorageException("Error on deleting record " + rid + "( cluster: " + cluster + ")", ioe);
        }
    }

    private OStorageOperationResult<Boolean> doHideRecord(ORecordId rid, OCluster cluster) {
        try {
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation(null);
            try {
                ORecordSerializationContext context = ORecordSerializationContext.getContext();
                if (context != null) {
                    context.executeOperations(this);
                }
                cluster.hideRecord(rid.clusterPosition);
                this.atomicOperationsManager.endAtomicOperation(false);
            }
            catch (Throwable e) {
                this.atomicOperationsManager.endAtomicOperation(true);
                OLogManager.instance().error((Object)this, "Error on deleting record " + rid + "( cluster: " + cluster + ")", e, new Object[0]);
                return new OStorageOperationResult<Boolean>(false);
            }
            return new OStorageOperationResult<Boolean>(true);
        }
        catch (IOException ioe) {
            OLogManager.instance().error((Object)this, "Error on deleting record " + rid + "( cluster: " + cluster + ")", (Throwable)ioe, new Object[0]);
            throw new OStorageException("Error on deleting record " + rid + "( cluster: " + cluster + ")", ioe);
        }
    }

    private ORawBuffer doReadRecord(OCluster clusterSegment, ORecordId rid) {
        try {
            ORawBuffer buff = clusterSegment.readRecord(rid.clusterPosition);
            return buff;
        }
        catch (IOException e) {
            throw new OStorageException("Error during read of record with rid = " + rid, e);
        }
    }

    private void addDefaultClusters() throws IOException {
        String storageCompression = this.getConfiguration().getContextConfiguration().getValueAsString(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD);
        String stgConflictStrategy = this.getConflictStrategy().getName();
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.size(), "internal", null, true, 20.0f, 4.0f, storageCompression, stgConflictStrategy, OStorageClusterConfiguration.STATUS.ONLINE));
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.size(), "index", null, false, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, storageCompression, stgConflictStrategy, OStorageClusterConfiguration.STATUS.ONLINE));
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.size(), "manindex", null, false, 1.0f, 1.0f, storageCompression, stgConflictStrategy, OStorageClusterConfiguration.STATUS.ONLINE));
        this.defaultClusterId = this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.size(), "default", null, true, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, storageCompression, stgConflictStrategy, OStorageClusterConfiguration.STATUS.ONLINE));
    }

    private int createClusterFromConfig(OStorageClusterConfiguration config) throws IOException {
        OCluster cluster = (OCluster)this.clusterMap.get(config.getName().toLowerCase());
        if (cluster != null) {
            cluster.configure(this, config);
            return -1;
        }
        cluster = config.getStatus() == OStorageClusterConfiguration.STATUS.ONLINE ? OPaginatedClusterFactory.INSTANCE.createCluster(config.getName(), this.configuration.version, this) : new OOfflineCluster(this, config.getId(), config.getName());
        cluster.configure(this, config);
        return this.registerCluster(cluster);
    }

    private void setCluster(int id, OCluster cluster) {
        if (this.clusters.size() <= id) {
            while (this.clusters.size() < id) {
                this.clusters.add(null);
            }
            this.clusters.add(cluster);
        } else {
            this.clusters.set(id, cluster);
        }
    }

    private int registerCluster(OCluster cluster) throws IOException {
        int id;
        if (cluster != null) {
            if (this.clusterMap.containsKey(cluster.getName().toLowerCase())) {
                throw new OConfigurationException("Cannot add cluster '" + cluster.getName() + "' because it is already registered in database '" + this.name + "'");
            }
            this.clusterMap.put(cluster.getName().toLowerCase(), cluster);
            id = cluster.getId();
        } else {
            id = this.clusters.size();
        }
        this.setCluster(id, cluster);
        return id;
    }

    private int doAddCluster(String clusterName, boolean fullCheckPoint, Object[] parameters) throws IOException {
        int clusterPos = this.clusters.size();
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (this.clusters.get(i) != null) continue;
            clusterPos = i;
            break;
        }
        return this.addClusterInternal(clusterName, clusterPos, fullCheckPoint, parameters);
    }

    private int addClusterInternal(String clusterName, int clusterPos, boolean fullCheckPoint, Object ... parameters) throws IOException {
        OCluster cluster;
        if (clusterName != null) {
            clusterName = clusterName.toLowerCase();
            cluster = OPaginatedClusterFactory.INSTANCE.createCluster(clusterName, this.configuration.version, this);
            cluster.configure(this, clusterPos, clusterName, parameters);
            if (clusterName.equals("ORIDs".toLowerCase())) {
                cluster.set(OCluster.ATTRIBUTES.USE_WAL, false);
                cluster.set(OCluster.ATTRIBUTES.RECORD_GROW_FACTOR, 5);
                cluster.set(OCluster.ATTRIBUTES.RECORD_OVERFLOW_GROW_FACTOR, 2);
            }
        } else {
            cluster = null;
        }
        int createdClusterId = this.registerCluster(cluster);
        if (cluster != null) {
            if (!cluster.exists()) {
                cluster.create(-1);
                if (this.makeFullCheckPointAfterClusterCreate && fullCheckPoint) {
                    this.makeFullCheckpoint();
                }
            } else {
                cluster.open();
            }
            this.configuration.update();
        }
        return createdClusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(boolean force, boolean onDelete) {
        if (!force && !onDelete) {
            return;
        }
        if (this.status == OStorage.STATUS.CLOSED) {
            return;
        }
        long timer = Orient.instance().getProfiler().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            if (this.status == OStorage.STATUS.CLOSED) {
                return;
            }
            this.status = OStorage.STATUS.CLOSING;
            if (!onDelete) {
                this.makeFullCheckpoint();
            }
            this.preCloseSteps();
            for (OCluster cluster : this.clusters) {
                if (cluster == null) continue;
                cluster.close(!onDelete);
            }
            this.clusters.clear();
            this.clusterMap.clear();
            if (this.configuration != null) {
                this.configuration.close();
            }
            super.close(force, onDelete);
            this.diskCache.removeLowDiskSpaceListener(this);
            if (this.writeAheadLog != null) {
                this.writeAheadLog.removeFullCheckpointListener(this);
            }
            if (!onDelete) {
                this.diskCache.close();
            } else {
                this.diskCache.delete();
            }
            if (this.writeAheadLog != null) {
                this.writeAheadLog.close();
                if (onDelete) {
                    this.writeAheadLog.delete();
                }
            }
            this.postCloseSteps(onDelete);
            this.status = OStorage.STATUS.CLOSED;
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on closing of storage '" + this.name, (Throwable)e, OStorageException.class, new Object[0]);
        }
        finally {
            this.lock.releaseExclusiveLock();
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".close", "Close a database", timer, "db.*.close");
        }
    }

    private byte[] checkAndIncrementVersion(OCluster iCluster, ORecordId rid, ORecordVersion version, ORecordVersion iDatabaseVersion, byte[] iRecordContent, byte iRecordType) {
        int v = version.getCounter();
        switch (v) {
            case -1: {
                iDatabaseVersion.increment();
                break;
            }
            case -2: {
                iDatabaseVersion.setCounter(-2);
                break;
            }
            default: {
                if (v < -2) {
                    version.clearRollbackMode();
                    iDatabaseVersion.setCounter(version.getCounter());
                    break;
                }
                if (!version.equals(iDatabaseVersion)) {
                    ORecordConflictStrategy strategy = iCluster.getRecordConflictStrategy() != null ? iCluster.getRecordConflictStrategy() : this.recordConflictStrategy;
                    return strategy.onUpdate(this, iRecordType, rid, version, iRecordContent, iDatabaseVersion);
                }
                iDatabaseVersion.increment();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void commitEntry(OTransaction clientTx, ORecordOperation txEntry) throws IOException {
        rec = txEntry.getRecord();
        if (txEntry.type != 2 && !rec.isDirty()) {
            return;
        }
        rid = (ORecordId)rec.getIdentity();
        if (txEntry.type == 1 && rid.isNew()) {
            txEntry.type = (byte)3;
        }
        ORecordSerializationContext.pushContext();
        try {
            clusterId = rid.clusterId;
            if (rid.clusterId == -1 && rec instanceof ODocument && ODocumentInternal.getImmutableSchemaClass((ODocument)rec) != null) {
                schemaClass = ODocumentInternal.getImmutableSchemaClass((ODocument)rec);
                clusterId = schemaClass.getClusterForNewInstance((ODocument)rec);
            }
            if ((cluster = this.getClusterById(clusterId)).getName().equals("index") || cluster.getName().equals("manindex")) {
                return;
            }
            if (rec instanceof OTxListener) {
                ((OTxListener)rec).onEvent(txEntry, OTxListener.EVENT.BEFORE_COMMIT);
            }
            switch (txEntry.type) {
                case 0: {
                    ** break;
lbl21:
                    // 1 sources

                    break;
                }
                case 3: {
                    stream = rec.toStream();
                    if (stream == null) {
                        OLogManager.instance().warn((Object)this, "Null serialization on committing new record %s in transaction", new Object[]{rid});
                        ** break;
lbl27:
                        // 1 sources

                    } else {
                        v0 = oldRID = rid.isNew() != false ? rid.copy() : rid;
                        if (rid.isNew()) {
                            rid = rid.copy();
                            rid.clusterId = cluster.getId();
                            recordType = ORecordInternal.getRecordType(rec);
                            ppos = this.doCreateRecord(rid, stream, rec.getRecordVersion(), recordType, null, cluster, new OPhysicalPosition(recordType)).getResult();
                            rid.clusterPosition = ppos.clusterPosition;
                            rec.getRecordVersion().copyFrom(ppos.recordVersion);
                            clientTx.updateIdentityAfterCommit(oldRID, rid);
                            ** break;
lbl38:
                            // 1 sources

                        } else {
                            rec.getRecordVersion().copyFrom(this.updateRecord(rid, ORecordInternal.isContentChanged(rec), stream, rec.getRecordVersion(), ORecordInternal.getRecordType(rec), -1, null).getResult());
                            ** break;
                        }
                    }
lbl41:
                    // 1 sources

                    break;
                }
                case 1: {
                    stream = rec.toStream();
                    if (stream == null) {
                        OLogManager.instance().warn((Object)this, "Null serialization on committing updated record %s in transaction", new Object[]{rid});
                        ** break;
lbl47:
                        // 1 sources

                    } else {
                        rec.getRecordVersion().copyFrom(this.doUpdateRecord(rid, ORecordInternal.isContentChanged(rec), stream, rec.getRecordVersion(), ORecordInternal.getRecordType(rec), null, cluster).getResult());
                        ** break;
                    }
lbl50:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.deleteRecord(rid, rec.getRecordVersion(), -1, null);
                    break;
                }
                ** default:
lbl56:
                // 1 sources

                break;
            }
        }
        finally {
            ORecordSerializationContext.pullContext();
        }
        if (rec instanceof ODocument && ((ODocument)rec).isTrackingChanges()) {
            ((ODocument)rec).setTrackingChanges(false);
            ((ODocument)rec).setTrackingChanges(true);
        }
        ORecordInternal.unsetDirty(rec);
        if (rec instanceof OTxListener) {
            ((OTxListener)rec).onEvent(txEntry, OTxListener.EVENT.AFTER_COMMIT);
        }
    }

    private void checkClusterSegmentIndexRange(int iClusterId) {
        if (iClusterId < 0 || iClusterId > this.clusters.size() - 1) {
            throw new IllegalArgumentException("Cluster segment #" + iClusterId + " does not exist in database '" + this.name + "'");
        }
    }

    private List<OLogSequenceNumber> readOperationUnit(OLogSequenceNumber startLSN, OOperationUnitId unitId) throws IOException {
        OLogSequenceNumber beginSequence = this.writeAheadLog.begin();
        if (startLSN == null) {
            startLSN = beginSequence;
        }
        if (startLSN.compareTo(beginSequence) < 0) {
            startLSN = beginSequence;
        }
        ArrayList<OLogSequenceNumber> operationUnit = new ArrayList<OLogSequenceNumber>();
        OLogSequenceNumber lsn = startLSN;
        while (lsn != null) {
            try {
                OWALRecord record = this.writeAheadLog.read(lsn);
                if (!(record instanceof OOperationUnitRecord)) {
                    lsn = this.writeAheadLog.next(lsn);
                    continue;
                }
                OOperationUnitRecord operationUnitRecord = (OOperationUnitRecord)record;
                if (operationUnitRecord.getOperationUnitId().equals(unitId)) {
                    operationUnit.add(lsn);
                    if (record instanceof OAtomicUnitEndRecord) break;
                }
                lsn = this.writeAheadLog.next(lsn);
            }
            catch (OWALPageBrokenException e) {
                break;
            }
        }
        return operationUnit;
    }

    private boolean restoreFromWAL() throws IOException {
        OWALRecord checkPointRecord;
        OLogSequenceNumber lastCheckPoint;
        if (this.writeAheadLog == null) {
            OLogManager.instance().error((Object)this, "Restore is not possible because write ahead logging is switched off.", new Object[0]);
            return true;
        }
        if (this.writeAheadLog.begin() == null) {
            OLogManager.instance().error((Object)this, "Restore is not possible because write ahead log is empty.", new Object[0]);
            return false;
        }
        OLogManager.instance().info((Object)this, "Looking for last checkpoint...", new Object[0]);
        try {
            lastCheckPoint = this.writeAheadLog.getLastCheckpoint();
        }
        catch (OWALPageBrokenException e) {
            lastCheckPoint = null;
        }
        if (lastCheckPoint == null) {
            OLogManager.instance().info((Object)this, "Checkpoints are absent, the restore will start from the beginning.", new Object[0]);
            return this.restoreFromBegging();
        }
        try {
            checkPointRecord = this.writeAheadLog.read(lastCheckPoint);
        }
        catch (OWALPageBrokenException e) {
            checkPointRecord = null;
        }
        if (checkPointRecord == null) {
            OLogManager.instance().info((Object)this, "Checkpoints are absent, the restore will start from the beginning.", new Object[0]);
            return this.restoreFromBegging();
        }
        if (checkPointRecord instanceof OFuzzyCheckpointStartRecord) {
            OLogManager.instance().info((Object)this, "Found FUZZY checkpoint.", new Object[0]);
            boolean fuzzyCheckPointIsComplete = this.checkFuzzyCheckPointIsComplete(lastCheckPoint);
            if (!fuzzyCheckPointIsComplete) {
                OLogManager.instance().warn((Object)this, "FUZZY checkpoint is not complete.", new Object[0]);
                OLogSequenceNumber previousCheckpoint = ((OFuzzyCheckpointStartRecord)checkPointRecord).getPreviousCheckpoint();
                checkPointRecord = null;
                if (previousCheckpoint != null) {
                    checkPointRecord = this.writeAheadLog.read(previousCheckpoint);
                }
                if (checkPointRecord != null) {
                    OLogManager.instance().warn((Object)this, "Restore will start from the previous checkpoint.", new Object[0]);
                    return this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
                }
                OLogManager.instance().warn((Object)this, "Restore will start from the beginning.", new Object[0]);
                return this.restoreFromBegging();
            }
            return this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
        }
        if (checkPointRecord instanceof OFullCheckpointStartRecord) {
            OLogManager.instance().info((Object)this, "FULL checkpoint found.", new Object[0]);
            boolean fullCheckPointIsComplete = this.checkFullCheckPointIsComplete(lastCheckPoint);
            if (!fullCheckPointIsComplete) {
                OLogManager.instance().warn((Object)this, "FULL checkpoint has not completed.", new Object[0]);
                OLogSequenceNumber previousCheckpoint = ((OFullCheckpointStartRecord)checkPointRecord).getPreviousCheckpoint();
                checkPointRecord = null;
                if (previousCheckpoint != null) {
                    checkPointRecord = this.writeAheadLog.read(previousCheckpoint);
                }
                if (checkPointRecord != null) {
                    OLogManager.instance().warn((Object)this, "Restore will start from the previous checkpoint.", new Object[0]);
                    return this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
                }
                OLogManager.instance().warn((Object)this, "Restore will start from the beginning.", new Object[0]);
                return this.restoreFromBegging();
            }
            return this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
        }
        throw new OStorageException("Unknown checkpoint record type " + checkPointRecord.getClass().getName());
    }

    private boolean checkFullCheckPointIsComplete(OLogSequenceNumber lastCheckPoint) throws IOException {
        try {
            OLogSequenceNumber lsn = this.writeAheadLog.next(lastCheckPoint);
            while (lsn != null) {
                OWALRecord walRecord = this.writeAheadLog.read(lsn);
                if (walRecord instanceof OCheckpointEndRecord) {
                    return true;
                }
                lsn = this.writeAheadLog.next(lsn);
            }
        }
        catch (OWALPageBrokenException e) {
            return false;
        }
        return false;
    }

    private boolean checkFuzzyCheckPointIsComplete(OLogSequenceNumber lastCheckPoint) throws IOException {
        try {
            OLogSequenceNumber lsn = this.writeAheadLog.next(lastCheckPoint);
            while (lsn != null) {
                OWALRecord walRecord = this.writeAheadLog.read(lsn);
                if (walRecord instanceof OFuzzyCheckpointEndRecord) {
                    return true;
                }
                lsn = this.writeAheadLog.next(lsn);
            }
        }
        catch (OWALPageBrokenException e) {
            return false;
        }
        return false;
    }

    private boolean restoreFromCheckPoint(OAbstractCheckPointStartRecord checkPointRecord) throws IOException {
        if (checkPointRecord instanceof OFuzzyCheckpointStartRecord) {
            return this.restoreFromFuzzyCheckPoint((OFuzzyCheckpointStartRecord)checkPointRecord);
        }
        if (checkPointRecord instanceof OFullCheckpointStartRecord) {
            return this.restoreFromFullCheckPoint((OFullCheckpointStartRecord)checkPointRecord);
        }
        throw new OStorageException("Unknown checkpoint record type " + checkPointRecord.getClass().getName());
    }

    private boolean restoreFromFullCheckPoint(OFullCheckpointStartRecord checkPointRecord) throws IOException {
        OLogManager.instance().info((Object)this, "Data restore procedure from full checkpoint is started. Restore is performed from LSN %s", checkPointRecord.getLsn());
        OLogSequenceNumber lsn = this.writeAheadLog.next(checkPointRecord.getLsn());
        return this.restoreFrom(lsn);
    }

    private boolean restoreFromFuzzyCheckPoint(OFuzzyCheckpointStartRecord checkPointRecord) throws IOException {
        OLogManager.instance().info((Object)this, "Data restore procedure from FUZZY checkpoint is started.", new Object[0]);
        OLogSequenceNumber flushedLsn = checkPointRecord.getFlushedLsn();
        if (flushedLsn.compareTo(this.writeAheadLog.begin()) < 0) {
            flushedLsn = this.writeAheadLog.begin();
        }
        return this.restoreFrom(flushedLsn);
    }

    private boolean restoreFromBegging() throws IOException {
        OLogManager.instance().info((Object)this, "Data restore procedure is started.", new Object[0]);
        OLogSequenceNumber lsn = this.writeAheadLog.begin();
        return this.restoreFrom(lsn);
    }

    private boolean restoreFrom(OLogSequenceNumber lsn) throws IOException {
        OModifiableBoolean atLeastOnePageUpdate = new OModifiableBoolean(false);
        long recordsProcessed = 0L;
        int reportInterval = OGlobalConfiguration.WAL_REPORT_AFTER_OPERATIONS_DURING_RESTORE.getValueAsInteger();
        HashMap operationUnits = new HashMap();
        try {
            while (lsn != null) {
                OWALRecord walRecord = this.writeAheadLog.read(lsn);
                if (walRecord instanceof OAtomicUnitEndRecord) {
                    OAtomicUnitEndRecord atomicUnitEndRecord = (OAtomicUnitEndRecord)walRecord;
                    List atomicUnit = (List)operationUnits.remove(atomicUnitEndRecord.getOperationUnitId());
                    if (atomicUnit != null) {
                        atomicUnit.add(walRecord);
                        this.restoreAtomicUnit(atomicUnit, atLeastOnePageUpdate);
                    }
                } else if (walRecord instanceof OAtomicUnitStartRecord) {
                    ArrayList<OWALRecord> operationList = new ArrayList<OWALRecord>();
                    assert (!operationUnits.containsKey(((OAtomicUnitStartRecord)walRecord).getOperationUnitId()));
                    operationUnits.put(((OAtomicUnitStartRecord)walRecord).getOperationUnitId(), operationList);
                    operationList.add(walRecord);
                } else if (walRecord instanceof OOperationUnitRecord) {
                    OOperationUnitRecord operationUnitRecord = (OOperationUnitRecord)walRecord;
                    ArrayList<OOperationUnitRecord> operationList = (ArrayList<OOperationUnitRecord>)operationUnits.get(operationUnitRecord.getOperationUnitId());
                    if (operationList == null) {
                        operationList = new ArrayList<OOperationUnitRecord>();
                        operationUnits.put(operationUnitRecord.getOperationUnitId(), operationList);
                    }
                    operationList.add(operationUnitRecord);
                } else if (walRecord instanceof ONonTxOperationPerformedWALRecord) {
                    if (!this.wereNonTxOperationsPerformedInPreviousOpen) {
                        OLogManager.instance().warn((Object)this, "Non tx operation was used during data modification we will need index rebuild.", new Object[0]);
                        this.wereNonTxOperationsPerformedInPreviousOpen = true;
                    }
                } else {
                    OLogManager.instance().warn((Object)this, "Record %s will be skipped during data restore.", walRecord);
                }
                if (reportInterval > 0 && ++recordsProcessed % (long)reportInterval == 0L) {
                    OLogManager.instance().info((Object)this, "%d operations were processed, current LSN is %s last LSN is %s", recordsProcessed, lsn, this.writeAheadLog.end());
                }
                lsn = this.writeAheadLog.next(lsn);
            }
        }
        catch (OWALPageBrokenException e) {
            OLogManager.instance().error((Object)this, "Data restore was paused because broken WAL page was found. The rest of changes will be rolled back.", new Object[0]);
        }
        return atLeastOnePageUpdate.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreAtomicUnit(List<OWALRecord> atomicUnit, OModifiableBoolean atLeastOnePageUpdate) throws IOException {
        assert (atomicUnit.get(atomicUnit.size() - 1) instanceof OAtomicUnitEndRecord);
        for (OWALRecord walRecord : atomicUnit) {
            if (walRecord instanceof OFileDeletedWALRecord) {
                OFileDeletedWALRecord fileDeletedWALRecord = (OFileDeletedWALRecord)walRecord;
                if (!this.diskCache.exists(fileDeletedWALRecord.getFileId())) continue;
                this.diskCache.deleteFile(fileDeletedWALRecord.getFileId());
                continue;
            }
            if (walRecord instanceof OFileCreatedWALRecord) {
                OFileCreatedWALRecord fileCreatedCreatedWALRecord = (OFileCreatedWALRecord)walRecord;
                if (this.diskCache.exists(fileCreatedCreatedWALRecord.getFileName())) {
                    this.diskCache.openFile(fileCreatedCreatedWALRecord.getFileName(), fileCreatedCreatedWALRecord.getFileId());
                    continue;
                }
                this.diskCache.addFile(fileCreatedCreatedWALRecord.getFileName(), fileCreatedCreatedWALRecord.getFileId());
                continue;
            }
            if (walRecord instanceof OUpdatePageRecord) {
                OCacheEntry cacheEntry;
                OUpdatePageRecord updatePageRecord = (OUpdatePageRecord)walRecord;
                long fileId = updatePageRecord.getFileId();
                long pageIndex = updatePageRecord.getPageIndex();
                if (!this.diskCache.isOpen(fileId)) {
                    this.diskCache.openFile(fileId);
                }
                if ((cacheEntry = this.diskCache.load(fileId, pageIndex, true)) == null) {
                    do {
                        if (cacheEntry == null) continue;
                        this.diskCache.release(cacheEntry);
                    } while ((cacheEntry = this.diskCache.allocateNewPage(fileId)).getPageIndex() != pageIndex);
                }
                OCachePointer cachePointer = cacheEntry.getCachePointer();
                cachePointer.acquireExclusiveLock();
                try {
                    ODurablePage durablePage = new ODurablePage(cacheEntry, null);
                    durablePage.restoreChanges(updatePageRecord.getChanges());
                    durablePage.setLsn(updatePageRecord.getLsn());
                }
                finally {
                    cachePointer.releaseExclusiveLock();
                    this.diskCache.release(cacheEntry);
                }
                atLeastOnePageUpdate.setValue(true);
                continue;
            }
            if (walRecord instanceof OAtomicUnitStartRecord || walRecord instanceof OAtomicUnitEndRecord) continue;
            if (walRecord instanceof OFileTruncatedWALRecord) {
                OFileTruncatedWALRecord fileTruncatedWALRecord = (OFileTruncatedWALRecord)walRecord;
                this.diskCache.truncateFile(fileTruncatedWALRecord.getFileId());
                continue;
            }
            OLogManager.instance().error((Object)this, "Invalid WAL record type was passed %s. Given record will be skipped.", new Object[]{walRecord.getClass()});
            assert (false) : "Invalid WAL record type was passed " + walRecord.getClass().getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLowDiskSpaceAndFullCheckpointRequests() {
        if (this.transaction.get() != null) {
            return;
        }
        if (this.lowDiskSpace != null && this.checkpointInProgress.compareAndSet(false, true)) {
            try {
                this.diskCache.makeFuzzyCheckpoint();
                if (this.diskCache.checkLowDiskSpace()) {
                    this.synch();
                    if (this.diskCache.checkLowDiskSpace()) {
                        throw new OLowDiskSpaceException("Error occurred while executing a write operation to database '" + this.name + "' due to limited free space on the disk (" + this.lowDiskSpace.freeSpace / 0x100000L + " MB). The database is now working in read-only mode." + " Please close the database (or stop OrientDB), make room on your hard drive and then reopen the database. " + "The minimal required space is " + this.lowDiskSpace.requiredSpace / 0x100000L + " MB. " + "Required space is now set to " + OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getValueAsInteger() + "MB (you can change it by setting parameter " + OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getKey() + ") .");
                    }
                    this.lowDiskSpace = null;
                } else {
                    this.lowDiskSpace = null;
                }
            }
            finally {
                this.checkpointInProgress.set(false);
            }
        }
        if (this.checkpointRequest && this.writeAheadLog instanceof ODiskWriteAheadLog && this.checkpointInProgress.compareAndSet(false, true)) {
            try {
                ODiskWriteAheadLog diskWriteAheadLog = (ODiskWriteAheadLog)this.writeAheadLog;
                long size = diskWriteAheadLog.size();
                this.diskCache.makeFuzzyCheckpoint();
                if (size <= diskWriteAheadLog.size()) {
                    this.synch();
                }
                this.checkpointRequest = false;
            }
            finally {
                this.checkpointInProgress.set(false);
            }
        }
    }
}

