/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.concur.resource.OSharedContainerImpl;
import com.orientechnologies.common.concur.resource.OSharedResource;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;

public abstract class OStorageAbstract
extends OSharedContainerImpl
implements OStorage {
    protected final String url;
    protected final String mode;
    protected final OSharedResourceAdaptiveExternal lock;
    protected volatile OStorageConfiguration configuration;
    protected volatile OCurrentStorageComponentsFactory componentsFactory;
    protected String name;
    protected AtomicLong version = new AtomicLong();
    protected volatile OStorage.STATUS status = OStorage.STATUS.CLOSED;

    public OStorageAbstract(String name, String iURL, String mode, int timeout) {
        this.name = OStringSerializerHelper.contains(name, '/') ? name.substring(name.lastIndexOf("/") + 1) : name;
        if (OStringSerializerHelper.contains(name, ',')) {
            throw new IllegalArgumentException("Invalid character in storage name: " + this.name);
        }
        this.url = iURL;
        this.mode = mode;
        this.lock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), timeout, true);
    }

    @Override
    public abstract OCluster getClusterByName(String var1);

    @Override
    public OStorage getUnderlying() {
        return this;
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isClosed() {
        return this.status == OStorage.STATUS.CLOSED;
    }

    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return ppos != null && !ppos.recordVersion.isTombstone();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void close() {
        this.close(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean iForce, boolean onDelete) {
        this.lock.acquireExclusiveLock();
        try {
            for (Object resource : this.sharedResources.values()) {
                if (resource instanceof OSharedResource) {
                    ((OSharedResource)resource).releaseExclusiveLock();
                }
                if (!(resource instanceof OCloseable)) continue;
                ((OCloseable)resource).close(onDelete);
            }
            this.sharedResources.clear();
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public long getVersion() {
        return this.version.get();
    }

    @Override
    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        return this.dropCluster(this.getClusterIdByName(iClusterName), iTruncate);
    }

    @Override
    public int getUsers() {
        return this.lock.getUsers();
    }

    @Override
    public int addUser() {
        return this.lock.addUser();
    }

    @Override
    public int removeUser() {
        return this.lock.removeUser();
    }

    @Override
    public OSharedResourceAdaptiveExternal getLock() {
        return this.lock;
    }

    @Override
    public long countRecords() {
        long tot = 0L;
        for (OCluster oCluster : this.getClusterInstances()) {
            if (oCluster == null) continue;
            tot += oCluster.getEntries() - oCluster.getTombstonesCount();
        }
        return tot;
    }

    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        if (iExclusiveLock) {
            this.lock.acquireExclusiveLock();
        } else {
            this.lock.acquireSharedLock();
        }
        try {
            V v = iCallable.call();
            return v;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OException("Error on nested call in lock", e);
        }
        finally {
            if (iExclusiveLock) {
                this.lock.releaseExclusiveLock();
            } else {
                this.lock.releaseSharedLock();
            }
        }
    }

    public String toString() {
        return this.url != null ? this.url : "?";
    }

    @Override
    public OStorage.STATUS getStatus() {
        return this.status;
    }

    @Override
    public void checkForClusterPermissions(String iClusterName) {
        OMetadata metaData = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata();
        if (metaData != null) {
            Set<OClass> classes = ((OMetadataInternal)metaData).getImmutableSchemaSnapshot().getClassesRelyOnCluster(iClusterName);
            for (OClass c : classes) {
                if (!c.isSubClassOf("ORestricted")) continue;
                throw new OSecurityException("Class " + c.getName() + " cannot be truncated because has record level security enabled (extends " + "ORestricted" + ")");
            }
        }
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isAssigningClusterIds() {
        return true;
    }

    @Override
    public OCurrentStorageComponentsFactory getComponentsFactory() {
        return this.componentsFactory;
    }

    @Override
    public long getLastOperationId() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkForClose(boolean force) {
        if (this.status == OStorage.STATUS.CLOSED) {
            return false;
        }
        this.lock.acquireSharedLock();
        try {
            if (this.status == OStorage.STATUS.CLOSED) {
                boolean bl = false;
                return bl;
            }
            int remainingUsers = this.getUsers() > 0 ? this.removeUser() : 0;
            boolean bl = force || !(this instanceof OAbstractPaginatedStorage) && remainingUsers == 0;
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }
}

