/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OPhysicalPosition
implements OSerializableStream,
Externalizable {
    public static int binarySize;
    private static boolean binarySizeKnown;
    public long clusterPosition;
    public byte recordType;
    public ORecordVersion recordVersion = OVersionFactory.instance().createVersion();
    public int recordSize;

    public OPhysicalPosition() {
    }

    public OPhysicalPosition(long iClusterPosition) {
        this.clusterPosition = iClusterPosition;
    }

    public OPhysicalPosition(byte iRecordType) {
        this.recordType = iRecordType;
    }

    public OPhysicalPosition(long iClusterPosition, ORecordVersion iVersion) {
        this.clusterPosition = iClusterPosition;
        this.recordVersion.copyFrom(iVersion);
    }

    public static int binarySize() {
        if (binarySizeKnown) {
            return binarySize;
        }
        binarySizeKnown = true;
        binarySize = 9 + OVersionFactory.instance().getVersionSize() + 4;
        return binarySize;
    }

    public void copyTo(OPhysicalPosition iDest) {
        iDest.clusterPosition = this.clusterPosition;
        iDest.recordType = this.recordType;
        iDest.recordVersion = this.recordVersion;
        iDest.recordSize = this.recordSize;
    }

    public void copyFrom(OPhysicalPosition iSource) {
        iSource.copyTo(this);
    }

    public String toString() {
        return "rid(?:" + this.clusterPosition + ") record(type:" + this.recordType + " size:" + this.recordSize + " v:" + this.recordVersion + ")";
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        int pos = 0;
        this.clusterPosition = OBinaryProtocol.bytes2long(iStream);
        this.recordType = iStream[pos += 8];
        this.recordSize = OBinaryProtocol.bytes2int(iStream, ++pos);
        this.recordVersion.getSerializer().readFrom(iStream, pos += 4, this.recordVersion);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        byte[] buffer = new byte[OPhysicalPosition.binarySize()];
        int pos = 0;
        OBinaryProtocol.long2bytes(this.clusterPosition, buffer, pos);
        buffer[pos += 8] = this.recordType;
        OBinaryProtocol.int2bytes(this.recordSize, buffer, ++pos);
        this.recordVersion.getSerializer().writeTo(buffer, pos += 4, this.recordVersion);
        return buffer;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OPhysicalPosition)) {
            return false;
        }
        OPhysicalPosition other = (OPhysicalPosition)obj;
        return this.clusterPosition == other.clusterPosition && this.recordType == other.recordType && this.recordVersion.equals(other.recordVersion) && this.recordSize == other.recordSize;
    }

    public int hashCode() {
        int result = (int)(31L * this.clusterPosition);
        result = 31 * result + this.recordType;
        result = 31 * result + (this.recordVersion != null ? this.recordVersion.hashCode() : 0);
        result = 31 * result + this.recordSize;
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.clusterPosition);
        out.writeByte(this.recordType);
        out.writeInt(this.recordSize);
        this.recordVersion.getSerializer().writeTo(out, this.recordVersion);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.clusterPosition = in.readLong();
        this.recordType = in.readByte();
        this.recordSize = in.readInt();
        this.recordVersion.getSerializer().readFrom(in, this.recordVersion);
    }

    static {
        binarySizeKnown = false;
    }
}

