/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.text;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.sql.method.misc.OAbstractSQLMethod;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

public class OSQLMethodHash
extends OAbstractSQLMethod {
    public static final String NAME = "hash";

    public OSQLMethodHash() {
        super(NAME, 0, 1);
    }

    @Override
    public String getSyntax() {
        return "hash([<algorithm>])";
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, OCommandContext iContext, Object ioResult, Object[] iParams) {
        if (iThis == null) {
            return null;
        }
        String algorithm = iParams.length > 0 ? iParams[0].toString() : "SHA-256";
        try {
            return OSecurityManager.digest2String(iThis.toString(), algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OCommandExecutionException("hash(): algorithm '" + algorithm + "' is not supported");
        }
        catch (UnsupportedEncodingException e) {
            throw new OCommandExecutionException("hash(): encoding 'UTF-8' is not supported");
        }
    }
}

