/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.math;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSQLFunctionAverage
extends OSQLFunctionMathAbstract {
    public static final String NAME = "avg";
    private Number sum;
    private int total = 0;

    public OSQLFunctionAverage() {
        super(NAME, 1, -1);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        block4: {
            block2: {
                block3: {
                    if (iParams.length != 1) break block2;
                    if (!(iParams[0] instanceof Number)) break block3;
                    this.sum((Number)iParams[0]);
                    break block4;
                }
                if (!OMultiValue.isMultiValue(iParams[0])) break block4;
                for (Object n : OMultiValue.getMultiValueIterable(iParams[0])) {
                    this.sum((Number)n);
                }
                break block4;
            }
            this.sum = null;
            for (int i = 0; i < iParams.length; ++i) {
                this.sum((Number)iParams[i]);
            }
        }
        return this.getResult();
    }

    protected void sum(Number value) {
        if (value != null) {
            ++this.total;
            this.sum = this.sum == null ? (Number)value : (Number)OType.increment(this.sum, value);
        }
    }

    @Override
    public String getSyntax() {
        return "avg(<field> [,<field>*])";
    }

    @Override
    public Object getResult() {
        if (this.returnDistributedResult()) {
            HashMap<String, Number> doc = new HashMap<String, Number>();
            doc.put("sum", this.sum);
            doc.put("total", this.total);
            return doc;
        }
        return this.computeAverage(this.sum, this.total);
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        Number dSum = null;
        int dTotal = 0;
        for (Object iParameter : resultsToMerge) {
            Map item = (Map)iParameter;
            dSum = dSum == null ? (Number)((Number)item.get("sum")) : (Number)OType.increment(dSum, (Number)item.get("sum"));
            dTotal += ((Integer)item.get("total")).intValue();
        }
        return this.computeAverage(dSum, dTotal);
    }

    @Override
    public boolean aggregateResults() {
        return this.configuredParameters.length == 1;
    }

    private Object computeAverage(Number iSum, int iTotal) {
        if (iSum instanceof Integer) {
            return iSum.intValue() / iTotal;
        }
        if (iSum instanceof Long) {
            return iSum.longValue() / (long)iTotal;
        }
        if (iSum instanceof Float) {
            return Float.valueOf(iSum.floatValue() / (float)iTotal);
        }
        if (iSum instanceof Double) {
            return iSum.doubleValue() / (double)iTotal;
        }
        if (iSum instanceof BigDecimal) {
            return ((BigDecimal)iSum).divide(new BigDecimal(iTotal), RoundingMode.HALF_UP);
        }
        return null;
    }
}

