/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.coll;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionMultiValueAbstract;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OSQLFunctionSymmetricDifference
extends OSQLFunctionMultiValueAbstract<Set<Object>> {
    boolean first = true;
    public static final String NAME = "symmetricDifference";

    public OSQLFunctionSymmetricDifference() {
        super(NAME, 1, -1);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        if (iParams[0] == null) {
            return null;
        }
        if (this.context == null) {
            this.context = new HashSet();
        }
        if (iParams.length == 1) {
            Object value = iParams[0];
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    if (this.first) {
                        if (o instanceof ODocument) {
                            ((Set)this.context).add(o);
                        } else if (o instanceof Collection) {
                            ((Set)this.context).addAll((Collection)o);
                        } else {
                            ((Set)this.context).add(o);
                        }
                        this.first = false;
                        continue;
                    }
                    this.context = this.getDifferenceOf(this.context, o);
                }
            }
            return null;
        }
        boolean first = true;
        for (Object o : iParams) {
            if (first) {
                if (o instanceof ODocument) {
                    ((Set)this.context).add(o);
                } else if (o instanceof Collection) {
                    ((Set)this.context).addAll((Collection)o);
                } else {
                    ((Set)this.context).add(o);
                }
                first = false;
                continue;
            }
            this.context = this.getDifferenceOf(this.context, o);
        }
        return this.context;
    }

    public Set<Object> getDifferenceOf(Object first, Object second) {
        HashSet<Object> result = new HashSet<Object>();
        HashSet<Object> boxedResult = new HashSet<Object>();
        if (first instanceof ODocument) {
            boxedResult.add(new ODocumentContent((ODocument)first));
        } else if (first instanceof Iterable) {
            for (Object o : (Iterable)first) {
                if (o instanceof ODocument) {
                    boxedResult.add(new ODocumentContent((ODocument)o));
                    continue;
                }
                boxedResult.add(o);
            }
        } else {
            boxedResult.add(first);
        }
        Object next = second;
        if (next instanceof ODocument) {
            boxedResult.remove(new ODocumentContent((ODocument)next));
        } else if (next instanceof Iterable) {
            for (Object t : (Iterable)next) {
                if (t instanceof ODocument) {
                    ODocumentContent newItem = new ODocumentContent((ODocument)t);
                    if (boxedResult.contains(newItem)) {
                        boxedResult.remove(newItem);
                        continue;
                    }
                    boxedResult.add(newItem);
                    continue;
                }
                if (boxedResult.contains(t)) {
                    boxedResult.remove(t);
                    continue;
                }
                boxedResult.add(t);
            }
        } else if (boxedResult.contains(next)) {
            boxedResult.remove(next);
        } else {
            boxedResult.add(next);
        }
        for (Object object : boxedResult) {
            if (object instanceof ODocumentContent) {
                result.add(((ODocumentContent)object).doc);
                continue;
            }
            result.add(object);
        }
        return result;
    }

    @Override
    public Set<Object> getResult() {
        if (this.returnDistributedResult()) {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.put("result", this.context);
            return Collections.singleton(doc);
        }
        return (Set)super.getResult();
    }

    @Override
    public String getSyntax() {
        return "difference(<field>*)";
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        Set<Object> result = new HashSet<Object>();
        boolean first = true;
        for (Object item : resultsToMerge) {
            if (first) {
                if (item instanceof Collection) {
                    result.addAll((Collection)item);
                } else {
                    result.add(item);
                }
                first = false;
                continue;
            }
            result = this.getDifferenceOf(result, item);
        }
        return result;
    }

    static class ODocumentContent {
        ODocument doc;

        ODocumentContent(ODocument doc) {
            this.doc = doc;
        }

        public boolean equals(Object obj) {
            if (this.doc.getIdentity().isPersistent() && obj instanceof ODocumentContent) {
                return this.doc.equals(((ODocumentContent)obj).doc);
            }
            if (obj instanceof ODocument) {
                return ODocumentHelper.hasSameContentOf(this.doc, null, (ODocument)obj, null, null);
            }
            if (obj instanceof ODocumentContent) {
                return ODocumentHelper.hasSameContentOf(this.doc, null, ((ODocumentContent)obj).doc, null, null, false);
            }
            return false;
        }

        public int hashCode() {
            int result = 0;
            for (Object o : this.doc.fieldValues()) {
                if (o == null) continue;
                result += o.hashCode();
            }
            return result;
        }
    }
}

