/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionFactory;
import com.orientechnologies.orient.core.index.OPropertyMapIndexDefinition;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OCommandExecutorSQLCreateIndex
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_INDEX = "INDEX";
    public static final String KEYWORD_ON = "ON";
    public static final String KEYWORD_METADATA = "METADATA";
    public static final String KEYWORD_ENGINE = "ENGINE";
    private String indexName;
    private OClass oClass;
    private String[] fields;
    private OClass.INDEX_TYPE indexType;
    private OType[] keyTypes;
    private byte serializerKeyId;
    private String engine;
    private ODocument metadataDoc = null;
    private String[] collates;

    public OCommandExecutorSQLCreateIndex parse(OCommandRequest iRequest) {
        this.init((OCommandRequestText)iRequest);
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLCreateIndex.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_CREATE)) {
            throw new OCommandSQLParsingException("Keyword CREATE not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateIndex.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_INDEX)) {
            throw new OCommandSQLParsingException("Keyword INDEX not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateIndex.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected index name. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        this.indexName = word.toString();
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateIndex.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Index type requested. Use " + this.getSyntax(), this.parserText, oldPos + 1);
        }
        if (word.toString().equals(KEYWORD_ON)) {
            oldPos = pos;
            if ((pos = OCommandExecutorSQLCreateIndex.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1) {
                throw new OCommandSQLParsingException("Expected class name. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            this.oClass = this.findClass(word.toString());
            if (this.oClass == null) {
                throw new OCommandExecutionException("Class " + word + " not found");
            }
            pos = this.parserTextUpperCase.indexOf(")");
            if (pos == -1) {
                throw new OCommandSQLParsingException("No right bracket found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            String props = this.parserText.substring(oldPos, pos).trim().substring(1);
            ArrayList<String> propList = new ArrayList<String>();
            Collections.addAll(propList, props.trim().split("\\s*,\\s*"));
            this.fields = new String[propList.size()];
            propList.toArray(this.fields);
            for (int i = 0; i < this.fields.length; ++i) {
                String fieldName = this.fields[i];
                int collatePos = fieldName.toUpperCase().indexOf(" COLLATE ");
                if (collatePos > 0) {
                    if (this.collates == null) {
                        this.collates = new String[this.fields.length];
                    }
                    this.collates[i] = fieldName.substring(collatePos + " COLLATE ".length()).toLowerCase().trim();
                    this.fields[i] = fieldName.substring(0, collatePos);
                    continue;
                }
                if (this.collates == null) continue;
                this.collates[i] = null;
            }
            for (String propToIndex : this.fields) {
                this.checkMapIndexSpecifier(propToIndex, this.parserText, oldPos);
                propList.add(propToIndex);
            }
            oldPos = pos + 1;
            if ((pos = OCommandExecutorSQLCreateIndex.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1) {
                throw new OCommandSQLParsingException("Index type requested. Use " + this.getSyntax(), this.parserText, oldPos + 1);
            }
        } else if (this.indexName.indexOf(46) > 0) {
            String[] parts = this.indexName.split("\\.");
            this.oClass = this.findClass(parts[0]);
            if (this.oClass == null) {
                throw new OCommandExecutionException("Class " + parts[0] + " not found");
            }
            this.fields = new String[]{parts[1]};
        }
        this.indexType = OClass.INDEX_TYPE.valueOf(word.toString());
        if (this.indexType == null) {
            throw new OCommandSQLParsingException("Index type is null", this.parserText, oldPos);
        }
        oldPos = pos;
        pos = OCommandExecutorSQLCreateIndex.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
        if (word.toString().equals(KEYWORD_ENGINE)) {
            oldPos = pos;
            oldPos = pos = OCommandExecutorSQLCreateIndex.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false);
            this.engine = word.toString().toUpperCase();
        } else {
            this.parserGoBack();
        }
        int configPos = this.parserTextUpperCase.indexOf(KEYWORD_METADATA, oldPos);
        if (configPos > -1) {
            String configString = this.parserText.substring(configPos + KEYWORD_METADATA.length()).trim();
            this.metadataDoc = new ODocument().fromJSON(configString);
        }
        if ((pos = OCommandExecutorSQLCreateIndex.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) != -1 && !word.toString().equalsIgnoreCase("NULL") && !word.toString().equalsIgnoreCase(KEYWORD_METADATA)) {
            String typesString = configPos > -1 ? this.parserTextUpperCase.substring(oldPos, configPos).trim() : this.parserTextUpperCase.substring(oldPos).trim();
            if (word.toString().equalsIgnoreCase("RUNTIME")) {
                oldPos = pos;
                pos = OCommandExecutorSQLCreateIndex.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
                this.serializerKeyId = Byte.parseByte(word.toString());
            } else {
                ArrayList<OType> keyTypeList = new ArrayList<OType>();
                for (String typeName : typesString.split("\\s*,\\s*")) {
                    keyTypeList.add(OType.valueOf(typeName));
                }
                this.keyTypes = new OType[keyTypeList.size()];
                keyTypeList.toArray(this.keyTypes);
                if (this.fields != null && this.fields.length != 0 && this.fields.length != this.keyTypes.length) {
                    throw new OCommandSQLParsingException("Count of fields does not match with count of property types. Fields: " + Arrays.toString(this.fields) + "; Types: " + Arrays.toString((Object[])this.keyTypes), this.parserText, oldPos);
                }
            }
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        OIndex<?> idx;
        if (this.indexName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal database = OCommandExecutorSQLCreateIndex.getDatabase();
        ArrayList<OCollate> collatesList = null;
        if (this.collates != null) {
            collatesList = new ArrayList<OCollate>();
            for (String collate : this.collates) {
                if (collate != null) {
                    OCollate col = OSQLEngine.getCollate(collate);
                    collatesList.add(col);
                    continue;
                }
                collatesList.add(null);
            }
        }
        if (this.fields == null || this.fields.length == 0) {
            idx = this.keyTypes != null ? database.getMetadata().getIndexManager().createIndex(this.indexName, this.indexType.toString(), new OSimpleKeyIndexDefinition(this.keyTypes, collatesList), null, null, this.metadataDoc, this.engine) : (this.serializerKeyId != 0 ? database.getMetadata().getIndexManager().createIndex(this.indexName, this.indexType.toString(), new ORuntimeKeyIndexDefinition(this.serializerKeyId), null, null, this.metadataDoc, this.engine) : database.getMetadata().getIndexManager().createIndex(this.indexName, this.indexType.toString(), null, null, null, this.metadataDoc, this.engine));
        } else if ((this.keyTypes == null || this.keyTypes.length == 0) && this.collates == null) {
            idx = this.oClass.createIndex(this.indexName, this.indexType.toString(), (OProgressListener)null, this.metadataDoc, this.engine, this.fields);
        } else {
            List<OType> fieldTypeList = this.keyTypes != null ? Arrays.asList(this.keyTypes) : ((OClassImpl)this.oClass).extractFieldTypes(this.fields);
            OIndexDefinition idxDef = OIndexDefinitionFactory.createIndexDefinition(this.oClass, Arrays.asList(this.fields), fieldTypeList, collatesList);
            idx = database.getMetadata().getIndexManager().createIndex(this.indexName, this.indexType.name(), idxDef, this.oClass.getPolymorphicClusterIds(), null, this.metadataDoc, this.engine);
        }
        if (idx != null) {
            return idx.getSize();
        }
        return null;
    }

    @Override
    public String getSyntax() {
        return "CREATE INDEX <name> [ON <class-name> (prop-names [COLLATE <collate>])] <type> [<key-type>] [METADATA {JSON Index Metadata Document}]";
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    private OClass findClass(String part) {
        return OCommandExecutorSQLCreateIndex.getDatabase().getMetadata().getSchema().getClass(part);
    }

    private void checkMapIndexSpecifier(String fieldName, String text, int pos) {
        String[] fieldNameParts = fieldName.split("\\s+");
        if (fieldNameParts.length == 1) {
            return;
        }
        if (fieldNameParts.length == 3) {
            if ("by".equals(fieldNameParts[1].toLowerCase())) {
                try {
                    OPropertyMapIndexDefinition.INDEX_BY.valueOf(fieldNameParts[2].toUpperCase());
                }
                catch (IllegalArgumentException iae) {
                    throw new OCommandSQLParsingException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + "'", text, pos);
                }
                return;
            }
            throw new OCommandSQLParsingException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + "'", text, pos);
        }
        throw new OCommandSQLParsingException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + "'", text, pos);
    }
}

