/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Map;

public class OCommandExecutorSQLCreateClass
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_CLASS = "CLASS";
    public static final String KEYWORD_EXTENDS = "EXTENDS";
    public static final String KEYWORD_ABSTRACT = "ABSTRACT";
    public static final String KEYWORD_CLUSTER = "CLUSTER";
    private String className;
    private OClass superClass;
    private int[] clusterIds;

    public OCommandExecutorSQLCreateClass parse(OCommandRequest iRequest) {
        int clusterId;
        ODatabaseDocumentInternal database = OCommandExecutorSQLCreateClass.getDatabase();
        this.init((OCommandRequestText)iRequest);
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLCreateClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_CREATE)) {
            throw new OCommandSQLParsingException("Keyword CREATE not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
            throw new OCommandSQLParsingException("Keyword CLASS not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>", this.parserText, oldPos);
        }
        this.className = word.toString();
        if (this.className == null) {
            throw new OCommandSQLParsingException("Expected <class>", this.parserText, oldPos);
        }
        oldPos = pos;
        while ((pos = OCommandExecutorSQLCreateClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) > -1) {
            String k = word.toString();
            if (k.equals(KEYWORD_EXTENDS)) {
                oldPos = pos;
                if ((pos = OCommandExecutorSQLCreateClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false)) == -1) {
                    throw new OCommandSQLParsingException("Syntax error after EXTENDS for class " + this.className + ". Expected the super-class name. Use " + this.getSyntax(), this.parserText, oldPos);
                }
                if (!database.getMetadata().getSchema().existsClass(word.toString())) {
                    throw new OCommandSQLParsingException("Super-class " + word + " not exists", this.parserText, oldPos);
                }
                this.superClass = database.getMetadata().getSchema().getClass(word.toString());
            } else if (k.equals(KEYWORD_CLUSTER)) {
                oldPos = pos;
                if ((pos = OCommandExecutorSQLCreateClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false, " =><()")) == -1) {
                    throw new OCommandSQLParsingException("Syntax error after CLUSTER for class " + this.className + ". Expected the cluster id or name. Use " + this.getSyntax(), this.parserText, oldPos);
                }
                String[] clusterIdsAsStrings = word.toString().split(",");
                if (clusterIdsAsStrings.length > 0) {
                    this.clusterIds = new int[clusterIdsAsStrings.length];
                    for (int i = 0; i < clusterIdsAsStrings.length; ++i) {
                        this.clusterIds[i] = Character.isDigit(clusterIdsAsStrings[i].charAt(0)) ? Integer.parseInt(clusterIdsAsStrings[i]) : database.getStorage().getClusterIdByName(clusterIdsAsStrings[i]);
                        if (this.clusterIds[i] == -1) {
                            throw new OCommandSQLParsingException("Cluster with id " + this.clusterIds[i] + " does not exists", this.parserText, oldPos);
                        }
                        try {
                            database.getStorage().getClusterById(this.clusterIds[i]);
                            continue;
                        }
                        catch (Exception e) {
                            throw new OCommandSQLParsingException("Cluster with id " + this.clusterIds[i] + " does not exists", this.parserText, oldPos);
                        }
                    }
                }
            } else if (k.equals(KEYWORD_ABSTRACT)) {
                this.clusterIds = new int[]{-1};
            } else {
                throw new OCommandSQLParsingException("Invalid keyword: " + k);
            }
            oldPos = pos;
        }
        if (this.clusterIds == null && (clusterId = database.getStorage().getClusterIdByName(this.className)) > -1) {
            this.clusterIds = new int[]{clusterId};
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.className == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal database = OCommandExecutorSQLCreateClass.getDatabase();
        database.getMetadata().getSchema().createClass(this.className, this.superClass, this.clusterIds);
        return database.getMetadata().getSchema().getClasses().size();
    }

    @Override
    public String getSyntax() {
        return "CREATE CLASS <class> [EXTENDS <super-class>] [CLUSTER <clusterId>*] [ABSTRACT]";
    }

    @Override
    public boolean involveSchema() {
        return true;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }
}

