/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyRecord;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerListRID;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerLiteral;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerLong;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerRID;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerRecord;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerSBTreeIndexRIDContainer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerString;

public class OStreamSerializerFactory {
    public static OStreamSerializer get(String iName) {
        try {
            if (iName.equals("l")) {
                return OStreamSerializerRecord.INSTANCE;
            }
            if (iName.equals("s")) {
                return OStreamSerializerString.INSTANCE;
            }
            if (iName.equals("lo")) {
                return OStreamSerializerLong.INSTANCE;
            }
            if (iName.equals("li")) {
                return OStreamSerializerLiteral.INSTANCE;
            }
            if (iName.equals("ar")) {
                return OStreamSerializerAnyRecord.INSTANCE;
            }
            if (iName.equals("at")) {
                return OStreamSerializerAnyStreamable.INSTANCE;
            }
            if (iName.equals("p")) {
                return OStreamSerializerRID.INSTANCE;
            }
            if (iName.equals("y")) {
                return OStreamSerializerListRID.INSTANCE;
            }
            if (iName.equals("icn")) {
                return OStreamSerializerSBTreeIndexRIDContainer.INSTANCE;
            }
            if (iName.equals("cks")) {
                return OCompositeKeySerializer.INSTANCE;
            }
            throw new OConfigurationException("Stream Serializer '" + iName + "' not registered");
        }
        catch (Exception e) {
            throw new OConfigurationException("Error on retrieving of Stream Serializer '" + iName + "'", e);
        }
    }
}

