/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;

public class OVarIntSerializer {
    public static int write(BytesContainer bytes, long value) {
        value = OVarIntSerializer.signedToUnsigned(value);
        int pos = bytes.offset;
        OVarIntSerializer.writeUnsignedVarLong(value, bytes);
        return pos;
    }

    public static short readAsShort(BytesContainer bytes) {
        return (short)OVarIntSerializer.readSignedVarLong(bytes);
    }

    public static long readAsLong(BytesContainer bytes) {
        return OVarIntSerializer.readSignedVarLong(bytes);
    }

    public static int readAsInteger(BytesContainer bytes) {
        return (int)OVarIntSerializer.readSignedVarLong(bytes);
    }

    private static long signedToUnsigned(long value) {
        return value << 1 ^ value >> 63;
    }

    public static void writeUnsignedVarLong(long value, BytesContainer bos) {
        int pos;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            pos = bos.alloc(1);
            bos.bytes[pos] = (byte)(value & 0x7FL | 0x80L);
            value >>>= 7;
        }
        pos = bos.alloc(1);
        bos.bytes[pos] = (byte)(value & 0x7FL);
    }

    public static long readSignedVarLong(BytesContainer bytes) {
        long raw = OVarIntSerializer.readUnsignedVarLong(bytes);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    public static long readUnsignedVarLong(BytesContainer bytes) {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)bytes.bytes[bytes.offset++]) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IllegalArgumentException("Variable length quantity is too long (must be <= 63)");
        }
        return value | b << i;
    }
}

