/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.HashMap;

final class OSimpleMultiValueChangeListener<K, V>
implements OMultiValueChangeListener<K, V> {
    private final ODocument oDocument;
    private final String fieldName;

    OSimpleMultiValueChangeListener(ODocument oDocument, String fieldName) {
        this.oDocument = oDocument;
        this.fieldName = fieldName;
    }

    @Override
    public void onAfterRecordChanged(OMultiValueChangeEvent<K, V> event) {
        OMultiValueChangeTimeLine<Object, Object> timeLine;
        if (this.oDocument.getInternalStatus() != ORecordElement.STATUS.UNMARSHALLING) {
            if (event.isChangesOwnerContent()) {
                this.oDocument.setDirty();
            } else {
                this.oDocument.setDirtyNoChanged();
            }
        }
        if (!this.oDocument._trackingChanges || !this.oDocument.getIdentity().isValid() || this.oDocument.getInternalStatus() == ORecordElement.STATUS.UNMARSHALLING) {
            return;
        }
        if (this.oDocument._fieldOriginalValues != null && this.oDocument._fieldOriginalValues.containsKey(this.fieldName)) {
            return;
        }
        if (this.oDocument._fieldCollectionChangeTimeLines == null) {
            this.oDocument._fieldCollectionChangeTimeLines = new HashMap<String, OMultiValueChangeTimeLine<Object, Object>>();
        }
        if ((timeLine = this.oDocument._fieldCollectionChangeTimeLines.get(this.fieldName)) == null) {
            timeLine = new OMultiValueChangeTimeLine();
            this.oDocument._fieldCollectionChangeTimeLines.put(this.fieldName, timeLine);
        }
        timeLine.addCollectionChangeEvent(event);
    }
}

