/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Comparator;
import java.util.List;

public class ODocumentComparator
implements Comparator<OIdentifiable> {
    private List<OPair<String, String>> orderCriteria;
    private OCommandContext context;

    public ODocumentComparator(List<OPair<String, String>> iOrderCriteria, OCommandContext iContext) {
        this.orderCriteria = iOrderCriteria;
        this.context = iContext;
    }

    @Override
    public int compare(OIdentifiable iDoc1, OIdentifiable iDoc2) {
        if (iDoc1 != null && iDoc1.equals(iDoc2)) {
            return 0;
        }
        int partialResult = 0;
        for (OPair<String, String> field : this.orderCriteria) {
            String fieldName = (String)field.getKey();
            String ordering = field.getValue();
            Object fieldValue1 = ((ODocument)iDoc1.getRecord()).field(fieldName);
            Object fieldValue2 = ((ODocument)iDoc2.getRecord()).field(fieldName);
            if (fieldValue1 == null && fieldValue2 == null) continue;
            if (fieldValue1 == null) {
                return this.factor(-1, ordering);
            }
            if (fieldValue2 == null) {
                return this.factor(1, ordering);
            }
            if (!(fieldValue1 instanceof Comparable)) {
                this.context.incrementVariable("INVALID_COMPARE_COUNT");
                partialResult = ("" + fieldValue1).compareTo("" + fieldValue2);
            } else {
                try {
                    partialResult = ((Comparable)fieldValue1).compareTo(fieldValue2);
                }
                catch (Exception x) {
                    this.context.incrementVariable("INVALID_COMPARE_COUNT");
                    partialResult = ("" + fieldValue1).compareTo("" + fieldValue2);
                }
            }
            if ((partialResult = this.factor(partialResult, ordering)) == 0) continue;
            break;
        }
        return partialResult;
    }

    private int factor(int partialResult, String iOrdering) {
        if (iOrdering.equals("DESC")) {
            return partialResult * -1;
        }
        return partialResult;
    }
}

