/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.record.impl.ORecordFlat;

public class ORecordFactoryManager {
    protected final String[] recordTypeNames = new String[127];
    protected final Class<? extends ORecord>[] recordTypes = new Class[127];
    protected final ORecordFactory[] recordFactories = new ORecordFactory[127];

    public ORecordFactoryManager() {
        this.declareRecordType((byte)100, "document", ODocument.class, new ORecordFactory(){

            @Override
            public ORecord newRecord() {
                return new ODocument();
            }
        });
        this.declareRecordType((byte)102, "flat", ORecordFlat.class, new ORecordFactory(){

            @Override
            public ORecord newRecord() {
                return new ORecordFlat();
            }
        });
        this.declareRecordType((byte)98, "bytes", ORecordBytes.class, new ORecordFactory(){

            @Override
            public ORecord newRecord() {
                return new ORecordBytes();
            }
        });
    }

    public String getRecordTypeName(byte iRecordType) {
        String name = this.recordTypeNames[iRecordType];
        if (name == null) {
            throw new IllegalArgumentException("Unsupported record type: " + iRecordType);
        }
        return name;
    }

    public Class<? extends ORecord> getRecordTypeClass(byte iRecordType) {
        Class<? extends ORecord> cls = this.recordTypes[iRecordType];
        if (cls == null) {
            throw new IllegalArgumentException("Unsupported record type: " + iRecordType);
        }
        return cls;
    }

    public ORecord newInstance() {
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.INSTANCE.get();
        try {
            return this.getFactory(database.getRecordType()).newRecord();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported record type: " + database.getRecordType(), e);
        }
    }

    public ORecord newInstance(byte iRecordType) {
        try {
            return this.getFactory(iRecordType).newRecord();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported record type: " + iRecordType, e);
        }
    }

    public void declareRecordType(byte iByte, String iName, Class<? extends ORecord> iClass, ORecordFactory iFactory) {
        if (this.recordTypes[iByte] != null) {
            throw new OException("Record type byte '" + iByte + "' already in use : " + this.recordTypes[iByte].getName());
        }
        this.recordTypeNames[iByte] = iName;
        this.recordTypes[iByte] = iClass;
        this.recordFactories[iByte] = iFactory;
    }

    protected ORecordFactory getFactory(byte iRecordType) {
        ORecordFactory factory = this.recordFactories[iRecordType];
        if (factory == null) {
            throw new IllegalArgumentException("Record type '" + iRecordType + "' is not supported");
        }
        return factory;
    }

    public static interface ORecordFactory {
        public ORecord newRecord();
    }
}

