/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.processor.block;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.processor.OComposableProcessor;
import com.orientechnologies.orient.core.processor.block.OAbstractBlock;
import com.orientechnologies.orient.core.record.impl.ODocument;

public class OScriptBlock
extends OAbstractBlock {
    public static final String NAME = "script";

    @Override
    public Object processBlock(OComposableProcessor iManager, OCommandContext iContext, ODocument iConfig, ODocument iOutput, boolean iReadOnly) {
        String language = this.getFieldOrDefault(iContext, iConfig, "language", "javascript");
        Object code = this.getRequiredField(iContext, iConfig, "code");
        if (OMultiValue.isMultiValue(code)) {
            StringBuilder buffer = new StringBuilder(1024);
            for (Object o : OMultiValue.getMultiValueIterable(code)) {
                if (buffer.length() > 0) {
                    buffer.append(";");
                }
                buffer.append(o.toString());
            }
            code = buffer.toString();
        }
        OCommandScript script = new OCommandScript(language, code.toString());
        script.getContext().setParent(iContext);
        iContext.setVariable("block", this);
        return script.execute(new Object[0]);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

