/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.processor.block;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.processor.OComposableProcessor;
import com.orientechnologies.orient.core.processor.block.OAbstractBlock;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;

public class OQueryBlock
extends OAbstractBlock {
    public static final String NAME = "query";

    @Override
    public Object processBlock(OComposableProcessor iManager, OCommandContext iContext, ODocument iConfig, ODocument iOutput, boolean iReadOnly) {
        if (!(iConfig instanceof ODocument)) {
            throw new OTransactionException("QueryBlock: expected document as content");
        }
        String command = this.parse(iContext, iConfig);
        command = (String)this.resolveValue(iContext, command, true);
        this.debug(iContext, "Executing: " + (iReadOnly ? NAME : "command") + ": " + command.replace("%", "%%") + "...", new Object[0]);
        OSQLSynchQuery cmd = new OSQLSynchQuery(command.toString());
        cmd.getContext().setParent(iContext);
        String returnVariable = this.getFieldOfClass(iContext, iConfig, "return", String.class);
        if (returnVariable != null) {
            List result = (List)cmd.execute(new Object[0]);
            this.debug(iContext, "Returned %d records", result.size());
            return result;
        }
        return cmd;
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected String parse(OCommandContext iContext, ODocument iContent) {
        Object code = this.getField(iContext, iContent, "code");
        if (code != null) {
            return code.toString();
        }
        StringBuilder command = new StringBuilder(256);
        command.append("select ");
        this.generateProjections(iContext, iContent, command);
        this.generateTarget(iContext, iContent, command);
        this.generateLet(iContext, iContent, command);
        this.generateLimit(iContext, iContent, command);
        this.generateFilter(iContext, iContent, command);
        this.generateGroupBy(iContext, iContent, command);
        this.generateOrderBy(iContext, iContent, command);
        this.generateLimit(iContext, iContent, command);
        return command.toString();
    }

    private void generateProjections(OCommandContext iContext, ODocument iInput, StringBuilder iCommandText) {
        Object fields = this.getField(iContext, iInput, "fields");
        if (fields instanceof String) {
            iCommandText.append(fields.toString());
        } else {
            List fieldList = (List)fields;
            if (fieldList != null) {
                boolean first = true;
                for (Object field : fieldList) {
                    if (first) {
                        first = false;
                    } else {
                        iCommandText.append(", ");
                    }
                    if (field instanceof ODocument) {
                        ODocument fieldDoc = (ODocument)field;
                        for (String f : fieldDoc.fieldNames()) {
                            iCommandText.append(f);
                            iCommandText.append(" as ");
                            iCommandText.append(fieldDoc.field(f));
                        }
                        continue;
                    }
                    iCommandText.append(field.toString());
                }
            }
        }
    }

    private void generateTarget(OCommandContext iContext, ODocument iInput, StringBuilder iCommandText) {
        String target = (String)this.getField(iContext, iInput, "target");
        if (target != null) {
            iCommandText.append(" from ");
            iCommandText.append(target);
        }
    }

    private void generateLet(OCommandContext iContext, ODocument iInput, StringBuilder iCommandText) {
        String let = (String)this.getField(iContext, iInput, "let");
        if (let != null) {
            iCommandText.append(" let ");
            iCommandText.append(let);
        }
    }

    private void generateFilter(OCommandContext iContext, ODocument iInput, StringBuilder iCommandText) {
        String filter = (String)this.getField(iContext, iInput, "filter");
        if (filter != null) {
            iCommandText.append(" where ");
            iCommandText.append(filter);
        }
    }

    private void generateGroupBy(OCommandContext iContext, ODocument iInput, StringBuilder iCommandText) {
        String groupBy = (String)this.getField(iContext, iInput, "groupBy");
        if (groupBy != null) {
            iCommandText.append(" group by ");
            iCommandText.append(groupBy);
        }
    }

    private void generateOrderBy(OCommandContext iContext, ODocument iInput, StringBuilder iCommandText) {
        String orderBy = (String)this.getField(iContext, iInput, "orderBy");
        if (orderBy != null) {
            iCommandText.append(" order by ");
            iCommandText.append(orderBy);
        }
    }

    private void generateLimit(OCommandContext iContext, ODocument iInput, StringBuilder iCommandText) {
        Integer limit = (Integer)this.getField(iContext, iInput, "limit");
        if (limit != null) {
            iCommandText.append(" limit ");
            iCommandText.append(limit);
        }
    }
}

