/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.processor.block;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.processor.OComposableProcessor;
import com.orientechnologies.orient.core.processor.block.OAbstractBlock;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OOutputBlock
extends OAbstractBlock {
    public static final String NAME = "output";

    @Override
    public Object processBlock(OComposableProcessor iManager, OCommandContext iContext, ODocument iConfig, ODocument iOutput, boolean iReadOnly) {
        Object value = this.getRequiredField(iContext, iConfig, "value");
        Boolean nullAsEmpty = this.getFieldOfClass(iContext, iConfig, "nullAsEmpty", Boolean.class);
        if (nullAsEmpty == null) {
            nullAsEmpty = true;
        }
        Boolean flatMultivalues = this.getFieldOfClass(iContext, iConfig, "flatMultivalues", Boolean.class);
        Object result = OOutputBlock.isBlock(value) ? this.delegate("value", iManager, value, iContext, iOutput, iReadOnly) : value;
        Object source = this.getField(iContext, iConfig, "source");
        if (source instanceof Map) {
            source = new ODocument((Map)source);
        }
        if (source instanceof ODocument && result instanceof List) {
            result = OOutputBlock.addDocumentFields((ODocument)source, (List)result, nullAsEmpty);
        } else if (OMultiValue.isMultiValue(result) && flatMultivalues != null && flatMultivalues.booleanValue()) {
            result = this.flatMultivalues(iContext, false, flatMultivalues, result);
        }
        String field = this.getFieldOfClass(iContext, iConfig, "field", String.class);
        if (field != null) {
            iOutput.field(field, result);
            return iOutput;
        }
        return result;
    }

    public static Object addDocumentFields(ODocument source, List<Object> result) {
        return OOutputBlock.addDocumentFields(source, result, true);
    }

    public static Object addDocumentFields(ODocument source, List<Object> result, boolean nullAsEmpty) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : result) {
            if (o == null) continue;
            Object fieldValue = source.field(o.toString());
            if (fieldValue == null && nullAsEmpty) {
                list.add("");
                continue;
            }
            list.add((String)fieldValue);
        }
        return list;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

