/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.processor.block;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.processor.OComposableProcessor;
import com.orientechnologies.orient.core.processor.OProcessException;
import com.orientechnologies.orient.core.processor.block.OAbstractBlock;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class OExecuteBlock
extends OAbstractBlock {
    public static final String NAME = "execute";
    private Object returnValue;

    @Override
    public Object processBlock(OComposableProcessor iManager, OCommandContext iContext, ODocument iConfig, ODocument iOutput, boolean iReadOnly) {
        Object foreach = this.getField(iContext, iConfig, "foreach", false);
        String returnType = this.getFieldOfClass(iContext, iConfig, "returnType", String.class);
        this.returnValue = null;
        if (returnType == null) {
            returnType = "last";
        } else if ("list".equalsIgnoreCase(returnType)) {
            this.returnValue = new ArrayList();
        } else if ("set".equalsIgnoreCase(returnType)) {
            this.returnValue = new HashSet();
        }
        int iterated = 0;
        Object beginClause = this.getField(iContext, iConfig, "begin");
        if (beginClause != null) {
            this.executeBlock(iManager, iContext, "begin", beginClause, iOutput, iReadOnly, returnType, this.returnValue);
        }
        if (foreach != null) {
            Object result = foreach instanceof ODocument ? this.delegate("foreach", iManager, (ODocument)foreach, iContext, iOutput, iReadOnly) : (foreach instanceof Map ? ((Map)foreach).values() : foreach);
            if (!OMultiValue.isIterable(result)) {
                throw new OProcessException("Result of 'foreach' block (" + foreach + ") must be iterable but found " + result.getClass());
            }
            for (Object current : OMultiValue.getMultiValueIterable(result)) {
                if (current instanceof Map.Entry) {
                    current = ((Map.Entry)current).getValue();
                }
                this.assignVariable(iContext, "current", current);
                this.assignVariable(iContext, "currentIndex", iterated);
                this.debug(iContext, "Executing...", new Object[0]);
                Object doClause = this.getRequiredField(iContext, iConfig, "do");
                this.returnValue = this.executeDo(iManager, iContext, doClause, returnType, this.returnValue, iOutput, iReadOnly);
                this.debug(iContext, "Done", new Object[0]);
                ++iterated;
            }
        } else {
            this.debug(iContext, "Executing...", new Object[0]);
            Object doClause = this.getRequiredField(iContext, iConfig, "do");
            this.returnValue = this.executeDo(iManager, iContext, doClause, returnType, this.returnValue, iOutput, iReadOnly);
            this.debug(iContext, "Done", new Object[0]);
        }
        Object endClause = this.getField(iContext, iConfig, "end");
        if (endClause != null) {
            this.executeBlock(iManager, iContext, "end", endClause, iOutput, iReadOnly, returnType, this.returnValue);
        }
        this.debug(iContext, "Executed %d iteration and returned type %s", iterated, returnType);
        return this.returnValue;
    }

    private Object executeDo(OComposableProcessor iManager, OCommandContext iContext, Object iDoClause, String returnType, Object returnValue, ODocument iOutput, boolean iReadOnly) {
        int i = 0;
        if (OExecuteBlock.isBlock(iDoClause)) {
            returnValue = this.executeBlock(iManager, iContext, "do", iDoClause, iOutput, iReadOnly, returnType, returnValue);
        } else {
            for (Object item : OMultiValue.getMultiValueIterable(iDoClause)) {
                String blockId = "do[" + i + "]";
                returnValue = this.executeBlock(iManager, iContext, blockId, item, iOutput, iReadOnly, returnType, returnValue);
                ++i;
            }
        }
        return returnValue;
    }

    private Object executeBlock(OComposableProcessor iManager, OCommandContext iContext, String iName, Object iValue, ODocument iOutput, boolean iReadOnly, String returnType, Object returnValue) {
        Object result;
        Boolean merge;
        Boolean bl = merge = iValue instanceof ODocument ? this.getFieldOfClass(iContext, (ODocument)iValue, "merge", Boolean.class) : Boolean.FALSE;
        if (merge == null) {
            merge = Boolean.FALSE;
        }
        if (OExecuteBlock.isBlock(iValue)) {
            ODocument value = (ODocument)iValue;
            result = this.delegate(iName, iManager, value, iContext, iOutput, iReadOnly);
            if (value.containsField("return")) {
                return returnValue;
            }
        } else {
            try {
                result = iManager.processFromFile(iName, iContext, iReadOnly);
            }
            catch (Exception e) {
                throw new OProcessException("Error on processing '" + iName + "' field of '" + this.getName() + "' block", e);
            }
        }
        if ("last".equalsIgnoreCase(returnType)) {
            returnValue = result;
        } else if (result != null && ("list".equalsIgnoreCase(returnType) || "set".equalsIgnoreCase(returnType))) {
            if (result instanceof Collection && merge.booleanValue()) {
                this.debug(iContext, "Merging content of collection with size %d with the master with size %d", ((Collection)result).size(), ((Collection)returnValue).size());
                ((Collection)returnValue).addAll((Collection)result);
            } else {
                ((Collection)returnValue).add(result);
            }
        }
        return returnValue;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }
}

