/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.processor;

import com.orientechnologies.common.factory.OConfigurableStatefulFactory;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.processor.OProcessException;
import com.orientechnologies.orient.core.processor.OProcessor;
import com.orientechnologies.orient.core.processor.block.OExecuteBlock;
import com.orientechnologies.orient.core.processor.block.OFunctionBlock;
import com.orientechnologies.orient.core.processor.block.OIfBlock;
import com.orientechnologies.orient.core.processor.block.OIterateBlock;
import com.orientechnologies.orient.core.processor.block.OLetBlock;
import com.orientechnologies.orient.core.processor.block.OOutputBlock;
import com.orientechnologies.orient.core.processor.block.OProcessorBlock;
import com.orientechnologies.orient.core.processor.block.OQueryBlock;
import com.orientechnologies.orient.core.processor.block.OScriptBlock;
import com.orientechnologies.orient.core.processor.block.OTableBlock;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class OComposableProcessor
extends OConfigurableStatefulFactory<String, OProcessorBlock>
implements OProcessor {
    private String path;
    private String extension;

    public OComposableProcessor() {
        this.register("function", OFunctionBlock.class);
        this.register("if", OIfBlock.class);
        this.register("iterate", OIterateBlock.class);
        this.register("let", OLetBlock.class);
        this.register("execute", OExecuteBlock.class);
        this.register("output", OOutputBlock.class);
        this.register("query", OQueryBlock.class);
        this.register("script", OScriptBlock.class);
        this.register("table", OTableBlock.class);
    }

    public Object processFromFile(String iFileName, OCommandContext iContext, boolean iReadOnly) throws IOException {
        ODocument template = new ODocument().fromJSON(this.loadTemplate(iFileName), "noMap");
        return this.process(null, template, iContext, new ODocument().setOrdered(true), iReadOnly);
    }

    @Override
    public Object process(OProcessorBlock iParent, Object iContent, OCommandContext iContext, ODocument iOutput, boolean iReadOnly) {
        if (!(iContent instanceof ODocument)) {
            throw new OProcessException("Composable processor needs a document");
        }
        ODocument document = (ODocument)iContent;
        String type = (String)document.field("type");
        if (type == null) {
            throw new OProcessException("Composable processor needs 'type' field");
        }
        return this.process(iParent, type, document, iContext, iOutput, iReadOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object process(OProcessorBlock iParent, String iType, ODocument iContent, OCommandContext iContext, ODocument iOutput, boolean iReadOnly) {
        Object object;
        OProcessorBlock block;
        if (iContent == null) {
            throw new OProcessException("Cannot find block type '" + iType + "'");
        }
        try {
            block = (OProcessorBlock)this.newInstance(iType);
        }
        catch (Exception e) {
            throw new OProcessException("Cannot create block of class '" + iType + "'", e);
        }
        block.setParentBlock(iParent);
        Integer depthLevel = (Integer)iContext.getVariable("depthLevel");
        iContext.setVariable("depthLevel", depthLevel == null ? 0 : depthLevel + 1);
        if (depthLevel == null) {
            OLogManager.instance().info((Object)this, "Start processing...", new Object[0]);
        }
        long start = System.currentTimeMillis();
        try {
            object = block.process(this, iContext, iContent, iOutput, iReadOnly);
            iContext.setVariable("depthLevel", depthLevel == null ? 0 : depthLevel);
        }
        catch (Throwable throwable) {
            iContext.setVariable("depthLevel", depthLevel == null ? 0 : depthLevel);
            if (depthLevel == null) {
                OLogManager.instance().info((Object)this, "End of processing. Elapsed %dms", System.currentTimeMillis() - start);
            }
            throw throwable;
        }
        if (depthLevel == null) {
            OLogManager.instance().info((Object)this, "End of processing. Elapsed %dms", System.currentTimeMillis() - start);
        }
        return object;
    }

    public String getPath() {
        return this.path;
    }

    public OComposableProcessor setPath(String path) {
        this.path = path;
        return this;
    }

    public String getExtension() {
        return this.extension;
    }

    public OComposableProcessor setExtension(String extension) {
        this.extension = extension;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadTemplate(String iPath) throws IOException {
        File file = new File(this.path + "/" + iPath + this.extension);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            long contentSize = file.length();
            byte[] buffer = new byte[(int)contentSize];
            int i = 0;
            while ((long)i < contentSize) {
                buffer[i] = (byte)is.read();
                ++i;
            }
            String string = new String(buffer);
            return string;
        }
        finally {
            is.close();
        }
    }
}

