/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;

public class OUserTrigger
extends ODocumentHookAbstract {
    public OUserTrigger() {
        this.setIncludeClasses("OUser", "ORole");
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.TARGET_NODE;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        if ("OUser".equalsIgnoreCase(iDocument.getClassName())) {
            return this.encodePassword(iDocument);
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        if ("OUser".equalsIgnoreCase(iDocument.getClassName())) {
            OSecurity sec = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSecurity().getUnderlying();
            return this.encodePassword(iDocument);
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    private ORecordHook.RESULT encodePassword(ODocument iDocument) {
        if (iDocument.field("name") == null) {
            throw new OSecurityException("User name not found");
        }
        String password = (String)iDocument.field("password");
        if (password == null) {
            throw new OSecurityException("User '" + iDocument.field("name") + "' has no password");
        }
        if (!password.startsWith("{SHA-256}")) {
            iDocument.field("password", OUser.encryptPassword(password));
            return ORecordHook.RESULT.RECORD_CHANGED;
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }
}

