/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.annotation.OAfterDeserialization;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OUser
extends ODocumentWrapper
implements OSecurityUser {
    public static final String ADMIN = "admin";
    public static final String CLASS_NAME = "OUser";
    private static final long serialVersionUID = 1L;
    protected Set<ORole> roles = new HashSet<ORole>();

    public OUser() {
    }

    public OUser(String iName) {
        super(CLASS_NAME);
        this.document.field("name", iName);
        this.setAccountStatus(OSecurityUser.STATUSES.ACTIVE);
    }

    public OUser(String iUserName, String iUserPassword) {
        super(CLASS_NAME);
        this.document.field("name", iUserName);
        this.setPassword(iUserPassword);
        this.setAccountStatus(OSecurityUser.STATUSES.ACTIVE);
    }

    public OUser(ODocument iSource) {
        this.fromStream(iSource);
    }

    public static final String encryptPassword(String iPassword) {
        return OSecurityManager.instance().digest2String(iPassword, true);
    }

    @Override
    @OAfterDeserialization
    public void fromStream(ODocument iSource) {
        if (this.document != null) {
            return;
        }
        this.document = iSource;
        this.roles = new HashSet<ORole>();
        Collection loadedRoles = (Collection)iSource.field("roles");
        if (loadedRoles != null) {
            for (ODocument d : loadedRoles) {
                if (d != null) {
                    this.roles.add(new ORole(d));
                    continue;
                }
                OLogManager.instance().warn((Object)this, "User '%s' declare to have a role that does not exist in database, skipt it", this.getName());
            }
        }
    }

    @Override
    public ORole allow(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        ORole role;
        if (this.roles == null || this.roles.isEmpty()) {
            if (this.document.field("roles") != null && !((Collection)this.document.field("roles")).isEmpty()) {
                ODocument doc = this.document;
                this.document = null;
                this.fromStream(doc);
            } else {
                throw new OSecurityAccessException(this.document.getDatabase().getName(), "User '" + this.document.field("name") + "' has no role defined");
            }
        }
        if ((role = this.checkIfAllowed(resourceGeneric, resourceSpecific, iOperation)) == null) {
            throw new OSecurityAccessException(this.document.getDatabase().getName(), "User '" + this.document.field("name") + "' has no the permission to execute the operation '" + ORole.permissionToString(iOperation) + "' against the resource: " + resourceGeneric + "." + resourceSpecific);
        }
        return role;
    }

    @Override
    public ORole checkIfAllowed(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        for (ORole r : this.roles) {
            if (r == null) {
                OLogManager.instance().warn((Object)this, "User '%s' has a null role, bypass it. Consider to fix this user roles before to continue", this.getName());
                continue;
            }
            if (!r.allow(resourceGeneric, resourceSpecific, iOperation)) continue;
            return r;
        }
        return null;
    }

    @Override
    @Deprecated
    public OSecurityRole allow(String iResource, int iOperation) {
        String resourceSpecific = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (resourceSpecific == null || resourceSpecific.equals("*")) {
            return this.allow(resourceGeneric, null, iOperation);
        }
        return this.allow(resourceGeneric, resourceSpecific, iOperation);
    }

    @Override
    @Deprecated
    public OSecurityRole checkIfAllowed(String iResource, int iOperation) {
        String resourceSpecific = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (resourceSpecific == null || resourceSpecific.equals("*")) {
            return this.checkIfAllowed(resourceGeneric, null, iOperation);
        }
        return this.checkIfAllowed(resourceGeneric, resourceSpecific, iOperation);
    }

    @Override
    @Deprecated
    public boolean isRuleDefined(String iResource) {
        String resourceSpecific = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (resourceSpecific == null || resourceSpecific.equals("*")) {
            return this.isRuleDefined(resourceGeneric, null);
        }
        return this.isRuleDefined(resourceGeneric, resourceSpecific);
    }

    @Override
    public boolean isRuleDefined(ORule.ResourceGeneric resourceGeneric, String resourceSpecific) {
        for (ORole r : this.roles) {
            if (r == null) {
                OLogManager.instance().warn((Object)this, "User '%s' has a null role, bypass it. Consider to fix this user roles before to continue", this.getName());
                continue;
            }
            if (!r.hasRule(resourceGeneric, resourceSpecific)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkPassword(String iPassword) {
        return OSecurityManager.instance().check(iPassword, (String)this.document.field("password"));
    }

    @Override
    public String getName() {
        return (String)this.document.field("name");
    }

    @Override
    public OUser setName(String iName) {
        this.document.field("name", iName);
        return this;
    }

    @Override
    public String getPassword() {
        return (String)this.document.field("password");
    }

    @Override
    public OUser setPassword(String iPassword) {
        this.document.field("password", iPassword);
        return this;
    }

    @Override
    public OSecurityUser.STATUSES getAccountStatus() {
        String status = (String)this.document.field("status");
        if (status == null) {
            throw new OSecurityException("User '" + this.getName() + "' has no status");
        }
        return OSecurityUser.STATUSES.valueOf(status);
    }

    @Override
    public void setAccountStatus(OSecurityUser.STATUSES accountStatus) {
        this.document.field("status", (Object)accountStatus);
    }

    public Set<ORole> getRoles() {
        return this.roles;
    }

    @Override
    public OUser addRole(String iRole) {
        if (iRole != null) {
            this.addRole(this.document.getDatabase().getMetadata().getSecurity().getRole(iRole));
        }
        return this;
    }

    @Override
    public OUser addRole(OSecurityRole iRole) {
        if (iRole != null) {
            this.roles.add((ORole)iRole);
        }
        HashSet<ODocument> persistentRoles = new HashSet<ODocument>();
        for (ORole r : this.roles) {
            persistentRoles.add(r.toStream());
        }
        this.document.field("roles", persistentRoles);
        return this;
    }

    @Override
    public boolean removeRole(String iRoleName) {
        Iterator<ORole> it = this.roles.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(iRoleName)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRole(String iRoleName, boolean iIncludeInherited) {
        for (ORole role : this.roles) {
            if (role.getName().equals(iRoleName)) {
                return true;
            }
            if (!iIncludeInherited) continue;
            for (ORole r = role.getParentRole(); r != null; r = r.getParentRole()) {
                if (!r.getName().equals(iRoleName)) continue;
                return true;
            }
        }
        return false;
    }

    public OUser save() {
        this.document.save(OUser.class.getSimpleName());
        return this;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public OIdentifiable getIdentity() {
        return this.document;
    }
}

