/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import java.lang.ref.WeakReference;

public class OSecurityTrackerHook
extends ODocumentHookAbstract {
    private final WeakReference<OSecurity> security;

    public OSecurityTrackerHook(OSecurity security) {
        this.security = new WeakReference<OSecurity>(security);
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.TARGET_NODE;
    }

    @Override
    public void onRecordAfterCreate(ODocument doc) {
        this.incrementSchemaVersion(doc);
    }

    @Override
    public void onRecordAfterUpdate(ODocument doc) {
        this.incrementSchemaVersion(doc);
    }

    @Override
    public void onRecordAfterDelete(ODocument doc) {
        this.incrementSchemaVersion(doc);
    }

    @Override
    public void onRecordCreateReplicated(ODocument doc) {
        this.incrementSchemaVersion(doc);
    }

    @Override
    public void onRecordUpdateReplicated(ODocument doc) {
        this.incrementSchemaVersion(doc);
    }

    @Override
    public void onRecordDeleteReplicated(ODocument doc) {
        this.incrementSchemaVersion(doc);
    }

    private void incrementSchemaVersion(ODocument doc) {
        OSecurity scr;
        if (ODocumentInternal.getImmutableSchemaClass(doc) == null) {
            return;
        }
        String className = ODocumentInternal.getImmutableSchemaClass(doc).getName();
        if ((className.equalsIgnoreCase("OUser") || className.equalsIgnoreCase("ORole")) && (scr = (OSecurity)this.security.get()) != null) {
            scr.incrementVersion();
        }
    }
}

