/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.security.OImmutableRole;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OSecurityManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OImmutableUser
implements OSecurityUser {
    private static final long serialVersionUID = 1L;
    private final long version;
    private final String name;
    private final String password;
    private final Set<OImmutableRole> roles = new HashSet<OImmutableRole>();
    private final OSecurityUser.STATUSES status;
    private final ORID rid;
    private final OUser user;

    public OImmutableUser(long version, OUser user) {
        this.version = version;
        this.name = user.getName();
        this.password = user.getPassword();
        this.status = user.getAccountStatus();
        this.rid = user.getIdentity().getIdentity();
        this.user = user;
        for (ORole role : user.getRoles()) {
            this.roles.add(new OImmutableRole(role));
        }
    }

    @Override
    public OSecurityRole allow(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        if (this.roles.isEmpty()) {
            throw new OSecurityAccessException(this.getName(), "User '" + this.getName() + "' has no role defined");
        }
        OSecurityRole role = this.checkIfAllowed(resourceGeneric, resourceSpecific, iOperation);
        if (role == null) {
            throw new OSecurityAccessException(this.getName(), "User '" + this.getName() + "' has no the permission to execute the operation '" + ORole.permissionToString(iOperation) + "' against the resource: " + resourceGeneric + "." + resourceSpecific);
        }
        return role;
    }

    @Override
    public OSecurityRole checkIfAllowed(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        for (OImmutableRole r : this.roles) {
            if (r == null) {
                OLogManager.instance().warn((Object)this, "User '%s' has a null role, bypass it. Consider to fix this user roles before to continue", this.getName());
                continue;
            }
            if (!r.allow(resourceGeneric, resourceSpecific, iOperation)) continue;
            return r;
        }
        return null;
    }

    @Override
    public boolean isRuleDefined(ORule.ResourceGeneric resourceGeneric, String resourceSpecific) {
        for (OImmutableRole r : this.roles) {
            if (r == null) {
                OLogManager.instance().warn((Object)this, "User '%s' has a null role, bypass it. Consider to fix this user roles before to continue", this.getName());
                continue;
            }
            if (!r.hasRule(resourceGeneric, resourceSpecific)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public OSecurityRole allow(String iResource, int iOperation) {
        String resourceSpecific = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (resourceSpecific == null || resourceSpecific.equals("*")) {
            return this.allow(resourceGeneric, null, iOperation);
        }
        return this.allow(resourceGeneric, resourceSpecific, iOperation);
    }

    @Override
    @Deprecated
    public OSecurityRole checkIfAllowed(String iResource, int iOperation) {
        String resourceSpecific = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (resourceSpecific == null || resourceSpecific.equals("*")) {
            return this.checkIfAllowed(resourceGeneric, null, iOperation);
        }
        return this.checkIfAllowed(resourceGeneric, resourceSpecific, iOperation);
    }

    @Override
    @Deprecated
    public boolean isRuleDefined(String iResource) {
        String resourceSpecific = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (resourceSpecific == null || resourceSpecific.equals("*")) {
            return this.isRuleDefined(resourceGeneric, null);
        }
        return this.isRuleDefined(resourceGeneric, resourceSpecific);
    }

    @Override
    public boolean checkPassword(String iPassword) {
        return OSecurityManager.instance().check(iPassword, this.getPassword());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OUser setName(String iName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public OUser setPassword(String iPassword) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OSecurityUser.STATUSES getAccountStatus() {
        return this.status;
    }

    @Override
    public void setAccountStatus(OSecurityUser.STATUSES accountStatus) {
        throw new UnsupportedOperationException();
    }

    public Set<OImmutableRole> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    @Override
    public OUser addRole(String iRole) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OUser addRole(OSecurityRole iRole) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRole(String iRoleName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasRole(String iRoleName, boolean iIncludeInherited) {
        for (OSecurityRole oSecurityRole : this.roles) {
            if (oSecurityRole.getName().equals(iRoleName)) {
                return true;
            }
            if (!iIncludeInherited) continue;
            for (OSecurityRole r = oSecurityRole.getParentRole(); r != null; r = r.getParentRole()) {
                if (!r.getName().equals(iRoleName)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public long getVersion() {
        return this.version;
    }

    @Override
    public OIdentifiable getIdentity() {
        return this.rid;
    }

    @Override
    public ODocument getDocument() {
        return this.user.getDocument();
    }
}

