/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OIndexManagerRemote;
import com.orientechnologies.orient.core.index.OIndexManagerShared;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibrary;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibraryImpl;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibraryProxy;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityProxy;
import com.orientechnologies.orient.core.metadata.security.OSecurityShared;
import com.orientechnologies.orient.core.schedule.OSchedulerListener;
import com.orientechnologies.orient.core.schedule.OSchedulerListenerImpl;
import com.orientechnologies.orient.core.schedule.OSchedulerListenerProxy;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public class OMetadataDefault
implements OMetadataInternal {
    public static final String CLUSTER_INTERNAL_NAME = "internal";
    public static final String CLUSTER_INDEX_NAME = "index";
    public static final String CLUSTER_MANUAL_INDEX_NAME = "manindex";
    protected int schemaClusterId;
    protected OSchemaProxy schema;
    protected OSecurity security;
    protected OIndexManagerProxy indexManager;
    protected OFunctionLibraryProxy functionLibrary;
    protected OSchedulerListenerProxy scheduler;
    protected static final OProfilerMBean PROFILER = Orient.instance().getProfiler();
    private final AtomicReference<OImmutableSchema> schemaCache = new AtomicReference();
    private final ThreadLocal<ThreadLocalSchemaSnapshot> threadLocalSchemaSnapshot = new ThreadLocal();

    @Override
    public void load() {
        long timer = PROFILER.startChrono();
        try {
            this.init(true);
            if (this.schemaClusterId == -1 || this.getDatabase().countClusterElements(CLUSTER_INTERNAL_NAME) == 0L) {
                return;
            }
        }
        finally {
            PROFILER.stopChrono(PROFILER.getDatabaseMetric(this.getDatabase().getName(), "metadata.load"), "Loading of database metadata", timer, "db.*.metadata.load");
        }
    }

    @Override
    public void create() throws IOException {
        this.init(false);
        this.schema.create();
        this.indexManager.create();
        this.security.create();
        this.functionLibrary.create();
        this.security.createClassTrigger();
        this.scheduler.create();
    }

    @Override
    public OSchemaProxy getSchema() {
        return this.schema;
    }

    @Override
    public void makeThreadLocalSchemaSnapshot() {
        ThreadLocalSchemaSnapshot schemaSnapshot = this.threadLocalSchemaSnapshot.get();
        if (schemaSnapshot == null) {
            OImmutableSchema immutableSchema = this.getImmutableSchemaSnapshot();
            schemaSnapshot = new ThreadLocalSchemaSnapshot(immutableSchema);
            this.threadLocalSchemaSnapshot.set(schemaSnapshot);
            return;
        }
        schemaSnapshot.snapshotCounter++;
    }

    @Override
    public void clearThreadLocalSchemaSnapshot() {
        ThreadLocalSchemaSnapshot schemaSnapshot = this.threadLocalSchemaSnapshot.get();
        if (schemaSnapshot != null) {
            if (schemaSnapshot.snapshotCounter <= 0) {
                throw new IllegalStateException("Thread local schema snapshot is cleared more times than it is done");
            }
            schemaSnapshot.snapshotCounter--;
            if (schemaSnapshot.snapshotCounter == 0) {
                this.threadLocalSchemaSnapshot.set(null);
            }
        }
    }

    @Override
    public OImmutableSchema getImmutableSchemaSnapshot() {
        OImmutableSchema newSchema;
        ThreadLocalSchemaSnapshot schemaSnapshot = this.threadLocalSchemaSnapshot.get();
        OImmutableSchema immutableSchema = null;
        if (schemaSnapshot != null) {
            immutableSchema = schemaSnapshot.schema;
        }
        if (immutableSchema != null) {
            return immutableSchema;
        }
        if (this.schema == null) {
            return null;
        }
        do {
            if ((immutableSchema = this.schemaCache.get()) == null || immutableSchema.version != this.schema.getVersion()) continue;
            newSchema = immutableSchema;
            break;
        } while (!this.schemaCache.compareAndSet(immutableSchema, newSchema = this.schema.makeSnapshot()));
        return newSchema;
    }

    @Override
    public OSecurity getSecurity() {
        return this.security;
    }

    @Override
    public OIndexManagerProxy getIndexManager() {
        return this.indexManager;
    }

    @Override
    public int getSchemaClusterId() {
        return this.schemaClusterId;
    }

    private void init(final boolean iLoad) {
        final ODatabaseDocumentInternal database = this.getDatabase();
        this.schemaClusterId = database.getClusterIdByName(CLUSTER_INTERNAL_NAME);
        this.schema = new OSchemaProxy(database.getStorage().getResource(OSchema.class.getSimpleName(), new Callable<OSchemaShared>(){

            @Override
            public OSchemaShared call() {
                ODatabaseDocumentInternal database = OMetadataDefault.this.getDatabase();
                OSchemaShared instance = new OSchemaShared(database.getStorageVersions().classesAreDetectedByClusterId());
                if (iLoad) {
                    instance.load();
                }
                return instance;
            }
        }), database);
        this.indexManager = new OIndexManagerProxy(database.getStorage().getResource(OIndexManager.class.getSimpleName(), new Callable<OIndexManager>(){

            @Override
            public OIndexManager call() {
                OIndexManagerAbstract instance = database.getStorage() instanceof OStorageProxy ? new OIndexManagerRemote(database) : new OIndexManagerShared(database);
                if (iLoad) {
                    try {
                        instance.load();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "[OMetadata] Error on loading index manager, reset index configuration", (Throwable)e, new Object[0]);
                        instance.create();
                    }
                }
                return instance;
            }
        }), database);
        this.security = new OSecurityProxy(database.getStorage().getResource(OSecurity.class.getSimpleName(), new Callable<OSecurityShared>(){

            @Override
            public OSecurityShared call() {
                OSecurityShared instance = new OSecurityShared();
                if (iLoad) {
                    OMetadataDefault.this.security = instance;
                    instance.load();
                }
                return instance;
            }
        }), database);
        Class securityClass = (Class)database.getProperty(ODatabase.OPTIONS.SECURITY.toString());
        if (securityClass != null) {
            try {
                OSecurity wrapped = this.security;
                this.security = (OSecurity)securityClass.getDeclaredConstructor(OSecurity.class, ODatabaseDocumentInternal.class).newInstance(wrapped, database);
            }
            catch (Exception e) {
                throw new OSecurityException("Cannot install custom security implementation (" + securityClass + ")", e);
            }
        }
        this.functionLibrary = new OFunctionLibraryProxy(database.getStorage().getResource(OFunctionLibrary.class.getSimpleName(), new Callable<OFunctionLibrary>(){

            @Override
            public OFunctionLibrary call() {
                OFunctionLibraryImpl instance = new OFunctionLibraryImpl();
                if (iLoad) {
                    instance.load();
                }
                return instance;
            }
        }), database);
        this.scheduler = new OSchedulerListenerProxy(database.getStorage().getResource(OSchedulerListener.class.getSimpleName(), new Callable<OSchedulerListener>(){

            @Override
            public OSchedulerListener call() {
                OSchedulerListenerImpl instance = new OSchedulerListenerImpl();
                if (iLoad) {
                    instance.load();
                }
                return instance;
            }
        }), database);
    }

    @Override
    public void reload() {
        if (this.schema != null) {
            this.schema.reload();
        }
        if (this.indexManager != null) {
            this.indexManager.reload();
        }
        if (this.security != null) {
            this.security.load();
        }
        if (this.functionLibrary != null) {
            this.functionLibrary.load();
        }
    }

    @Override
    public void close() {
        if (this.schema != null) {
            this.schema.close();
        }
        if (this.security != null) {
            this.security.close(false);
        }
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public OFunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    @Override
    public OSchedulerListener getSchedulerListener() {
        return this.scheduler;
    }

    private final class ThreadLocalSchemaSnapshot {
        private final OImmutableSchema schema;
        private int snapshotCounter = 1;

        private ThreadLocalSchemaSnapshot(OImmutableSchema schema) {
            this.schema = schema;
        }
    }
}

