/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local.cache;

import com.orientechnologies.common.concur.lock.ONewLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OAllCacheEntriesAreUsedException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCachePointer;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.index.hashindex.local.cache.WriteGroup;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.zip.CRC32;

public class OWOWCache {
    public static final int PAGE_PADDING = 8;
    public static final String NAME_ID_MAP_EXTENSION = ".cm";
    private static final String NAME_ID_MAP = "name_id_map.cm";
    public static final int MIN_CACHE_SIZE = 16;
    public static final long MAGIC_NUMBER = 4207608830L;
    private final long freeSpaceLimit = OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getValueAsLong() * 1024L * 1024L;
    private final long diskSizeCheckInterval = OGlobalConfiguration.DISC_CACHE_FREE_SPACE_CHECK_INTERVAL.getValueAsInteger() * 1000;
    private final List<WeakReference<OLowDiskSpaceListener>> listeners = new CopyOnWriteArrayList<WeakReference<OLowDiskSpaceListener>>();
    private final AtomicLong lastDiskSpaceCheck = new AtomicLong(System.currentTimeMillis());
    private final String storagePath;
    private final ConcurrentSkipListMap<GroupKey, WriteGroup> writeGroups = new ConcurrentSkipListMap();
    private final OBinarySerializer<String> stringSerializer;
    private final Map<Long, OFileClassic> files;
    private final boolean syncOnPageFlush;
    private final int pageSize;
    private final long groupTTL;
    private final OWriteAheadLog writeAheadLog;
    private final AtomicInteger cacheSize = new AtomicInteger();
    private final ONewLockManager<GroupKey> lockManager = new ONewLockManager();
    private final OLocalPaginatedStorage storageLocal;
    private final OReadersWriterSpinLock filesLock = new OReadersWriterSpinLock();
    private final ScheduledExecutorService commitExecutor;
    private final ExecutorService lowSpaceEventsPublisher;
    private Map<String, Long> nameIdMap;
    private RandomAccessFile nameIdMapHolder;
    private volatile int cacheMaxSize;
    private long fileCounter = 0L;
    private GroupKey lastGroupKey = new GroupKey(0L, -1L);
    private File nameIdMapHolderFile;
    private final AtomicLong allocatedSpace = new AtomicLong();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWOWCache(boolean syncOnPageFlush, int pageSize, long groupTTL, OWriteAheadLog writeAheadLog, long pageFlushInterval, int cacheMaxSize, OLocalPaginatedStorage storageLocal, boolean checkMinSize) {
        this.filesLock.acquireWriteLock();
        try {
            this.files = new ConcurrentHashMap<Long, OFileClassic>();
            this.syncOnPageFlush = syncOnPageFlush;
            this.pageSize = pageSize;
            this.groupTTL = groupTTL;
            this.writeAheadLog = writeAheadLog;
            this.cacheMaxSize = cacheMaxSize;
            this.storageLocal = storageLocal;
            this.storagePath = storageLocal.getVariableParser().resolveVariables(storageLocal.getStoragePath());
            OBinarySerializerFactory binarySerializerFactory = storageLocal.getComponentsFactory().binarySerializerFactory;
            this.stringSerializer = binarySerializerFactory.getObjectSerializer(OType.STRING);
            if (checkMinSize && this.cacheMaxSize < 16) {
                this.cacheMaxSize = 16;
            }
            this.commitExecutor = Executors.newSingleThreadScheduledExecutor(new FlushThreadFactory(storageLocal.getName()));
            this.lowSpaceEventsPublisher = Executors.newCachedThreadPool(new LowSpaceEventsPublisherFactory(storageLocal.getName()));
            if (pageFlushInterval > 0L) {
                this.commitExecutor.scheduleWithFixedDelay(new PeriodicFlushTask(), pageFlushInterval, pageFlushInterval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    public void startFuzzyCheckpoints() {
        if (this.writeAheadLog != null) {
            long fuzzyCheckPointInterval = OGlobalConfiguration.WAL_FUZZY_CHECKPOINT_INTERVAL.getValueAsInteger();
            this.commitExecutor.scheduleWithFixedDelay(new PeriodicalFuzzyCheckpointTask(), fuzzyCheckPointInterval, fuzzyCheckPointInterval, TimeUnit.SECONDS);
        }
    }

    public void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        this.listeners.add(new WeakReference<OLowDiskSpaceListener>(listener));
    }

    public void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        ArrayList<WeakReference<OLowDiskSpaceListener>> itemsToRemove = new ArrayList<WeakReference<OLowDiskSpaceListener>>();
        for (WeakReference<OLowDiskSpaceListener> ref : this.listeners) {
            OLowDiskSpaceListener lowDiskSpaceListener = (OLowDiskSpaceListener)ref.get();
            if (lowDiskSpaceListener != null && !lowDiskSpaceListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        for (WeakReference<OLowDiskSpaceListener> ref : itemsToRemove) {
            this.listeners.remove(ref);
        }
    }

    private void addAllocatedSpace(long diff) {
        if (diff == 0L) {
            return;
        }
        this.allocatedSpace.addAndGet(diff);
        long ts = System.currentTimeMillis();
        long lastSpaceCheck = this.lastDiskSpaceCheck.get();
        if (ts - lastSpaceCheck > this.diskSizeCheckInterval) {
            File storageDir = new File(this.storagePath);
            long freeSpace = storageDir.getFreeSpace();
            long effectiveFreeSpace = freeSpace - this.allocatedSpace.get();
            if (effectiveFreeSpace < this.freeSpaceLimit) {
                this.callLowSpaceListeners(new OLowDiskSpaceInformation(effectiveFreeSpace, this.freeSpaceLimit));
            }
            this.lastDiskSpaceCheck.lazySet(ts);
        }
    }

    private void callLowSpaceListeners(final OLowDiskSpaceInformation information) {
        this.lowSpaceEventsPublisher.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (WeakReference lowDiskSpaceListenerWeakReference : OWOWCache.this.listeners) {
                    OLowDiskSpaceListener listener = (OLowDiskSpaceListener)lowDiskSpaceListenerWeakReference.get();
                    if (listener == null) continue;
                    try {
                        listener.lowDiskSpace(information);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error during notification of low disk space for storage " + OWOWCache.this.storageLocal.getName(), (Throwable)e, new Object[0]);
                    }
                }
                return null;
            }
        });
    }

    private static int calculatePageCrc(byte[] pageData) {
        int systemSize = 12;
        CRC32 crc32 = new CRC32();
        crc32.update(pageData, systemSize, pageData.length - systemSize);
        return (int)crc32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long bookFileId(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Long fileId = this.nameIdMap.get(fileName);
            if (fileId != null && fileId < 0L) {
                long l = -fileId.longValue();
                return l;
            }
            ++this.fileCounter;
            long l = this.fileCounter;
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long openFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Long fileId = this.nameIdMap.get(fileName);
            OFileClassic fileClassic = fileId == null || fileId < 0L ? null : this.files.get(fileId);
            if (fileClassic == null) {
                fileClassic = this.createFile(fileName);
                if (!fileClassic.exists()) {
                    throw new OStorageException("File with name " + fileName + " does not exist in storage " + this.storageLocal.getName());
                }
                OLogManager.instance().error((Object)this, "File " + fileName + " is not registered in 'file name - id' map but exists in file system, " + "probably you work in distributed storage. If it is not true, please create bug in bug tracker https://github.com/orientechnologies/orientdb/issues .", new Object[0]);
                if (fileId == null) {
                    ++this.fileCounter;
                    fileId = this.fileCounter;
                } else {
                    fileId = -fileId.longValue();
                }
                this.files.put(fileId, fileClassic);
                this.nameIdMap.put(fileName, fileId);
                this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId), true);
            }
            this.openFile(fileClassic);
            long l = fileId;
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Long fileId = this.nameIdMap.get(fileName);
            if (fileId != null && fileId >= 0L) {
                throw new OStorageException("File with name " + fileName + " already exists in storage " + this.storageLocal.getName());
            }
            if (fileId == null) {
                ++this.fileCounter;
                fileId = this.fileCounter;
            } else {
                fileId = -fileId.longValue();
            }
            OFileClassic fileClassic = this.createFile(fileName);
            this.files.put(fileId, fileClassic);
            this.nameIdMap.put(fileName, fileId);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId), true);
            this.addFile(fileClassic);
            long l = fileId;
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(String fileName, long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Long existingFileId = this.nameIdMap.get(fileName);
            if (existingFileId != null && fileId >= 0L) {
                if (existingFileId != fileId) {
                    throw new OStorageException("File with given name already exists but has different id " + existingFileId + " vs. proposed " + fileId);
                }
            } else {
                throw new OStorageException("File with name " + fileName + " does not exist in storage " + this.storageLocal.getName());
            }
            OFileClassic fileClassic = this.files.get(fileId);
            this.openFile(fileClassic);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(String fileName, long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Long existingFileId = this.nameIdMap.get(fileName);
            if (existingFileId != null && existingFileId >= 0L) {
                if (existingFileId == fileId) {
                    throw new OStorageException("File with name " + fileName + " already exists in storage " + this.storageLocal.getName());
                }
                throw new OStorageException("File with given name already exists but has different id " + existingFileId + " vs. proposed " + fileId);
            }
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic != null) {
                throw new OStorageException("File with given id exists but has different name " + fileClassic.getName() + " vs. proposed " + fileName);
            }
            if (this.fileCounter < fileId) {
                this.fileCounter = fileId;
            }
            fileClassic = this.createFile(fileName);
            this.files.put(fileId, fileClassic);
            this.nameIdMap.put(fileName, fileId);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId), true);
            this.addFile(fileClassic);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    public boolean checkLowDiskSpace() {
        File storageDir = new File(this.storagePath);
        long freeSpace = storageDir.getFreeSpace();
        long effectiveFreeSpace = freeSpace - this.allocatedSpace.get();
        return effectiveFreeSpace < this.freeSpaceLimit;
    }

    public void makeFuzzyCheckpoint() {
        if (this.writeAheadLog != null) {
            this.writeAheadLog.flush();
            Future<?> future = this.commitExecutor.submit(new PeriodicalFuzzyCheckpointTask());
            try {
                future.get();
            }
            catch (Exception e) {
                throw new OStorageException("Error during fuzzy checkpoint execution for storage " + this.storageLocal.getName(), e);
            }
        }
    }

    public void lock() throws IOException {
        for (OFileClassic file : this.files.values()) {
            file.lock();
        }
    }

    public void unlock() throws IOException {
        for (OFileClassic file : this.files.values()) {
            file.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic == null) {
                throw new OStorageException("File with id " + fileId + " does not exist.");
            }
            this.openFile(fileClassic);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String fileName) {
        this.filesLock.acquireReadLock();
        try {
            Long fileId;
            if (this.nameIdMap != null && (fileId = this.nameIdMap.get(fileName)) != null && fileId >= 0L) {
                boolean bl = true;
                return bl;
            }
            File file = new File(this.storageLocal.getVariableParser().resolveVariables(this.storageLocal.getStoragePath() + File.separator + fileName));
            boolean bl = file.exists();
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(long fileId) {
        this.filesLock.acquireReadLock();
        try {
            OFileClassic file = this.files.get(fileId);
            if (file == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = file.exists();
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future store(long fileId, long pageIndex, OCachePointer dataPointer) {
        Future<?> future = null;
        this.filesLock.acquireReadLock();
        try {
            GroupKey groupKey = new GroupKey(fileId, pageIndex >>> 4);
            Lock groupLock = this.lockManager.acquireExclusiveLock(groupKey);
            try {
                int entryIndex;
                WriteGroup writeGroup = this.writeGroups.get(groupKey);
                if (writeGroup == null) {
                    writeGroup = new WriteGroup(System.currentTimeMillis());
                    this.writeGroups.put(groupKey, writeGroup);
                }
                if (writeGroup.pages[entryIndex = (int)(pageIndex & 0xFL)] == null) {
                    dataPointer.incrementReferrer();
                    writeGroup.pages[entryIndex] = dataPointer;
                    this.cacheSize.incrementAndGet();
                } else if (!writeGroup.pages[entryIndex].equals(dataPointer)) {
                    writeGroup.pages[entryIndex].decrementReferrer();
                    dataPointer.incrementReferrer();
                    writeGroup.pages[entryIndex] = dataPointer;
                }
                writeGroup.recencyBit = true;
            }
            finally {
                this.lockManager.releaseLock(groupLock);
            }
            if (this.cacheSize.get() > this.cacheMaxSize) {
                future = this.commitExecutor.submit(new PeriodicFlushTask());
            }
            Future<?> future2 = future;
            return future2;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCachePointer load(long fileId, long pageIndex, boolean addNewPages) throws IOException {
        this.filesLock.acquireReadLock();
        try {
            OCachePointer pagePointer;
            Lock groupLock;
            block15: {
                WriteGroup writeGroup;
                block13: {
                    OCachePointer pagePointer2;
                    block14: {
                        GroupKey groupKey = new GroupKey(fileId, pageIndex >>> 4);
                        groupLock = this.lockManager.acquireSharedLock(groupKey);
                        try {
                            writeGroup = this.writeGroups.get(groupKey);
                            if (writeGroup != null) break block13;
                            pagePointer2 = this.cacheFileContent(fileId, pageIndex, addNewPages);
                            if (pagePointer2 != null) break block14;
                            OCachePointer oCachePointer = null;
                            this.lockManager.releaseLock(groupLock);
                            return oCachePointer;
                        }
                        catch (Throwable throwable) {
                            this.lockManager.releaseLock(groupLock);
                            throw throwable;
                        }
                    }
                    pagePointer2.incrementReferrer();
                    OCachePointer oCachePointer = pagePointer2;
                    this.lockManager.releaseLock(groupLock);
                    return oCachePointer;
                }
                int entryIndex = (int)(pageIndex & 0xFL);
                pagePointer = writeGroup.pages[entryIndex];
                if (pagePointer == null) {
                    pagePointer = this.cacheFileContent(fileId, pageIndex, addNewPages);
                }
                if (pagePointer != null) break block15;
                OCachePointer oCachePointer = null;
                this.lockManager.releaseLock(groupLock);
                return oCachePointer;
            }
            pagePointer.incrementReferrer();
            OCachePointer oCachePointer = pagePointer;
            this.lockManager.releaseLock(groupLock);
            return oCachePointer;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    public void flush(long fileId) {
        Future<Void> future = this.commitExecutor.submit(new FileFlushTask(fileId));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new OException("File flush was interrupted", e);
        }
        catch (Exception e) {
            throw new OException("File flush was abnormally terminated", e);
        }
    }

    public void flush() {
        for (long fileId : this.files.keySet()) {
            this.flush(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFilledUpTo(long fileId) throws IOException {
        this.filesLock.acquireReadLock();
        try {
            long l = this.files.get(fileId).getFilledUpTo() / (long)this.pageSize;
            return l;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    public long getAllocatedPages() {
        return this.cacheSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen(long fileId) {
        this.filesLock.acquireReadLock();
        try {
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic != null) {
                boolean bl = fileClassic.isOpen();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long isOpen(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Long fileId = this.nameIdMap.get(fileName);
            if (fileId == null || fileId < 0L) {
                long l = -1L;
                return l;
            }
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic == null || !fileClassic.isOpen()) {
                long l = -1L;
                return l;
            }
            long l = fileId;
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftlyClosed(long fileId, boolean softlyClosed) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic != null && fileClassic.isOpen()) {
                fileClassic.setSoftlyClosed(softlyClosed);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            for (long fileId : this.files.keySet()) {
                this.setSoftlyClosed(fileId, softlyClosed);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasSoftlyClosed(long fileId) throws IOException {
        this.filesLock.acquireReadLock();
        try {
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = fileClassic.wasSoftlyClosed();
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            String name = this.doDeleteFile(fileId);
            if (name != null) {
                this.nameIdMap.put(name, -fileId);
                this.writeNameIdEntry(new NameFileIdEntry(name, -fileId), true);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    public void truncateFile(long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.removeCachedPages(fileId);
            this.files.get(fileId).shrink(0L);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFile(long fileId, String oldFileName, String newFileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            if (!this.files.containsKey(fileId)) {
                return;
            }
            OFileClassic file = this.files.get(fileId);
            String osFileName = file.getName();
            if (osFileName.startsWith(oldFileName)) {
                File newFile = new File(this.storageLocal.getStoragePath() + File.separator + newFileName + osFileName.substring(osFileName.lastIndexOf(oldFileName) + oldFileName.length()));
                boolean renamed = file.renameTo(newFile);
                while (!renamed) {
                    renamed = file.renameTo(newFile);
                }
            }
            this.nameIdMap.remove(oldFileName);
            this.nameIdMap.put(newFileName, fileId);
            this.writeNameIdEntry(new NameFileIdEntry(oldFileName, -1L), false);
            this.writeNameIdEntry(new NameFileIdEntry(newFileName, fileId), true);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    public void close() throws IOException {
        this.flush();
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new OException("Background data flush task can not be stopped.");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error((Object)this, "Data flush thread was interrupted", new Object[0]);
                Thread.interrupted();
                throw new OException("Data flush thread was interrupted", e);
            }
        }
        this.filesLock.acquireWriteLock();
        try {
            for (OFileClassic oFileClassic : this.files.values()) {
                if (!oFileClassic.isOpen()) continue;
                oFileClassic.close();
            }
            if (this.nameIdMapHolder != null) {
                this.nameIdMapHolder.setLength(0L);
                for (Map.Entry entry : this.nameIdMap.entrySet()) {
                    this.writeNameIdEntry(new NameFileIdEntry((String)entry.getKey(), (Long)entry.getValue()), false);
                }
                this.nameIdMapHolder.getFD().sync();
                this.nameIdMapHolder.close();
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long fileId, boolean flush) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            if (!this.isOpen(fileId)) {
                return;
            }
            if (flush) {
                this.flush(fileId);
            } else {
                this.removeCachedPages(fileId);
            }
            this.files.get(fileId).close();
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        int notificationTimeOut = 5000;
        ArrayList<OPageDataVerificationError> errors = new ArrayList<OPageDataVerificationError>();
        this.filesLock.acquireWriteLock();
        try {
            OPageDataVerificationError[] oPageDataVerificationErrorArray = this.files.keySet().iterator();
            while (oPageDataVerificationErrorArray.hasNext()) {
                boolean fileIsCorrect;
                long fileId = oPageDataVerificationErrorArray.next();
                OFileClassic fileClassic = this.files.get(fileId);
                try {
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Flashing file " + fileClassic.getName() + "... ");
                    }
                    this.flush(fileId);
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Start verification of content of " + fileClassic.getName() + "file ...");
                    }
                    long time = System.currentTimeMillis();
                    long filledUpTo = fileClassic.getFilledUpTo();
                    fileIsCorrect = true;
                    for (long pos = 0L; pos < filledUpTo; pos += (long)this.pageSize) {
                        int calculatedCRC32;
                        int storedCRC32;
                        boolean checkSumIncorrect = false;
                        boolean magicNumberIncorrect = false;
                        byte[] data = new byte[this.pageSize];
                        fileClassic.read(pos, data, data.length);
                        long magicNumber = OLongSerializer.INSTANCE.deserializeNative(data, 0);
                        if (magicNumber != 4207608830L) {
                            magicNumberIncorrect = true;
                            if (commandOutputListener != null) {
                                commandOutputListener.onMessage("Error: Magic number for page " + pos / (long)this.pageSize + " in file " + fileClassic.getName() + " does not much !!!");
                            }
                            fileIsCorrect = false;
                        }
                        if ((storedCRC32 = OIntegerSerializer.INSTANCE.deserializeNative(data, 8)) != (calculatedCRC32 = OWOWCache.calculatePageCrc(data))) {
                            checkSumIncorrect = true;
                            if (commandOutputListener != null) {
                                commandOutputListener.onMessage("Error: Checksum for page " + pos / (long)this.pageSize + " in file " + fileClassic.getName() + " is incorrect !!!");
                            }
                            fileIsCorrect = false;
                        }
                        if (magicNumberIncorrect || checkSumIncorrect) {
                            errors.add(new OPageDataVerificationError(magicNumberIncorrect, checkSumIncorrect, pos / (long)this.pageSize, fileClassic.getName()));
                        }
                        if (commandOutputListener == null || System.currentTimeMillis() - time <= 5000L) continue;
                        time = 5000L;
                        commandOutputListener.onMessage(pos / (long)this.pageSize + " pages were processed ...");
                    }
                }
                catch (IOException ioe) {
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Error: Error during processing of file " + fileClassic.getName() + ". " + ioe.getMessage());
                    }
                    fileIsCorrect = false;
                }
                if (!fileIsCorrect) {
                    if (commandOutputListener == null) continue;
                    commandOutputListener.onMessage("Verification of file " + fileClassic.getName() + " is finished with errors.");
                    continue;
                }
                if (commandOutputListener == null) continue;
                commandOutputListener.onMessage("Verification of file " + fileClassic.getName() + " is successfully finished.");
            }
            oPageDataVerificationErrorArray = errors.toArray(new OPageDataVerificationError[errors.size()]);
            return oPageDataVerificationErrorArray;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            for (long fileId : this.files.keySet()) {
                this.doDeleteFile(fileId);
            }
            if (this.nameIdMapHolderFile != null) {
                if (this.nameIdMapHolderFile.exists()) {
                    this.nameIdMapHolder.close();
                    if (!this.nameIdMapHolderFile.delete()) {
                        throw new OStorageException("Can not delete disk cache file which contains name-id mapping.");
                    }
                }
                this.nameIdMapHolder = null;
                this.nameIdMapHolderFile = null;
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new OException("Background data flush task can not be stopped.");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error((Object)this, "Data flush thread was interrupted", new Object[0]);
                Thread.interrupted();
                throw new OException("Data flush thread was interrupted", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fileNameById(long fileId) {
        this.filesLock.acquireReadLock();
        try {
            String string = this.files.get(fileId).getName();
            return string;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    private void openFile(OFileClassic fileClassic) throws IOException {
        if (fileClassic.exists()) {
            if (!fileClassic.isOpen()) {
                fileClassic.open();
            }
        } else {
            throw new OStorageException("File " + fileClassic + " does not exist.");
        }
    }

    private void addFile(OFileClassic fileClassic) throws IOException {
        if (fileClassic.exists()) {
            throw new OStorageException("File " + fileClassic + " already exists.");
        }
        fileClassic.create(-1);
        fileClassic.synch();
    }

    private void initNameIdMapping() throws IOException {
        if (this.nameIdMapHolder == null) {
            File storagePath = new File(this.storageLocal.getStoragePath());
            if (!storagePath.exists() && !storagePath.mkdirs()) {
                throw new OStorageException("Can not create directories for the path " + storagePath);
            }
            this.nameIdMapHolderFile = new File(storagePath, NAME_ID_MAP);
            this.nameIdMapHolder = new RandomAccessFile(this.nameIdMapHolderFile, "rw");
            this.readNameIdMap();
        }
    }

    private OFileClassic createFile(String fileName) {
        OFileClassic fileClassic = new OFileClassic();
        String path = this.storageLocal.getVariableParser().resolveVariables(this.storageLocal.getStoragePath() + File.separator + fileName);
        fileClassic.init(path, this.storageLocal.getMode());
        return fileClassic;
    }

    private void readNameIdMap() throws IOException {
        NameFileIdEntry nameFileIdEntry;
        this.nameIdMap = new ConcurrentHashMap<String, Long>();
        long localFileCounter = -1L;
        this.nameIdMapHolder.seek(0L);
        while ((nameFileIdEntry = this.readNextNameIdEntry()) != null) {
            if (localFileCounter < nameFileIdEntry.fileId) {
                localFileCounter = nameFileIdEntry.fileId;
            }
            this.nameIdMap.put(nameFileIdEntry.name, nameFileIdEntry.fileId);
        }
        if (localFileCounter > 0L) {
            this.fileCounter = localFileCounter;
        }
        for (Map.Entry<String, Long> nameIdEntry : this.nameIdMap.entrySet()) {
            if (nameIdEntry.getValue() < 0L || this.files.containsKey(nameIdEntry.getValue())) continue;
            OFileClassic fileClassic = this.createFile(nameIdEntry.getKey());
            this.files.put(nameIdEntry.getValue(), fileClassic);
        }
    }

    private NameFileIdEntry readNextNameIdEntry() throws IOException {
        try {
            int nameSize = this.nameIdMapHolder.readInt();
            byte[] serializedName = new byte[nameSize];
            this.nameIdMapHolder.readFully(serializedName);
            String name = this.stringSerializer.deserialize(serializedName, 0);
            long fileId = this.nameIdMapHolder.readLong();
            return new NameFileIdEntry(name, fileId);
        }
        catch (EOFException eof) {
            return null;
        }
    }

    private void writeNameIdEntry(NameFileIdEntry nameFileIdEntry, boolean sync) throws IOException {
        this.nameIdMapHolder.seek(this.nameIdMapHolder.length());
        int nameSize = this.stringSerializer.getObjectSize(nameFileIdEntry.name, new Object[0]);
        byte[] serializedName = new byte[nameSize];
        this.stringSerializer.serialize(nameFileIdEntry.name, serializedName, 0, new Object[0]);
        this.nameIdMapHolder.writeInt(nameSize);
        this.nameIdMapHolder.write(serializedName);
        this.nameIdMapHolder.writeLong(nameFileIdEntry.fileId);
        if (sync) {
            this.nameIdMapHolder.getFD().sync();
        }
    }

    private String doDeleteFile(long fileId) throws IOException {
        if (this.isOpen(fileId)) {
            this.truncateFile(fileId);
        }
        OFileClassic fileClassic = this.files.remove(fileId);
        String name = null;
        if (fileClassic != null) {
            name = fileClassic.getName();
            if (fileClassic.exists()) {
                fileClassic.delete();
            }
        }
        return name;
    }

    private void removeCachedPages(long fileId) {
        Future<Void> future = this.commitExecutor.submit(new RemoveFilePagesTask(fileId));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new OException("File data removal was interrupted", e);
        }
        catch (Exception e) {
            throw new OException("File data removal was abnormally terminated", e);
        }
    }

    private OCachePointer cacheFileContent(long fileId, long pageIndex, boolean addNewPages) throws IOException {
        OCachePointer dataPointer;
        long startPosition = pageIndex * (long)this.pageSize;
        long endPosition = startPosition + (long)this.pageSize;
        byte[] content = new byte[this.pageSize + 16];
        OFileClassic fileClassic = this.files.get(fileId);
        if (fileClassic == null) {
            throw new IllegalArgumentException("File with id " + fileId + " not found in WOW Cache");
        }
        OLogSequenceNumber lastLsn = this.writeAheadLog != null ? this.writeAheadLog.getFlushedLSN() : new OLogSequenceNumber(-1L, -1L);
        if (fileClassic.getFilledUpTo() >= endPosition) {
            fileClassic.read(startPosition, content, content.length - 16, 8);
            ODirectMemoryPointer pointer = new ODirectMemoryPointer(content);
            dataPointer = new OCachePointer(pointer, lastLsn);
        } else if (addNewPages) {
            int space = (int)(endPosition - fileClassic.getFilledUpTo());
            fileClassic.allocateSpace(space);
            this.addAllocatedSpace(space);
            ODirectMemoryPointer pointer = new ODirectMemoryPointer(content);
            dataPointer = new OCachePointer(pointer, lastLsn);
        } else {
            return null;
        }
        return dataPointer;
    }

    private void flushPage(long fileId, long pageIndex, ODirectMemoryPointer dataPointer) throws IOException {
        if (this.writeAheadLog != null) {
            OLogSequenceNumber lsn = ODurablePage.getLogSequenceNumberFromPage(dataPointer);
            OLogSequenceNumber flushedLSN = this.writeAheadLog.getFlushedLSN();
            if (flushedLSN == null || flushedLSN.compareTo(lsn) < 0) {
                this.writeAheadLog.flush();
            }
        }
        byte[] content = dataPointer.get(8L, this.pageSize);
        OLongSerializer.INSTANCE.serializeNative(4207608830L, content, 0, new Object[0]);
        int crc32 = OWOWCache.calculatePageCrc(content);
        OIntegerSerializer.INSTANCE.serializeNative(crc32, content, 8, new Object[0]);
        OFileClassic fileClassic = this.files.get(fileId);
        long spaceDiff = fileClassic.write(pageIndex * (long)this.pageSize, content);
        assert (spaceDiff >= 0L);
        this.addAllocatedSpace(-spaceDiff);
        if (this.syncOnPageFlush) {
            fileClassic.synch();
        }
    }

    private static class LowSpaceEventsPublisherFactory
    implements ThreadFactory {
        private final String storageName;

        private LowSpaceEventsPublisherFactory(String storageName) {
            this.storageName = storageName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("OrientDB Low Disk Space Publisher (" + this.storageName + ")");
            return thread;
        }
    }

    private static class FlushThreadFactory
    implements ThreadFactory {
        private final String storageName;

        private FlushThreadFactory(String storageName) {
            this.storageName = storageName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("OrientDB Write Cache Flush Task (" + this.storageName + ")");
            return thread;
        }
    }

    private final class RemoveFilePagesTask
    implements Callable<Void> {
        private final long fileId;

        private RemoveFilePagesTask(long fileId) {
            this.fileId = fileId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            GroupKey firstKey = new GroupKey(this.fileId, 0L);
            GroupKey lastKey = new GroupKey(this.fileId, Long.MAX_VALUE);
            NavigableMap subMap = OWOWCache.this.writeGroups.subMap(firstKey, true, lastKey, true);
            Iterator entryIterator = subMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                WriteGroup writeGroup = (WriteGroup)entry.getValue();
                GroupKey groupKey = (GroupKey)entry.getKey();
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(groupKey);
                try {
                    for (OCachePointer pagePointer : writeGroup.pages) {
                        if (pagePointer == null) continue;
                        pagePointer.acquireExclusiveLock();
                        try {
                            pagePointer.decrementReferrer();
                            OWOWCache.this.cacheSize.decrementAndGet();
                        }
                        finally {
                            pagePointer.releaseExclusiveLock();
                        }
                    }
                    entryIterator.remove();
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                }
            }
            return null;
        }
    }

    private final class FileFlushTask
    implements Callable<Void> {
        private final long fileId;

        private FileFlushTask(long fileId) {
            this.fileId = fileId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            GroupKey firstKey = new GroupKey(this.fileId, 0L);
            GroupKey lastKey = new GroupKey(this.fileId, Long.MAX_VALUE);
            NavigableMap subMap = OWOWCache.this.writeGroups.subMap(firstKey, true, lastKey, true);
            Iterator entryIterator = subMap.entrySet().iterator();
            block7: while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                WriteGroup writeGroup = (WriteGroup)entry.getValue();
                GroupKey groupKey = (GroupKey)entry.getKey();
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(groupKey);
                try {
                    int flushedPages = 0;
                    for (int i = 0; i < 16; ++i) {
                        OCachePointer pagePointer = writeGroup.pages[i];
                        if (pagePointer == null) continue;
                        if (!pagePointer.tryAcquireSharedLock()) continue block7;
                        try {
                            OWOWCache.this.flushPage(groupKey.fileId, (groupKey.groupIndex << 4) + (long)i, pagePointer.getDataPointer());
                            ++flushedPages;
                            continue;
                        }
                        finally {
                            pagePointer.releaseSharedLock();
                        }
                    }
                    for (OCachePointer pagePointer : writeGroup.pages) {
                        if (pagePointer == null) continue;
                        pagePointer.decrementReferrer();
                    }
                    OWOWCache.this.cacheSize.addAndGet(-flushedPages);
                    entryIterator.remove();
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                }
            }
            ((OFileClassic)OWOWCache.this.files.get(this.fileId)).synch();
            return null;
        }
    }

    private final class PeriodicalFuzzyCheckpointTask
    implements Runnable {
        private PeriodicalFuzzyCheckpointTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OLogSequenceNumber minLsn = OWOWCache.this.writeAheadLog.getFlushedLSN();
            if (minLsn == null) {
                return;
            }
            for (Map.Entry entry : OWOWCache.this.writeGroups.entrySet()) {
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(entry.getKey());
                try {
                    WriteGroup group = (WriteGroup)entry.getValue();
                    for (int i = 0; i < 16; ++i) {
                        OCachePointer pagePointer = group.pages[i];
                        if (pagePointer == null || pagePointer.getLastFlushedLsn() == null || minLsn.compareTo(pagePointer.getLastFlushedLsn()) <= 0) continue;
                        minLsn = pagePointer.getLastFlushedLsn();
                    }
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                }
            }
            OLogManager.instance().debug((Object)this, "Start fuzzy checkpoint flushed LSN is %s", minLsn);
            try {
                OWOWCache.this.writeAheadLog.logFuzzyCheckPointStart(minLsn);
                for (OFileClassic fileClassic : OWOWCache.this.files.values()) {
                    fileClassic.synch();
                }
                OWOWCache.this.writeAheadLog.logFuzzyCheckPointEnd();
                OWOWCache.this.writeAheadLog.flush();
                if (minLsn.compareTo(new OLogSequenceNumber(-1L, -1L)) > 0) {
                    OWOWCache.this.writeAheadLog.cutTill(minLsn);
                }
            }
            catch (IOException ioe) {
                OLogManager.instance().error((Object)this, "Error during fuzzy checkpoint", (Throwable)ioe, new Object[0]);
            }
            OLogManager.instance().debug((Object)this, "End fuzzy checkpoint", new Object[0]);
        }
    }

    private final class PeriodicFlushTask
    implements Runnable {
        private PeriodicFlushTask() {
        }

        @Override
        public void run() {
            block10: {
                try {
                    int writeGroupsToFlush;
                    if (OWOWCache.this.writeGroups.isEmpty()) {
                        return;
                    }
                    boolean useForceSync = false;
                    double threshold = (double)OWOWCache.this.cacheSize.get() / (double)OWOWCache.this.cacheMaxSize;
                    if (threshold > 0.8) {
                        writeGroupsToFlush = (int)(0.2 * (double)OWOWCache.this.writeGroups.size());
                        useForceSync = true;
                    } else if (threshold > 0.9) {
                        writeGroupsToFlush = (int)(0.4 * (double)OWOWCache.this.writeGroups.size());
                        useForceSync = true;
                    } else {
                        writeGroupsToFlush = 1;
                    }
                    if (writeGroupsToFlush < 1) {
                        writeGroupsToFlush = 1;
                    }
                    int flushedGroups = 0;
                    if ((flushedGroups = this.flushRing(writeGroupsToFlush, flushedGroups, false)) < writeGroupsToFlush && useForceSync) {
                        flushedGroups = this.flushRing(writeGroupsToFlush, flushedGroups, true);
                    }
                    if (flushedGroups >= writeGroupsToFlush || OWOWCache.this.cacheSize.get() <= OWOWCache.this.cacheMaxSize) break block10;
                    if (OGlobalConfiguration.SERVER_CACHE_INCREASE_ON_DEMAND.getValueAsBoolean()) {
                        long oldCacheMaxSize = OWOWCache.this.cacheMaxSize;
                        OWOWCache.this.cacheMaxSize = (int)Math.ceil((float)OWOWCache.this.cacheMaxSize * (1.0f + OGlobalConfiguration.SERVER_CACHE_INCREASE_STEP.getValueAsFloat()));
                        OLogManager.instance().warn((Object)this, "Write cache size is increased from %d to %d", oldCacheMaxSize, OWOWCache.this.cacheMaxSize);
                        break block10;
                    }
                    throw new OAllCacheEntriesAreUsedException("All records in write cache are used!");
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Exception during data flush.", (Throwable)e, new Object[0]);
                }
            }
        }

        private int flushRing(int writeGroupsToFlush, int flushedGroups, boolean forceFlush) throws IOException {
            NavigableMap subMap = OWOWCache.this.writeGroups.tailMap(OWOWCache.this.lastGroupKey, false);
            if (!subMap.isEmpty()) {
                flushedGroups = this.iterateBySubRing(subMap, writeGroupsToFlush, 0, forceFlush);
                if (flushedGroups < writeGroupsToFlush && !subMap.isEmpty()) {
                    subMap = OWOWCache.this.writeGroups.headMap(subMap.firstKey(), false);
                    flushedGroups = this.iterateBySubRing(subMap, writeGroupsToFlush, flushedGroups, forceFlush);
                }
            } else {
                flushedGroups = this.iterateBySubRing(OWOWCache.this.writeGroups, writeGroupsToFlush, flushedGroups, forceFlush);
            }
            return flushedGroups;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int iterateBySubRing(NavigableMap<GroupKey, WriteGroup> subMap, int writeGroupsToFlush, int flushedWriteGroups, boolean forceFlush) throws IOException {
            Iterator entriesIterator = subMap.entrySet().iterator();
            long currentTime = System.currentTimeMillis();
            block7: while (entriesIterator.hasNext() && flushedWriteGroups < writeGroupsToFlush) {
                boolean weakLockMode;
                Map.Entry entry = entriesIterator.next();
                WriteGroup group = (WriteGroup)entry.getValue();
                GroupKey groupKey = (GroupKey)entry.getKey();
                boolean bl = weakLockMode = group.creationTime - currentTime < OWOWCache.this.groupTTL && !forceFlush;
                if (group.recencyBit && weakLockMode) {
                    group.recencyBit = false;
                    continue;
                }
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(entry.getKey());
                try {
                    if (group.recencyBit && weakLockMode) {
                        group.recencyBit = false;
                    } else {
                        group.recencyBit = false;
                        int flushedPages = 0;
                        for (int i = 0; i < 16; ++i) {
                            OCachePointer pagePointer = group.pages[i];
                            if (pagePointer == null) continue;
                            if (!pagePointer.tryAcquireSharedLock()) continue block7;
                            try {
                                OWOWCache.this.flushPage(groupKey.fileId, (groupKey.groupIndex << 4) + (long)i, pagePointer.getDataPointer());
                                ++flushedPages;
                                OLogSequenceNumber flushedLSN = ODurablePage.getLogSequenceNumberFromPage(pagePointer.getDataPointer());
                                pagePointer.setLastFlushedLsn(flushedLSN);
                                continue;
                            }
                            finally {
                                pagePointer.releaseSharedLock();
                            }
                        }
                        for (OCachePointer pagePointer : group.pages) {
                            if (pagePointer == null) continue;
                            pagePointer.decrementReferrer();
                        }
                        entriesIterator.remove();
                        ++flushedWriteGroups;
                        OWOWCache.this.cacheSize.addAndGet(-flushedPages);
                    }
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                    continue;
                }
                OWOWCache.this.lastGroupKey = groupKey;
            }
            return flushedWriteGroups;
        }
    }

    private final class GroupKey
    implements Comparable<GroupKey> {
        private final long fileId;
        private final long groupIndex;

        private GroupKey(long fileId, long groupIndex) {
            this.fileId = fileId;
            this.groupIndex = groupIndex;
        }

        @Override
        public int compareTo(GroupKey other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            if (this.groupIndex > other.groupIndex) {
                return 1;
            }
            if (this.groupIndex < other.groupIndex) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupKey groupKey = (GroupKey)o;
            if (this.fileId != groupKey.fileId) {
                return false;
            }
            return this.groupIndex == groupKey.groupIndex;
        }

        public int hashCode() {
            int result = (int)(this.fileId ^ this.fileId >>> 32);
            result = 31 * result + (int)(this.groupIndex ^ this.groupIndex >>> 32);
            return result;
        }

        public String toString() {
            return "GroupKey{fileId=" + this.fileId + ", groupIndex=" + this.groupIndex + '}';
        }
    }

    private static final class NameFileIdEntry {
        private final String name;
        private final long fileId;

        private NameFileIdEntry(String name, long fileId) {
            this.name = name;
            this.fileId = fileId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameFileIdEntry that = (NameFileIdEntry)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (int)(this.fileId ^ this.fileId >>> 32);
            return result;
        }
    }
}

