/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local.cache;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OCachePointer {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final AtomicInteger referrersCount = new AtomicInteger();
    private final AtomicInteger usagesCounter = new AtomicInteger();
    private volatile OLogSequenceNumber lastFlushedLsn;
    private final ODirectMemoryPointer dataPointer;

    public OCachePointer(ODirectMemoryPointer dataPointer, OLogSequenceNumber lastFlushedLsn) {
        this.lastFlushedLsn = lastFlushedLsn;
        this.dataPointer = dataPointer;
    }

    public OCachePointer(byte[] data, OLogSequenceNumber lastFlushedLsn) {
        this.lastFlushedLsn = lastFlushedLsn;
        this.dataPointer = new ODirectMemoryPointer(data);
    }

    OLogSequenceNumber getLastFlushedLsn() {
        return this.lastFlushedLsn;
    }

    void setLastFlushedLsn(OLogSequenceNumber lastFlushedLsn) {
        this.lastFlushedLsn = lastFlushedLsn;
    }

    public void incrementReferrer() {
        this.referrersCount.incrementAndGet();
    }

    public void decrementReferrer() {
        if (this.referrersCount.decrementAndGet() == 0) {
            this.dataPointer.free();
        }
    }

    public ODirectMemoryPointer getDataPointer() {
        return this.dataPointer;
    }

    public void acquireExclusiveLock() {
        this.readWriteLock.writeLock().lock();
    }

    public boolean tryAcquireExclusiveLock() {
        return this.readWriteLock.writeLock().tryLock();
    }

    public void releaseExclusiveLock() {
        this.readWriteLock.writeLock().unlock();
    }

    public void acquireSharedLock() {
        this.readWriteLock.readLock().lock();
    }

    public void releaseSharedLock() {
        this.readWriteLock.readLock().unlock();
    }

    public boolean tryAcquireSharedLock() {
        return this.readWriteLock.readLock().tryLock();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.referrersCount.get() > 0) {
            this.dataPointer.free();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCachePointer that = (OCachePointer)o;
        return !(this.dataPointer != null ? !this.dataPointer.equals(that.dataPointer) : that.dataPointer != null);
    }

    public int hashCode() {
        return this.dataPointer != null ? this.dataPointer.hashCode() : 0;
    }

    public String toString() {
        return "OCachePointer{referrersCount=" + this.referrersCount + ", usagesCount=" + this.usagesCounter + ", dataPointer=" + this.dataPointer + '}';
    }
}

