/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.io.IOException;

public class ONullBucket<V>
extends ODurablePage {
    private final OBinarySerializer<V> valueSerializer;

    public ONullBucket(OCacheEntry cacheEntry, OWALChangesTree changesTree, OBinarySerializer<V> valueSerializer, boolean isNew) {
        super(cacheEntry, changesTree);
        this.valueSerializer = valueSerializer;
        if (isNew) {
            this.setByteValue(28, (byte)0);
        }
    }

    public void setValue(V value) throws IOException {
        this.setByteValue(28, (byte)1);
        int valueSize = this.valueSerializer.getObjectSize(value, new Object[0]);
        byte[] serializedValue = new byte[valueSize];
        this.valueSerializer.serializeNativeObject(value, serializedValue, 0, new Object[0]);
        this.setBinaryValue(29, serializedValue);
    }

    public V getValue() {
        if (this.getByteValue(28) == 0) {
            return null;
        }
        return this.deserializeFromDirectMemory(this.valueSerializer, 29L);
    }

    public void removeValue() {
        this.setByteValue(28, (byte)0);
    }
}

