/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.hashindex.local.OHashFunction;
import com.orientechnologies.orient.core.index.hashindex.local.OHashIndexBucket;
import com.orientechnologies.orient.core.index.hashindex.local.OHashIndexFileLevelMetadataPage;
import com.orientechnologies.orient.core.index.hashindex.local.OHashTableDirectory;
import com.orientechnologies.orient.core.index.hashindex.local.ONullBucket;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;

public class OLocalHashTable<K, V>
extends ODurableComponent {
    private static final double MERGE_THRESHOLD = 0.2;
    private static final long HASH_CODE_MIN_VALUE = 0L;
    private static final long HASH_CODE_MAX_VALUE = -1L;
    private final String metadataConfigurationFileExtension;
    private final String treeStateFileExtension;
    public static final int HASH_CODE_SIZE = 64;
    public static final int MAX_LEVEL_DEPTH = 8;
    public static final int MAX_LEVEL_SIZE = 256;
    public static final int LEVEL_MASK = 255;
    private final ODiskCache diskCache;
    private final OHashFunction<K> keyHashFunction;
    private OBinarySerializer<K> keySerializer;
    private OBinarySerializer<V> valueSerializer;
    private OType[] keyTypes;
    private final boolean durableInNonTxMode;
    private final KeyHashCodeComparator<K> comparator;
    private boolean nullKeyIsSupported;
    private long nullBucketFileId = -1L;
    private final String nullBucketFileExtension;
    private long fileStateId;
    private long hashStateEntryIndex;
    private OHashTableDirectory directory;

    public OLocalHashTable(String name, String metadataConfigurationFileExtension, String treeStateFileExtension, String bucketFileExtension, String nullBucketFileExtension, OHashFunction<K> keyHashFunction, boolean durableInNonTxMode, OAbstractPaginatedStorage abstractPaginatedStorage) {
        super(abstractPaginatedStorage, name, bucketFileExtension);
        this.metadataConfigurationFileExtension = metadataConfigurationFileExtension;
        this.treeStateFileExtension = treeStateFileExtension;
        this.keyHashFunction = keyHashFunction;
        this.nullBucketFileExtension = nullBucketFileExtension;
        this.durableInNonTxMode = durableInNonTxMode;
        this.comparator = new KeyHashCodeComparator<K>(this.keyHashFunction);
        this.diskCache = abstractPaginatedStorage.getDiskCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, boolean nullKeyIsSupported) {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during hash table creation.", e);
        }
        this.acquireExclusiveLock();
        try {
            try {
                this.keyTypes = keyTypes;
                this.nullKeyIsSupported = nullKeyIsSupported;
                this.directory = new OHashTableDirectory(this.treeStateFileExtension, this.getName(), this.durableInNonTxMode, this.storage);
                this.fileStateId = OLocalHashTable.addFile(atomicOperation, this.getName() + this.metadataConfigurationFileExtension, this.diskCache);
                this.directory.create();
                OCacheEntry hashStateEntry = OLocalHashTable.addPage(atomicOperation, this.fileStateId, this.diskCache);
                OLocalHashTable.pinPage(atomicOperation, hashStateEntry, this.diskCache);
                hashStateEntry.acquireExclusiveLock();
                try {
                    OHashIndexFileLevelMetadataPage page = new OHashIndexFileLevelMetadataPage(hashStateEntry, OLocalHashTable.getChangesTree(atomicOperation, hashStateEntry), true);
                    this.createFileMetadata(0, page, atomicOperation);
                    this.hashStateEntryIndex = hashStateEntry.getPageIndex();
                }
                finally {
                    hashStateEntry.releaseExclusiveLock();
                    OLocalHashTable.releasePage(atomicOperation, hashStateEntry, this.diskCache);
                }
                this.setKeySerializer(keySerializer);
                this.setValueSerializer(valueSerializer);
                this.initHashTreeState(atomicOperation);
                if (nullKeyIsSupported) {
                    this.nullBucketFileId = OLocalHashTable.addFile(atomicOperation, this.getName() + this.nullBucketFileExtension, this.diskCache);
                }
                this.endAtomicOperation(false);
            }
            catch (IOException e) {
                this.endAtomicOperation(true);
                throw e;
            }
            catch (Throwable e) {
                this.endAtomicOperation(true);
                throw new OStorageException(null, e);
            }
        }
        catch (IOException e) {
            throw new OIndexException("Error during local hash table creation.", e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    protected void endAtomicOperation(boolean rollback) throws IOException {
        if (this.storage.getStorageTransaction() == null && !this.durableInNonTxMode) {
            return;
        }
        super.endAtomicOperation(rollback);
    }

    @Override
    protected OAtomicOperation startAtomicOperation() throws IOException {
        if (this.storage.getStorageTransaction() == null && !this.durableInNonTxMode) {
            return this.atomicOperationsManager.getCurrentOperation();
        }
        return super.startAtomicOperation();
    }

    public OBinarySerializer<K> getKeySerializer() {
        this.acquireSharedLock();
        try {
            OBinarySerializer<K> oBinarySerializer = this.keySerializer;
            return oBinarySerializer;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeySerializer(OBinarySerializer<K> keySerializer) {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during hash set serializer for index keys.", e);
        }
        this.acquireExclusiveLock();
        try {
            this.keySerializer = keySerializer;
            OCacheEntry hashStateEntry = OLocalHashTable.loadPage(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true, this.diskCache);
            hashStateEntry.acquireExclusiveLock();
            try {
                OHashIndexFileLevelMetadataPage metadataPage = new OHashIndexFileLevelMetadataPage(hashStateEntry, OLocalHashTable.getChangesTree(atomicOperation, hashStateEntry), false);
                metadataPage.setKeySerializerId(keySerializer.getId());
            }
            finally {
                hashStateEntry.releaseExclusiveLock();
                OLocalHashTable.releasePage(atomicOperation, hashStateEntry, this.diskCache);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.rollback();
            throw new OIndexException("Can not set serializer for index keys", e);
        }
        catch (Throwable e) {
            this.rollback();
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void rollback() {
        try {
            this.endAtomicOperation(true);
        }
        catch (IOException ioe) {
            throw new OIndexException("Error during operation roolback", ioe);
        }
    }

    public OBinarySerializer<V> getValueSerializer() {
        this.acquireSharedLock();
        try {
            OBinarySerializer<V> oBinarySerializer = this.valueSerializer;
            return oBinarySerializer;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueSerializer(OBinarySerializer<V> valueSerializer) {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during hash table set serializer for index values", e);
        }
        this.acquireExclusiveLock();
        try {
            this.valueSerializer = valueSerializer;
            OCacheEntry hashStateEntry = OLocalHashTable.loadPage(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true, this.diskCache);
            hashStateEntry.acquireExclusiveLock();
            try {
                OHashIndexFileLevelMetadataPage metadataPage = new OHashIndexFileLevelMetadataPage(hashStateEntry, OLocalHashTable.getChangesTree(atomicOperation, hashStateEntry), false);
                metadataPage.setValueSerializerId(valueSerializer.getId());
            }
            finally {
                hashStateEntry.releaseExclusiveLock();
                OLocalHashTable.releasePage(atomicOperation, hashStateEntry, this.diskCache);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.rollback();
            throw new OIndexException("Can not set serializer for index values", e);
        }
        catch (Throwable e) {
            this.rollback();
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void createFileMetadata(int fileLevel, OHashIndexFileLevelMetadataPage page, OAtomicOperation atomicOperation) throws IOException {
        String fileName = this.getName() + fileLevel + this.getExtension();
        long fileId = OLocalHashTable.addFile(atomicOperation, fileName, this.diskCache);
        page.setFileMetadata(fileLevel, fileId, 0L, -1L);
    }

    /*
     * Exception decompiling
     */
    public V get(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 25[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void put(K key, V value) {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during hash table entry put", e);
        }
        this.acquireExclusiveLock();
        try {
            this.checkNullSupport(key);
            key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
            this.doPut(key, value, atomicOperation);
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.rollback();
            throw new OIndexException("Error during index update", e);
        }
        catch (Throwable e) {
            this.rollback();
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V remove(K key) {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during hash table entry deletion.", e);
        }
        this.acquireExclusiveLock();
        try {
            this.checkNullSupport(key);
            int sizeDiff = 0;
            if (key != null) {
                Object removed;
                key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
                long hashCode = this.keyHashFunction.hashCode(key);
                BucketPath nodePath = this.getBucket(hashCode);
                long bucketPointer = this.directory.getNodePointer(nodePath.nodeIndex, nodePath.itemIndex + nodePath.hashMapOffset);
                long pageIndex = this.getPageIndex(bucketPointer);
                int fileLevel = this.getFileLevel(bucketPointer);
                OCacheEntry cacheEntry = this.loadPageEntry(pageIndex, fileLevel, atomicOperation);
                cacheEntry.acquireExclusiveLock();
                try {
                    OHashIndexBucket<K, V> bucket = new OHashIndexBucket<K, V>(cacheEntry, this.keySerializer, this.valueSerializer, this.keyTypes, OLocalHashTable.getChangesTree(atomicOperation, cacheEntry));
                    int positionIndex = bucket.getIndex(hashCode, key);
                    if (positionIndex < 0) {
                        this.endAtomicOperation(false);
                        V v = null;
                        return v;
                    }
                    removed = bucket.deleteEntry((int)positionIndex).value;
                    --sizeDiff;
                    this.mergeBucketsAfterDeletion(nodePath, bucket, atomicOperation);
                }
                finally {
                    cacheEntry.releaseExclusiveLock();
                    OLocalHashTable.releasePage(atomicOperation, cacheEntry, this.diskCache);
                }
                if (nodePath.parent != null) {
                    int hashMapSize = 1 << nodePath.nodeLocalDepth;
                    boolean allMapsContainSameBucket = this.checkAllMapsContainSameBucket(this.directory.getNode(nodePath.nodeIndex), hashMapSize);
                    if (allMapsContainSameBucket) {
                        this.mergeNodeToParent(nodePath);
                    }
                }
                this.changeSize(sizeDiff, atomicOperation);
                this.endAtomicOperation(false);
                Object v = removed;
                return v;
            }
            if (OLocalHashTable.getFilledUpTo(atomicOperation, this.diskCache, this.nullBucketFileId) == 0L) {
                this.endAtomicOperation(false);
                V hashCode = null;
                return hashCode;
            }
            V removed = null;
            OCacheEntry cacheEntry = OLocalHashTable.loadPage(atomicOperation, this.nullBucketFileId, 0L, false, this.diskCache);
            if (cacheEntry == null) {
                cacheEntry = OLocalHashTable.addPage(atomicOperation, this.nullBucketFileId, this.diskCache);
            }
            cacheEntry.acquireExclusiveLock();
            try {
                ONullBucket<V> nullBucket = new ONullBucket<V>(cacheEntry, OLocalHashTable.getChangesTree(atomicOperation, cacheEntry), this.valueSerializer, false);
                removed = nullBucket.getValue();
                if (removed != null) {
                    nullBucket.removeValue();
                    --sizeDiff;
                }
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                OLocalHashTable.releasePage(atomicOperation, cacheEntry, this.diskCache);
            }
            this.changeSize(sizeDiff, atomicOperation);
            this.endAtomicOperation(false);
            V v = removed;
            return v;
        }
        catch (IOException e) {
            this.rollback();
            throw new OIndexException("Error during index removal", e);
        }
        catch (Throwable e) {
            this.rollback();
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeSize(int sizeDiff, OAtomicOperation atomicOperation) throws IOException {
        if (sizeDiff != 0) {
            OCacheEntry hashStateEntry = OLocalHashTable.loadPage(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true, this.diskCache);
            hashStateEntry.acquireExclusiveLock();
            try {
                OHashIndexFileLevelMetadataPage page = new OHashIndexFileLevelMetadataPage(hashStateEntry, OLocalHashTable.getChangesTree(atomicOperation, hashStateEntry), false);
                page.setRecordsCount(page.getRecordsCount() + (long)sizeDiff);
            }
            finally {
                hashStateEntry.releaseExclusiveLock();
                OLocalHashTable.releasePage(atomicOperation, hashStateEntry, this.diskCache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during hash table clear", e);
        }
        this.acquireExclusiveLock();
        try {
            OCacheEntry hashStateEntry = OLocalHashTable.loadPage(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true, this.diskCache);
            hashStateEntry.acquireExclusiveLock();
            try {
                OHashIndexFileLevelMetadataPage page = new OHashIndexFileLevelMetadataPage(hashStateEntry, OLocalHashTable.getChangesTree(atomicOperation, hashStateEntry), false);
                for (int i = 0; i < 64; ++i) {
                    if (page.isRemoved(i)) continue;
                    OLocalHashTable.truncateFile(atomicOperation, page.getFileId(i), this.diskCache);
                    page.setBucketsCount(i, 0L);
                    page.setTombstoneIndex(i, -1L);
                }
            }
            finally {
                hashStateEntry.releaseExclusiveLock();
                OLocalHashTable.releasePage(atomicOperation, hashStateEntry, this.diskCache);
            }
            if (this.nullKeyIsSupported) {
                OLocalHashTable.truncateFile(atomicOperation, this.nullBucketFileId, this.diskCache);
            }
            this.initHashTreeState(atomicOperation);
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.rollback();
            throw new OIndexException("Error during hash table clear", e);
        }
        catch (Throwable e) {
            this.rollback();
            throw new OSBTreeException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public OHashIndexBucket.Entry<K, V>[] higherEntries(K key) {
        return this.higherEntries(key, -1);
    }

    /*
     * Exception decompiling
     */
    public OHashIndexBucket.Entry<K, V>[] higherEntries(K key, int limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String name, OType[] keyTypes, boolean nullKeyIsSupported) {
        this.acquireExclusiveLock();
        try {
            this.keyTypes = keyTypes;
            this.nullKeyIsSupported = nullKeyIsSupported;
            OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
            this.fileStateId = OLocalHashTable.openFile(atomicOperation, name + this.metadataConfigurationFileExtension, this.diskCache);
            OCacheEntry hashStateEntry = OLocalHashTable.loadPage(atomicOperation, this.fileStateId, 0L, true, this.diskCache);
            this.hashStateEntryIndex = hashStateEntry.getPageIndex();
            this.directory = new OHashTableDirectory(this.treeStateFileExtension, name, this.durableInNonTxMode, this.storage);
            this.directory.open();
            OLocalHashTable.pinPage(atomicOperation, hashStateEntry, this.diskCache);
            try {
                OHashIndexFileLevelMetadataPage page = new OHashIndexFileLevelMetadataPage(hashStateEntry, OLocalHashTable.getChangesTree(atomicOperation, hashStateEntry), false);
                this.keySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(page.getKeySerializerId());
                this.valueSerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(page.getValueSerializerId());
                for (int i = 0; i < 64; ++i) {
                    if (page.isRemoved(i)) continue;
                    OLocalHashTable.openFile(atomicOperation, page.getFileId(i), this.diskCache);
                }
            }
            finally {
                OLocalHashTable.releasePage(atomicOperation, hashStateEntry, this.diskCache);
            }
            if (nullKeyIsSupported) {
                this.nullBucketFileId = OLocalHashTable.openFile(atomicOperation, name + this.nullBucketFileExtension, this.diskCache);
            }
        }
        catch (IOException e) {
            throw new OIndexException("Exception during hash table loading", e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWithoutLoad(String name, OAbstractPaginatedStorage storageLocal) {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during hash table deletion.", e);
        }
        this.acquireExclusiveLock();
        try {
            ODiskCache diskCache = this.storage.getDiskCache();
            if (OLocalHashTable.isFileExists(atomicOperation, name + this.metadataConfigurationFileExtension, diskCache)) {
                this.fileStateId = OLocalHashTable.openFile(atomicOperation, name + this.metadataConfigurationFileExtension, diskCache);
                OCacheEntry hashStateEntry = OLocalHashTable.loadPage(atomicOperation, this.fileStateId, 0L, true, diskCache);
                try {
                    OHashIndexFileLevelMetadataPage metadataPage = new OHashIndexFileLevelMetadataPage(hashStateEntry, OLocalHashTable.getChangesTree(atomicOperation, hashStateEntry), false);
                    for (int i = 0; i < 64; ++i) {
                        if (metadataPage.isRemoved(i)) continue;
                        long fileId = metadataPage.getFileId(i);
                        OLocalHashTable.openFile(atomicOperation, fileId, diskCache);
                        OLocalHashTable.deleteFile(atomicOperation, fileId, diskCache);
                    }
                }
                finally {
                    OLocalHashTable.releasePage(atomicOperation, hashStateEntry, diskCache);
                }
                if (OLocalHashTable.isFileExists(atomicOperation, this.fileStateId, diskCache)) {
                    OLocalHashTable.deleteFile(atomicOperation, this.fileStateId, diskCache);
                }
                this.directory = new OHashTableDirectory(this.treeStateFileExtension, name, this.durableInNonTxMode, this.storage);
                this.directory.deleteWithoutOpen();
                if (OLocalHashTable.isFileExists(atomicOperation, name + this.nullBucketFileExtension, diskCache)) {
                    long nullBucketId = OLocalHashTable.openFile(atomicOperation, name + this.nullBucketFileExtension, diskCache);
                    OLocalHashTable.deleteFile(atomicOperation, nullBucketId, diskCache);
                }
            }
            this.endAtomicOperation(false);
        }
        catch (IOException ioe) {
            this.rollback();
            throw new OIndexException("Can not delete hash table with name " + name, ioe);
        }
        catch (Exception e) {
            this.rollback();
            throw new OIndexException("Can not delete hash table with name " + name, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private OHashIndexBucket.Entry<K, V>[] convertBucketToEntries(OHashIndexBucket<K, V> bucket, int startIndex, int endIndex) {
        OHashIndexBucket.Entry[] entries = new OHashIndexBucket.Entry[endIndex - startIndex];
        Iterator<OHashIndexBucket.Entry<K, V>> iterator = bucket.iterator(startIndex);
        int i = 0;
        for (int k = startIndex; k < endIndex; ++k) {
            entries[i] = iterator.next();
            ++i;
        }
        return entries;
    }

    private BucketPath nextBucketToFind(BucketPath bucketPath, int bucketDepth) throws IOException {
        BucketPath bucketPathToFind;
        int offset = bucketPath.nodeGlobalDepth - bucketDepth;
        BucketPath currentNode = bucketPath;
        int nodeLocalDepth = this.directory.getNodeLocalDepth(bucketPath.nodeIndex);
        assert (this.directory.getNodeLocalDepth(bucketPath.nodeIndex) == bucketPath.nodeLocalDepth);
        while (offset > 0) {
            if ((offset -= nodeLocalDepth) <= 0) continue;
            currentNode = bucketPath.parent;
            nodeLocalDepth = currentNode.nodeLocalDepth;
            assert (this.directory.getNodeLocalDepth(currentNode.nodeIndex) == currentNode.nodeLocalDepth);
        }
        int diff = bucketDepth - (currentNode.nodeGlobalDepth - nodeLocalDepth);
        int interval = 1 << nodeLocalDepth - diff;
        int firstStartIndex = currentNode.itemIndex & (255 << nodeLocalDepth - diff & 0xFF);
        int globalIndex = firstStartIndex + interval + currentNode.hashMapOffset;
        if (globalIndex >= 256) {
            bucketPathToFind = this.nextLevelUp(currentNode);
        } else {
            int hashMapSize = 1 << currentNode.nodeLocalDepth;
            int hashMapOffset = globalIndex / hashMapSize * hashMapSize;
            int startIndex = globalIndex - hashMapOffset;
            bucketPathToFind = new BucketPath(currentNode.parent, hashMapOffset, startIndex, currentNode.nodeIndex, currentNode.nodeLocalDepth, currentNode.nodeGlobalDepth);
        }
        return this.nextNonEmptyNode(bucketPathToFind);
    }

    private BucketPath nextNonEmptyNode(BucketPath bucketPath) throws IOException {
        block0: while (bucketPath != null) {
            long[] node = this.directory.getNode(bucketPath.nodeIndex);
            int startIndex = bucketPath.itemIndex + bucketPath.hashMapOffset;
            int endIndex = 256;
            for (int i = startIndex; i < 256; ++i) {
                long position = node[i];
                if (position > 0L) {
                    int hashMapSize = 1 << bucketPath.nodeLocalDepth;
                    int hashMapOffset = i / hashMapSize * hashMapSize;
                    int itemIndex = i - hashMapOffset;
                    return new BucketPath(bucketPath.parent, hashMapOffset, itemIndex, bucketPath.nodeIndex, bucketPath.nodeLocalDepth, bucketPath.nodeGlobalDepth);
                }
                if (position >= 0L) continue;
                int childNodeIndex = (int)((position & Long.MAX_VALUE) >> 8);
                int childItemOffset = (int)position & 0xFF;
                BucketPath parent = new BucketPath(bucketPath.parent, 0, i, bucketPath.nodeIndex, bucketPath.nodeLocalDepth, bucketPath.nodeGlobalDepth);
                byte childLocalDepth = this.directory.getNodeLocalDepth(childNodeIndex);
                bucketPath = new BucketPath(parent, childItemOffset, 0, childNodeIndex, childLocalDepth, bucketPath.nodeGlobalDepth + childLocalDepth);
                continue block0;
            }
            bucketPath = this.nextLevelUp(bucketPath);
        }
        return null;
    }

    private BucketPath nextLevelUp(BucketPath bucketPath) throws IOException {
        if (bucketPath.parent == null) {
            return null;
        }
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        assert (this.directory.getNodeLocalDepth(bucketPath.nodeIndex) == bucketPath.nodeLocalDepth);
        int pointersSize = 1 << 8 - nodeLocalDepth;
        BucketPath parent = bucketPath.parent;
        if (parent.itemIndex < 128) {
            int nextParentIndex = (parent.itemIndex / pointersSize + 1) * pointersSize;
            return new BucketPath(parent.parent, 0, nextParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        int nextParentIndex = ((parent.itemIndex - 128) / pointersSize + 1) * pointersSize + 128;
        if (nextParentIndex < 256) {
            return new BucketPath(parent.parent, 0, nextParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        return this.nextLevelUp(new BucketPath(parent.parent, 0, 255, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth));
    }

    /*
     * Exception decompiling
     */
    public OHashIndexBucket.Entry<K, V>[] ceilingEntries(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public OHashIndexBucket.Entry<K, V> firstEntry() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public OHashIndexBucket.Entry<K, V> lastEntry() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public OHashIndexBucket.Entry<K, V>[] lowerEntries(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public OHashIndexBucket.Entry<K, V>[] floorEntries(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BucketPath prevBucketToFind(BucketPath bucketPath, int bucketDepth) throws IOException {
        BucketPath bucketPathToFind;
        int offset = bucketPath.nodeGlobalDepth - bucketDepth;
        BucketPath currentBucket = bucketPath;
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        while (offset > 0) {
            if ((offset -= nodeLocalDepth) <= 0) continue;
            currentBucket = bucketPath.parent;
            nodeLocalDepth = currentBucket.nodeLocalDepth;
        }
        int diff = bucketDepth - (currentBucket.nodeGlobalDepth - nodeLocalDepth);
        int firstStartIndex = currentBucket.itemIndex & (255 << nodeLocalDepth - diff & 0xFF);
        int globalIndex = firstStartIndex + currentBucket.hashMapOffset - 1;
        if (globalIndex < 0) {
            bucketPathToFind = this.prevLevelUp(bucketPath);
        } else {
            int hashMapSize = 1 << currentBucket.nodeLocalDepth;
            int hashMapOffset = globalIndex / hashMapSize * hashMapSize;
            int startIndex = globalIndex - hashMapOffset;
            bucketPathToFind = new BucketPath(currentBucket.parent, hashMapOffset, startIndex, currentBucket.nodeIndex, currentBucket.nodeLocalDepth, currentBucket.nodeGlobalDepth);
        }
        return this.prevNonEmptyNode(bucketPathToFind);
    }

    private BucketPath prevNonEmptyNode(BucketPath nodePath) throws IOException {
        block0: while (nodePath != null) {
            int endIndex;
            long[] node = this.directory.getNode(nodePath.nodeIndex);
            boolean startIndex = false;
            for (int i = endIndex = nodePath.itemIndex + nodePath.hashMapOffset; i >= 0; --i) {
                long position = node[i];
                if (position > 0L) {
                    int hashMapSize = 1 << nodePath.nodeLocalDepth;
                    int hashMapOffset = i / hashMapSize * hashMapSize;
                    int itemIndex = i - hashMapOffset;
                    return new BucketPath(nodePath.parent, hashMapOffset, itemIndex, nodePath.nodeIndex, nodePath.nodeLocalDepth, nodePath.nodeGlobalDepth);
                }
                if (position >= 0L) continue;
                int childNodeIndex = (int)((position & Long.MAX_VALUE) >> 8);
                int childItemOffset = (int)position & 0xFF;
                byte nodeLocalDepth = this.directory.getNodeLocalDepth(childNodeIndex);
                int endChildIndex = (1 << nodeLocalDepth) - 1;
                BucketPath parent = new BucketPath(nodePath.parent, 0, i, nodePath.nodeIndex, nodePath.nodeLocalDepth, nodePath.nodeGlobalDepth);
                nodePath = new BucketPath(parent, childItemOffset, endChildIndex, childNodeIndex, nodeLocalDepth, parent.nodeGlobalDepth + nodeLocalDepth);
                continue block0;
            }
            nodePath = this.prevLevelUp(nodePath);
        }
        return null;
    }

    private BucketPath prevLevelUp(BucketPath bucketPath) {
        if (bucketPath.parent == null) {
            return null;
        }
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        int pointersSize = 1 << 8 - nodeLocalDepth;
        BucketPath parent = bucketPath.parent;
        if (parent.itemIndex > 128) {
            int prevParentIndex = (parent.itemIndex - 128) / pointersSize * pointersSize + 128 - 1;
            return new BucketPath(parent.parent, 0, prevParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        int prevParentIndex = parent.itemIndex / pointersSize * pointersSize - 1;
        if (prevParentIndex >= 0) {
            return new BucketPath(parent.parent, 0, prevParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        return this.prevLevelUp(new BucketPath(parent.parent, 0, 0, parent.nodeIndex, parent.nodeLocalDepth, -1));
    }

    /*
     * Exception decompiling
     */
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.acquireExclusiveLock();
        try {
            this.flush();
            OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
            this.directory.close();
            OCacheEntry hashStateEntry = OLocalHashTable.loadPage(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true, this.diskCache);
            try {
                for (int i = 0; i < 64; ++i) {
                    OHashIndexFileLevelMetadataPage metadataPage = new OHashIndexFileLevelMetadataPage(hashStateEntry, OLocalHashTable.getChangesTree(atomicOperation, hashStateEntry), false);
                    if (metadataPage.isRemoved(i)) continue;
                    this.diskCache.closeFile(metadataPage.getFileId(i));
                }
            }
            finally {
                OLocalHashTable.releasePage(atomicOperation, hashStateEntry, this.diskCache);
            }
            this.diskCache.closeFile(this.fileStateId);
        }
        catch (IOException e) {
            throw new OIndexException("Error during hash table close", e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during hash table deletion.", e);
        }
        this.acquireExclusiveLock();
        try {
            OCacheEntry hashStateEntry = OLocalHashTable.loadPage(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true, this.diskCache);
            try {
                for (int i = 0; i < 64; ++i) {
                    OHashIndexFileLevelMetadataPage metadataPage = new OHashIndexFileLevelMetadataPage(hashStateEntry, OLocalHashTable.getChangesTree(atomicOperation, hashStateEntry), false);
                    if (metadataPage.isRemoved(i)) continue;
                    OLocalHashTable.deleteFile(atomicOperation, metadataPage.getFileId(i), this.diskCache);
                }
            }
            finally {
                OLocalHashTable.releasePage(atomicOperation, hashStateEntry, this.diskCache);
            }
            this.directory.delete();
            OLocalHashTable.deleteFile(atomicOperation, this.fileStateId, this.diskCache);
            if (this.nullKeyIsSupported) {
                OLocalHashTable.deleteFile(atomicOperation, this.nullBucketFileId, this.diskCache);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.rollback();
            throw new OIndexException("Exception during index deletion", e);
        }
        catch (Exception e) {
            this.rollback();
            throw new OIndexException("Exception during index deletion", e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void mergeNodeToParent(BucketPath nodePath) throws IOException {
        byte maxChildDepth;
        int startIndex = this.findParentNodeStartIndex(nodePath);
        int localNodeDepth = nodePath.nodeLocalDepth;
        int hashMapSize = 1 << localNodeDepth;
        int parentIndex = nodePath.parent.nodeIndex;
        int i = 0;
        int k = startIndex;
        while (i < 256) {
            this.directory.setNodePointer(parentIndex, k, this.directory.getNodePointer(nodePath.nodeIndex, i));
            i += hashMapSize;
            ++k;
        }
        this.directory.deleteNode(nodePath.nodeIndex);
        if (nodePath.parent.itemIndex < 128) {
            maxChildDepth = this.directory.getMaxLeftChildDepth(parentIndex);
            if (maxChildDepth == localNodeDepth) {
                this.directory.setMaxLeftChildDepth(parentIndex, (byte)this.getMaxLevelDepth(parentIndex, 0, 128));
            }
        } else {
            maxChildDepth = this.directory.getMaxRightChildDepth(parentIndex);
            if (maxChildDepth == localNodeDepth) {
                this.directory.setMaxRightChildDepth(parentIndex, (byte)this.getMaxLevelDepth(parentIndex, 128, 256));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeBucketsAfterDeletion(BucketPath nodePath, OHashIndexBucket<K, V> bucket, OAtomicOperation atomicOperation) throws IOException {
        long buddyIndex;
        int buddyLevel;
        int itemOffset;
        int nodeIndex;
        long buddyPointer;
        int firstEndIndex;
        int bucketDepth = bucket.getDepth();
        if ((double)bucket.getContentSize() > (double)OHashIndexBucket.MAX_BUCKET_SIZE_BYTES * 0.2) {
            return;
        }
        if (bucketDepth - 8 < 1) {
            return;
        }
        int offset = nodePath.nodeGlobalDepth - (bucketDepth - 1);
        BucketPath currentNode = nodePath;
        int nodeLocalDepth = nodePath.nodeLocalDepth;
        while (offset > 0) {
            if ((offset -= nodeLocalDepth) <= 0) continue;
            currentNode = nodePath.parent;
            nodeLocalDepth = currentNode.nodeLocalDepth;
        }
        int diff = bucketDepth - 1 - (currentNode.nodeGlobalDepth - nodeLocalDepth);
        int interval = 1 << nodeLocalDepth - diff - 1;
        int firstStartIndex = currentNode.itemIndex & (255 << nodeLocalDepth - diff & 0xFF);
        int secondStartIndex = firstEndIndex = firstStartIndex + interval;
        int secondEndIndex = secondStartIndex + interval;
        if ((currentNode.itemIndex >>> nodeLocalDepth - diff - 1 & 1) == 1) {
            buddyPointer = this.directory.getNodePointer(currentNode.nodeIndex, firstStartIndex + currentNode.hashMapOffset);
            while (buddyPointer < 0L) {
                nodeIndex = (int)((buddyPointer & Long.MAX_VALUE) >> 8);
                itemOffset = (int)buddyPointer & 0xFF;
                buddyPointer = this.directory.getNodePointer(nodeIndex, itemOffset);
            }
            assert (buddyPointer > 0L);
            buddyLevel = this.getFileLevel(buddyPointer);
            buddyIndex = this.getPageIndex(buddyPointer);
        } else {
            buddyPointer = this.directory.getNodePointer(currentNode.nodeIndex, secondStartIndex + currentNode.hashMapOffset);
            while (buddyPointer < 0L) {
                nodeIndex = (int)((buddyPointer & Long.MAX_VALUE) >> 8);
                itemOffset = (int)buddyPointer & 0xFF;
                buddyPointer = this.directory.getNodePointer(nodeIndex, itemOffset);
            }
            assert (buddyPointer > 0L);
            buddyLevel = this.getFileLevel(buddyPointer);
            buddyIndex = this.getPageIndex(buddyPointer);
        }
        OCacheEntry buddyCacheEntry = this.loadPageEntry(buddyIndex, buddyLevel, atomicOperation);
        buddyCacheEntry.acquireExclusiveLock();
        try {
            OCacheEntry hashStateEntry = OLocalHashTable.loadPage(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true, this.diskCache);
            hashStateEntry.acquireExclusiveLock();
            try {
                OHashIndexBucket<K, V> buddyBucket = new OHashIndexBucket<K, V>(buddyCacheEntry, this.keySerializer, this.valueSerializer, this.keyTypes, OLocalHashTable.getChangesTree(atomicOperation, buddyCacheEntry));
                if (buddyBucket.getDepth() != bucketDepth) {
                    return;
                }
                if (bucket.mergedSize(buddyBucket) >= OHashIndexBucket.MAX_BUCKET_SIZE_BYTES) {
                    return;
                }
                OHashIndexFileLevelMetadataPage metadataPage = new OHashIndexFileLevelMetadataPage(hashStateEntry, OLocalHashTable.getChangesTree(atomicOperation, hashStateEntry), false);
                metadataPage.setBucketsCount(buddyLevel, metadataPage.getBucketsCount(buddyLevel) - 2L);
                int newBuddyLevel = buddyLevel - 1;
                long newBuddyIndex = buddyBucket.getSplitHistory(newBuddyLevel);
                metadataPage.setBucketsCount(buddyLevel, metadataPage.getBucketsCount(buddyLevel) + 1L);
                OCacheEntry newBuddyCacheEntry = this.loadPageEntry(newBuddyIndex, newBuddyLevel, atomicOperation);
                newBuddyCacheEntry.acquireExclusiveLock();
                try {
                    OHashIndexBucket newBuddyBucket = new OHashIndexBucket(bucketDepth - 1, newBuddyCacheEntry, this.keySerializer, this.valueSerializer, this.keyTypes, OLocalHashTable.getChangesTree(atomicOperation, newBuddyCacheEntry));
                    for (OHashIndexBucket.Entry<K, V> entry : buddyBucket) {
                        newBuddyBucket.appendEntry(entry.hashCode, entry.key, entry.value);
                    }
                    for (OHashIndexBucket.Entry<K, V> entry : bucket) {
                        newBuddyBucket.addEntry(entry.hashCode, entry.key, entry.value);
                    }
                }
                finally {
                    newBuddyCacheEntry.releaseExclusiveLock();
                    OLocalHashTable.releasePage(atomicOperation, newBuddyCacheEntry, this.diskCache);
                }
                long bucketPointer = this.directory.getNodePointer(nodePath.nodeIndex, nodePath.itemIndex + nodePath.hashMapOffset);
                long bucketIndex = this.getPageIndex(bucketPointer);
                long newBuddyPointer = this.createBucketPointer(buddyIndex, buddyLevel);
                for (int i = firstStartIndex; i < secondEndIndex; ++i) {
                    this.updateBucket(currentNode.nodeIndex, i, currentNode.hashMapOffset, newBuddyPointer);
                }
                if (metadataPage.getBucketsCount(buddyLevel) > 0L) {
                    long newTombstoneIndex;
                    if (bucketIndex < buddyIndex) {
                        bucket.setNextRemovedBucketPair(metadataPage.getTombstoneIndex(buddyLevel));
                        newTombstoneIndex = bucketIndex;
                    } else {
                        buddyBucket.setNextRemovedBucketPair(metadataPage.getTombstoneIndex(buddyLevel));
                        newTombstoneIndex = buddyIndex;
                    }
                    metadataPage.setTombstoneIndex(buddyLevel, newTombstoneIndex);
                } else {
                    metadataPage.setTombstoneIndex(buddyLevel, -1L);
                }
            }
            finally {
                hashStateEntry.releaseExclusiveLock();
                OLocalHashTable.releasePage(atomicOperation, hashStateEntry, this.diskCache);
            }
        }
        finally {
            buddyCacheEntry.releaseExclusiveLock();
            OLocalHashTable.releasePage(atomicOperation, buddyCacheEntry, this.diskCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.acquireExclusiveLock();
        try {
            OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
            OCacheEntry hashStateEntry = OLocalHashTable.loadPage(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true, this.diskCache);
            try {
                for (int i = 0; i < 64; ++i) {
                    OHashIndexFileLevelMetadataPage metadataPage = new OHashIndexFileLevelMetadataPage(hashStateEntry, OLocalHashTable.getChangesTree(atomicOperation, hashStateEntry), false);
                    if (metadataPage.isRemoved(i)) continue;
                    this.diskCache.flushFile(metadataPage.getFileId(i));
                }
            }
            finally {
                OLocalHashTable.releasePage(atomicOperation, hashStateEntry, this.diskCache);
            }
            this.diskCache.flushFile(this.fileStateId);
            this.directory.flush();
            if (this.nullKeyIsSupported) {
                this.diskCache.flushFile(this.nullBucketFileId);
            }
        }
        catch (IOException e) {
            throw new OIndexException("Error during hash table flush", e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPut(K key, V value, OAtomicOperation atomicOperation) throws IOException {
        int sizeDiff = 0;
        if (key == null) {
            boolean isNew;
            OCacheEntry cacheEntry;
            if (OLocalHashTable.getFilledUpTo(atomicOperation, this.diskCache, this.nullBucketFileId) == 0L) {
                cacheEntry = OLocalHashTable.addPage(atomicOperation, this.nullBucketFileId, this.diskCache);
                isNew = true;
            } else {
                cacheEntry = OLocalHashTable.loadPage(atomicOperation, this.nullBucketFileId, 0L, false, this.diskCache);
                isNew = false;
            }
            cacheEntry.acquireExclusiveLock();
            try {
                ONullBucket<V> nullBucket = new ONullBucket<V>(cacheEntry, OLocalHashTable.getChangesTree(atomicOperation, cacheEntry), this.valueSerializer, isNew);
                if (nullBucket.getValue() != null) {
                    --sizeDiff;
                }
                nullBucket.setValue(value);
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                OLocalHashTable.releasePage(atomicOperation, cacheEntry, this.diskCache);
            }
            this.changeSize(++sizeDiff, atomicOperation);
        } else {
            long hashCode = this.keyHashFunction.hashCode(key);
            BucketPath bucketPath = this.getBucket(hashCode);
            long bucketPointer = this.directory.getNodePointer(bucketPath.nodeIndex, bucketPath.itemIndex + bucketPath.hashMapOffset);
            if (bucketPointer == 0L) {
                throw new IllegalStateException("In this version of hash table buckets are added through split only.");
            }
            long pageIndex = this.getPageIndex(bucketPointer);
            int fileLevel = this.getFileLevel(bucketPointer);
            OCacheEntry cacheEntry = this.loadPageEntry(pageIndex, fileLevel, atomicOperation);
            cacheEntry.acquireExclusiveLock();
            try {
                OHashIndexBucket<K, V> bucket = new OHashIndexBucket<K, V>(cacheEntry, this.keySerializer, this.valueSerializer, this.keyTypes, OLocalHashTable.getChangesTree(atomicOperation, cacheEntry));
                int index = bucket.getIndex(hashCode, key);
                if (index > -1) {
                    int updateResult = bucket.updateEntry(index, value);
                    if (updateResult == 0) {
                        this.changeSize(sizeDiff, atomicOperation);
                        return;
                    }
                    if (updateResult == 1) {
                        this.changeSize(sizeDiff, atomicOperation);
                        return;
                    }
                    assert (updateResult == -1);
                    bucket.deleteEntry(index);
                    --sizeDiff;
                }
                if (bucket.addEntry(hashCode, key, value)) {
                    this.changeSize(++sizeDiff, atomicOperation);
                    return;
                }
                BucketSplitResult splitResult = this.splitBucket(bucket, fileLevel, pageIndex, atomicOperation);
                long updatedBucketPointer = splitResult.updatedBucketPointer;
                long newBucketPointer = splitResult.newBucketPointer;
                int bucketDepth = splitResult.newDepth;
                if (bucketDepth <= bucketPath.nodeGlobalDepth) {
                    this.updateNodeAfterBucketSplit(bucketPath, bucketDepth, newBucketPointer, updatedBucketPointer);
                } else if (bucketPath.nodeLocalDepth < 8) {
                    NodeSplitResult nodeSplitResult = this.splitNode(bucketPath);
                    assert (!nodeSplitResult.allLeftHashMapsEqual || !nodeSplitResult.allRightHashMapsEqual);
                    long[] newNode = nodeSplitResult.newNode;
                    int nodeLocalDepth = bucketPath.nodeLocalDepth + 1;
                    int hashMapSize = 1 << nodeLocalDepth;
                    assert (nodeSplitResult.allRightHashMapsEqual == this.checkAllMapsContainSameBucket(newNode, hashMapSize));
                    int newNodeIndex = -1;
                    if (!nodeSplitResult.allRightHashMapsEqual || bucketPath.itemIndex >= 128) {
                        newNodeIndex = this.directory.addNewNode((byte)0, (byte)0, (byte)nodeLocalDepth, newNode);
                    }
                    int updatedItemIndex = bucketPath.itemIndex << 1;
                    int updatedOffset = bucketPath.hashMapOffset << 1;
                    int updatedGlobalDepth = bucketPath.nodeGlobalDepth + 1;
                    boolean allLeftHashMapsEqual = nodeSplitResult.allLeftHashMapsEqual;
                    boolean allRightHashMapsEqual = nodeSplitResult.allRightHashMapsEqual;
                    if (updatedOffset < 256) {
                        allLeftHashMapsEqual = false;
                        BucketPath updatedBucketPath = new BucketPath(bucketPath.parent, updatedOffset, updatedItemIndex, bucketPath.nodeIndex, nodeLocalDepth, updatedGlobalDepth);
                        this.updateNodeAfterBucketSplit(updatedBucketPath, bucketDepth, newBucketPointer, updatedBucketPointer);
                    } else {
                        allRightHashMapsEqual = false;
                        BucketPath newBucketPath = new BucketPath(bucketPath.parent, updatedOffset - 256, updatedItemIndex, newNodeIndex, nodeLocalDepth, updatedGlobalDepth);
                        this.updateNodeAfterBucketSplit(newBucketPath, bucketDepth, newBucketPointer, updatedBucketPointer);
                    }
                    this.updateNodesAfterSplit(bucketPath, bucketPath.nodeIndex, newNode, nodeLocalDepth, hashMapSize, allLeftHashMapsEqual, allRightHashMapsEqual, newNodeIndex);
                    if (allLeftHashMapsEqual) {
                        this.directory.deleteNode(bucketPath.nodeIndex);
                    }
                } else {
                    this.addNewLevelNode(bucketPath, bucketPath.nodeIndex, newBucketPointer, updatedBucketPointer);
                }
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                OLocalHashTable.releasePage(atomicOperation, cacheEntry, this.diskCache);
            }
            this.changeSize(sizeDiff, atomicOperation);
            this.doPut(key, value, atomicOperation);
        }
    }

    private void checkNullSupport(K key) {
        if (key == null && !this.nullKeyIsSupported) {
            throw new OIndexException("Null keys are not supported.");
        }
    }

    private void updateNodesAfterSplit(BucketPath bucketPath, int nodeIndex, long[] newNode, int nodeLocalDepth, int hashMapSize, boolean allLeftHashMapEquals, boolean allRightHashMapsEquals, int newNodeIndex) throws IOException {
        long position;
        int i;
        int startIndex = this.findParentNodeStartIndex(bucketPath);
        int parentNodeIndex = bucketPath.parent.nodeIndex;
        assert (this.assertParentNodeStartIndex(bucketPath, this.directory.getNode(parentNodeIndex), startIndex));
        int pointersSize = 1 << 8 - nodeLocalDepth;
        if (allLeftHashMapEquals) {
            for (i = 0; i < pointersSize; ++i) {
                position = this.directory.getNodePointer(nodeIndex, i * hashMapSize);
                this.directory.setNodePointer(parentNodeIndex, startIndex + i, position);
            }
        } else {
            for (i = 0; i < pointersSize; ++i) {
                this.directory.setNodePointer(parentNodeIndex, startIndex + i, (long)(bucketPath.nodeIndex << 8 | i * hashMapSize) | Long.MIN_VALUE);
            }
        }
        if (allRightHashMapsEquals) {
            for (i = 0; i < pointersSize; ++i) {
                position = newNode[i * hashMapSize];
                this.directory.setNodePointer(parentNodeIndex, startIndex + pointersSize + i, position);
            }
        } else {
            for (i = 0; i < pointersSize; ++i) {
                this.directory.setNodePointer(parentNodeIndex, startIndex + pointersSize + i, (long)(newNodeIndex << 8 | i * hashMapSize) | Long.MIN_VALUE);
            }
        }
        this.updateMaxChildDepth(bucketPath.parent, bucketPath.nodeLocalDepth + 1);
    }

    private void updateMaxChildDepth(BucketPath parentPath, int childDepth) throws IOException {
        if (parentPath == null) {
            return;
        }
        if (parentPath.itemIndex < 128) {
            byte maxChildDepth = this.directory.getMaxLeftChildDepth(parentPath.nodeIndex);
            if (childDepth > maxChildDepth) {
                this.directory.setMaxLeftChildDepth(parentPath.nodeIndex, (byte)childDepth);
            }
        } else {
            byte maxChildDepth = this.directory.getMaxRightChildDepth(parentPath.nodeIndex);
            if (childDepth > maxChildDepth) {
                this.directory.setMaxRightChildDepth(parentPath.nodeIndex, (byte)childDepth);
            }
        }
    }

    private boolean assertParentNodeStartIndex(BucketPath bucketPath, long[] parentNode, int calculatedIndex) {
        int startIndex = -1;
        for (int i = 0; i < parentNode.length; ++i) {
            if (parentNode[i] >= 0L || (parentNode[i] & Long.MAX_VALUE) >>> 8 != (long)bucketPath.nodeIndex) continue;
            startIndex = i;
            break;
        }
        return startIndex == calculatedIndex;
    }

    private int findParentNodeStartIndex(BucketPath bucketPath) {
        BucketPath parentBucketPath = bucketPath.parent;
        int pointersSize = 1 << 8 - bucketPath.nodeLocalDepth;
        if (parentBucketPath.itemIndex < 128) {
            return parentBucketPath.itemIndex / pointersSize * pointersSize;
        }
        return (parentBucketPath.itemIndex - 128) / pointersSize * pointersSize + 128;
    }

    private void addNewLevelNode(BucketPath bucketPath, int nodeIndex, long newBucketPointer, long updatedBucketPointer) throws IOException {
        int newNodeStartIndex;
        int mapInterval;
        byte newNodeDepth;
        byte maxDepth;
        if (bucketPath.itemIndex < 128) {
            maxDepth = this.directory.getMaxLeftChildDepth(bucketPath.nodeIndex);
            assert (this.getMaxLevelDepth(bucketPath.nodeIndex, 0, 128) == maxDepth);
            newNodeDepth = maxDepth > 0 ? maxDepth : (byte)1;
            mapInterval = 1 << 8 - newNodeDepth;
            newNodeStartIndex = bucketPath.itemIndex / mapInterval * mapInterval;
        } else {
            maxDepth = this.directory.getMaxRightChildDepth(bucketPath.nodeIndex);
            assert (this.getMaxLevelDepth(bucketPath.nodeIndex, 128, 256) == maxDepth);
            newNodeDepth = maxDepth > 0 ? maxDepth : (byte)1;
            mapInterval = 1 << 8 - newNodeDepth;
            newNodeStartIndex = (bucketPath.itemIndex - 128) / mapInterval * mapInterval + 128;
        }
        int newNodeIndex = this.directory.addNewNode((byte)0, (byte)0, newNodeDepth, new long[256]);
        int mapSize = 1 << newNodeDepth;
        for (int i = 0; i < mapInterval; ++i) {
            int n;
            int nodeOffset = i + newNodeStartIndex;
            long bucketPointer = this.directory.getNodePointer(nodeIndex, nodeOffset);
            if (nodeOffset != bucketPath.itemIndex) {
                for (n = i << newNodeDepth; n < i + 1 << newNodeDepth; ++n) {
                    this.directory.setNodePointer(newNodeIndex, n, bucketPointer);
                }
            } else {
                for (n = i << newNodeDepth; n < 2 * i + 1 << newNodeDepth - 1; ++n) {
                    this.directory.setNodePointer(newNodeIndex, n, updatedBucketPointer);
                }
                for (n = 2 * i + 1 << newNodeDepth - 1; n < i + 1 << newNodeDepth; ++n) {
                    this.directory.setNodePointer(newNodeIndex, n, newBucketPointer);
                }
            }
            this.directory.setNodePointer(nodeIndex, nodeOffset, (long)(newNodeIndex << 8 | i * mapSize) | Long.MIN_VALUE);
        }
        this.updateMaxChildDepth(bucketPath, newNodeDepth);
    }

    private int getMaxLevelDepth(int nodeIndex, int start, int end) throws IOException {
        int currentIndex = -1;
        byte maxDepth = 0;
        for (int i = start; i < end; ++i) {
            int index;
            long nodePosition = this.directory.getNodePointer(nodeIndex, i);
            if (nodePosition >= 0L || (index = (int)((nodePosition & Long.MAX_VALUE) >>> 8)) == currentIndex) continue;
            currentIndex = index;
            byte nodeLocalDepth = this.directory.getNodeLocalDepth(index);
            if (maxDepth >= nodeLocalDepth) continue;
            maxDepth = nodeLocalDepth;
        }
        return maxDepth;
    }

    private void updateNodeAfterBucketSplit(BucketPath bucketPath, int bucketDepth, long newBucketPointer, long updatedBucketPointer) throws IOException {
        int i;
        int firstEndIndex;
        int offset = bucketPath.nodeGlobalDepth - (bucketDepth - 1);
        BucketPath currentNode = bucketPath;
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        while (offset > 0) {
            if ((offset -= nodeLocalDepth) <= 0) continue;
            currentNode = bucketPath.parent;
            nodeLocalDepth = currentNode.nodeLocalDepth;
        }
        int diff = bucketDepth - 1 - (currentNode.nodeGlobalDepth - nodeLocalDepth);
        int interval = 1 << nodeLocalDepth - diff - 1;
        int firstStartIndex = currentNode.itemIndex & (255 << nodeLocalDepth - diff & 0xFF);
        int secondStartIndex = firstEndIndex = firstStartIndex + interval;
        int secondEndIndex = secondStartIndex + interval;
        for (i = firstStartIndex; i < firstEndIndex; ++i) {
            this.updateBucket(currentNode.nodeIndex, i, currentNode.hashMapOffset, updatedBucketPointer);
        }
        for (i = secondStartIndex; i < secondEndIndex; ++i) {
            this.updateBucket(currentNode.nodeIndex, i, currentNode.hashMapOffset, newBucketPointer);
        }
    }

    private boolean checkAllMapsContainSameBucket(long[] newNode, int hashMapSize) {
        boolean allHashMapsEquals = true;
        block0: for (int n = 0; n < newNode.length; n += hashMapSize) {
            boolean allHashBucketEquals = true;
            for (int i = 0; i < hashMapSize - 1; ++i) {
                if (newNode[i + n] == newNode[i + n + 1]) continue;
                allHashBucketEquals = false;
                continue block0;
            }
            if (allHashBucketEquals) continue;
            allHashMapsEquals = false;
            break;
        }
        assert (this.assertAllNodesAreFilePointers(allHashMapsEquals, newNode, hashMapSize));
        return allHashMapsEquals;
    }

    private boolean assertAllNodesAreFilePointers(boolean allHashMapsEquals, long[] newNode, int hashMapSize) {
        if (allHashMapsEquals) {
            for (int n = 0; n < newNode.length; n += hashMapSize) {
                for (int i = 0; i < hashMapSize; ++i) {
                    if (newNode[i] >= 0L) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private NodeSplitResult splitNode(BucketPath bucketPath) throws IOException {
        long[] newNode = new long[256];
        int hashMapSize = 1 << bucketPath.nodeLocalDepth + 1;
        boolean hashMapItemsAreEqual = true;
        int mapCounter = 0;
        long firstPosition = -1L;
        long[] node = this.directory.getNode(bucketPath.nodeIndex);
        for (int i = 128; i < 256; ++i) {
            long position = node[i];
            if (hashMapItemsAreEqual && mapCounter == 0) {
                firstPosition = position;
            }
            newNode[2 * (i - 128)] = position;
            newNode[2 * (i - 128) + 1] = position;
            if (!hashMapItemsAreEqual) continue;
            boolean bl = hashMapItemsAreEqual = firstPosition == position;
            if ((mapCounter += 2) < hashMapSize) continue;
            mapCounter = 0;
        }
        mapCounter = 0;
        boolean allRightItemsAreEqual = hashMapItemsAreEqual;
        hashMapItemsAreEqual = true;
        long[] updatedNode = new long[node.length];
        for (int i = 0; i < 128; ++i) {
            long position = node[i];
            if (hashMapItemsAreEqual && mapCounter == 0) {
                firstPosition = position;
            }
            updatedNode[2 * i] = position;
            updatedNode[2 * i + 1] = position;
            if (!hashMapItemsAreEqual) continue;
            boolean bl = hashMapItemsAreEqual = firstPosition == position;
            if ((mapCounter += 2) < hashMapSize) continue;
            mapCounter = 0;
        }
        boolean allLeftItemsAreEqual = hashMapItemsAreEqual;
        this.directory.setNode(bucketPath.nodeIndex, updatedNode);
        this.directory.setNodeLocalDepth(bucketPath.nodeIndex, (byte)(this.directory.getNodeLocalDepth(bucketPath.nodeIndex) + 1));
        return new NodeSplitResult(newNode, allLeftItemsAreEqual, allRightItemsAreEqual);
    }

    private void splitBucketContent(OHashIndexBucket<K, V> bucket, OHashIndexBucket<K, V> updatedBucket, OHashIndexBucket<K, V> newBucket, int newBucketDepth) throws IOException {
        assert (this.checkBucketDepth(bucket));
        for (OHashIndexBucket.Entry<K, V> entry : bucket) {
            if ((this.keyHashFunction.hashCode(entry.key) >>> 64 - newBucketDepth & 1L) == 0L) {
                updatedBucket.appendEntry(entry.hashCode, entry.key, entry.value);
                continue;
            }
            newBucket.appendEntry(entry.hashCode, entry.key, entry.value);
        }
        updatedBucket.setDepth(newBucketDepth);
        newBucket.setDepth(newBucketDepth);
        assert (this.checkBucketDepth(updatedBucket));
        assert (this.checkBucketDepth(newBucket));
    }

    /*
     * Exception decompiling
     */
    private BucketSplitResult splitBucket(OHashIndexBucket<K, V> bucket, int fileLevel, long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkBucketDepth(OHashIndexBucket<K, V> bucket) {
        int bucketDepth = bucket.getDepth();
        if (bucket.size() == 0) {
            return true;
        }
        Iterator<OHashIndexBucket.Entry<K, V>> positionIterator = bucket.iterator();
        long firstValue = this.keyHashFunction.hashCode(positionIterator.next().key) >>> 64 - bucketDepth;
        while (positionIterator.hasNext()) {
            long value = this.keyHashFunction.hashCode(positionIterator.next().key) >>> 64 - bucketDepth;
            if (value == firstValue) continue;
            return false;
        }
        return true;
    }

    private void updateBucket(int nodeIndex, int itemIndex, int offset, long newBucketPointer) throws IOException {
        long position = this.directory.getNodePointer(nodeIndex, itemIndex + offset);
        if (position >= 0L) {
            this.directory.setNodePointer(nodeIndex, itemIndex + offset, newBucketPointer);
        } else {
            int childNodeIndex = (int)((position & Long.MAX_VALUE) >>> 8);
            int childOffset = (int)(position & 0xFFL);
            byte childNodeDepth = this.directory.getNodeLocalDepth(childNodeIndex);
            int interval = 1 << childNodeDepth;
            for (int i = 0; i < interval; ++i) {
                this.updateBucket(childNodeIndex, i, childOffset, newBucketPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHashTreeState(OAtomicOperation atomicOperation) throws IOException {
        for (long pageIndex = 0L; pageIndex < 256L; ++pageIndex) {
            OCacheEntry cacheEntry = this.loadPageEntry(pageIndex, 0, atomicOperation);
            cacheEntry.acquireExclusiveLock();
            try {
                OHashIndexBucket<K, V> emptyBucket = new OHashIndexBucket<K, V>(8, cacheEntry, this.keySerializer, this.valueSerializer, this.keyTypes, OLocalHashTable.getChangesTree(atomicOperation, cacheEntry));
                continue;
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                OLocalHashTable.releasePage(atomicOperation, cacheEntry, this.diskCache);
            }
        }
        long[] rootTree = new long[256];
        for (int i = 0; i < 256; ++i) {
            rootTree[i] = this.createBucketPointer(i, 0);
        }
        this.directory.clear();
        this.directory.addNewNode((byte)0, (byte)0, (byte)8, rootTree);
        OCacheEntry hashStateEntry = OLocalHashTable.loadPage(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true, this.diskCache);
        hashStateEntry.acquireExclusiveLock();
        try {
            OHashIndexFileLevelMetadataPage metadataPage = new OHashIndexFileLevelMetadataPage(hashStateEntry, OLocalHashTable.getChangesTree(atomicOperation, hashStateEntry), false);
            metadataPage.setBucketsCount(0, 256L);
            metadataPage.setRecordsCount(0L);
        }
        finally {
            hashStateEntry.releaseExclusiveLock();
            OLocalHashTable.releasePage(atomicOperation, hashStateEntry, this.diskCache);
        }
    }

    private long createBucketPointer(long pageIndex, int fileLevel) {
        return pageIndex + 1L << 8 | (long)fileLevel;
    }

    private long getPageIndex(long bucketPointer) {
        return (bucketPointer >>> 8) - 1L;
    }

    private int getFileLevel(long bucketPointer) {
        return (int)(bucketPointer & 0xFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OCacheEntry loadPageEntry(long pageIndex, int fileLevel, OAtomicOperation atomicOperation) throws IOException {
        long fileId;
        OCacheEntry hashStateEntry = OLocalHashTable.loadPage(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true, this.diskCache);
        try {
            OHashIndexFileLevelMetadataPage metadataPage = new OHashIndexFileLevelMetadataPage(hashStateEntry, OLocalHashTable.getChangesTree(atomicOperation, hashStateEntry), false);
            fileId = metadataPage.getFileId(fileLevel);
        }
        finally {
            OLocalHashTable.releasePage(atomicOperation, hashStateEntry, this.diskCache);
        }
        OCacheEntry entry = OLocalHashTable.loadPage(atomicOperation, fileId, pageIndex, false, this.diskCache);
        if (entry == null) {
            entry = OLocalHashTable.addPage(atomicOperation, fileId, this.diskCache);
        }
        return entry;
    }

    private BucketPath getBucket(long hashCode) throws IOException {
        int localNodeDepth;
        int nodeDepth = localNodeDepth = this.directory.getNodeLocalDepth(0);
        BucketPath parentNode = null;
        int nodeIndex = 0;
        int offset = 0;
        int index = (int)(hashCode >>> 64 - nodeDepth & (long)(255 >>> 8 - localNodeDepth));
        BucketPath currentNode = new BucketPath(parentNode, 0, index, 0, localNodeDepth, nodeDepth);
        do {
            long position;
            if ((position = this.directory.getNodePointer(nodeIndex, index + offset)) >= 0L) {
                return currentNode;
            }
            nodeIndex = (int)((position & Long.MAX_VALUE) >>> 8);
            offset = (int)(position & 0xFFL);
            localNodeDepth = this.directory.getNodeLocalDepth(nodeIndex);
            index = (int)(hashCode >>> 64 - (nodeDepth += localNodeDepth) & (long)(255 >>> 8 - localNodeDepth));
            parentNode = currentNode;
            currentNode = new BucketPath(parentNode, offset, index, nodeIndex, localNodeDepth, nodeDepth);
        } while (nodeDepth <= 64);
        throw new IllegalStateException("Extendible hashing tree in corrupted state.");
    }

    private static final class KeyHashCodeComparator<K>
    implements Comparator<K> {
        private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
        private final OHashFunction<K> keyHashFunction;

        public KeyHashCodeComparator(OHashFunction<K> keyHashFunction) {
            this.keyHashFunction = keyHashFunction;
        }

        @Override
        public int compare(K keyOne, K keyTwo) {
            long hashCodeTwo;
            long hashCodeOne = this.keyHashFunction.hashCode(keyOne);
            if (KeyHashCodeComparator.greaterThanUnsigned(hashCodeOne, hashCodeTwo = this.keyHashFunction.hashCode(keyTwo))) {
                return 1;
            }
            if (KeyHashCodeComparator.lessThanUnsigned(hashCodeOne, hashCodeTwo)) {
                return -1;
            }
            return this.comparator.compare(keyOne, keyTwo);
        }

        private static boolean lessThanUnsigned(long longOne, long longTwo) {
            return longOne + Long.MIN_VALUE < longTwo + Long.MIN_VALUE;
        }

        private static boolean greaterThanUnsigned(long longOne, long longTwo) {
            return longOne + Long.MIN_VALUE > longTwo + Long.MIN_VALUE;
        }
    }

    private static final class NodeSplitResult {
        private final long[] newNode;
        private final boolean allLeftHashMapsEqual;
        private final boolean allRightHashMapsEqual;

        private NodeSplitResult(long[] newNode, boolean allLeftHashMapsEqual, boolean allRightHashMapsEqual) {
            this.newNode = newNode;
            this.allLeftHashMapsEqual = allLeftHashMapsEqual;
            this.allRightHashMapsEqual = allRightHashMapsEqual;
        }
    }

    private static final class BucketSplitResult {
        private final long updatedBucketPointer;
        private final long newBucketPointer;
        private final int newDepth;

        private BucketSplitResult(long updatedBucketPointer, long newBucketPointer, int newDepth) {
            this.updatedBucketPointer = updatedBucketPointer;
            this.newBucketPointer = newBucketPointer;
            this.newDepth = newDepth;
        }
    }

    private static final class BucketPath {
        private final BucketPath parent;
        private final int hashMapOffset;
        private final int itemIndex;
        private final int nodeIndex;
        private final int nodeGlobalDepth;
        private final int nodeLocalDepth;

        private BucketPath(BucketPath parent, int hashMapOffset, int itemIndex, int nodeIndex, int nodeLocalDepth, int nodeGlobalDepth) {
            this.parent = parent;
            this.hashMapOffset = hashMapOffset;
            this.itemIndex = itemIndex;
            this.nodeIndex = nodeIndex;
            this.nodeGlobalDepth = nodeGlobalDepth;
            this.nodeLocalDepth = nodeLocalDepth;
        }
    }
}

