/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.util.OClassLoaderHelper;
import com.orientechnologies.common.util.OCollections;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class OIndexes {
    private static Set<OIndexFactory> FACTORIES = null;
    private static final Set<OIndexFactory> DYNAMIC_FACTORIES = Collections.synchronizedSet(new HashSet());
    private static ClassLoader orientClassLoader = OIndexes.class.getClassLoader();

    private OIndexes() {
    }

    private static synchronized Set<OIndexFactory> getFactories() {
        if (FACTORIES == null) {
            Iterator<OIndexFactory> ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OIndexFactory.class, orientClassLoader);
            HashSet<OIndexFactory> factories = new HashSet<OIndexFactory>();
            while (ite.hasNext()) {
                factories.add(ite.next());
            }
            factories.addAll(DYNAMIC_FACTORIES);
            FACTORIES = Collections.unmodifiableSet(factories);
        }
        return FACTORIES;
    }

    public static Iterator<OIndexFactory> getAllFactories() {
        return OIndexes.getFactories().iterator();
    }

    public static Set<String> getIndexTypes() {
        HashSet<String> types = new HashSet<String>();
        Iterator<OIndexFactory> ite = OIndexes.getAllFactories();
        while (ite.hasNext()) {
            types.addAll(ite.next().getTypes());
        }
        return types;
    }

    public static Set<String> getIndexEngines() {
        HashSet<String> engines = new HashSet<String>();
        Iterator<OIndexFactory> ite = OIndexes.getAllFactories();
        while (ite.hasNext()) {
            engines.addAll(ite.next().getAlgorithms());
        }
        return engines;
    }

    public static OIndexInternal<?> createIndex(ODatabaseDocumentInternal database, String name, String indexType, String algorithm, String valueContainerAlgorithm, ODocument metadata, int version) throws OConfigurationException, OIndexException {
        OIndexFactory factory;
        Iterator<OIndexFactory> ite = OIndexes.getAllFactories();
        boolean found = false;
        while (ite.hasNext()) {
            factory = ite.next();
            found = found || factory.getAlgorithms().contains(algorithm);
        }
        if (!found) {
            throw new OIndexException("Engine type: '" + algorithm + "' is not supported. Types are " + OCollections.toString(OIndexes.getIndexEngines()) + ". Please check the engine name or verify that the engine '" + algorithm + "' is installed correctly");
        }
        ite = OIndexes.getAllFactories();
        while (ite.hasNext()) {
            factory = ite.next();
            if (!factory.getTypes().contains(indexType) || !factory.getAlgorithms().contains(algorithm)) continue;
            return factory.createIndex(name, database, indexType, algorithm, valueContainerAlgorithm, metadata, version);
        }
        throw new OIndexException("Index type: " + indexType + " is not supported. Types are " + OCollections.toString(OIndexes.getIndexTypes()));
    }

    public static synchronized void scanForPlugins() {
        FACTORIES = null;
    }

    public static void registerFactory(OIndexFactory factory) {
        DYNAMIC_FACTORIES.add(factory);
        OIndexes.scanForPlugins();
    }

    public static void unregisterFactory(OIndexFactory factory) {
        DYNAMIC_FACTORIES.remove(factory);
        OIndexes.scanForPlugins();
    }
}

