/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OIndexRIDContainer;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerListRID;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class OIndexMultiValues
extends OIndexAbstract<Set<OIdentifiable>> {
    public OIndexMultiValues(String type, String algorithm, OIndexEngine<Set<OIdentifiable>> indexEngine, String valueContainerAlgorithm, ODocument metadata) {
        super(type, algorithm, indexEngine, valueContainerAlgorithm, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIdentifiable> get(Object key) {
        this.checkForRebuild();
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireSharedLock(key);
        }
        try {
            Set values;
            block10: {
                Set<OIdentifiable> set;
                this.acquireSharedLock();
                try {
                    values = (Set)this.indexEngine.get(key);
                    if (values != null) break block10;
                    set = Collections.emptySet();
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return set;
            }
            HashSet<OIdentifiable> hashSet = new HashSet<OIdentifiable>(values);
            this.releaseSharedLock();
            return hashSet;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseSharedLock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(Object key) {
        this.checkForRebuild();
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireSharedLock(key);
        }
        try {
            Set values;
            block10: {
                long l;
                this.acquireSharedLock();
                try {
                    values = (Set)this.indexEngine.get(key);
                    if (values != null) break block10;
                    l = 0L;
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return l;
            }
            long l = values.size();
            this.releaseSharedLock();
            return l;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseSharedLock(key);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public OIndexMultiValues put(Object key, OIdentifiable iSingleValue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void putInSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        Object snapshotValue = snapshot.get(key = this.getCollatingValue(key));
        Object values = snapshotValue == null ? (Set)this.indexEngine.get(key) : (snapshotValue.equals(OIndexAbstract.RemovedValue.INSTANCE) ? null : (Set)snapshotValue);
        if (values == null) {
            if ("SBTREEBONSAISET".equals(this.valueContainerAlgorithm)) {
                boolean durable = false;
                if (this.metadata != null && Boolean.TRUE.equals(this.metadata.field("durableInNonTxMode"))) {
                    durable = true;
                }
                values = new OIndexRIDContainer(this.getName(), durable);
            } else {
                values = new OMVRBTreeRIDSet(OGlobalConfiguration.MVRBTREE_RID_BINARY_THRESHOLD.getValueAsInteger());
                ((OMVRBTreeRIDSet)values).setAutoConvertToRecord(false);
            }
            snapshot.put(key, values);
        }
        values.add(value.getIdentity());
        snapshot.put(key, values);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean remove(Object key, OIdentifiable value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 22[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void removeFromSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        Object snapshotValue = snapshot.get(key = this.getCollatingValue(key));
        Object values = snapshotValue == null ? (Set)this.indexEngine.get(key) : (snapshotValue.equals(OIndexAbstract.RemovedValue.INSTANCE) ? null : (Set)snapshotValue);
        if (values == null) {
            return;
        }
        if (values.remove(value)) {
            if (values.isEmpty()) {
                snapshot.put(key, OIndexAbstract.RemovedValue.INSTANCE);
            } else {
                snapshot.put(key, values);
            }
        }
    }

    @Override
    protected void commitSnapshot(Map<Object, Object> snapshot) {
        for (Map.Entry<Object, Object> snapshotEntry : snapshot.entrySet()) {
            Object key = snapshotEntry.getKey();
            Object value = snapshotEntry.getValue();
            this.checkForKeyType(key);
            if (value.equals(OIndexAbstract.RemovedValue.INSTANCE)) {
                this.indexEngine.remove(key);
                continue;
            }
            this.indexEngine.put(key, (Set)value);
        }
    }

    public OIndexMultiValues create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return (OIndexMultiValues)super.create(name, indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, this.determineValueSerializer());
    }

    @Override
    protected OStreamSerializer determineValueSerializer() {
        if ("SBTREEBONSAISET".equals(this.valueContainerAlgorithm)) {
            return (OStreamSerializer)((Object)this.getDatabase().getSerializerFactory().getObjectSerializer((byte)21));
        }
        return OStreamSerializerListRID.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        this.checkForRebuild();
        fromKey = this.getCollatingValue(fromKey);
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.iterateEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        this.checkForRebuild();
        fromKey = this.getCollatingValue(fromKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.iterateEntriesMajor(fromKey, fromInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        this.checkForRebuild();
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.iterateEntriesMinor(toKey, toInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        this.checkForRebuild();
        final ArrayList sortedKeys = new ArrayList(keys);
        Comparator<Object> comparator = ascSortOrder ? ODefaultComparator.INSTANCE : Collections.reverseOrder(ODefaultComparator.INSTANCE);
        Collections.sort(sortedKeys, comparator);
        return new OIndexAbstractCursor(){
            private Iterator<?> keysIterator;
            private Iterator<OIdentifiable> currentIterator;
            private Object currentKey;
            {
                this.keysIterator = sortedKeys.iterator();
                this.currentIterator = OEmptyIterator.IDENTIFIABLE_INSTANCE;
            }

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (this.currentIterator == null) {
                    return null;
                }
                Object key = null;
                if (!this.currentIterator.hasNext()) {
                    Collection result = null;
                    while (this.keysIterator.hasNext() && (result == null || result.isEmpty())) {
                        key = this.keysIterator.next();
                        key = OIndexMultiValues.this.getCollatingValue(key);
                        OIndexMultiValues.this.acquireSharedLock();
                        try {
                            result = (Collection)OIndexMultiValues.this.indexEngine.get(key);
                        }
                        finally {
                            OIndexMultiValues.this.releaseSharedLock();
                        }
                    }
                    if (result == null) {
                        this.currentIterator = null;
                        return null;
                    }
                    this.currentKey = key;
                    this.currentIterator = result.iterator();
                }
                final OIdentifiable resultValue = this.currentIterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return currentKey;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return resultValue;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException("setValue");
                    }
                };
            }
        };
    }

    @Override
    public long getSize() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            long l = this.indexEngine.size(MultiValuesTransformer.INSTANCE);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getKeySize() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            long l = this.indexEngine.size(null);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor cursor() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.cursor(MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor descCursor() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.descCursor(MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static final class MultiValuesTransformer
    implements OIndexEngine.ValuesTransformer<Set<OIdentifiable>> {
        private static final MultiValuesTransformer INSTANCE = new MultiValuesTransformer();

        private MultiValuesTransformer() {
        }

        @Override
        public Collection<OIdentifiable> transformFromValue(Set<OIdentifiable> value) {
            return value;
        }
    }
}

