/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.ODefaultIndexFactory;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexRemoteMultiValue;
import com.orientechnologies.orient.core.index.OIndexRemoteOneValue;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import java.util.Set;

public class OIndexManagerRemote
extends OIndexManagerAbstract {
    private static final String QUERY_DROP = "drop index %s";

    public OIndexManagerRemote(ODatabaseDocument iDatabase) {
        super(iDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndex<?> createIndex(String iName, String iType, OIndexDefinition iIndexDefinition, int[] iClusterIdsToIndex, OProgressListener progressListener, ODocument metadata, String engine) {
        String createIndexDDL = iIndexDefinition != null ? iIndexDefinition.toCreateIndexDDL(iName, iType) : new OSimpleKeyIndexDefinition().toCreateIndexDDL(iName, iType);
        if (engine != null) {
            createIndexDDL = createIndexDDL + " ENGINE " + engine;
        }
        if (metadata != null) {
            createIndexDDL = createIndexDDL + " METADATA " + metadata.toJSON();
        }
        this.acquireExclusiveLock();
        try {
            if (progressListener != null) {
                progressListener.onBegin(this, 0L, false);
            }
            this.getDatabase().command(new OCommandSQL(createIndexDDL)).execute(new Object[0]);
            ORecordInternal.setIdentity(this.document, new ORecordId(ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().indexMgrRecordId));
            if (progressListener != null) {
                progressListener.onCompletition(this, true);
            }
            this.reload();
            OIndex<?> oIndex = this.preProcessBeforeReturn((OIndex)this.indexes.get(iName.toLowerCase()));
            return oIndex;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OIndexDefinition indexDefinition, int[] clusterIdsToIndex, OProgressListener progressListener, ODocument metadata) {
        return this.createIndex(iName, iType, indexDefinition, clusterIdsToIndex, progressListener, metadata, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexManager dropIndex(String iIndexName) {
        this.acquireExclusiveLock();
        try {
            String text = String.format(QUERY_DROP, iIndexName);
            this.getDatabase().command(new OCommandSQL(text)).execute(new Object[0]);
            this.indexes.remove(iIndexName.toLowerCase());
            this.reload();
            OIndexManagerRemote oIndexManagerRemote = this;
            return oIndexManagerRemote;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ODocument toStream() {
        throw new UnsupportedOperationException("Remote index cannot be streamed");
    }

    @Override
    public void recreateIndexes() {
        throw new UnsupportedOperationException("recreateIndexes()");
    }

    @Override
    public void waitTillIndexRestore() {
    }

    @Override
    public boolean autoRecreateIndexesAfterCrash() {
        return false;
    }

    @Override
    public void removeClassPropertyIndex(OIndex<?> idx) {
    }

    protected OIndex<?> getRemoteIndexInstance(boolean isMultiValueIndex, String type, String name, Set<String> clustersToIndex, OIndexDefinition indexDefinition, ORID identity, ODocument configuration) {
        if (isMultiValueIndex) {
            return new OIndexRemoteMultiValue(name, type, identity, indexDefinition, configuration, clustersToIndex);
        }
        return new OIndexRemoteOneValue(name, type, identity, indexDefinition, configuration, clustersToIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fromStream() {
        this.acquireExclusiveLock();
        try {
            this.clearMetadata();
            Collection idxs = (Collection)this.document.field("indexes");
            if (idxs != null) {
                for (ODocument d : idxs) {
                    d.setLazyLoad(false);
                    try {
                        boolean isMultiValue = ODefaultIndexFactory.isMultiValueIndex((String)d.field("type"));
                        OIndexInternal.IndexMetadata newIndexMetadata = OIndexAbstract.loadMetadataInternal(d, (String)d.field("type"), (String)d.field("algorithm"), (String)d.field("valueContainerAlgorithm"));
                        this.addIndexInternal(this.getRemoteIndexInstance(isMultiValue, newIndexMetadata.getType(), newIndexMetadata.getName(), newIndexMetadata.getClustersToIndex(), newIndexMetadata.getIndexDefinition(), (ORID)d.field("mapRid"), d));
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error on loading of index by configuration: %s", (Throwable)e, d);
                    }
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }
}

