/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.util.OMultiKey;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import com.orientechnologies.orient.core.index.OIndexTxAwareDictionary;
import com.orientechnologies.orient.core.index.OIndexTxAwareMultiValue;
import com.orientechnologies.orient.core.index.OIndexTxAwareOneValue;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class OIndexManagerAbstract
extends ODocumentWrapperNoClass
implements OIndexManager,
OCloseable {
    public static final String CONFIG_INDEXES = "indexes";
    public static final String DICTIONARY_NAME = "dictionary";
    protected final Map<String, Map<OMultiKey, Set<OIndex<?>>>> classPropertyIndex = new HashMap();
    protected Map<String, OIndex<?>> indexes = new ConcurrentHashMap();
    protected String defaultClusterName = "index";
    protected String manualClusterName = "manindex";
    protected ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean fullCheckpointOnChange = false;

    public OIndexManagerAbstract(ODatabaseDocument iDatabase) {
        super(new ODocument());
    }

    @Override
    public boolean isFullCheckpointOnChange() {
        return this.fullCheckpointOnChange;
    }

    @Override
    public void setFullCheckpointOnChange(boolean fullCheckpointOnChange) {
        this.fullCheckpointOnChange = fullCheckpointOnChange;
    }

    @Override
    public OIndexManagerAbstract load() {
        if (!this.autoRecreateIndexesAfterCrash()) {
            this.acquireExclusiveLock();
            try {
                if (this.getDatabase().getStorage().getConfiguration().indexMgrRecordId == null) {
                    this.create();
                }
                ((ORecordId)this.document.getIdentity()).fromString(this.getDatabase().getStorage().getConfiguration().indexMgrRecordId);
                super.reload("*:-1 index:0");
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        return this;
    }

    @Override
    public <RET extends ODocumentWrapper> RET reload() {
        this.acquireExclusiveLock();
        try {
            Object RET = super.reload();
            return RET;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public <RET extends ODocumentWrapper> RET save() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[FORLOOP], 3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void create() {
        this.acquireExclusiveLock();
        try {
            block5: {
                try {
                    this.save("internal");
                }
                catch (Exception e) {
                    if (!ORecordId.isPersistent(this.document.getIdentity().getClusterPosition())) break block5;
                    this.document.getIdentity().reset();
                    this.save("internal");
                }
            }
            this.getDatabase().getStorage().getConfiguration().indexMgrRecordId = this.document.getIdentity().toString();
            this.getDatabase().getStorage().getConfiguration().update();
            this.createIndex(DICTIONARY_NAME, OClass.INDEX_TYPE.DICTIONARY.toString(), new OSimpleKeyIndexDefinition(OType.STRING), null, null, null);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void flush() {
        for (OIndex<?> idx : this.indexes.values()) {
            OIndexInternal<?> indexInternal = idx.getInternal();
            if (indexInternal == null) continue;
            indexInternal.flush();
        }
    }

    @Override
    public Collection<? extends OIndex<?>> getIndexes() {
        Collection<OIndex<?>> rawResult = this.indexes.values();
        ArrayList result = new ArrayList(rawResult.size());
        for (OIndex<?> index : rawResult) {
            result.add(this.preProcessBeforeReturn(index));
        }
        return result;
    }

    @Override
    public OIndex<?> getIndex(String iName) {
        OIndex<?> index = this.indexes.get(iName.toLowerCase());
        if (index == null) {
            return null;
        }
        return this.preProcessBeforeReturn(index);
    }

    @Override
    public void addClusterToIndex(String clusterName, String indexName) {
        OIndex<?> index = this.indexes.get(indexName.toLowerCase());
        if (index == null) {
            throw new OIndexException("Index with name " + indexName + " does not exist.");
        }
        if (index.getInternal() == null) {
            throw new OIndexException("Index with name " + indexName + " has no internal presentation.");
        }
        index.getInternal().addCluster(clusterName);
        this.save();
    }

    @Override
    public void removeClusterFromIndex(String clusterName, String indexName) {
        OIndex<?> index = this.indexes.get(indexName.toLowerCase());
        if (index == null) {
            throw new OIndexException("Index with name " + indexName + " does not exist.");
        }
        index.getInternal().removeCluster(clusterName);
        this.save();
    }

    @Override
    public boolean existsIndex(String iName) {
        return this.indexes.containsKey(iName.toLowerCase());
    }

    @Override
    public String getDefaultClusterName() {
        this.acquireSharedLock();
        try {
            String string = this.defaultClusterName;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void setDefaultClusterName(String defaultClusterName) {
        this.acquireExclusiveLock();
        try {
            this.defaultClusterName = defaultClusterName;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ODictionary<ORecord> getDictionary() {
        OIndex<OIdentifiable> idx;
        this.acquireSharedLock();
        try {
            idx = this.getIndex(DICTIONARY_NAME);
        }
        finally {
            this.releaseSharedLock();
        }
        if (idx == null) {
            idx = this.createDictionaryIfNeeded();
        }
        return new ODictionary<ORecord>(idx);
    }

    @Override
    public ODocument getConfiguration() {
        this.acquireSharedLock();
        try {
            ODocument oDocument = this.getDocument();
            return oDocument;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean onDelete) {
        this.acquireExclusiveLock();
        try {
            if (!onDelete) {
                this.flush();
                for (OIndex<?> idx : this.indexes.values()) {
                    OIndexInternal<?> indexInternal = idx.getInternal();
                    if (indexInternal == null) continue;
                    indexInternal.close();
                }
            } else {
                for (OIndex<?> idx : this.indexes.values()) {
                    OIndexInternal<?> indexInternal = idx.getInternal();
                    if (indexInternal == null) continue;
                    indexInternal.delete();
                }
            }
            this.clearMetadata();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public OIndexManager setDirty() {
        this.acquireExclusiveLock();
        try {
            this.document.setDirty();
            OIndexManagerAbstract oIndexManagerAbstract = this;
            return oIndexManagerAbstract;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndex<?> getIndex(ORID iRID) {
        for (OIndex<?> idx : this.indexes.values()) {
            if (!idx.getIdentity().equals(iRID)) continue;
            return idx;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String className, Collection<String> fields) {
        this.acquireSharedLock();
        try {
            fields = this.normalizeFieldNames(fields);
            OMultiKey multiKey = new OMultiKey(fields);
            Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.classPropertyIndex.get(className.toLowerCase());
            if (propertyIndex == null || !propertyIndex.containsKey(multiKey)) {
                Set<OIndex<?>> set = Collections.emptySet();
                return set;
            }
            Set<OIndex<?>> rawResult = propertyIndex.get(multiKey);
            HashSet transactionalResult = new HashSet(rawResult.size());
            for (OIndex<?> index : rawResult) {
                transactionalResult.add(this.preProcessBeforeReturn(index));
            }
            HashSet<OIndex<?>> hashSet = transactionalResult;
            return hashSet;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String className, String ... fields) {
        return this.getClassInvolvedIndexes(className, Arrays.asList(fields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areIndexed(String className, Collection<String> fields) {
        this.acquireSharedLock();
        try {
            fields = this.normalizeFieldNames(fields);
            OMultiKey multiKey = new OMultiKey(fields);
            Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.classPropertyIndex.get(className.toLowerCase());
            if (propertyIndex == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = propertyIndex.containsKey(multiKey) && !propertyIndex.get(multiKey).isEmpty();
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean areIndexed(String className, String ... fields) {
        return this.areIndexed(className, Arrays.asList(fields));
    }

    @Override
    public Set<OIndex<?>> getClassIndexes(String className) {
        HashSet coll = new HashSet(4);
        this.getClassIndexes(className, coll);
        return coll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getClassIndexes(String className, Collection<OIndex<?>> indexes) {
        this.acquireSharedLock();
        try {
            Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.classPropertyIndex.get(className.toLowerCase());
            if (propertyIndex == null) {
                return;
            }
            for (Set<OIndex<?>> propertyIndexes : propertyIndex.values()) {
                for (OIndex<?> index : propertyIndexes) {
                    indexes.add(this.preProcessBeforeReturn(index));
                }
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndex<?> getClassIndex(String className, String indexName) {
        className = className.toLowerCase();
        OIndex<?> index = this.indexes.get(indexName = indexName.toLowerCase());
        if (index != null && index.getDefinition() != null && index.getDefinition().getClassName() != null && className.equals(index.getDefinition().getClassName().toLowerCase())) {
            return this.preProcessBeforeReturn(index);
        }
        return null;
    }

    protected void acquireSharedLock() {
        this.lock.readLock().lock();
    }

    protected void releaseSharedLock() {
        this.lock.readLock().unlock();
    }

    protected void acquireExclusiveLock() {
        OMetadataInternal metadata;
        ODatabaseDocumentInternal databaseRecord = this.getDatabaseIfDefined();
        if (databaseRecord != null && !databaseRecord.isClosed() && (metadata = (OMetadataInternal)databaseRecord.getMetadata()) != null) {
            metadata.makeThreadLocalSchemaSnapshot();
        }
        this.lock.writeLock().lock();
    }

    protected void releaseExclusiveLock() {
        OMetadata metadata;
        this.lock.writeLock().unlock();
        ODatabaseDocumentInternal databaseRecord = this.getDatabaseIfDefined();
        if (databaseRecord != null && !databaseRecord.isClosed() && (metadata = databaseRecord.getMetadata()) != null) {
            ((OMetadataInternal)metadata).clearThreadLocalSchemaSnapshot();
        }
    }

    protected void clearMetadata() {
        this.acquireExclusiveLock();
        try {
            this.indexes.clear();
            this.classPropertyIndex.clear();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    protected ODatabaseDocumentInternal getDatabaseIfDefined() {
        return ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addIndexInternal(OIndex<?> index) {
        this.acquireExclusiveLock();
        try {
            this.indexes.put(index.getName().toLowerCase(), index);
            OIndexDefinition indexDefinition = index.getDefinition();
            if (indexDefinition == null || indexDefinition.getClassName() == null) {
                return;
            }
            Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.classPropertyIndex.get(indexDefinition.getClassName().toLowerCase());
            if (propertyIndex == null) {
                propertyIndex = new HashMap();
                this.classPropertyIndex.put(indexDefinition.getClassName().toLowerCase(), propertyIndex);
            }
            int paramCount = indexDefinition.getParamCount();
            for (int i = 1; i <= paramCount; ++i) {
                List<String> fields = indexDefinition.getFields().subList(0, i);
                OMultiKey multiKey = new OMultiKey(this.normalizeFieldNames(fields));
                Set<OIndex<?>> indexSet = propertyIndex.get(multiKey);
                if (indexSet == null) {
                    indexSet = new HashSet();
                }
                indexSet.add(index);
                propertyIndex.put(multiKey, indexSet);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    protected List<String> normalizeFieldNames(Collection<String> fieldNames) {
        ArrayList<String> result = new ArrayList<String>(fieldNames.size());
        for (String fieldName : fieldNames) {
            result.add(fieldName.toLowerCase());
        }
        return result;
    }

    protected OIndex<?> preProcessBeforeReturn(OIndex<?> index) {
        if (!(this.getDatabase().getStorage() instanceof OStorageProxy)) {
            if (index instanceof OIndexMultiValues) {
                return new OIndexTxAwareMultiValue(this.getDatabase(), index);
            }
            if (index instanceof OIndexDictionary) {
                return new OIndexTxAwareDictionary(this.getDatabase(), (OIndex<OIdentifiable>)index);
            }
            if (index instanceof OIndexOneValue) {
                return new OIndexTxAwareOneValue(this.getDatabase(), (OIndex<OIdentifiable>)index);
            }
        }
        return index;
    }

    private OIndex<?> createDictionaryIfNeeded() {
        this.acquireExclusiveLock();
        try {
            OIndex<?> idx = this.getIndex(DICTIONARY_NAME);
            OIndex<?> oIndex = idx != null ? idx : this.createDictionary();
            return oIndex;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private OIndex<?> createDictionary() {
        return this.createIndex(DICTIONARY_NAME, OClass.INDEX_TYPE.DICTIONARY.toString(), new OSimpleKeyIndexDefinition(OType.STRING), null, null, null);
    }
}

