/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OIndexRIDContainer;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OIndexFullText
extends OIndexMultiValues {
    private static final String CONFIG_STOP_WORDS = "stopWords";
    private static final String CONFIG_SEPARATOR_CHARS = "separatorChars";
    private static final String CONFIG_IGNORE_CHARS = "ignoreChars";
    private static final String CONFIG_INDEX_RADIX = "indexRadix";
    private static final String CONFIG_MIN_WORD_LEN = "minWordLength";
    private static final boolean DEF_INDEX_RADIX = true;
    private static final String DEF_SEPARATOR_CHARS = " \r\n\t:;,.|+*/\\=!?[]()";
    private static final String DEF_IGNORE_CHARS = "'\"";
    private static final String DEF_STOP_WORDS = "the in a at as and or for his her him this that what which while up with be was were is";
    private static int DEF_MIN_WORD_LENGTH = 3;
    private boolean indexRadix;
    private String separatorChars;
    private String ignoreChars;
    private int minWordLength;
    private Set<String> stopWords;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexFullText(String typeId, String algorithm, OIndexEngine<Set<OIdentifiable>> indexEngine, String valueContainerAlgorithm, ODocument metadata) {
        super(typeId, algorithm, indexEngine, valueContainerAlgorithm, metadata);
        this.acquireExclusiveLock();
        try {
            this.config();
            this.configWithMetadata(metadata);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexFullText put(Object key, OIdentifiable iSingleValue) {
        this.checkForRebuild();
        if (key == null) {
            return this;
        }
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireExclusiveLock(key);
        }
        try {
            this.modificationLock.requestModificationLock();
            try {
                Set<String> words = this.splitIntoWords(key.toString());
                for (String word : words) {
                    this.acquireSharedLock();
                    this.startStorageAtomicOperation();
                    try {
                        Set refs = (Set)this.indexEngine.get(word);
                        if (refs == null) {
                            if ("SBTREEBONSAISET".equals(this.valueContainerAlgorithm)) {
                                boolean durable = false;
                                if (this.metadata != null && Boolean.TRUE.equals(this.metadata.field("durableInNonTxMode"))) {
                                    durable = true;
                                }
                                refs = new OIndexRIDContainer(this.getName(), durable);
                            } else {
                                refs = new OMVRBTreeRIDSet();
                                ((OMVRBTreeRIDSet)refs).setAutoConvertToRecord(false);
                            }
                        }
                        refs.add(iSingleValue);
                        this.indexEngine.put(word, refs);
                        this.commitStorageAtomicOperation();
                    }
                    catch (RuntimeException e) {
                        this.rollbackStorageAtomicOperation();
                        throw new OIndexException("Error during put of key - value entry", e);
                    }
                    finally {
                        this.releaseSharedLock();
                    }
                }
                OIndexFullText oIndexFullText = this;
                this.modificationLock.releaseModificationLock();
                return oIndexFullText;
            }
            catch (Throwable throwable) {
                this.modificationLock.releaseModificationLock();
                throw throwable;
            }
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseExclusiveLock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, OIdentifiable value) {
        this.checkForRebuild();
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireExclusiveLock(key);
        }
        try {
            this.modificationLock.requestModificationLock();
            try {
                Set<String> words = this.splitIntoWords(key.toString());
                boolean removed = false;
                for (String word : words) {
                    this.acquireSharedLock();
                    this.startStorageAtomicOperation();
                    try {
                        Set recs = (Set)this.indexEngine.get(word);
                        if (recs != null && !recs.isEmpty() && recs.remove(value)) {
                            if (recs.isEmpty()) {
                                this.indexEngine.remove(word);
                            } else {
                                this.indexEngine.put(word, recs);
                            }
                            removed = true;
                        }
                        this.commitStorageAtomicOperation();
                    }
                    catch (RuntimeException e) {
                        this.rollbackStorageAtomicOperation();
                        throw new OIndexException("Error during removal of entry by key and value", e);
                    }
                    finally {
                        this.releaseSharedLock();
                    }
                }
                boolean bl = removed;
                this.modificationLock.releaseModificationLock();
                return bl;
            }
            catch (Throwable throwable) {
                this.modificationLock.releaseModificationLock();
                throw throwable;
            }
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseExclusiveLock(key);
            }
        }
    }

    @Override
    public OIndexInternal<?> create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener, OStreamSerializer valueSerializer) {
        if (indexDefinition.getFields().size() > 1) {
            throw new OIndexException(this.type + " indexes cannot be used as composite ones.");
        }
        return super.create(name, indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, valueSerializer);
    }

    @Override
    public OIndexMultiValues create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        if (indexDefinition.getFields().size() > 1) {
            throw new OIndexException(this.type + " indexes cannot be used as composite ones.");
        }
        return super.create(name, indexDefinition, clusterIndexName, (Set)clustersToIndex, rebuild, progressListener);
    }

    @Override
    protected void doConfigurationUpdate(ODocument newConfig) {
        super.doConfigurationUpdate(newConfig);
        newConfig.field(CONFIG_SEPARATOR_CHARS, this.separatorChars);
        newConfig.field(CONFIG_IGNORE_CHARS, this.ignoreChars);
        newConfig.field(CONFIG_STOP_WORDS, this.stopWords);
        newConfig.field(CONFIG_MIN_WORD_LEN, this.minWordLength);
        newConfig.field(CONFIG_INDEX_RADIX, this.indexRadix);
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return false;
    }

    @Override
    public boolean supportsOrderedIterations() {
        return false;
    }

    protected void configWithMetadata(ODocument metadata) {
        if (metadata != null) {
            if (metadata.containsField(CONFIG_IGNORE_CHARS)) {
                this.ignoreChars = (String)metadata.field(CONFIG_IGNORE_CHARS);
            }
            if (metadata.containsField(CONFIG_INDEX_RADIX)) {
                this.indexRadix = (Boolean)metadata.field(CONFIG_INDEX_RADIX);
            }
            if (metadata.containsField(CONFIG_SEPARATOR_CHARS)) {
                this.separatorChars = (String)metadata.field(CONFIG_SEPARATOR_CHARS);
            }
            if (metadata.containsField(CONFIG_MIN_WORD_LEN)) {
                this.minWordLength = (Integer)metadata.field(CONFIG_MIN_WORD_LEN);
            }
            if (metadata.containsField(CONFIG_STOP_WORDS)) {
                this.stopWords = new HashSet<String>((Collection)metadata.field(CONFIG_STOP_WORDS));
            }
        }
    }

    protected void config() {
        this.ignoreChars = DEF_IGNORE_CHARS;
        this.indexRadix = true;
        this.separatorChars = DEF_SEPARATOR_CHARS;
        this.minWordLength = DEF_MIN_WORD_LENGTH;
        this.stopWords = new HashSet<String>(OStringSerializerHelper.split(DEF_STOP_WORDS, ' ', new char[0]));
    }

    @Override
    protected void putInSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        if (key == null) {
            return;
        }
        key = this.getCollatingValue(key);
        Set<String> words = this.splitIntoWords(key.toString());
        for (String word : words) {
            Object snapshotValue = snapshot.get(word);
            Object refs = snapshotValue == null ? (Set)this.indexEngine.get(word) : (snapshotValue.equals(OIndexAbstract.RemovedValue.INSTANCE) ? null : (Set)snapshotValue);
            if (refs == null) {
                if ("SBTREEBONSAISET".equals(this.valueContainerAlgorithm)) {
                    boolean durable = false;
                    if (this.metadata != null && Boolean.TRUE.equals(this.metadata.field("durableInNonTxMode"))) {
                        durable = true;
                    }
                    refs = new OIndexRIDContainer(this.getName(), durable);
                } else {
                    refs = new OMVRBTreeRIDSet();
                    ((OMVRBTreeRIDSet)refs).setAutoConvertToRecord(false);
                }
                snapshot.put(word, refs);
            }
            refs.add(value.getIdentity());
        }
    }

    @Override
    protected void removeFromSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        key = this.getCollatingValue(key);
        Set<String> words = this.splitIntoWords(key.toString());
        for (String word : words) {
            Object snapshotValue = snapshot.get(word);
            Object recs = snapshotValue == null ? (Set)this.indexEngine.get(word) : (snapshotValue.equals(OIndexAbstract.RemovedValue.INSTANCE) ? null : (Set)snapshotValue);
            if (recs == null || recs.isEmpty() || !recs.remove(value)) continue;
            if (recs.isEmpty()) {
                snapshot.put(word, OIndexAbstract.RemovedValue.INSTANCE);
                continue;
            }
            snapshot.put(word, recs);
        }
    }

    private Set<String> splitIntoWords(String iKey) {
        HashSet<String> result = new HashSet<String>();
        List words = (List)OStringSerializerHelper.split(new ArrayList<String>(), iKey, 0, -1, this.separatorChars, new char[0]);
        StringBuilder buffer = new StringBuilder(64);
        block0: for (String word : words) {
            buffer.setLength(0);
            for (int i = 0; i < word.length(); ++i) {
                char c = word.charAt(i);
                boolean ignore = false;
                for (int k = 0; k < this.ignoreChars.length(); ++k) {
                    if (c != this.ignoreChars.charAt(k)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                buffer.append(c);
            }
            for (int length = buffer.length(); length >= this.minWordLength; --length) {
                buffer.setLength(length);
                word = buffer.toString();
                if (!this.stopWords.contains(word)) {
                    result.add(word);
                }
                if (!this.indexRadix) continue block0;
            }
        }
        return result;
    }
}

