/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.concur.lock.OModificationLock;
import com.orientechnologies.common.concur.lock.ONewLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.annotation.ODocumentInstance;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.OIndexRebuildOutputListener;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public abstract class OIndexAbstract<T>
implements OIndexInternal<T> {
    protected static final String CONFIG_MAP_RID = "mapRid";
    protected static final String CONFIG_CLUSTERS = "clusters";
    protected final OModificationLock modificationLock = new OModificationLock();
    protected final OIndexEngine<T> indexEngine;
    private final String databaseName;
    protected String type;
    protected String valueContainerAlgorithm;
    protected final ONewLockManager<Object> keyLockManager = new ONewLockManager();
    @ODocumentInstance
    protected final AtomicReference<ODocument> configuration = new AtomicReference();
    protected ODocument metadata;
    private String name;
    private String algorithm;
    private Set<String> clustersToIndex = new HashSet<String>();
    private volatile OIndexDefinition indexDefinition;
    private volatile boolean rebuilding = false;
    private Thread rebuildThread = null;
    private final ThreadLocal<IndexTxSnapshot> txSnapshot = new IndexTxSnapshotThreadLocal();
    private final OReadersWriterSpinLock rwLock = new OReadersWriterSpinLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexAbstract(String type, String algorithm, OIndexEngine<T> indexEngine, String valueContainerAlgorithm, ODocument metadata) {
        this.acquireExclusiveLock();
        try {
            this.databaseName = ODatabaseRecordThreadLocal.INSTANCE.get().getName();
            this.type = type;
            this.indexEngine = indexEngine;
            this.algorithm = algorithm;
            this.metadata = metadata;
            this.valueContainerAlgorithm = valueContainerAlgorithm;
            indexEngine.init();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public static OIndexInternal.IndexMetadata loadMetadataInternal(ODocument config, String type, String algorithm, String valueContainerAlgorithm) {
        String indexName = (String)config.field("name");
        ODocument indexDefinitionDoc = (ODocument)config.field("indexDefinition");
        OIndexDefinition loadedIndexDefinition = null;
        if (indexDefinitionDoc != null) {
            try {
                String indexDefClassName = (String)config.field("indexDefinitionClass");
                Class<?> indexDefClass = Class.forName(indexDefClassName);
                loadedIndexDefinition = (OIndexDefinition)indexDefClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                loadedIndexDefinition.fromStream(indexDefinitionDoc);
            }
            catch (ClassNotFoundException e) {
                throw new OIndexException("Error during deserialization of index definition", e);
            }
            catch (NoSuchMethodException e) {
                throw new OIndexException("Error during deserialization of index definition", e);
            }
            catch (InvocationTargetException e) {
                throw new OIndexException("Error during deserialization of index definition", e);
            }
            catch (InstantiationException e) {
                throw new OIndexException("Error during deserialization of index definition", e);
            }
            catch (IllegalAccessException e) {
                throw new OIndexException("Error during deserialization of index definition", e);
            }
        } else {
            Boolean isAutomatic = (Boolean)config.field("automatic");
            if (Boolean.TRUE.equals(isAutomatic)) {
                int pos = indexName.lastIndexOf(46);
                if (pos < 0) {
                    throw new OIndexException("Can not convert from old index model to new one. Invalid index name. Dot (.) separator should be present.");
                }
                String className = indexName.substring(0, pos);
                String propertyName = indexName.substring(pos + 1);
                String keyTypeStr = (String)config.field("keyType");
                if (keyTypeStr == null) {
                    throw new OIndexException("Can not convert from old index model to new one. Index key type is absent.");
                }
                OType keyType = OType.valueOf(keyTypeStr.toUpperCase(Locale.ENGLISH));
                loadedIndexDefinition = new OPropertyIndexDefinition(className, propertyName, keyType);
                config.removeField("automatic");
                config.removeField("keyType");
            } else if (config.field("keyType") != null) {
                String keyTypeStr = (String)config.field("keyType");
                OType keyType = OType.valueOf(keyTypeStr.toUpperCase(Locale.ENGLISH));
                loadedIndexDefinition = new OSimpleKeyIndexDefinition(keyType);
                config.removeField("keyType");
            }
        }
        HashSet<String> clusters = new HashSet<String>((Collection)config.field(CONFIG_CLUSTERS, OType.EMBEDDEDSET));
        return new OIndexInternal.IndexMetadata(indexName, loadedIndexDefinition, clusters, type, algorithm, valueContainerAlgorithm);
    }

    @Override
    public void flush() {
        this.acquireSharedLock();
        try {
            this.indexEngine.flush();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean hasRangeQuerySupport() {
        this.acquireSharedLock();
        try {
            boolean bl = this.indexEngine.hasRangeQuerySupport();
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public OIndexInternal<?> create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener, OStreamSerializer valueSerializer) {
        this.acquireExclusiveLock();
        try {
            this.name = name;
            this.configuration.set(new ODocument());
            this.indexDefinition = indexDefinition;
            this.clustersToIndex = clustersToIndex != null ? new HashSet<String>(clustersToIndex) : new HashSet<String>();
            this.markStorageDirty();
            if (rebuild) {
                this.rebuild(progressListener);
            }
            this.updateConfiguration();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Exception during index %s creation.", (Throwable)e, name);
            try {
                this.indexEngine.delete();
            }
            catch (Exception ex) {
                OLogManager.instance().error((Object)this, "Exception during index %s deletion.", (Throwable)ex, name);
            }
            if (e instanceof OIndexException) {
                throw (OIndexException)e;
            }
            throw new OIndexException("Cannot create the index '" + name + "'", e);
        }
        finally {
            this.releaseExclusiveLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromConfiguration(ODocument config) {
        this.acquireExclusiveLock();
        try {
            this.configuration.set(config);
            this.clustersToIndex.clear();
            OIndexInternal.IndexMetadata indexMetadata = this.loadMetadata(this.configuration.get());
            this.name = indexMetadata.getName();
            this.indexDefinition = indexMetadata.getIndexDefinition();
            this.clustersToIndex.addAll(indexMetadata.getClustersToIndex());
            this.algorithm = indexMetadata.getAlgorithm();
            this.valueContainerAlgorithm = indexMetadata.getValueContainerAlgorithm();
            ORID rid = (ORID)config.field(CONFIG_MAP_RID, ORID.class);
            try {
                this.indexEngine.load(rid, this.name, this.indexDefinition, this.determineValueSerializer(), this.isAutomatic());
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "", new Object[0]);
                if (this.isAutomatic() && this.getStorage() instanceof OAbstractPaginatedStorage) {
                    OLogManager.instance().warn((Object)this, "Cannot load index '%s' from storage (rid=%s): rebuilt it from scratch", this.getName(), rid);
                }
                try {
                    this.indexEngine.deleteWithoutLoad(this.name);
                    this.indexEngine.create(this.indexDefinition, this.getDatabase().getMetadata().getIndexManager().getDefaultClusterName(), this.determineValueSerializer(), this.isAutomatic());
                    this.rebuild();
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Cannot rebuild index '%s' from storage (rid=%s) because '" + t + "'. The index will be removed in configuration", (Throwable)e, this.getName(), rid);
                    boolean bl = false;
                    this.releaseExclusiveLock();
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndexInternal.IndexMetadata loadMetadata(ODocument config) {
        return OIndexAbstract.loadMetadataInternal(config, this.type, this.algorithm, this.valueContainerAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object key) {
        this.checkForRebuild();
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireSharedLock(key);
        }
        try {
            this.acquireSharedLock();
            try {
                boolean bl = this.indexEngine.contains(key);
                this.releaseSharedLock();
                return bl;
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseSharedLock(key);
            }
        }
    }

    @Override
    public ORID getIdentity() {
        this.acquireSharedLock();
        try {
            ORID oRID = this.indexEngine.getIdentity();
            return oRID;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long rebuild() {
        return this.rebuild(new OIndexRebuildOutputListener(this));
    }

    @Override
    public void setRebuildingFlag() {
        this.rebuilding = true;
    }

    @Override
    public void close() {
        this.acquireSharedLock();
        try {
            this.indexEngine.close();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Object getFirstKey() {
        this.acquireSharedLock();
        try {
            Object object = this.indexEngine.getFirstKey();
            return object;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Object getLastKey() {
        this.acquireSharedLock();
        try {
            Object object = this.indexEngine.getLastKey();
            return object;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rebuild(OProgressListener iProgressListener) {
        long documentIndexed = 0L;
        boolean intentInstalled = this.getDatabase().declareIntent(new OIntentMassiveInsert());
        this.modificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.markStorageDirty();
                this.rebuildThread = Thread.currentThread();
                this.rebuilding = true;
                try {
                    this.indexEngine.deleteWithoutLoad(this.name);
                    this.removeValuesContainer();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.indexEngine.create(this.indexDefinition, this.getDatabase().getMetadata().getIndexManager().getDefaultClusterName(), this.determineValueSerializer(), this.isAutomatic());
                long documentNum = 0L;
                long documentTotal = 0L;
                for (String cluster : this.clustersToIndex) {
                    documentTotal += this.getDatabase().countClusterElements(cluster);
                }
                if (iProgressListener != null) {
                    iProgressListener.onBegin(this, documentTotal, true);
                }
                for (String clusterName : this.clustersToIndex) {
                    long[] metrics = this.indexCluster(clusterName, iProgressListener, documentNum, documentIndexed, documentTotal);
                    documentNum += metrics[0];
                    documentIndexed += metrics[1];
                }
                if (iProgressListener != null) {
                    iProgressListener.onCompletition(this, true);
                }
            }
            catch (Exception e) {
                if (iProgressListener != null) {
                    iProgressListener.onCompletition(this, false);
                }
                try {
                    this.indexEngine.clear();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw new OIndexException("Error on rebuilding the index for clusters: " + this.clustersToIndex, e);
            }
            finally {
                this.rebuilding = false;
                this.rebuildThread = null;
                if (intentInstalled) {
                    this.getDatabase().declareIntent(null);
                }
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
        return documentIndexed;
    }

    @Override
    public boolean remove(Object key, OIdentifiable value) {
        return this.remove(key);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean remove(Object key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void lockKeysForUpdateNoTx(Object ... key) {
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireExclusiveLocksInBatch((Object[])key);
        }
    }

    @Override
    public void lockKeysForUpdateNoTx(Collection<Object> keys) {
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireExclusiveLocksInBatch(keys);
        }
    }

    @Override
    public void releaseKeysForUpdateNoTx(Object ... key) {
        if (key == null) {
            return;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            for (Object k : key) {
                this.keyLockManager.releaseExclusiveLock(k);
            }
        }
    }

    @Override
    public void releaseKeysForUpdateNoTx(Collection<Object> keys) {
        if (keys == null) {
            return;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            for (Object k : keys) {
                this.keyLockManager.releaseExclusiveLock(k);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public OIndex<T> clear() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public OIndexInternal<T> delete() {
        this.modificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.markStorageDirty();
                this.indexEngine.delete();
                if (this.getDatabase().getMetadata() != null) {
                    this.getDatabase().getMetadata().getIndexManager().removeClassPropertyIndex(this);
                }
                this.removeValuesContainer();
                OIndexAbstract oIndexAbstract = this;
                this.releaseExclusiveLock();
                return oIndexAbstract;
            }
            catch (Throwable throwable) {
                this.releaseExclusiveLock();
                throw throwable;
            }
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public void deleteWithoutIndexLoad(String indexName) {
        this.modificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.markStorageDirty();
                this.indexEngine.deleteWithoutLoad(indexName);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public String getName() {
        this.acquireSharedLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String getType() {
        this.acquireSharedLock();
        try {
            String string = this.type;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String getAlgorithm() {
        this.acquireSharedLock();
        try {
            String string = this.algorithm;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public String toString() {
        this.acquireSharedLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexInternal<T> getInternal() {
        return this;
    }

    @Override
    public Set<String> getClusters() {
        this.acquireSharedLock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.clustersToIndex);
            return set;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexAbstract<T> addCluster(String clusterName) {
        this.acquireExclusiveLock();
        try {
            if (this.clustersToIndex.add(clusterName)) {
                this.updateConfiguration();
                this.indexCluster(clusterName, null, 0L, 0L, 0L);
            }
            OIndexAbstract oIndexAbstract = this;
            return oIndexAbstract;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndexAbstract<T> removeCluster(String iClusterName) {
        this.acquireExclusiveLock();
        try {
            if (this.clustersToIndex.remove(iClusterName)) {
                this.updateConfiguration();
                this.rebuild();
            }
            OIndexAbstract oIndexAbstract = this;
            return oIndexAbstract;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ODocument checkEntry(OIdentifiable iRecord, Object iKey) {
        return null;
    }

    @Override
    public final ODocument updateConfiguration() {
        ODocument newConfig;
        ODocument oldConfig;
        do {
            oldConfig = this.configuration.get();
            newConfig = new ODocument();
            oldConfig.copyTo(newConfig);
            newConfig.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            try {
                this.doConfigurationUpdate(newConfig);
            }
            finally {
                newConfig.setInternalStatus(ORecordElement.STATUS.LOADED);
            }
        } while (!this.configuration.compareAndSet(oldConfig, newConfig));
        return newConfig;
    }

    protected void doConfigurationUpdate(ODocument newConfig) {
        newConfig.field("type", this.type);
        newConfig.field("name", this.name);
        if (this.indexDefinition != null) {
            ODocument indexDefDocument = this.indexDefinition.toStream();
            if (!indexDefDocument.hasOwners()) {
                ODocumentInternal.addOwner(indexDefDocument, newConfig);
            }
            newConfig.field("indexDefinition", indexDefDocument, OType.EMBEDDED);
            newConfig.field("indexDefinitionClass", this.indexDefinition.getClass().getName());
        } else {
            newConfig.removeField("indexDefinition");
            newConfig.removeField("indexDefinitionClass");
        }
        newConfig.field(CONFIG_CLUSTERS, this.clustersToIndex, OType.EMBEDDEDSET);
        newConfig.field(CONFIG_MAP_RID, this.indexEngine.getIdentity());
        newConfig.field("algorithm", this.algorithm);
        newConfig.field("valueContainerAlgorithm", this.valueContainerAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTxOperation(ODocument operationDocument) {
        this.checkForRebuild();
        if (operationDocument == null) {
            return;
        }
        this.acquireSharedLock();
        try {
            IndexTxSnapshot indexTxSnapshot = this.txSnapshot.get();
            Boolean clearAll = (Boolean)operationDocument.field("clear");
            if (clearAll != null && clearAll.booleanValue()) {
                indexTxSnapshot.clear = true;
                indexTxSnapshot.indexSnapshot.clear();
            }
            Collection entries = (Collection)operationDocument.field("entries");
            Map<Object, Object> snapshot = indexTxSnapshot.indexSnapshot;
            for (ODocument entry : entries) {
                this.applyIndexTxEntry(snapshot, entry);
            }
            ODocument nullIndexEntry = (ODocument)operationDocument.field("nullEntries");
            this.applyIndexTxEntry(snapshot, nullIndexEntry);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void commit() {
        this.acquireSharedLock();
        try {
            IndexTxSnapshot indexTxSnapshot = this.txSnapshot.get();
            if (indexTxSnapshot.clear) {
                this.clear();
            }
            this.commitSnapshot(indexTxSnapshot.indexSnapshot);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void preCommit() {
        this.txSnapshot.set(new IndexTxSnapshot());
    }

    @Override
    public void postCommit() {
        this.txSnapshot.set(new IndexTxSnapshot());
    }

    @Override
    public ODocument getConfiguration() {
        this.acquireSharedLock();
        try {
            ODocument oDocument = this.configuration.get();
            return oDocument;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public ODocument getMetadata() {
        return (ODocument)this.getConfiguration().field("metadata", OType.EMBEDDED);
    }

    @Override
    public boolean isAutomatic() {
        this.acquireSharedLock();
        try {
            boolean bl = this.indexDefinition != null && this.indexDefinition.getClassName() != null;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OType[] getKeyTypes() {
        this.acquireSharedLock();
        try {
            if (this.indexDefinition == null) {
                OType[] oTypeArray = null;
                return oTypeArray;
            }
            OType[] oTypeArray = this.indexDefinition.getTypes();
            return oTypeArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            OIndexKeyCursor oIndexKeyCursor = this.indexEngine.keyCursor();
            return oIndexKeyCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexDefinition getDefinition() {
        return this.indexDefinition;
    }

    @Override
    public void freeze(boolean throwException) {
        this.modificationLock.prohibitModifications(throwException);
    }

    @Override
    public void release() {
        this.modificationLock.allowModifications();
    }

    @Override
    public void acquireModificationLock() {
        this.modificationLock.requestModificationLock();
    }

    @Override
    public void releaseModificationLock() {
        try {
            this.modificationLock.releaseModificationLock();
        }
        catch (IllegalMonitorStateException e) {
            OLogManager.instance().error((Object)this, "Error on releasing index lock against %s", (Throwable)e, this.getName());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        this.acquireSharedLock();
        try {
            if (this == o) {
                boolean bl = true;
                return bl;
            }
            if (o == null || this.getClass() != o.getClass()) {
                boolean bl = false;
                return bl;
            }
            OIndexAbstract that = (OIndexAbstract)o;
            if (!this.name.equals(that.name)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public int hashCode() {
        this.acquireSharedLock();
        try {
            int n = this.name.hashCode();
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public boolean isRebuiding() {
        return this.rebuilding;
    }

    protected void startStorageAtomicOperation() {
        try {
            this.getStorage().startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during start of atomic operation", e);
        }
    }

    protected void commitStorageAtomicOperation() {
        try {
            this.getStorage().commitAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during commit of atomic operation", e);
        }
    }

    protected void rollbackStorageAtomicOperation() {
        try {
            this.getStorage().rollbackAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during rollback of atomic operation", e);
        }
    }

    protected void markStorageDirty() {
        try {
            this.getStorage().markDirty();
        }
        catch (IOException e) {
            throw new OIndexException("Can not mark storage as dirty", e);
        }
    }

    protected abstract OStreamSerializer determineValueSerializer();

    protected void populateIndex(ODocument doc, Object fieldValue) {
        if (fieldValue instanceof Collection) {
            for (Object fieldValueItem : (Collection)fieldValue) {
                this.put(fieldValueItem, doc);
            }
        } else {
            this.put(fieldValue, doc);
        }
    }

    @Override
    public Object getCollatingValue(Object key) {
        if (key != null && this.getDefinition() != null) {
            return this.getDefinition().getCollate().transform(key);
        }
        return key;
    }

    protected abstract void commitSnapshot(Map<Object, Object> var1);

    protected abstract void putInSnapshot(Object var1, OIdentifiable var2, Map<Object, Object> var3);

    protected abstract void removeFromSnapshot(Object var1, OIdentifiable var2, Map<Object, Object> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compareTo(OIndex<T> index) {
        this.acquireSharedLock();
        try {
            String name = index.getName();
            int n = this.name.compareTo(name);
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    protected void removeFromSnapshot(Object key, Map<Object, Object> snapshot) {
        key = this.getCollatingValue(key);
        snapshot.put(key, RemovedValue.INSTANCE);
    }

    protected void checkForKeyType(Object iKey) {
        if (this.indexDefinition == null) {
            OType type = OType.getTypeByClass(iKey.getClass());
            if (type == null) {
                return;
            }
            this.indexDefinition = new OSimpleKeyIndexDefinition(type);
            this.updateConfiguration();
        }
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    protected void checkForRebuild() {
        if (this.rebuilding && !Thread.currentThread().equals(this.rebuildThread)) {
            throw new OIndexException("Index " + this.name + " is rebuilding now and can not be used.");
        }
    }

    protected long[] indexCluster(String clusterName, OProgressListener iProgressListener, long documentNum, long documentIndexed, long documentTotal) {
        try {
            for (ORecord record : this.getDatabase().browseCluster(clusterName)) {
                if (Thread.interrupted()) {
                    throw new OCommandExecutionException("The index rebuild has been interrupted");
                }
                if (record instanceof ODocument) {
                    ODocument doc = (ODocument)record;
                    if (this.indexDefinition == null) {
                        throw new OConfigurationException("Index '" + this.name + "' cannot be rebuilt because has no a valid definition (" + this.indexDefinition + ")");
                    }
                    Object fieldValue = this.indexDefinition.getDocumentValueToIndex(doc);
                    if (fieldValue != null) {
                        try {
                            this.populateIndex(doc, fieldValue);
                        }
                        catch (OIndexException e) {
                            OLogManager.instance().error((Object)this, "Exception during index rebuild. Exception was caused by following key/ value pair - key %s, value %s. Rebuild will continue from this point.", (Throwable)e, fieldValue, doc.getIdentity());
                        }
                        ++documentIndexed;
                    }
                }
                ++documentNum;
                if (iProgressListener == null) continue;
                iProgressListener.onProgress(this, documentNum, (float)((double)documentNum * 100.0 / (double)documentTotal));
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        return new long[]{documentNum, documentIndexed};
    }

    private OAbstractPaginatedStorage getStorage() {
        return (OAbstractPaginatedStorage)this.getDatabase().getStorage().getUnderlying();
    }

    protected void releaseExclusiveLock() {
        this.rwLock.releaseWriteLock();
    }

    protected void acquireExclusiveLock() {
        this.rwLock.acquireWriteLock();
    }

    protected void releaseSharedLock() {
        this.rwLock.releaseReadLock();
    }

    protected void acquireSharedLock() {
        this.rwLock.acquireReadLock();
    }

    private void removeValuesContainer() {
        OAbstractPaginatedStorage storage;
        if (this.valueContainerAlgorithm.equals("SBTREEBONSAISET") && (storage = this.getStorage()) instanceof OAbstractPaginatedStorage) {
            OAtomicOperation atomicOperation = storage.getAtomicOperationsManager().getCurrentOperation();
            ODiskCache diskCache = storage.getDiskCache();
            if (atomicOperation == null) {
                try {
                    String fileName = this.getName() + ".irs";
                    if (diskCache.exists(fileName)) {
                        long fileId = diskCache.openFile(fileName);
                        diskCache.deleteFile(fileId);
                    }
                }
                catch (IOException e) {
                    OLogManager.instance().error((Object)this, "Can't delete file for value containers", (Throwable)e, new Object[0]);
                }
            } else {
                try {
                    String fileName = this.getName() + ".irs";
                    if (atomicOperation.isFileExists(fileName, diskCache)) {
                        long fileId = atomicOperation.openFile(fileName, diskCache);
                        atomicOperation.deleteFile(fileId, diskCache);
                    }
                }
                catch (IOException e) {
                    OLogManager.instance().error((Object)this, "Can't delete file for value containers", (Throwable)e, new Object[0]);
                }
            }
        }
    }

    private void applyIndexTxEntry(Map<Object, Object> snapshot, ODocument entry) {
        List operations;
        Object key;
        if (entry.field("k") != null) {
            Object serKey = entry.field("k");
            try {
                ODocument keyContainer = null;
                if (serKey instanceof String) {
                    String serializedKey = OStringSerializerHelper.decode((String)serKey);
                    keyContainer = new ODocument();
                    keyContainer.setLazyLoad(false);
                    ORecordSerializerSchemaAware2CSV.INSTANCE.fromString(serializedKey, keyContainer, null);
                } else if (serKey instanceof ODocument) {
                    keyContainer = (ODocument)serKey;
                }
                Object storedKey = keyContainer.field("key");
                if (storedKey instanceof List) {
                    key = new OCompositeKey((List)storedKey);
                }
                if (Boolean.TRUE.equals(keyContainer.field("binary"))) {
                    key = OStreamSerializerAnyStreamable.INSTANCE.fromStream((byte[])storedKey);
                }
                key = storedKey;
            }
            catch (IOException ioe) {
                throw new OTransactionException("Error during index changes deserialization. ", ioe);
            }
        } else {
            key = null;
        }
        if ((operations = (List)entry.field("ops")) != null) {
            for (ODocument op : operations) {
                op.setLazyLoad(false);
                int operation = (Integer)op.rawField("o");
                OIdentifiable value = (OIdentifiable)op.field("v");
                if (operation == OTransactionIndexChanges.OPERATION.PUT.ordinal()) {
                    this.putInSnapshot(key, value, snapshot);
                    continue;
                }
                if (operation != OTransactionIndexChanges.OPERATION.REMOVE.ordinal()) continue;
                if (value == null) {
                    this.removeFromSnapshot(key, snapshot);
                    continue;
                }
                this.removeFromSnapshot(key, value, snapshot);
            }
        }
    }

    private static class IndexTxSnapshotThreadLocal
    extends ThreadLocal<IndexTxSnapshot> {
        private IndexTxSnapshotThreadLocal() {
        }

        @Override
        protected IndexTxSnapshot initialValue() {
            return new IndexTxSnapshot();
        }
    }

    protected static final class IndexTxSnapshot {
        public Map<Object, Object> indexSnapshot = new HashMap<Object, Object>();
        public boolean clear = false;

        protected IndexTxSnapshot() {
        }
    }

    protected static final class RemovedValue {
        public static final RemovedValue INSTANCE = new RemovedValue();

        protected RemovedValue() {
        }
    }
}

