/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.fetch;

import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OFetchPlan {
    static final String ROOT_FETCH = "*";
    final Map<String, Integer> fetchPlan = new HashMap<String, Integer>();
    final Map<String, Integer> fetchPlanStartsWith = new HashMap<String, Integer>();

    public OFetchPlan(String iFetchPlan) {
        List<String> planParts;
        this.fetchPlan.put(ROOT_FETCH, 0);
        if (iFetchPlan != null && !iFetchPlan.isEmpty() && !(planParts = OStringSerializerHelper.split(iFetchPlan, ' ', new char[0])).isEmpty()) {
            for (String planPart : planParts) {
                List<String> parts = OStringSerializerHelper.split(planPart, ':', new char[0]);
                if (parts.size() != 2) {
                    throw new IllegalArgumentException("Wrong fetch plan: " + planPart);
                }
                String key = parts.get(0);
                if (key.length() > 1 && key.endsWith(ROOT_FETCH)) {
                    this.fetchPlanStartsWith.put(key.substring(0, key.length() - 1), Integer.parseInt(parts.get(1)));
                    continue;
                }
                this.fetchPlan.put(key, Integer.parseInt(parts.get(1)));
            }
        }
    }

    public int getDepthLevel(String iFieldPath) {
        Integer depthLevel = this.fetchPlan.get(ROOT_FETCH);
        for (String string : this.fetchPlan.keySet()) {
            if (iFieldPath.equals(string)) {
                return this.fetchPlan.get(string);
            }
            if (!string.startsWith(iFieldPath)) continue;
            return 1;
        }
        for (Map.Entry entry : this.fetchPlanStartsWith.entrySet()) {
            if (!iFieldPath.startsWith((String)entry.getKey())) continue;
            return (Integer)entry.getValue();
        }
        return depthLevel;
    }

    public boolean has(String iFieldPath) {
        for (String string : this.fetchPlan.keySet()) {
            if (iFieldPath.equals(string)) {
                return true;
            }
            if (!string.startsWith(iFieldPath)) continue;
            return true;
        }
        for (Map.Entry entry : this.fetchPlanStartsWith.entrySet()) {
            if (!iFieldPath.startsWith((String)entry.getKey())) continue;
            return true;
        }
        return false;
    }
}

