/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.engine.local;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.engine.OEngineAbstract;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.File;
import java.util.Map;

public class OEngineLocalPaginated
extends OEngineAbstract {
    public static final String NAME = "plocal";

    @Override
    public OStorage createStorage(String dbName, Map<String, String> configuration) {
        try {
            return new OLocalPaginatedStorage(dbName, dbName, this.getMode(configuration));
        }
        catch (Throwable t) {
            OLogManager.instance().error((Object)this, "Error on opening database: " + dbName + ". Current location is: " + new File(".").getAbsolutePath(), t, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isShared() {
        return true;
    }
}

