/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record.ridbag;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.DoubleReferenceItem;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsaiLocal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OBonsaiTreeRepair {
    public void repairDatabaseRidbags(ODatabaseDocumentTx db) {
        Set<String> clusters = db.getStorage().getClusterNames();
        for (String clusterName : clusters) {
            ArrayList<DoubleReferenceItem> doubles = new ArrayList<DoubleReferenceItem>();
            HashMap map = new HashMap();
            for (ORecord oRecord : db.browseCluster(clusterName)) {
                try {
                    if (!(oRecord instanceof ODocument)) continue;
                    ODocument doc = (ODocument)oRecord;
                    for (String fieldName : doc.fieldNames()) {
                        ORidBag ridBag;
                        Object fieldValue = doc.rawField(fieldName);
                        if (!(fieldValue instanceof ORidBag) || !(ridBag = (ORidBag)fieldValue).getPointer().isValid()) continue;
                        OSBTreeBonsaiLocal tree = (OSBTreeBonsaiLocal)db.getSbTreeCollectionManager().loadSBTree(ridBag.getPointer());
                        long fileId = tree.getFileId();
                        List<OBonsaiBucketPointer> buckets = tree.listBuckets();
                        for (OBonsaiBucketPointer oBonsaiBucketPointer : buckets) {
                            HashMap<ORidBag, String> refBag = (HashMap<ORidBag, String>)map.get(oBonsaiBucketPointer);
                            if (refBag != null) {
                                for (Map.Entry entry : refBag.entrySet()) {
                                    DoubleReferenceItem ref = new DoubleReferenceItem(fieldName, ridBag, (String)entry.getValue(), (ORidBag)entry.getKey(), oBonsaiBucketPointer);
                                    doubles.add(ref);
                                }
                            } else {
                                refBag = new HashMap<ORidBag, String>();
                            }
                            refBag.put(ridBag, fieldName);
                            map.put(oBonsaiBucketPointer, refBag);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (DoubleReferenceItem doubleReferenceItem : doubles) {
                try {
                    ORidBag ridBagOne = doubleReferenceItem.getRidBagOne();
                    ODocument docOne = (ODocument)ridBagOne.getDelegate().getOwner();
                    OSBTreeBonsaiLocal tree = (OSBTreeBonsaiLocal)db.getSbTreeCollectionManager().loadSBTree(ridBagOne.getPointer());
                    tree.removeBucketsFromFreeList();
                    tree.clear();
                    ORidBag ridBagTwo = doubleReferenceItem.getRidBagTwo();
                    OSBTreeBonsaiLocal tree2 = (OSBTreeBonsaiLocal)db.getSbTreeCollectionManager().loadSBTree(ridBagOne.getPointer());
                    tree2.removeBucketsFromFreeList();
                    tree2.clear();
                    ODocument docTwo = (ODocument)ridBagTwo.getDelegate().getOwner();
                    List<ODocument> list = this.regenerateRidBag(docOne, doubleReferenceItem.getFieldNameOne(), db);
                    for (ODocument oDocument : list) {
                        ridBagOne.add((OIdentifiable)oDocument.field("res"));
                    }
                    db.save(docOne);
                    List<ODocument> list1 = this.regenerateRidBag(docTwo, doubleReferenceItem.getFieldNameTwo(), db);
                    for (ODocument oDocument : list1) {
                        ridBagTwo.add((OIdentifiable)oDocument.field("res"));
                    }
                    db.save(docTwo);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private List<ODocument> regenerateRidBag(ODocument docOne, String fieldNameOne, ODatabaseDocumentTx db) {
        OClass linkClass;
        OClass clazzOne = ODocumentInternal.getImmutableSchemaClass(docOne);
        OProperty prop = clazzOne.getProperty(fieldNameOne);
        String className = null;
        if (prop != null && (linkClass = prop.getLinkedClass()) != null) {
            className = linkClass.getName();
        }
        if (className == null) {
            className = OBonsaiTreeRepair.getEdgeLabel(fieldNameOne);
        }
        String fieldInEdge = OBonsaiTreeRepair.getEdgeField(fieldNameOne);
        String query = " select @rid as res from " + className + "  where " + fieldInEdge + " = " + docOne.getIdentity() + " ";
        Object res = db.query(new OSQLSynchQuery(query), new Object[0]);
        return res;
    }

    public static String getEdgeField(String iConnectionField) {
        if (iConnectionField.startsWith("out_")) {
            return "out";
        }
        if (iConnectionField.startsWith("in_")) {
            return "in";
        }
        return null;
    }

    public static String getEdgeLabel(String iConnectionField) {
        if (iConnectionField.startsWith("out_")) {
            return iConnectionField.substring("out_".length());
        }
        if (iConnectionField.startsWith("in_")) {
            return iConnectionField.substring("in_".length());
        }
        return null;
    }
}

