/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.db.document.ODocumentFieldVisitor;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class ODocumentFieldWalker {
    public void walkDocument(ODocument document, ODocumentFieldVisitor fieldWalker) {
        Set<ODocument> walked = Collections.newSetFromMap(new IdentityHashMap());
        this.walkDocument(document, fieldWalker, walked);
        walked.clear();
    }

    private void walkDocument(ODocument document, ODocumentFieldVisitor fieldWalker, Set<ODocument> walked) {
        if (walked.contains(document)) {
            return;
        }
        walked.add(document);
        boolean oldLazyLoad = document.isLazyLoad();
        document.setLazyLoad(false);
        boolean updateMode = fieldWalker.updateMode();
        OClass clazz = ODocumentInternal.getImmutableSchemaClass(document);
        for (String fieldName : document.fieldNames()) {
            OProperty property;
            OType concreteType;
            OType fieldType = concreteType = document.fieldType(fieldName);
            OType linkedType = null;
            if (fieldType == null && clazz != null && (property = clazz.getProperty(fieldName)) != null) {
                fieldType = property.getType();
                linkedType = property.getLinkedType();
            }
            Object fieldValue = document.field(fieldName, fieldType);
            Object newValue = fieldWalker.visitField(fieldType, linkedType, fieldValue);
            boolean updated = updateMode ? this.updateFieldValueIfChanged(document, fieldName, fieldValue, newValue, concreteType) : false;
            if (!(updated || fieldValue == null || OType.LINK.equals((Object)fieldType) || OType.LINKBAG.equals((Object)fieldType) || OType.LINKLIST.equals((Object)fieldType) || OType.LINKSET.equals((Object)fieldType) || fieldValue instanceof ORecordLazyMultiValue || !fieldWalker.goDeeper(fieldType, linkedType, fieldValue))) {
                if (fieldValue instanceof Map) {
                    this.walkMap((Map)fieldValue, fieldType, fieldWalker, walked);
                } else if (OMultiValue.isIterable(fieldValue)) {
                    this.walkIterable(OMultiValue.getMultiValueIterable(fieldValue), fieldType, fieldWalker, walked);
                } else if (fieldValue instanceof ODocument) {
                    ODocument doc = (ODocument)fieldValue;
                    if (OType.EMBEDDED.equals((Object)fieldType) || doc.isEmbedded()) {
                        this.walkDocument((ODocument)fieldValue, fieldWalker);
                    }
                }
            }
            if (fieldWalker.goFurther(fieldType, linkedType, fieldValue, newValue)) continue;
            document.setLazyLoad(oldLazyLoad);
            return;
        }
        document.setLazyLoad(oldLazyLoad);
    }

    private void walkMap(Map map, OType fieldType, ODocumentFieldVisitor fieldWalker, Set<ODocument> walked) {
        for (Object value : map.values()) {
            if (!(value instanceof ODocument)) continue;
            ODocument doc = (ODocument)value;
            if (!OType.EMBEDDEDMAP.equals((Object)fieldType) && !doc.isEmbedded()) continue;
            this.walkDocument((ODocument)value, fieldWalker, walked);
        }
    }

    private void walkIterable(Iterable iterable, OType fieldType, ODocumentFieldVisitor fieldWalker, Set<ODocument> walked) {
        for (Object value : iterable) {
            if (!(value instanceof ODocument)) continue;
            ODocument doc = (ODocument)value;
            if (!OType.EMBEDDEDLIST.equals((Object)fieldType) && !OType.EMBEDDEDSET.equals((Object)fieldType) && !doc.isEmbedded()) continue;
            this.walkDocument((ODocument)value, fieldWalker, walked);
        }
    }

    private boolean updateFieldValueIfChanged(ODocument document, String fieldName, Object fieldValue, Object newValue, OType concreteType) {
        if (fieldValue != newValue) {
            document.field(fieldName, newValue, concreteType);
            return true;
        }
        return false;
    }
}

