/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.listener.OListenerManger;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCacheLevelOneLocatorImpl;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OHookReplacedRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OClassTrigger;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.ORidBagDeleteHook;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManagerProxy;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OTransactionBlockedException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.hook.OHookThreadLocal;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.function.OFunctionTrigger;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.OImmutableUser;
import com.orientechnologies.orient.core.metadata.security.ORestrictedAccessHook;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OSecurityTrackerHook;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.metadata.security.OUserTrigger;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.schedule.OSchedulerTrigger;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationSetThreadLocal;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OOfflineClusterException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.Callable;

public class ODatabaseDocumentTx
extends OListenerManger<ODatabaseListener>
implements ODatabaseDocumentInternal {
    @Deprecated
    private static final String DEF_RECORD_FORMAT = "csv";
    protected static ORecordSerializer defaultSerializer = ORecordSerializerFactory.instance().getFormat(OGlobalConfiguration.DB_DOCUMENT_SERIALIZER.getValueAsString());
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<ORecordHook, ORecordHook.HOOK_POSITION> unmodifiableHooks;
    protected ORecordSerializer serializer;
    private String url;
    private OStorage storage;
    private ODatabase.STATUS status;
    private OIntent currentIntent;
    private ODatabaseInternal<?> databaseOwner;
    private OSBTreeCollectionManager sbTreeCollectionManager;
    private OMetadataDefault metadata;
    private OImmutableUser user;
    private byte recordType;
    @Deprecated
    private String recordFormat;
    private Map<ORecordHook, ORecordHook.HOOK_POSITION> hooks = new LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION>();
    private boolean retainRecords = true;
    private OLocalRecordCache localCache;
    private boolean mvcc;
    private boolean validation;
    private OCurrentStorageComponentsFactory componentsFactory;
    private boolean initialized = false;
    private OTransaction currentTx;
    private boolean keepStorageOpen = false;

    public ODatabaseDocumentTx(String iURL) {
        this(iURL, false);
    }

    public ODatabaseDocumentTx(String iURL, boolean keepStorageOpen) {
        super(false);
        if (iURL == null) {
            throw new IllegalArgumentException("URL parameter is null");
        }
        try {
            this.keepStorageOpen = keepStorageOpen;
            this.url = iURL.replace('\\', '/');
            this.status = ODatabase.STATUS.CLOSED;
            this.setProperty("fetch-max", 50);
            this.storage = Orient.instance().loadStorage(this.url);
            this.unmodifiableHooks = Collections.unmodifiableMap(this.hooks);
            this.recordType = (byte)100;
            this.localCache = new OLocalRecordCache(new OCacheLevelOneLocatorImpl());
            this.mvcc = OGlobalConfiguration.DB_MVCC.getValueAsBoolean();
            this.validation = OGlobalConfiguration.DB_VALIDATION.getValueAsBoolean();
            this.init();
            this.databaseOwner = this;
        }
        catch (Throwable t) {
            if (this.storage != null) {
                Orient.instance().unregisterStorage(this.storage);
            }
            throw new ODatabaseException("Error on opening database '" + iURL + "'", t);
        }
        this.setSerializer(defaultSerializer);
    }

    public static ORecordSerializer getDefaultSerializer() {
        return defaultSerializer;
    }

    public static void setDefaultSerializer(ORecordSerializer iDefaultSerializer) {
        defaultSerializer = iDefaultSerializer;
    }

    @Override
    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        this.setCurrentDatabaseInThreadLocal();
        try {
            String name;
            if (this.status == ODatabase.STATUS.OPEN) {
                throw new IllegalStateException("Database " + this.getName() + " is already open");
            }
            if (this.user != null && !this.user.getName().equals(iUserName)) {
                this.initialized = false;
            }
            if (this.storage.isClosed()) {
                this.storage.open(iUserName, iUserPassword, this.properties);
            } else if (this.storage instanceof OStorageProxy && !(name = ((OStorageProxy)this.storage).getUserName()).equals(iUserName)) {
                this.storage.close();
                this.storage.open(iUserName, iUserPassword, this.properties);
            }
            this.status = ODatabase.STATUS.OPEN;
            this.initAtFirstOpen(iUserName, iUserPassword);
            if (!(this.getStorage() instanceof OStorageProxy)) {
                OSecurity security = this.metadata.getSecurity();
                if (this.user == null || this.user.getVersion() != security.getVersion() || !this.user.getName().equalsIgnoreCase(iUserName)) {
                    OUser usr = this.metadata.getSecurity().authenticate(iUserName, iUserPassword);
                    this.user = usr != null ? new OImmutableUser(security.getVersion(), usr) : null;
                    this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_READ, new Object[0]);
                }
            }
            this.callOnOpenListeners();
        }
        catch (OException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new ODatabaseException("Cannot open database", e);
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase> DB open(OToken iToken) {
        this.setCurrentDatabaseInThreadLocal();
        try {
            if (this.status == ODatabase.STATUS.OPEN) {
                throw new IllegalStateException("Database " + this.getName() + " is already open");
            }
            if (this.user != null && !this.user.getIdentity().equals(iToken.getUserId())) {
                this.initialized = false;
            }
            if (this.storage instanceof OStorageProxy) {
                throw new ODatabaseException("Cannot use a token open on remote database");
            }
            if (this.storage.isClosed()) {
                this.storage.open("", "", this.properties);
            }
            this.status = ODatabase.STATUS.OPEN;
            this.initAtFirstOpen(null, null);
            OSecurity security = this.metadata.getSecurity();
            if (this.user == null || this.user.getVersion() != security.getVersion()) {
                OUser usr = this.metadata.getSecurity().authenticate(iToken);
                this.user = usr != null ? new OImmutableUser(security.getVersion(), usr) : null;
                this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_READ, new Object[0]);
            }
            this.callOnOpenListeners();
        }
        catch (OException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new ODatabaseException("Cannot open database", e);
        }
        return (DB)this;
    }

    public void callOnOpenListeners() {
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onOpen(this.getDatabaseOwner());
        }
        for (ODatabaseListener listener : this.getListenersCopy()) {
            try {
                listener.onOpen(this.getDatabaseOwner());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public <DB extends ODatabase> DB create() {
        return this.create(null);
    }

    @Override
    public <DB extends ODatabase> DB create(Map<OGlobalConfiguration, Object> iInitialSettings) {
        this.setCurrentDatabaseInThreadLocal();
        try {
            if (this.status == ODatabase.STATUS.OPEN) {
                throw new IllegalStateException("Database " + this.getName() + " is already open");
            }
            if (this.storage == null) {
                this.storage = Orient.instance().loadStorage(this.url);
            }
            if (iInitialSettings != null) {
                OContextConfiguration ctxCfg = this.storage.getConfiguration().getContextConfiguration();
                for (Map.Entry<OGlobalConfiguration, Object> e : iInitialSettings.entrySet()) {
                    ctxCfg.setValue(e.getKey(), e.getValue());
                }
            }
            this.storage.create(this.properties);
            this.status = ODatabase.STATUS.OPEN;
            this.componentsFactory = this.getStorage().getComponentsFactory();
            this.sbTreeCollectionManager = new OSBTreeCollectionManagerProxy(this, this.getStorage().getResource(OSBTreeCollectionManager.class.getSimpleName(), new Callable<OSBTreeCollectionManager>(){

                @Override
                public OSBTreeCollectionManager call() throws Exception {
                    Class<? extends OSBTreeCollectionManager> managerClass = ODatabaseDocumentTx.this.getStorage().getCollectionManagerClass();
                    if (managerClass == null) {
                        OLogManager.instance().warn((Object)this, "Current implementation of storage does not support sbtree collections", new Object[0]);
                        return null;
                    }
                    return managerClass.newInstance();
                }
            }));
            this.localCache.startup();
            this.getStorage().getConfiguration().setRecordSerializer(this.getSerializer().toString());
            this.getStorage().getConfiguration().setRecordSerializerVersion(this.getSerializer().getCurrentVersion());
            this.getStorage().getConfiguration().update();
            if (!(this.getStorage() instanceof OStorageProxy)) {
                this.installHooks();
            }
            this.metadata = new OMetadataDefault();
            this.metadata.create();
            this.registerHook(new OSecurityTrackerHook(this.metadata.getSecurity()), ORecordHook.HOOK_POSITION.LAST);
            OUser usr = this.getMetadata().getSecurity().getUser("admin");
            this.user = usr == null ? null : new OImmutableUser(this.getMetadata().getSecurity().getVersion(), usr);
            if (!this.metadata.getSchema().existsClass("ORIDs")) {
                this.metadata.getSchema().createClass("ORIDs");
            }
            if (OGlobalConfiguration.DB_MAKE_FULL_CHECKPOINT_ON_SCHEMA_CHANGE.getValueAsBoolean()) {
                this.metadata.getSchema().setFullCheckpointOnChange(true);
            }
            if (OGlobalConfiguration.DB_MAKE_FULL_CHECKPOINT_ON_INDEX_CHANGE.getValueAsBoolean()) {
                this.metadata.getIndexManager().setFullCheckpointOnChange(true);
            }
            this.getStorage().synch();
            Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onCreate(this.getDatabaseOwner());
            }
            for (ODatabaseListener listener : this.browseListeners()) {
                try {
                    listener.onCreate(this);
                }
                catch (Throwable ignore) {}
            }
        }
        catch (Exception e) {
            throw new ODatabaseException("Cannot create database '" + this.getName() + "'", e);
        }
        return (DB)this;
    }

    public boolean isKeepStorageOpen() {
        return this.keepStorageOpen;
    }

    @Override
    public void drop() {
        this.checkOpeness();
        this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_DELETE, new Object[0]);
        this.setCurrentDatabaseInThreadLocal();
        this.callOnCloseListeners();
        if (this.metadata != null) {
            this.metadata.close();
            this.metadata = null;
        }
        Iterable tmpListeners = this.getListenersCopy();
        this.closeOnDelete();
        try {
            if (this.storage == null) {
                this.storage = Orient.instance().loadStorage(this.url);
            }
            this.storage.delete();
            this.storage = null;
            for (ODatabaseListener listener : tmpListeners) {
                try {
                    listener.onDelete(this);
                }
                catch (Throwable t) {}
            }
            this.status = ODatabase.STATUS.CLOSED;
            ODatabaseRecordThreadLocal.INSTANCE.remove();
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ODatabaseException("Cannot delete database", e);
        }
    }

    public void callOnCloseListeners() {
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onClose(this.getDatabaseOwner());
        }
        for (ODatabaseListener listener : this.getListenersCopy()) {
            try {
                listener.onClose(this.getDatabaseOwner());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public <RET extends ORecord> RET getRecord(OIdentifiable iIdentifiable) {
        if (iIdentifiable instanceof ORecord) {
            return (RET)((ORecord)iIdentifiable);
        }
        return (RET)this.load(iIdentifiable.getIdentity());
    }

    @Override
    public void reload() {
        if (this.isClosed()) {
            throw new ODatabaseException("Cannot reload a closed db");
        }
        this.metadata.reload();
        this.storage.reload();
    }

    @Override
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecordId, null, iFetchPlan, iIgnoreCache, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public ODatabase<ORecord> delete(ORID iRecord, ORecordVersion iVersion) {
        this.executeDeleteRecord(iRecord, iVersion, true, true, ODatabase.OPERATION_MODE.SYNCHRONOUS, false);
        return this;
    }

    @Override
    public ODatabase<ORecord> cleanOutRecord(ORID iRecord, ORecordVersion iVersion) {
        this.executeDeleteRecord(iRecord, iVersion, true, true, ODatabase.OPERATION_MODE.SYNCHRONOUS, true);
        return this;
    }

    @Override
    public ORecord getRecordByUserObject(Object iUserObject, boolean iCreateIfNotAvailable) {
        return (ORecord)iUserObject;
    }

    @Override
    public void registerUserObject(Object iObject, ORecord iRecord) {
    }

    @Override
    public void registerUserObjectAfterLinkSave(ORecord iRecord) {
    }

    @Override
    public Object getUserObjectByRecord(OIdentifiable record, String iFetchPlan) {
        return record;
    }

    @Override
    public boolean existsUserObjectByRID(ORID iRID) {
        return true;
    }

    @Override
    public String getType() {
        return "document";
    }

    public ODatabaseDocument delete(ORID iRecord, ODatabase.OPERATION_MODE iMode) {
        Object record = iRecord.getRecord();
        if (record == null) {
            return this;
        }
        this.delete((ORecord)record, iMode);
        return this;
    }

    public ODatabaseDocument delete(ORecord iRecord, ODatabase.OPERATION_MODE iMode) {
        this.currentTx.deleteRecord(iRecord, iMode);
        return this;
    }

    @Override
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iClass) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseInThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId, true);
    }

    @Override
    @Deprecated
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iRecordClass, long startClusterPosition, long endClusterPosition, boolean loadTombstones) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseInThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId, startClusterPosition, endClusterPosition, true, loadTombstones, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iRecordClass, long startClusterPosition, long endClusterPosition) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseInThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId, startClusterPosition, endClusterPosition, true);
    }

    @Override
    public OCommandRequest command(OCommandRequest iCommand) {
        this.checkSecurity(ORule.ResourceGeneric.COMMAND, ORole.PERMISSION_READ, new Object[0]);
        this.setCurrentDatabaseInThreadLocal();
        OCommandRequestInternal command = (OCommandRequestInternal)iCommand;
        try {
            command.reset();
            return command;
        }
        catch (Exception e) {
            throw new ODatabaseException("Error on command execution", e);
        }
    }

    @Override
    public <RET extends List<?>> RET query(OQuery<?> iCommand, Object ... iArgs) {
        this.setCurrentDatabaseInThreadLocal();
        iCommand.reset();
        return (RET)((List)iCommand.execute(iArgs));
    }

    @Override
    public byte getRecordType() {
        return this.recordType;
    }

    @Override
    public long countClusterElements(int[] iClusterIds) {
        return this.countClusterElements(iClusterIds, false);
    }

    @Override
    public long countClusterElements(int iClusterId) {
        return this.countClusterElements(iClusterId, false);
    }

    @Override
    public long countClusterElements(int iClusterId, boolean countTombstones) {
        String name = this.getClusterNameById(iClusterId);
        if (name == null) {
            return 0L;
        }
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)name);
        this.setCurrentDatabaseInThreadLocal();
        return this.storage.count(iClusterId, countTombstones);
    }

    @Override
    public long countClusterElements(int[] iClusterIds, boolean countTombstones) {
        for (int iClusterId : iClusterIds) {
            String name = this.getClusterNameById(iClusterId);
            this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)name);
        }
        return this.storage.count(iClusterIds, countTombstones);
    }

    @Override
    public long countClusterElements(String iClusterName) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseInThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        if (clusterId < 0) {
            throw new IllegalArgumentException("Cluster '" + iClusterName + "' was not found");
        }
        return this.storage.count(clusterId);
    }

    @Override
    public OMetadataDefault getMetadata() {
        this.checkOpeness();
        return this.metadata;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        if (this.user != null) {
            try {
                this.user.allow(resourceGeneric, resourceSpecific, iOperation);
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', operation '%s'", this.getUser(), resourceGeneric + "." + resourceSpecific, iOperation);
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        if (this.user != null) {
            try {
                if (iResourcesSpecific.length != 0) {
                    for (Object target : iResourcesSpecific) {
                        if (target != null) {
                            this.user.allow(iResourceGeneric, target.toString(), iOperation);
                            continue;
                        }
                        this.user.allow(iResourceGeneric, null, iOperation);
                    }
                } else {
                    this.user.allow(iResourceGeneric, null, iOperation);
                }
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', target(s) '%s', operation '%s'", this.getUser(), iResourceGeneric, Arrays.toString(iResourcesSpecific), iOperation);
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric iResourceGeneric, int iOperation, Object iResourceSpecific) {
        this.checkOpeness();
        if (this.user != null) {
            try {
                if (iResourceSpecific != null) {
                    this.user.allow(iResourceGeneric, iResourceSpecific.toString(), iOperation);
                } else {
                    this.user.allow(iResourceGeneric, null, iOperation);
                }
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', target '%s', operation '%s'", this.getUser(), iResourceGeneric, iResourceSpecific, iOperation);
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public ODatabaseInternal<?> getDatabaseOwner() {
        ODatabaseInternal<?> current;
        for (current = this.databaseOwner; current != null && current != this && current.getDatabaseOwner() != current; current = current.getDatabaseOwner()) {
        }
        return current;
    }

    @Override
    public ODatabaseInternal<ORecord> setDatabaseOwner(ODatabaseInternal<?> iOwner) {
        this.databaseOwner = iOwner;
        return this;
    }

    @Override
    public boolean isRetainRecords() {
        return this.retainRecords;
    }

    @Override
    public ODatabaseDocument setRetainRecords(boolean retainRecords) {
        this.retainRecords = retainRecords;
        return this;
    }

    @Override
    public <DB extends ODatabase> DB setStatus(ODatabase.STATUS status) {
        this.setStatusInternal(status);
        return (DB)this;
    }

    public void setStatusInternal(ODatabase.STATUS status) {
        this.status = status;
    }

    public void setDefaultClusterIdInternal(int iDefClusterId) {
        this.getStorage().setDefaultClusterId(iDefClusterId);
    }

    @Override
    public void setInternal(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        this.set(iAttribute, iValue);
    }

    @Override
    public OSecurityUser getUser() {
        return this.user;
    }

    @Override
    public void setUser(OSecurityUser user) {
        if (user instanceof OUser) {
            OMetadataDefault metadata = this.getMetadata();
            if (metadata != null) {
                OSecurity security = metadata.getSecurity();
                this.user = new OImmutableUser(security.getVersion(), (OUser)user);
            } else {
                this.user = new OImmutableUser(-1L, (OUser)user);
            }
        } else {
            this.user = (OImmutableUser)user;
        }
    }

    @Override
    public boolean isMVCC() {
        return this.mvcc;
    }

    @Override
    public <DB extends ODatabase<?>> DB setMVCC(boolean mvcc) {
        this.mvcc = mvcc;
        return (DB)this;
    }

    @Override
    public ODictionary<ORecord> getDictionary() {
        this.checkOpeness();
        return this.metadata.getIndexManager().getDictionary();
    }

    @Override
    public <DB extends ODatabase<?>> DB registerHook(ORecordHook iHookImpl, ORecordHook.HOOK_POSITION iPosition) {
        LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION> tmp = new LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION>(this.hooks);
        tmp.put(iHookImpl, iPosition);
        this.hooks.clear();
        for (ORecordHook.HOOK_POSITION p : ORecordHook.HOOK_POSITION.values()) {
            for (Map.Entry e : tmp.entrySet()) {
                if (e.getValue() != p) continue;
                this.hooks.put((ORecordHook)e.getKey(), (ORecordHook.HOOK_POSITION)((Object)e.getValue()));
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase<?>> DB registerHook(ORecordHook iHookImpl) {
        return this.registerHook(iHookImpl, ORecordHook.HOOK_POSITION.REGULAR);
    }

    @Override
    public <DB extends ODatabase<?>> DB unregisterHook(ORecordHook iHookImpl) {
        if (iHookImpl != null) {
            iHookImpl.onUnregister();
            this.hooks.remove(iHookImpl);
        }
        return (DB)this;
    }

    @Override
    public OLocalRecordCache getLocalCache() {
        return this.localCache;
    }

    @Override
    public Map<ORecordHook, ORecordHook.HOOK_POSITION> getHooks() {
        return this.unmodifiableHooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordHook.RESULT callbackHooks(ORecordHook.TYPE type, OIdentifiable id) {
        if (id == null || !OHookThreadLocal.INSTANCE.push(id)) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        try {
            Object rec = id.getRecord();
            if (rec == null) {
                ORecordHook.RESULT rESULT = ORecordHook.RESULT.RECORD_NOT_CHANGED;
                return rESULT;
            }
            OScenarioThreadLocal.RUN_MODE runMode = OScenarioThreadLocal.INSTANCE.get();
            boolean recordChanged = false;
            block11: for (ORecordHook hook : this.hooks.keySet()) {
                switch (runMode) {
                    case DEFAULT: {
                        if (!this.getStorage().isDistributed() || hook.getDistributedExecutionMode() != ORecordHook.DISTRIBUTED_EXECUTION_MODE.TARGET_NODE) break;
                        continue block11;
                    }
                    case RUNNING_DISTRIBUTED: {
                        if (hook.getDistributedExecutionMode() != ORecordHook.DISTRIBUTED_EXECUTION_MODE.SOURCE_NODE) break;
                        continue block11;
                    }
                }
                ORecordHook.RESULT res = hook.onTrigger(type, (ORecord)rec);
                if (res == ORecordHook.RESULT.RECORD_CHANGED) {
                    recordChanged = true;
                    continue;
                }
                if (res == ORecordHook.RESULT.SKIP_IO) {
                    ORecordHook.RESULT rESULT = res;
                    return rESULT;
                }
                if (res == ORecordHook.RESULT.SKIP) {
                    ORecordHook.RESULT rESULT = res;
                    return rESULT;
                }
                if (res != ORecordHook.RESULT.RECORD_REPLACED) continue;
                ORecordHook.RESULT rESULT = res;
                return rESULT;
            }
            Object object = recordChanged ? ORecordHook.RESULT.RECORD_CHANGED : ORecordHook.RESULT.RECORD_NOT_CHANGED;
            return object;
        }
        finally {
            OHookThreadLocal.INSTANCE.pop(id);
        }
    }

    @Override
    public boolean isValidationEnabled() {
        return !this.getStatus().equals((Object)ODatabase.STATUS.IMPORTING) && this.validation;
    }

    @Override
    public <DB extends ODatabaseDocument> DB setValidationEnabled(boolean iEnabled) {
        this.validation = iEnabled;
        return (DB)this;
    }

    @Override
    public ORecordConflictStrategy getConflictStrategy() {
        return this.getStorage().getConflictStrategy();
    }

    @Override
    public ODatabaseDocumentTx setConflictStrategy(String iStrategyName) {
        this.getStorage().setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(iStrategyName));
        return this;
    }

    @Override
    public ODatabaseDocumentTx setConflictStrategy(ORecordConflictStrategy iResolver) {
        this.getStorage().setConflictStrategy(iResolver);
        return this;
    }

    @Override
    public OContextConfiguration getConfiguration() {
        if (this.storage != null) {
            return this.storage.getConfiguration().getContextConfiguration();
        }
        return null;
    }

    @Override
    public boolean declareIntent(OIntent iIntent) {
        if (this.currentIntent != null) {
            if (iIntent != null && iIntent.getClass().equals(this.currentIntent.getClass())) {
                return false;
            }
            this.currentIntent.end(this);
        }
        this.currentIntent = iIntent;
        if (iIntent != null) {
            iIntent.begin(this);
        }
        return true;
    }

    @Override
    public boolean exists() {
        if (this.status == ODatabase.STATUS.OPEN) {
            return true;
        }
        if (this.storage == null) {
            this.storage = Orient.instance().loadStorage(this.url);
        }
        return this.storage.exists();
    }

    @Override
    public void close() {
        this.localCache.shutdown();
        if (this.isClosed()) {
            return;
        }
        this.setCurrentDatabaseInThreadLocal();
        try {
            this.commit(true);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Exception during commit of active transaction.", (Throwable)e, new Object[0]);
        }
        if (this.status != ODatabase.STATUS.OPEN) {
            return;
        }
        this.callOnCloseListeners();
        if (this.currentIntent != null) {
            this.currentIntent.end(this);
            this.currentIntent = null;
        }
        this.status = ODatabase.STATUS.CLOSED;
        this.localCache.clear();
        if (!this.keepStorageOpen && this.storage != null) {
            this.storage.close();
        }
        ODatabaseRecordThreadLocal.INSTANCE.remove();
    }

    @Override
    public ODatabase.STATUS getStatus() {
        return this.status;
    }

    @Override
    public long getSize() {
        return this.storage.getSize();
    }

    @Override
    public String getName() {
        return this.storage != null ? this.storage.getName() : this.url;
    }

    @Override
    public String getURL() {
        return this.url != null ? this.url : this.storage.getURL();
    }

    @Override
    public int getDefaultClusterId() {
        return this.storage.getDefaultClusterId();
    }

    @Override
    public int getClusters() {
        return this.storage.getClusters();
    }

    @Override
    public boolean existsCluster(String iClusterName) {
        return this.storage.getClusterNames().contains(iClusterName.toLowerCase());
    }

    @Override
    public Collection<String> getClusterNames() {
        return this.storage.getClusterNames();
    }

    @Override
    public int getClusterIdByName(String iClusterName) {
        if (iClusterName == null) {
            return -1;
        }
        return this.storage.getClusterIdByName(iClusterName.toLowerCase());
    }

    @Override
    public String getClusterNameById(int iClusterId) {
        if (iClusterId == -1) {
            return null;
        }
        return this.storage.getPhysicalClusterNameById(iClusterId);
    }

    @Override
    public long getClusterRecordSizeByName(String clusterName) {
        try {
            return this.storage.getClusterById(this.getClusterIdByName(clusterName)).getRecordsSize();
        }
        catch (Exception e) {
            throw new ODatabaseException("Error on reading records size for cluster '" + clusterName + "'", e);
        }
    }

    @Override
    public long getClusterRecordSizeById(int clusterId) {
        try {
            return this.storage.getClusterById(clusterId).getRecordsSize();
        }
        catch (Exception e) {
            throw new ODatabaseException("Error on reading records size for cluster with id '" + clusterId + "'", e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.status == ODatabase.STATUS.CLOSED || this.storage.isClosed();
    }

    @Override
    public int addCluster(String iClusterName, Object ... iParameters) {
        return this.storage.addCluster(iClusterName, false, iParameters);
    }

    @Override
    public int addCluster(String iClusterName, int iRequestedId, Object ... iParameters) {
        return this.storage.addCluster(iClusterName, iRequestedId, false, iParameters);
    }

    @Override
    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        int clusterId = this.getClusterIdByName(iClusterName);
        OClass clazz = this.metadata.getSchema().getClassByClusterId(clusterId);
        if (clazz != null) {
            clazz.removeClusterId(clusterId);
        }
        return this.storage.dropCluster(iClusterName, iTruncate);
    }

    @Override
    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        OClass clazz = this.metadata.getSchema().getClassByClusterId(iClusterId);
        if (clazz != null) {
            clazz.removeClusterId(iClusterId);
        }
        return this.storage.dropCluster(iClusterId, iTruncate);
    }

    @Override
    public Object setProperty(String iName, Object iValue) {
        if (iValue == null) {
            return this.properties.remove(iName.toLowerCase());
        }
        return this.properties.put(iName.toLowerCase(), iValue);
    }

    @Override
    public Object getProperty(String iName) {
        return this.properties.get(iName.toLowerCase());
    }

    @Override
    public Iterator<Map.Entry<String, Object>> getProperties() {
        return this.properties.entrySet().iterator();
    }

    @Override
    public Object get(ODatabase.ATTRIBUTES iAttribute) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (iAttribute) {
            case STATUS: {
                return this.getStatus();
            }
            case DEFAULTCLUSTERID: {
                return this.getDefaultClusterId();
            }
            case TYPE: {
                return this.getMetadata().getImmutableSchemaSnapshot().existsClass("V") ? "graph" : "document";
            }
            case DATEFORMAT: {
                return this.storage.getConfiguration().dateFormat;
            }
            case DATETIMEFORMAT: {
                return this.storage.getConfiguration().dateTimeFormat;
            }
            case TIMEZONE: {
                return this.storage.getConfiguration().getTimeZone().getID();
            }
            case LOCALECOUNTRY: {
                return this.storage.getConfiguration().getLocaleCountry();
            }
            case LOCALELANGUAGE: {
                return this.storage.getConfiguration().getLocaleLanguage();
            }
            case CHARSET: {
                return this.storage.getConfiguration().getCharset();
            }
            case CUSTOM: {
                return this.storage.getConfiguration().properties;
            }
            case CLUSTERSELECTION: {
                return this.storage.getConfiguration().getClusterSelection();
            }
            case MINIMUMCLUSTERS: {
                return this.storage.getConfiguration().getMinimumClusters();
            }
            case CONFLICTSTRATEGY: {
                return this.storage.getConfiguration().getConflictStrategy();
            }
        }
        return null;
    }

    @Override
    public <DB extends ODatabase> DB set(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = OStringSerializerHelper.getStringContent(iValue != null ? iValue.toString() : null);
        switch (iAttribute) {
            case STATUS: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("DB status can't be null");
                }
                this.setStatus(ODatabase.STATUS.valueOf(stringValue.toUpperCase(Locale.ENGLISH)));
                break;
            }
            case DEFAULTCLUSTERID: {
                if (iValue == null) break;
                if (iValue instanceof Number) {
                    this.storage.setDefaultClusterId(((Number)iValue).intValue());
                    break;
                }
                this.storage.setDefaultClusterId(this.storage.getClusterIdByName(iValue.toString()));
                break;
            }
            case TYPE: {
                throw new IllegalArgumentException("Database type property is not supported");
            }
            case DATEFORMAT: {
                new SimpleDateFormat(stringValue).format(new Date());
                this.storage.getConfiguration().dateFormat = stringValue;
                this.storage.getConfiguration().update();
                break;
            }
            case DATETIMEFORMAT: {
                new SimpleDateFormat(stringValue).format(new Date());
                this.storage.getConfiguration().dateTimeFormat = stringValue;
                this.storage.getConfiguration().update();
                break;
            }
            case TIMEZONE: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("Timezone can't be null");
                }
                this.storage.getConfiguration().setTimeZone(TimeZone.getTimeZone(stringValue.toUpperCase()));
                this.storage.getConfiguration().update();
                break;
            }
            case LOCALECOUNTRY: {
                this.storage.getConfiguration().setLocaleCountry(stringValue);
                this.storage.getConfiguration().update();
                break;
            }
            case LOCALELANGUAGE: {
                this.storage.getConfiguration().setLocaleLanguage(stringValue);
                this.storage.getConfiguration().update();
                break;
            }
            case CHARSET: {
                this.storage.getConfiguration().setCharset(stringValue);
                this.storage.getConfiguration().update();
                break;
            }
            case CUSTOM: {
                int indx;
                int n = indx = stringValue != null ? stringValue.indexOf(61) : -1;
                if (indx < 0) {
                    if ("clear".equalsIgnoreCase(stringValue)) {
                        this.clearCustomInternal();
                        break;
                    }
                    throw new IllegalArgumentException("Syntax error: expected <name> = <value> or clear, instead found: " + iValue);
                }
                String customName = stringValue.substring(0, indx).trim();
                String customValue = stringValue.substring(indx + 1).trim();
                if (customValue.isEmpty()) {
                    this.removeCustomInternal(customName);
                    break;
                }
                this.setCustomInternal(customName, customValue);
                break;
            }
            case CLUSTERSELECTION: {
                this.storage.getConfiguration().setClusterSelection(stringValue);
                this.storage.getConfiguration().update();
                break;
            }
            case MINIMUMCLUSTERS: {
                if (iValue != null) {
                    if (iValue instanceof Number) {
                        this.storage.getConfiguration().setMinimumClusters(((Number)iValue).intValue());
                    } else {
                        this.storage.getConfiguration().setMinimumClusters(Integer.parseInt(stringValue));
                    }
                } else {
                    this.storage.getConfiguration().setMinimumClusters(1);
                }
                this.storage.getConfiguration().update();
                break;
            }
            case CONFLICTSTRATEGY: {
                this.storage.setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(stringValue));
                this.storage.getConfiguration().setConflictStrategy(stringValue);
                this.storage.getConfiguration().update();
                break;
            }
            default: {
                throw new IllegalArgumentException("Option '" + (Object)((Object)iAttribute) + "' not supported on alter database");
            }
        }
        return (DB)this;
    }

    @Override
    public ORecordMetadata getRecordMetadata(ORID rid) {
        return this.storage.getRecordMetadata(rid);
    }

    @Override
    public void freezeCluster(int iClusterId) {
        this.freezeCluster(iClusterId, false);
    }

    @Override
    public void releaseCluster(int iClusterId) {
        if (!(this.getStorage() instanceof OLocalPaginatedStorage)) {
            OLogManager.instance().error((Object)this, "We can not freeze non local storage.", new Object[0]);
            return;
        }
        OLocalPaginatedStorage storage = (OLocalPaginatedStorage)this.getStorage();
        storage.release(iClusterId);
    }

    @Override
    public void freezeCluster(int iClusterId, boolean throwException) {
        if (this.getStorage() instanceof OLocalPaginatedStorage) {
            OLocalPaginatedStorage paginatedStorage = (OLocalPaginatedStorage)this.getStorage();
            paginatedStorage.freeze(throwException, iClusterId);
        } else {
            OLogManager.instance().error((Object)this, "Only local paginated storage supports cluster freeze.", new Object[0]);
        }
    }

    @Override
    public OTransaction getTransaction() {
        return this.currentTx;
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan) {
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, iFetchPlan, false, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    @Deprecated
    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache, loadTombstone, iLockingStrategy);
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iRecord) {
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, null, false);
    }

    @Override
    public <RET extends ORecord> RET load(ORID recordId) {
        return (RET)this.currentTx.loadRecord(recordId, null, null, false);
    }

    @Override
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan) {
        return (RET)this.currentTx.loadRecord(iRecordId, null, iFetchPlan, false);
    }

    @Override
    @Deprecated
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        return (RET)this.currentTx.loadRecord(iRecordId, null, iFetchPlan, iIgnoreCache, loadTombstone, iLockingStrategy);
    }

    public <RET extends ORecord> RET reload(ORecord iRecord) {
        return this.reload(iRecord, (String)null, false);
    }

    public <RET extends ORecord> RET reload(ORecord iRecord, String iFetchPlan) {
        return this.reload(iRecord, iFetchPlan, false);
    }

    @Override
    public <RET extends ORecord> RET reload(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache) {
        ORecord record = this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache);
        if (record != null && iRecord != record) {
            iRecord.fromStream(record.toStream());
            iRecord.getRecordVersion().copyFrom(record.getRecordVersion());
        } else if (record == null) {
            throw new ORecordNotFoundException("Record with rid " + iRecord.getIdentity() + " was not found in database");
        }
        return (RET)record;
    }

    public ODatabaseDocument delete(ORID iRecord) {
        this.checkOpeness();
        Object rec = iRecord.getRecord();
        if (rec != null) {
            rec.delete();
        }
        return this;
    }

    @Override
    public boolean hide(ORID rid) {
        this.checkOpeness();
        if (this.currentTx.isActive()) {
            throw new ODatabaseException("This operation can be executed only in non tx mode");
        }
        return this.executeHideRecord(rid, ODatabase.OPERATION_MODE.SYNCHRONOUS);
    }

    @Override
    public OBinarySerializerFactory getSerializerFactory() {
        return this.componentsFactory.binarySerializerFactory;
    }

    public ODatabaseDocument begin(OTransaction iTx) {
        this.checkOpeness();
        if (this.currentTx.isActive() && iTx.equals(this.currentTx)) {
            this.currentTx.begin();
            return this;
        }
        this.currentTx.rollback(true, 0);
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onBeforeTxBegin(this);
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "Error before the transaction begin", t, OTransactionBlockedException.class, new Object[0]);
            }
        }
        this.currentTx = iTx;
        this.currentTx.begin();
        return this;
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache, false, OStorage.LOCKING_STRATEGY.NONE);
    }

    public <RET extends ORecord> RET executeReadRecord(ORecordId rid, ORecord iRecord, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstones, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkOpeness();
        this.getMetadata().makeThreadLocalSchemaSnapshot();
        ORecordSerializationContext.pushContext();
        try {
            ORawBuffer recordBuffer;
            this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)this.getClusterNameById(rid.getClusterId()));
            ORecord record = this.getTransaction().getRecord(rid);
            if (record == OTransactionRealAbstract.DELETED_RECORD) {
                RET RET = null;
                return RET;
            }
            if (record == null && !iIgnoreCache) {
                record = this.getLocalCache().findRecord(rid);
            }
            if (record != null) {
                if (iRecord != null) {
                    iRecord.fromStream(record.toStream());
                    iRecord.getRecordVersion().copyFrom(record.getRecordVersion());
                    record = iRecord;
                }
                OFetchHelper.checkFetchPlanValid(iFetchPlan);
                if (this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, record) == ORecordHook.RESULT.SKIP) {
                    RET RET = null;
                    return RET;
                }
                if (record.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    record.reload();
                }
                if (iLockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_SHARED_LOCK) {
                    OLogManager.instance().warn((Object)this, "You use depricated record locking strategy : %s it may lead to deadlocks " + (Object)((Object)iLockingStrategy), new Object[0]);
                    record.lock(false);
                } else if (iLockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK) {
                    OLogManager.instance().warn((Object)this, "You use depricated record locking strategy : %s it may lead to deadlocks " + (Object)((Object)iLockingStrategy), new Object[0]);
                    record.lock(true);
                }
                this.callbackHooks(ORecordHook.TYPE.AFTER_READ, record);
                ORecord oRecord = record;
                return (RET)oRecord;
            }
            if (!rid.isValid()) {
                recordBuffer = null;
            } else {
                OFetchHelper.checkFetchPlanValid(iFetchPlan);
                recordBuffer = this.storage.readRecord(rid, iFetchPlan, iIgnoreCache, null).getResult();
            }
            if (recordBuffer == null) {
                RET RET = null;
                return RET;
            }
            if (iRecord == null || ORecordInternal.getRecordType(iRecord) != recordBuffer.recordType) {
                iRecord = Orient.instance().getRecordFactoryManager().newInstance(recordBuffer.recordType);
            }
            ORecordInternal.fill(iRecord, rid, recordBuffer.version, recordBuffer.buffer, false);
            if (iRecord.getRecordVersion().isTombstone()) {
                ORecord oRecord = iRecord;
                return (RET)oRecord;
            }
            if (this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, iRecord) == ORecordHook.RESULT.SKIP) {
                RET RET = null;
                return RET;
            }
            iRecord.fromStream(recordBuffer.buffer);
            this.callbackHooks(ORecordHook.TYPE.AFTER_READ, iRecord);
            if (!iIgnoreCache) {
                this.getLocalCache().updateRecord(iRecord);
            }
            ORecord oRecord = iRecord;
            return (RET)oRecord;
        }
        catch (OOfflineClusterException t) {
            throw t;
        }
        catch (Throwable t) {
            if (rid.isTemporary()) {
                throw new ODatabaseException("Error on retrieving record using temporary RecordId: " + rid, t);
            }
            throw new ODatabaseException("Error on retrieving record " + rid + " (cluster: " + this.storage.getPhysicalClusterNameById(rid.clusterId) + ")", t);
        }
        finally {
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <RET extends ORecord> RET executeSaveRecord(ORecord record, String clusterName, ORecordVersion ver, boolean callTriggers, ODatabase.OPERATION_MODE mode, boolean forceCreate, ORecordCallback<? extends Number> recordCreatedCallback, ORecordCallback<ORecordVersion> recordUpdatedCallback) {
        this.checkOpeness();
        this.setCurrentDatabaseInThreadLocal();
        if (!record.isDirty()) {
            return (RET)record;
        }
        rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot create record because it has no identity. Probably is not a regular record or contains projections of fields rather than a full record");
        }
        lockedIndexes = new HashSet<OIndex<?>>();
        record.setInternalStatus(ORecordElement.STATUS.MARSHALLING);
        try {
            if (record instanceof ODocument) {
                this.acquireIndexModificationLock((ODocument)record, lockedIndexes);
            }
            v0 = wasNew = forceCreate != false || rid.isNew() != false;
            if (wasNew && rid.clusterId == -1 && (clusterName != null || this.storage.isAssigningClusterIds())) {
                if (clusterName != null) {
                    rid.clusterId = this.getClusterIdByName(clusterName);
                } else if (record instanceof ODocument && ODocumentInternal.getImmutableSchemaClass((ODocument)record) != null) {
                    rid.clusterId = ODocumentInternal.getImmutableSchemaClass((ODocument)record).getClusterForNewInstance((ODocument)record);
                } else {
                    this.getDefaultClusterId();
                }
            }
            stream = null;
            this.getMetadata().makeThreadLocalSchemaSnapshot();
            ORecordSerializationContext.pushContext();
            try {
                stream = record.toStream();
                v1 = isNew = forceCreate != false || rid.isNew() != false;
                if (isNew) {
                    ORecordInternal.onBeforeIdentityChanged(record);
                } else if (stream == null || stream.length == 0) {
                    var15_16 = record;
                    return (RET)var15_16;
                }
                if (isNew && rid.clusterId < 0 && this.storage.isAssigningClusterIds()) {
                    v2 = rid.clusterId = clusterName != null ? this.getClusterIdByName(clusterName) : this.getDefaultClusterId();
                }
                if (rid.clusterId > -1 && clusterName == null) {
                    clusterName = this.getClusterNameById(rid.clusterId);
                }
                if (this.storage.isAssigningClusterIds()) {
                    this.checkRecordClass(record, clusterName, rid, isNew);
                }
                this.checkSecurity(ORule.ResourceGeneric.CLUSTER, wasNew != false ? ORole.PERMISSION_CREATE : ORole.PERMISSION_UPDATE, (Object)clusterName);
                if (!(record instanceof ODocument)) ** GOTO lbl-1000
                if (OSerializationSetThreadLocal.checkIfPartial((ODocument)record)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = partialMarshalling = false;
                }
                if (stream != null && stream.length > 0 && !partialMarshalling && callTriggers) {
                    triggerType /* !! */  = wasNew != false ? ORecordHook.TYPE.BEFORE_CREATE : ORecordHook.TYPE.BEFORE_UPDATE;
                    hookResult = this.callbackHooks((ORecordHook.TYPE)triggerType /* !! */ , record);
                    if (hookResult == ORecordHook.RESULT.RECORD_CHANGED) {
                        stream = this.updateStream(record);
                    } else {
                        if (hookResult == ORecordHook.RESULT.SKIP_IO) {
                            var18_22 = record;
                            return (RET)var18_22;
                        }
                        if (hookResult == ORecordHook.RESULT.RECORD_REPLACED) {
                            var18_23 = (ORecord)OHookReplacedRecordThreadLocal.INSTANCE.get();
                            return (RET)var18_23;
                        }
                    }
                }
                if (wasNew && !isNew) {
                    record.setDirty();
                } else if (!record.isDirty()) {
                    triggerType /* !! */  = record;
                    return (RET)triggerType /* !! */ ;
                }
                try {
                    updateContent = ORecordInternal.isContentChanged(record);
                    content = stream == null ? new byte[]{} : stream;
                    recordType = ORecordInternal.getRecordType(record);
                    modeIndex = mode.ordinal();
                    Orient.instance().getRecordFactoryManager().getRecordTypeClass(recordType);
                    if (forceCreate || ORecordId.isNew(rid.clusterPosition)) {
                        ppos = this.storage.createRecord(rid, content, ver, recordType, modeIndex, recordCreatedCallback);
                        operationResult = new OStorageOperationResult<ORecordVersion>(ppos.getResult().recordVersion, ppos.isMoved());
                    } else {
                        operationResult = this.storage.updateRecord(rid, updateContent, content, ver, recordType, modeIndex, recordUpdatedCallback);
                    }
                    version = operationResult.getResult();
                    if (isNew) {
                        ((ORecordId)record.getIdentity()).copyFrom(rid);
                        ORecordInternal.onAfterIdentityChanged(record);
                    }
                    if (operationResult.getModifiedRecordContent() != null) {
                        stream = operationResult.getModifiedRecordContent();
                    }
                    ORecordInternal.fill(record, rid, version, stream, partialMarshalling);
                    this.callbackHookSuccess(record, callTriggers, wasNew, stream, operationResult);
                }
                catch (Throwable t) {
                    this.callbackHookFailure(record, callTriggers, wasNew, stream);
                    throw t;
                }
            }
            finally {
                this.callbackHookFinalize(record, callTriggers, wasNew, stream);
                ORecordSerializationContext.pullContext();
                this.getMetadata().clearThreadLocalSchemaSnapshot();
            }
            if (stream == null) return (RET)record;
            if (stream.length <= 0) return (RET)record;
            if (operationResult.isMoved() != false) return (RET)record;
            this.getLocalCache().updateRecord(record);
            return (RET)record;
        }
        catch (OException e) {
            throw e;
        }
        catch (Throwable t) {
            if (ORecordId.isValid(record.getIdentity().getClusterPosition()) != false) throw new ODatabaseException("Error on saving record " + record.getIdentity(), t);
            throw new ODatabaseException("Error on saving record in cluster #" + record.getIdentity().getClusterId(), t);
        }
        finally {
            this.releaseIndexModificationLock(lockedIndexes);
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDeleteRecord(OIdentifiable record, ORecordVersion iVersion, boolean iRequired, boolean iCallTriggers, ODatabase.OPERATION_MODE iMode, boolean prohibitTombstones) {
        this.checkOpeness();
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot delete record because it has no identity. Probably was created from scratch or contains projections of fields rather than a full record");
        }
        if (!rid.isValid()) {
            return;
        }
        if ((record = record.getRecord()) == null) {
            return;
        }
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_DELETE, (Object)this.getClusterNameById(rid.clusterId));
        HashSet lockedIndexes = new HashSet();
        this.setCurrentDatabaseInThreadLocal();
        ORecordSerializationContext.pushContext();
        this.getMetadata().makeThreadLocalSchemaSnapshot();
        try {
            if (record instanceof ODocument) {
                this.acquireIndexModificationLock((ODocument)record, lockedIndexes);
            }
            try {
                OStorageOperationResult<Boolean> operationResult;
                Object rec = record.getRecord();
                if (iCallTriggers && rec != null) {
                    this.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, (OIdentifiable)rec);
                }
                ORecordVersion realVersion = this.mvcc ? iVersion : OVersionFactory.instance().createUntrackedVersion();
                try {
                    if (prohibitTombstones) {
                        boolean result = this.storage.cleanOutRecord(rid, iVersion, iMode.ordinal(), null);
                        if (!result && iRequired) {
                            throw new ORecordNotFoundException("The record with id " + rid + " was not found");
                        }
                        operationResult = new OStorageOperationResult<Boolean>(result);
                    } else {
                        OStorageOperationResult<Boolean> result = this.storage.deleteRecord(rid, iVersion, iMode.ordinal(), null);
                        if (!result.getResult().booleanValue() && iRequired) {
                            throw new ORecordNotFoundException("The record with id " + rid + " was not found");
                        }
                        operationResult = new OStorageOperationResult<Boolean>(result.getResult());
                    }
                    if (iCallTriggers) {
                        if (!operationResult.isMoved() && rec != null) {
                            this.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, (OIdentifiable)rec);
                        } else if (rec != null) {
                            this.callbackHooks(ORecordHook.TYPE.DELETE_REPLICATED, (OIdentifiable)rec);
                        }
                    }
                }
                catch (Throwable t) {
                    if (iCallTriggers) {
                        this.callbackHooks(ORecordHook.TYPE.DELETE_FAILED, (OIdentifiable)rec);
                    }
                    throw t;
                }
                this.clearDocumentTracking((ORecord)rec);
                if (!operationResult.isMoved()) {
                    this.getLocalCache().deleteRecord(rid);
                }
            }
            catch (OException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ODatabaseException("Error on deleting record in cluster #" + record.getIdentity().getClusterId(), t);
            }
        }
        finally {
            this.releaseIndexModificationLock(lockedIndexes);
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeHideRecord(OIdentifiable record, ODatabase.OPERATION_MODE iMode) {
        this.checkOpeness();
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot hide record because it has no identity. Probably was created from scratch or contains projections of fields rather than a full record");
        }
        if (!rid.isValid()) {
            return false;
        }
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_DELETE, (Object)this.getClusterNameById(rid.clusterId));
        this.setCurrentDatabaseInThreadLocal();
        this.getMetadata().makeThreadLocalSchemaSnapshot();
        ORecordSerializationContext.pushContext();
        try {
            OStorageOperationResult<Boolean> operationResult = this.storage.hideRecord(rid, iMode.ordinal(), null);
            if (!operationResult.isMoved()) {
                this.getLocalCache().deleteRecord(rid);
            }
            boolean bl = operationResult.getResult();
            return bl;
        }
        finally {
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
        }
    }

    public ODatabaseDocumentTx begin() {
        return this.begin(OTransaction.TXTYPE.OPTIMISTIC);
    }

    public ODatabaseDocumentTx begin(OTransaction.TXTYPE iType) {
        this.checkOpeness();
        this.setCurrentDatabaseInThreadLocal();
        if (this.currentTx.isActive()) {
            if (iType == OTransaction.TXTYPE.OPTIMISTIC && this.currentTx instanceof OTransactionOptimistic) {
                this.currentTx.begin();
                return this;
            }
            this.currentTx.rollback(true, 0);
        }
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onBeforeTxBegin(this);
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "Error before tx begin", t, new Object[0]);
            }
        }
        switch (iType) {
            case NOTX: {
                this.setDefaultTransactionMode();
                break;
            }
            case OPTIMISTIC: {
                this.currentTx = new OTransactionOptimistic(this);
                break;
            }
            case PESSIMISTIC: {
                throw new UnsupportedOperationException("Pessimistic transaction");
            }
        }
        this.currentTx.begin();
        return this;
    }

    public void setDefaultTransactionMode() {
        if (!(this.currentTx instanceof OTransactionNoTx)) {
            this.currentTx = new OTransactionNoTx(this);
        }
    }

    @Override
    public void freeze(boolean throwException) {
        this.checkOpeness();
        if (!(this.getStorage() instanceof OFreezableStorage)) {
            OLogManager.instance().error((Object)this, "We can not freeze non local storage. If you use remote client please use OServerAdmin instead.", new Object[0]);
            return;
        }
        long startTime = Orient.instance().getProfiler().startChrono();
        Collection<? extends OIndex<?>> indexes = this.getMetadata().getIndexManager().getIndexes();
        List<OIndexAbstract<?>> indexesToLock = this.prepareIndexesToFreeze(indexes);
        this.freezeIndexes(indexesToLock, true);
        this.flushIndexes(indexesToLock);
        OFreezableStorage storage = this.getFreezableStorage();
        if (storage != null) {
            storage.freeze(throwException);
        }
        Orient.instance().getProfiler().stopChrono("db." + this.getName() + ".freeze", "Time to freeze the database", startTime, "db.*.freeze");
    }

    @Override
    public void freeze() {
        this.checkOpeness();
        if (!(this.getStorage() instanceof OFreezableStorage)) {
            OLogManager.instance().error((Object)this, "We can not freeze non local storage. If you use remote client please use OServerAdmin instead.", new Object[0]);
            return;
        }
        long startTime = Orient.instance().getProfiler().startChrono();
        Collection<? extends OIndex<?>> indexes = this.getMetadata().getIndexManager().getIndexes();
        List<OIndexAbstract<?>> indexesToLock = this.prepareIndexesToFreeze(indexes);
        this.freezeIndexes(indexesToLock, false);
        this.flushIndexes(indexesToLock);
        OFreezableStorage storage = this.getFreezableStorage();
        if (storage != null) {
            storage.freeze(false);
        }
        Orient.instance().getProfiler().stopChrono("db." + this.getName() + ".freeze", "Time to freeze the database", startTime, "db.*.freeze");
    }

    @Override
    public void release() {
        this.checkOpeness();
        if (!(this.getStorage() instanceof OFreezableStorage)) {
            OLogManager.instance().error((Object)this, "We can not release non local storage. If you use remote client please use OServerAdmin instead.", new Object[0]);
            return;
        }
        long startTime = Orient.instance().getProfiler().startChrono();
        OFreezableStorage storage = this.getFreezableStorage();
        if (storage != null) {
            storage.release();
        }
        Collection<? extends OIndex<?>> indexes = this.getMetadata().getIndexManager().getIndexes();
        this.releaseIndexes(indexes);
        Orient.instance().getProfiler().stopChrono("db." + this.getName() + ".release", "Time to release the database", startTime, "db.*.release");
    }

    @Override
    public ODocument newInstance() {
        return new ODocument();
    }

    @Override
    public ODocument newInstance(String iClassName) {
        return new ODocument(iClassName);
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName) {
        return this.browseClass(iClassName, true);
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName, boolean iPolymorphic) {
        if (this.getMetadata().getImmutableSchemaSnapshot().getClass(iClassName) == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' not found in current database");
        }
        this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_READ, (Object)iClassName);
        ORecordIteratorClass<ODocument> iter = new ORecordIteratorClass<ODocument>((ODatabaseDocumentInternal)this, (ODatabaseDocumentInternal)this, iClassName, iPolymorphic, true, false);
        return iter;
    }

    public ORecordIteratorCluster<ODocument> browseCluster(String iClusterName) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        return new ORecordIteratorCluster<ODocument>(this, this, this.getClusterIdByName(iClusterName), true);
    }

    public ORecordIteratorCluster<ODocument> browseCluster(String iClusterName, long startClusterPosition, long endClusterPosition, boolean loadTombstones) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        return new ORecordIteratorCluster<ODocument>(this, this, this.getClusterIdByName(iClusterName), startClusterPosition, endClusterPosition, true, loadTombstones, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord) {
        return this.save(iRecord, (String)null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, (ORecordCallback<? extends Number>)null, (ORecordCallback<ORecordVersion>)null);
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        return this.save(iRecord, (String)null, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord, String iClusterName) {
        return this.save(iRecord, iClusterName, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, (ORecordCallback<? extends Number>)null, (ORecordCallback<ORecordVersion>)null);
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        this.checkOpeness();
        if (!(iRecord instanceof ODocument)) {
            return (RET)this.currentTx.saveRecord(iRecord, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
        }
        ODocument doc = (ODocument)iRecord;
        if (!this.getTransaction().isActive() || this.getTransaction().getStatus() == OTransaction.TXSTATUS.COMMITTING) {
            doc.validate();
        }
        ODocumentInternal.convertAllMultiValuesToTrackedVersions(doc);
        if (iForceCreate || !doc.getIdentity().isValid()) {
            if (doc.getClassName() != null) {
                this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_CREATE, (Object)doc.getClassName());
            }
            OClass schemaClass = ODocumentInternal.getImmutableSchemaClass(doc);
            int clusterId = iRecord.getIdentity().getClusterId();
            if (clusterId == -1) {
                if (iClusterName == null && this.storage.isAssigningClusterIds()) {
                    if (schemaClass != null) {
                        if (schemaClass.isAbstract()) {
                            throw new OSchemaException("Document belongs to abstract class " + schemaClass.getName() + " and can not be saved");
                        }
                        iClusterName = this.getClusterNameById(schemaClass.getClusterForNewInstance(doc));
                    } else {
                        iClusterName = this.getClusterNameById(this.storage.getDefaultClusterId());
                    }
                }
                if (iClusterName != null && (clusterId = this.getClusterIdByName(iClusterName)) == -1) {
                    throw new IllegalArgumentException("Cluster name '" + iClusterName + "' is not configured");
                }
            }
            if (schemaClass != null && clusterId > -1) {
                int i;
                int[] clusterIds = schemaClass.getClusterIds();
                for (i = 0; i < clusterIds.length && clusterIds[i] != clusterId; ++i) {
                }
                if (i == clusterIds.length) {
                    throw new IllegalArgumentException("Cluster name '" + iClusterName + "' (id=" + clusterId + ") is not configured to store the class '" + doc.getClassName() + "', valid are " + Arrays.toString(clusterIds));
                }
            }
            ((ORecordId)iRecord.getIdentity()).clusterId = clusterId;
        } else if (doc.getClassName() != null) {
            this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_UPDATE, (Object)doc.getClassName());
        }
        doc = (ODocument)this.currentTx.saveRecord(iRecord, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
        return (RET)doc;
    }

    public ODatabaseDocumentTx delete(ORecord record) {
        this.checkOpeness();
        if (record == null) {
            throw new ODatabaseException("Cannot delete null document");
        }
        if (record instanceof ODocument && ((ODocument)record).getClassName() != null) {
            this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_DELETE, (Object)((ODocument)record).getClassName());
        }
        try {
            this.currentTx.deleteRecord(record, ODatabase.OPERATION_MODE.SYNCHRONOUS);
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            if (record instanceof ODocument) {
                throw new ODatabaseException("Error on deleting record " + record.getIdentity() + " of class '" + ((ODocument)record).getClassName() + "'", e);
            }
            throw new ODatabaseException("Error on deleting record " + record.getIdentity());
        }
        return this;
    }

    @Override
    public long countClass(String iClassName) {
        return this.countClass(iClassName, true);
    }

    @Override
    public long countClass(String iClassName, boolean iPolymorphic) {
        ODatabaseRecordThreadLocal.INSTANCE.set(this);
        OClass cls = this.getMetadata().getImmutableSchemaSnapshot().getClass(iClassName);
        if (cls == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' not found in database");
        }
        long totalOnDb = cls.count(iPolymorphic);
        long deletedInTx = 0L;
        long addedInTx = 0L;
        if (this.getTransaction().isActive()) {
            for (ORecordOperation oRecordOperation : this.getTransaction().getCurrentRecordEntries()) {
                ORecord rec;
                if (oRecordOperation.type == 2 && (rec = oRecordOperation.getRecord()) != null && rec instanceof ODocument && ((ODocument)rec).getSchemaClass().isSubClassOf(iClassName)) {
                    ++deletedInTx;
                }
                if (oRecordOperation.type != 3 || (rec = oRecordOperation.getRecord()) == null || !(rec instanceof ODocument) || !((ODocument)rec).getSchemaClass().isSubClassOf(iClassName)) continue;
                ++addedInTx;
            }
        }
        return totalOnDb + addedInTx - deletedInTx;
    }

    @Override
    public ODatabase<ORecord> commit() {
        return this.commit(false);
    }

    public ODatabaseDocument commit(boolean force) throws OTransactionException {
        this.checkOpeness();
        if (!this.currentTx.isActive()) {
            return this;
        }
        if (!force && this.currentTx.amountOfNestedTxs() > 1) {
            this.currentTx.commit();
            return this;
        }
        this.setCurrentDatabaseInThreadLocal();
        for (Iterator listener : this.browseListeners()) {
            try {
                listener.onBeforeTxCommit(this);
            }
            catch (Throwable t) {
                this.rollback(force);
                OLogManager.instance().debug((Object)this, "Cannot commit the transaction: caught exception on execution of %s.onBeforeTxCommit()", t, OTransactionBlockedException.class, listener.getClass());
            }
        }
        try {
            this.currentTx.commit(force);
        }
        catch (RuntimeException e) {
            for (ODatabaseListener listener : this.browseListeners()) {
                try {
                    listener.onBeforeTxRollback(this);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error before tx rollback", t, new Object[0]);
                }
            }
            this.currentTx.rollback(false, 0);
            this.getLocalCache().clear();
            for (ODatabaseListener listener : this.browseListeners()) {
                try {
                    listener.onAfterTxRollback(this);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error after tx rollback", t, new Object[0]);
                }
            }
            throw e;
        }
        for (Iterator listener : this.browseListeners()) {
            try {
                listener.onAfterTxCommit(this);
            }
            catch (Throwable t) {
                OLogManager.instance().debug((Object)this, "Error after the transaction has been committed. The transaction remains valid. The exception caught was on execution of %s.onAfterTxCommit()", t, OTransactionBlockedException.class, listener.getClass());
            }
        }
        return this;
    }

    @Override
    public ODatabase<ORecord> rollback() {
        return this.rollback(false);
    }

    public ODatabaseDocument rollback(boolean force) throws OTransactionException {
        this.checkOpeness();
        if (this.currentTx.isActive()) {
            if (!force && this.currentTx.amountOfNestedTxs() > 1) {
                this.currentTx.rollback();
                return this;
            }
            for (ODatabaseListener listener : this.browseListeners()) {
                try {
                    listener.onBeforeTxRollback(this);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error before tx rollback", t, new Object[0]);
                }
            }
            this.currentTx.rollback(force, -1);
            for (ODatabaseListener listener : this.browseListeners()) {
                try {
                    listener.onAfterTxRollback(this);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error after tx rollback", t, new Object[0]);
                }
            }
        }
        this.getLocalCache().clear();
        return this;
    }

    @Override
    public <DB extends ODatabase> DB getUnderlying() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OStorage getStorage() {
        return this.storage;
    }

    @Override
    public void replaceStorage(OStorage iNewStorage) {
        this.storage = iNewStorage;
    }

    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return this.storage.callInLock(iCallable, iExclusiveLock);
    }

    @Override
    public void backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        this.storage.backup(out, options, callable, iListener, compressionLevel, bufferSize);
    }

    @Override
    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        if (this.storage == null) {
            this.storage = Orient.instance().loadStorage(this.url);
        }
        this.getStorage().restore(in, options, callable, iListener);
    }

    @Override
    public OSBTreeCollectionManager getSbTreeCollectionManager() {
        return this.sbTreeCollectionManager;
    }

    @Override
    public OCurrentStorageComponentsFactory getStorageVersions() {
        return this.componentsFactory;
    }

    @Override
    public ORecordSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(ORecordSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public void resetInitialization() {
        for (ORecordHook h : this.hooks.keySet()) {
            h.onUnregister();
        }
        this.hooks.clear();
        this.close();
        this.initialized = false;
    }

    @Override
    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResource, int iOperation) {
        String resourceSpecific = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (resourceSpecific == null || resourceSpecific.equals("*")) {
            this.checkSecurity(resourceGeneric, null, iOperation);
        }
        return this.checkSecurity(resourceGeneric, resourceSpecific, iOperation);
    }

    @Override
    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResourceGeneric, int iOperation, Object iResourceSpecific) {
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResourceGeneric);
        if (iResourceSpecific == null || iResourceSpecific.equals("*")) {
            return this.checkSecurity(resourceGeneric, iOperation, (Object)null);
        }
        return this.checkSecurity(resourceGeneric, iOperation, iResourceSpecific);
    }

    @Override
    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResourceGeneric);
        return this.checkSecurity(resourceGeneric, iOperation, iResourcesSpecific);
    }

    public void setCurrentDatabaseInThreadLocal() {
        ODatabaseRecordThreadLocal.INSTANCE.set(this);
    }

    protected void checkTransaction() {
        if (this.currentTx == null || this.currentTx.getStatus() == OTransaction.TXSTATUS.INVALID) {
            throw new OTransactionException("Transaction not started");
        }
    }

    @Deprecated
    protected ORecordSerializer resolveFormat(Object iObject) {
        return ORecordSerializerFactory.instance().getFormatForObject(iObject, this.recordFormat);
    }

    protected void checkOpeness() {
        if (this.isClosed()) {
            throw new ODatabaseException("Database '" + this.getURL() + "' is closed");
        }
    }

    private void setCurrentDatabaseinThreadLocal() {
        ODatabaseRecordThreadLocal.INSTANCE.set(this);
    }

    private void initAtFirstOpen(String iUserName, String iUserPassword) {
        if (this.initialized) {
            return;
        }
        ORecordSerializerFactory serializerFactory = ORecordSerializerFactory.instance();
        String serializeName = this.getStorage().getConfiguration().getRecordSerializer();
        if (serializeName == null) {
            serializeName = "ORecordDocument2csv";
        }
        this.serializer = serializerFactory.getFormat(serializeName);
        if (this.serializer == null) {
            throw new ODatabaseException("RecordSerializer with name '" + serializeName + "' not found ");
        }
        if (this.getStorage().getConfiguration().getRecordSerializerVersion() > this.serializer.getMinSupportedVersion()) {
            throw new ODatabaseException("Persistent record serializer version is not support by the current implementation");
        }
        this.componentsFactory = this.getStorage().getComponentsFactory();
        OSBTreeCollectionManager sbTreeCM = this.getStorage().getResource(OSBTreeCollectionManager.class.getSimpleName(), new Callable<OSBTreeCollectionManager>(){

            @Override
            public OSBTreeCollectionManager call() throws Exception {
                Class<? extends OSBTreeCollectionManager> managerClass = ODatabaseDocumentTx.this.getStorage().getCollectionManagerClass();
                if (managerClass == null) {
                    OLogManager.instance().warn((Object)this, "Current implementation of storage does not support sbtree collections", new Object[0]);
                    return null;
                }
                return managerClass.newInstance();
            }
        });
        this.sbTreeCollectionManager = sbTreeCM != null ? new OSBTreeCollectionManagerProxy(this, sbTreeCM) : null;
        this.localCache.startup();
        this.metadata = new OMetadataDefault();
        this.metadata.load();
        this.recordFormat = DEF_RECORD_FORMAT;
        if (!(this.getStorage() instanceof OStorageProxy)) {
            if (this.metadata.getIndexManager().autoRecreateIndexesAfterCrash()) {
                this.metadata.getIndexManager().recreateIndexes();
                this.setCurrentDatabaseInThreadLocal();
                this.user = null;
            }
            this.installHooks();
            this.registerHook(new OSecurityTrackerHook(this.metadata.getSecurity()), ORecordHook.HOOK_POSITION.LAST);
            this.user = null;
        } else if (iUserName != null && iUserPassword != null) {
            this.user = new OImmutableUser(-1L, new OUser(iUserName, OUser.encryptPassword(iUserPassword)).addRole(new ORole("passthrough", null, OSecurityRole.ALLOW_MODES.ALLOW_ALL_BUT)));
        }
        if ("ORecordDocument2csv".equals(serializeName) && !this.metadata.getSchema().existsClass("ORIDs")) {
            this.metadata.getSchema().createClass("ORIDs");
        }
        if (OGlobalConfiguration.DB_MAKE_FULL_CHECKPOINT_ON_SCHEMA_CHANGE.getValueAsBoolean()) {
            this.metadata.getSchema().setFullCheckpointOnChange(true);
        }
        if (OGlobalConfiguration.DB_MAKE_FULL_CHECKPOINT_ON_INDEX_CHANGE.getValueAsBoolean()) {
            this.metadata.getIndexManager().setFullCheckpointOnChange(true);
        }
        this.initialized = true;
    }

    private void installHooks() {
        this.registerHook(new OClassTrigger(), ORecordHook.HOOK_POSITION.FIRST);
        this.registerHook(new ORestrictedAccessHook(), ORecordHook.HOOK_POSITION.FIRST);
        this.registerHook(new OUserTrigger(), ORecordHook.HOOK_POSITION.EARLY);
        this.registerHook(new OFunctionTrigger(), ORecordHook.HOOK_POSITION.REGULAR);
        this.registerHook(new OClassIndexManager(this), ORecordHook.HOOK_POSITION.LAST);
        this.registerHook(new OSchedulerTrigger(), ORecordHook.HOOK_POSITION.LAST);
        this.registerHook(new ORidBagDeleteHook(), ORecordHook.HOOK_POSITION.LAST);
    }

    private void closeOnDelete() {
        if (this.status != ODatabase.STATUS.OPEN) {
            return;
        }
        if (this.currentIntent != null) {
            this.currentIntent.end(this);
            this.currentIntent = null;
        }
        this.resetListeners();
        if (this.storage != null) {
            this.storage.close(true, true);
        }
        this.storage = null;
        this.status = ODatabase.STATUS.CLOSED;
    }

    private void clearCustomInternal() {
        this.storage.getConfiguration().properties.clear();
    }

    private void removeCustomInternal(String iName) {
        this.setCustomInternal(iName, null);
    }

    private void setCustomInternal(String iName, String iValue) {
        if (iValue == null || "null".equalsIgnoreCase(iValue)) {
            Iterator<OStorageEntryConfiguration> it = this.storage.getConfiguration().properties.iterator();
            while (it.hasNext()) {
                OStorageEntryConfiguration e = it.next();
                if (!e.name.equals(iName)) continue;
                it.remove();
                break;
            }
        } else {
            boolean found = false;
            for (OStorageEntryConfiguration e : this.storage.getConfiguration().properties) {
                if (!e.name.equals(iName)) continue;
                e.value = iValue;
                found = true;
                break;
            }
            if (!found) {
                this.storage.getConfiguration().properties.add(new OStorageEntryConfiguration(iName, iValue));
            }
        }
        this.storage.getConfiguration().update();
    }

    private void callbackHookFailure(ORecord record, boolean iCallTriggers, boolean wasNew, byte[] stream) {
        if (iCallTriggers && stream != null && stream.length > 0) {
            this.callbackHooks(wasNew ? ORecordHook.TYPE.CREATE_FAILED : ORecordHook.TYPE.UPDATE_FAILED, record);
        }
    }

    private void callbackHookSuccess(ORecord record, boolean iCallTriggers, boolean wasNew, byte[] stream, OStorageOperationResult<ORecordVersion> operationResult) {
        if (iCallTriggers && stream != null && stream.length > 0) {
            ORecordHook.TYPE hookType = !operationResult.isMoved() ? (wasNew ? ORecordHook.TYPE.AFTER_CREATE : ORecordHook.TYPE.AFTER_UPDATE) : (wasNew ? ORecordHook.TYPE.CREATE_REPLICATED : ORecordHook.TYPE.UPDATE_REPLICATED);
            this.callbackHooks(hookType, record);
            this.clearDocumentTracking(record);
        }
    }

    private void callbackHookFinalize(ORecord record, boolean callTriggers, boolean wasNew, byte[] stream) {
        if (callTriggers && stream != null && stream.length > 0) {
            ORecordHook.TYPE hookType = wasNew ? ORecordHook.TYPE.FINALIZE_CREATION : ORecordHook.TYPE.FINALIZE_UPDATE;
            this.callbackHooks(hookType, record);
        }
    }

    private void clearDocumentTracking(ORecord record) {
        if (record instanceof ODocument && ((ODocument)record).isTrackingChanges()) {
            ((ODocument)record).setTrackingChanges(false);
            ((ODocument)record).setTrackingChanges(true);
        }
    }

    private void checkRecordClass(ORecord record, String iClusterName, ORecordId rid, boolean isNew) {
        if (rid.clusterId > -1 && this.getStorageVersions().classesAreDetectedByClusterId() && isNew && record instanceof ODocument) {
            ODocument recordSchemaAware = (ODocument)record;
            OClass recordClass = ODocumentInternal.getImmutableSchemaClass(recordSchemaAware);
            OClass clusterIdClass = this.metadata.getImmutableSchemaSnapshot().getClassByClusterId(rid.clusterId);
            if (recordClass == null && clusterIdClass != null || clusterIdClass == null && recordClass != null || recordClass != null && !recordClass.equals(clusterIdClass)) {
                throw new OSchemaException("Record saved into cluster '" + iClusterName + "' should be saved with class '" + clusterIdClass + "' but has been created with class '" + recordClass + "'");
            }
        }
    }

    private byte[] updateStream(ORecord record) {
        ORecordInternal.unsetDirty(record);
        record.setDirty();
        ORecordSerializationContext.pullContext();
        ORecordSerializationContext.pushContext();
        return record.toStream();
    }

    private void releaseIndexModificationLock(Set<OIndex<?>> lockedIndexes) {
        if (this.metadata == null) {
            return;
        }
        OIndexManagerProxy indexManager = this.metadata.getIndexManager();
        if (indexManager == null) {
            return;
        }
        for (OIndex<?> index : lockedIndexes) {
            index.getInternal().releaseModificationLock();
        }
    }

    private void acquireIndexModificationLock(ODocument doc, Set<OIndex<?>> lockedIndexes) {
        Set<OIndex<?>> indexes;
        OClass cls;
        if (this.getStorage().getUnderlying() instanceof OAbstractPaginatedStorage && (cls = ODocumentInternal.getImmutableSchemaClass(doc)) != null && (indexes = cls.getIndexes()) != null) {
            TreeSet indexesToLock = new TreeSet(new Comparator<OIndex<?>>(){

                @Override
                public int compare(OIndex<?> indexOne, OIndex<?> indexTwo) {
                    return indexOne.getName().compareTo(indexTwo.getName());
                }
            });
            indexesToLock.addAll(indexes);
            for (OIndex oIndex : indexesToLock) {
                oIndex.getInternal().acquireModificationLock();
                lockedIndexes.add(oIndex);
            }
        }
    }

    private void init() {
        this.currentTx = new OTransactionNoTx(this);
    }

    private OFreezableStorage getFreezableStorage() {
        OStorage s = this.getStorage();
        if (s instanceof OFreezableStorage) {
            return (OFreezableStorage)((Object)s);
        }
        OLogManager.instance().error((Object)this, "Storage of type " + s.getType() + " does not support freeze operation.", new Object[0]);
        return null;
    }

    private void freezeIndexes(List<OIndexAbstract<?>> indexesToFreeze, boolean throwException) {
        if (indexesToFreeze != null) {
            for (OIndexAbstract<?> indexToLock : indexesToFreeze) {
                indexToLock.freeze(throwException);
            }
        }
    }

    private void flushIndexes(List<OIndexAbstract<?>> indexesToFlush) {
        for (OIndexAbstract<?> index : indexesToFlush) {
            index.flush();
        }
    }

    private List<OIndexAbstract<?>> prepareIndexesToFreeze(Collection<? extends OIndex<?>> indexes) {
        ArrayList<OIndexAbstract> indexesToFreeze = null;
        if (indexes != null && !indexes.isEmpty()) {
            indexesToFreeze = new ArrayList<OIndexAbstract>(indexes.size());
            for (OIndex<?> index : indexes) {
                indexesToFreeze.add((OIndexAbstract)index.getInternal());
            }
            Collections.sort(indexesToFreeze, new Comparator<OIndex<?>>(){

                @Override
                public int compare(OIndex<?> o1, OIndex<?> o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        return indexesToFreeze;
    }

    private void releaseIndexes(Collection<? extends OIndex<?>> indexesToRelease) {
        if (indexesToRelease != null) {
            Iterator<OIndex<?>> it = indexesToRelease.iterator();
            while (it.hasNext()) {
                it.next().getInternal().release();
                it.remove();
            }
        }
    }

    static {
        if (defaultSerializer == null) {
            throw new ODatabaseException("Impossible to find serializer with name " + OGlobalConfiguration.DB_DOCUMENT_SERIALIZER.getValueAsString());
        }
    }
}

