/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.ODatabaseException;

public class ODatabaseRecordThreadLocal
extends ThreadLocal<ODatabaseDocumentInternal> {
    public static volatile ODatabaseRecordThreadLocal INSTANCE = new ODatabaseRecordThreadLocal();

    @Override
    public ODatabaseDocumentInternal get() {
        ODatabaseDocumentInternal db = (ODatabaseDocumentInternal)super.get();
        if (db == null) {
            if (Orient.instance().getDatabaseThreadFactory() == null) {
                throw new ODatabaseException("Database instance is not set in current thread. Assure to set it with: ODatabaseRecordThreadLocal.INSTANCE.set(db);");
            }
            db = Orient.instance().getDatabaseThreadFactory().getThreadDatabase();
            if (db == null) {
                throw new ODatabaseException("Database instance is not set in current thread. Assure to set it with: ODatabaseRecordThreadLocal.INSTANCE.set(db);");
            }
            this.set(db);
        }
        return db;
    }

    @Override
    public void remove() {
        super.remove();
    }

    @Override
    public void set(ODatabaseDocumentInternal value) {
        super.set(value);
    }

    public ODatabaseDocumentInternal getIfDefined() {
        return (ODatabaseDocumentInternal)super.get();
    }

    public boolean isDefined() {
        return super.get() != null;
    }

    static {
        Orient inst = Orient.instance();
        if (inst != null) {
            inst.registerListener(new OOrientListenerAbstract(){

                @Override
                public void onStartup() {
                    if (INSTANCE == null) {
                        INSTANCE = new ODatabaseRecordThreadLocal();
                    }
                }

                @Override
                public void onShutdown() {
                    INSTANCE = null;
                }
            });
        }
    }
}

